/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf.imp;

import java.awt.Color;
import java.io.IOException;
import jet.export.rtf.api.Field;
import jet.export.rtf.api.GlobalDoc;
import jet.export.rtf.api.LineInfo;
import jet.export.rtf.imp.RtfShape;
import jet.export.rtf.imp.WriteTool;

abstract class RtfField
extends WriteTool
implements Field {
    protected GlobalDoc globalDoc;
    private boolean SEDU;
    private boolean append;
    private boolean drawBoxBorder;
    protected LineInfo left;
    protected LineInfo right;
    protected LineInfo top;
    protected LineInfo bottom;
    protected StringBuffer fieldBuf;
    protected int x;
    protected int y;
    protected int w;
    protected int h;
    private Color drawFourBorder;
    protected RtfShape shape;

    RtfField(GlobalDoc globalDoc) {
        this.globalDoc = globalDoc;
        this.reset();
    }

    protected boolean hasBorder() {
        return this.SEDU;
    }

    protected boolean isSameStyle() {
        return this.append;
    }

    @Override
    public void reset() {
        this.fieldBuf = new StringBuffer();
        this.drawBoxBorder = false;
        this.drawFourBorder = null;
    }

    @Override
    public void setBorderInfo(LineInfo lineInfo, LineInfo lineInfo2, LineInfo lineInfo3, LineInfo lineInfo4) {
        this.append = this.equal(lineInfo, lineInfo2) && this.equal(lineInfo, lineInfo3) && this.equal(lineInfo, lineInfo4);
        this.left = lineInfo;
        this.top = lineInfo2;
        this.right = lineInfo3;
        this.bottom = lineInfo4;
        if (lineInfo != null && !lineInfo.isNoLine()) {
            this.SEDU = true;
        }
        if (!this.SEDU && lineInfo2 != null && !lineInfo2.isNoLine()) {
            this.SEDU = true;
        }
        if (!this.SEDU && lineInfo3 != null && !lineInfo3.isNoLine()) {
            this.SEDU = true;
        }
        if (!this.SEDU && lineInfo4 != null && !lineInfo4.isNoLine()) {
            this.SEDU = true;
        }
    }

    protected void drawingBorder() throws IOException {
        if (this.SEDU) {
            if (this.isSameStyle()) {
                this.drawBoxBorder(this.left);
            } else {
                this.drawFourBorder();
            }
            if (this.left != null) {
                this.left.reset();
            }
            if (this.right != null) {
                this.right.reset();
            }
            if (this.top != null) {
                this.top.reset();
            }
            if (this.bottom != null) {
                this.bottom.reset();
            }
        }
        if (this.drawBoxBorder) {
            this.SEDU();
        }
    }

    private void SEDU() throws IOException {
        int n = 50;
        if (this.shape == null) {
            this.shape = new RtfShape(this.globalDoc);
        }
        this.shape.I(this.x, this.y + this.h - n, this.x + this.w, this.y + this.h - n);
        this.shape.I(0);
        LineInfo lineInfo = new LineInfo();
        lineInfo.setLineWidth(n * 2);
        lineInfo.setColor(this.drawFourBorder);
        this.shape.I(lineInfo);
        this.fieldBuf.append(this.shape.Z());
        this.shape.I();
        this.shape.I(this.x + this.w - n, this.y, this.x + this.w - n, this.y + this.h);
        this.shape.I(0);
        this.shape.I(lineInfo);
        this.fieldBuf.append(this.shape.Z());
        this.shape.I();
    }

    protected void drawFourBorder() throws IOException {
        int n;
        int n2;
        if (this.shape == null) {
            this.shape = new RtfShape(this.globalDoc);
        }
        if (this.left != null && !this.left.isNoLine()) {
            n2 = this.left.getTwipLineWidth() / 2;
            n = this.x + n2;
            this.shape.I(n, this.y, n, this.y + this.h);
            this.shape.I(0);
            this.shape.I(this.left);
            this.fieldBuf.append(this.shape.Z());
            this.shape.I();
        }
        if (this.top != null && !this.top.isNoLine()) {
            n2 = this.left.getTwipLineWidth() / 2;
            n = this.y + n2;
            this.shape.I(this.x, n, this.x + this.w, n);
            this.shape.I(0);
            this.shape.I(this.top);
            this.fieldBuf.append(this.shape.Z());
            this.shape.I();
        }
        if (this.right != null && !this.right.isNoLine()) {
            n2 = this.left.getTwipLineWidth() / 2;
            n = this.x + this.w - n2;
            this.shape.I(n, this.y, n, this.y + this.h);
            this.shape.I(0);
            this.shape.I(this.right);
            this.fieldBuf.append(this.shape.Z());
            this.shape.I();
        }
        if (this.bottom != null && !this.bottom.isNoLine()) {
            n2 = this.left.getTwipLineWidth() / 2;
            n = this.y + this.h - n2;
            this.shape.I(this.x, n, this.x + this.w, n);
            this.shape.I(0);
            this.shape.I(this.bottom);
            this.fieldBuf.append(this.shape.Z());
            this.shape.I();
        }
    }

    protected abstract void drawBoxBorder(LineInfo var1) throws IOException;

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
    }

    @Override
    public void setHasShadow(boolean bl, Color color) {
        this.drawBoxBorder = bl;
        this.drawFourBorder = color;
    }
}

