/*
 * Decompiled with CFR 0.152.
 */
package jet.export.text;

import guitools.toolkit.Unit;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import jet.datastream.DSField;
import jet.datastream.DSParagraphText;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.ExportAuxInfo;
import jet.export.text.TextBaseCache;
import jet.export.util.CCUtil;
import jet.export.util.FontInfo;
import jet.udos.JHyperLinkRslt;
import jet.util.FontSets;
import jet.util.Propertiable;

public class TextCache
extends TextBaseCache {
    private int SEDU = -1;
    private Map booleanValue = new HashMap();
    private Map clear = new HashMap();

    TextCache(ExportAuxInfo exportAuxInfo) {
        super(exportAuxInfo, "txt");
        this.firstLogid = 2402004;
        this.secondLogid = 2402005;
    }

    @Override
    boolean checkExportProperty(JRObjectResult jRObjectResult) {
        Propertiable propertiable = jRObjectResult.getPropertyByName("ExportToText");
        if (propertiable != null) {
            return (Boolean)propertiable.getObject();
        }
        int n = jRObjectResult.getObjectType();
        return n != 65540 && n != 65541;
    }

    public Font getFont(DSParagraphText dSParagraphText) {
        FontInfo fontInfo = super.getFontInfo(dSParagraphText);
        return this.SEDU(dSParagraphText, fontInfo);
    }

    public Font getUdoFont(JRVisiableResult jRVisiableResult) {
        FontInfo fontInfo = super.getUdoFontInfo(jRVisiableResult);
        if (jRVisiableResult instanceof JHyperLinkRslt) {
            String string = fontInfo.getFontName();
            int n = 0;
            if (this.booleanValue(jRVisiableResult, "fontBold")) {
                n |= 1;
            }
            if (this.booleanValue(jRVisiableResult, "fontItalic")) {
                n |= 2;
            }
            int n2 = this.clear(fontInfo.getFontSize());
            Font font = FontSets.getFont(string, n, n2);
            return font;
        }
        return this.SEDU(jRVisiableResult, fontInfo);
    }

    private Font SEDU(JRVisiableResult jRVisiableResult, FontInfo fontInfo) {
        String string = fontInfo.getFontName();
        int n = 0;
        if (this.booleanValue(jRVisiableResult, "Bold")) {
            n |= 1;
        }
        if (this.booleanValue(jRVisiableResult, "Italic")) {
            n |= 2;
        }
        int n2 = this.clear(fontInfo.getFontSize());
        Font font = FontSets.getFont(string, n, n2);
        return font;
    }

    private boolean booleanValue(JRObjectResult jRObjectResult, String string) {
        return (Boolean)jRObjectResult.getPropertyByName(string).getObject();
    }

    public Font getFont(DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Font font = (Font)this.booleanValue.get(dSTemplatible);
        if (font == null) {
            boolean bl = true;
            FontInfo fontInfo = this.getFontInfo(dSField);
            String string = fontInfo.getFontName();
            int n = 0;
            if (CCUtil.getBooleanPropertyByName(dSField, "Bold")) {
                n |= 1;
            }
            if (CCUtil.getBooleanPropertyByName(dSField, "Italic")) {
                n |= 2;
            }
            int n2 = this.clear(fontInfo.getFontSize());
            font = FontSets.getFont(string, n, n2);
            if (this.clear.containsKey(dSTemplatible)) {
                bl = (Boolean)this.clear.get(dSTemplatible);
            } else {
                if (!fontInfo.isCanBeCache() || CCUtil.isChangeByFormularProperty(dSField, "Bold") || CCUtil.isChangeByFormularProperty(dSField, "Italic")) {
                    bl = false;
                }
                this.clear.put(dSTemplatible, bl);
            }
            if (bl) {
                this.booleanValue.put(dSTemplatible, font);
            }
        }
        return font;
    }

    private int clear(int n) {
        return Unit.convertUnitToPixel(n, this.SEDU);
    }

    @Override
    public void clear() {
        super.clear();
        this.clear.clear();
        this.clear = null;
        this.booleanValue.clear();
        this.booleanValue = null;
    }

    public void setResolution(int n) {
        this.SEDU = n;
    }

    @Override
    protected String getToString(DSField dSField) {
        return dSField.toString();
    }
}

