/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.util.Hashtable;

public class AggregationConstants {
    public static final int NO_AGG_FUNC = 0;
    public static final int CNT = 1;
    public static final int SUM = 2;
    public static final int MIN = 3;
    public static final int MAX = 4;
    public static final int DCNT = 5;
    public static final int AVG = 6;
    public static final int SQRSUM = 7;
    public static final int POPSTDDEV = 8;
    public static final int POPVRNCE = 9;
    public static final int STDDV = 10;
    public static final int VRNCE = 11;
    public static final int RECMIN = 12;
    public static final int RECMAX = 13;
    public static final int RECSATISFY = 14;
    public static final int RECNOTSATISFY = 15;
    public static final int RUNNING_CNT = 16;
    public static final int RUNNING_SUM = 17;
    public static final int RUNNING_MIN = 18;
    public static final int RUNNING_MAX = 19;
    public static final int RUNNING_DCNT = 20;
    public static final int RUNNING_AVG = 21;
    public static final int _ANY = 22;
    public static final int _EVERY = 23;
    public static final int[] COUNT = new int[]{1};
    public static final int[] SUMMARY = new int[]{2};
    public static final int[] MINIMUM = new int[]{3};
    public static final int[] MAXIMUM = new int[]{4};
    public static final int[] SQUARESUM = new int[]{7};
    public static final int[] DISTINCTCOUNT = new int[]{5};
    public static final int[] AVERAGE = new int[]{6, 1, 2};
    public static final int[] POPULATIONSTDDEV = new int[]{8, 1, 2, 7};
    public static final int[] POPULATIONVARIANCE = new int[]{9, 1, 2, 7};
    public static final int[] STDDEV = new int[]{10, 1, 2, 7};
    public static final int[] VARIANCE = new int[]{11, 1, 2, 7};
    public static final int[] RECINDMIN = new int[]{12};
    public static final int[] RECINDMAX = new int[]{13};
    public static final int[] RECSATISFYCON = new int[]{14};
    public static final int[] RECNOTSATISFYCON = new int[]{15};
    public static final int[] NONE = new int[]{0};
    public static final int[] RUNNING_COUNT = new int[]{16};
    public static final int[] RUNNING_SUMMARY = new int[]{17};
    public static final int[] RUNNING_MINIMUM = new int[]{18};
    public static final int[] RUNNING_MAXIMUM = new int[]{19};
    public static final int[] RUNNING_DISTINCTCOUNT = new int[]{20};
    public static final int[] RUNNING_AVERAGE = new int[]{21, 16, 17};
    public static final int[] ANY = new int[]{22};
    public static final int[] EVERY = new int[]{23};
    public static final String FUNC_NAME_COUNT = "Count";
    public static final String FUNC_NAME_SUMMARY = "Sum";
    public static final String FUNC_NAME_MINIMUM = "Minimum";
    public static final String FUNC_NAME_MAXIMUM = "Maximum";
    public static final String FUNC_NAME_DISTINCTCOUNT = "DistinctCount";
    public static final String FUNC_NAME_AVERAGE = "Average";
    public static final String FUNC_NAME_SQRSUM = "SquareSum";
    public static final String FUNC_NAME_POPULATIONSTDDEV = "PopulationStdDev";
    public static final String FUNC_NAME_POPULATIONVARIANCE = "PopulationVariance";
    public static final String FUNC_NAME_STDDEV = "StdDev";
    public static final String FUNC_NAME_VARIANCE = "Variance";
    public static final String FUNC_NAME_RECINDMIN = "RecMin";
    public static final String FUNC_NAME_RECINDMAX = "RecMax";
    public static final String FUNC_NAME_RECSATISFYCON = "RecSatisfy";
    public static final String FUNC_NAME_RECNOTSATISFYCON = "RecNotSatisfy";
    public static final String FUNC_NAME_NONE = "NONE";
    public static final String FUNC_NAME_RUNNING_COUNT = "RunningCount";
    public static final String FUNC_NAME_RUNNING_SUMMARY = "RunningSum";
    public static final String FUNC_NAME_RUNNING_MINIMUM = "RunningMinimum";
    public static final String FUNC_NAME_RUNNING_MAXIMUM = "RunningMaximum";
    public static final String FUNC_NAME_RUNNING_DISTINCTCOUNT = "RunningDistinctCount";
    public static final String FUNC_NAME_RUNNING_AVERAGE = "RunningAvg";
    public static final String FUNC_NAME_ANY = "ANY";
    public static final String FUNC_NAME_EVERY = "EVERY";
    protected static String[] FunctionNames = new String[24];
    protected static Hashtable codemap = new Hashtable();

    public static boolean isRunningTotal(int n) {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    public static final int getFunctionCode(String string) {
        int[] nArray = (int[])codemap.get(string.toUpperCase());
        if (null != nArray) {
            return nArray[0];
        }
        return -1;
    }

    public static final String getFunctionName(int n) {
        return FunctionNames[n];
    }

    public static boolean isCompondAggregation(int n) {
        switch (n) {
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    public static final int[] getFunctionCodes(String string) {
        return (int[])codemap.get(string.toUpperCase());
    }

    public static final int[] getBasicFunctionCodes(int n) {
        int[] nArray = new int[]{};
        switch (n) {
            case 1: {
                nArray = COUNT;
                break;
            }
            case 5: {
                nArray = DISTINCTCOUNT;
                break;
            }
            case 2: {
                nArray = SUMMARY;
                break;
            }
            case 3: {
                nArray = MINIMUM;
                break;
            }
            case 4: {
                nArray = MAXIMUM;
                break;
            }
            case 6: {
                nArray = new int[]{1, 2};
                break;
            }
            case 7: {
                nArray = SQUARESUM;
                break;
            }
            case 16: {
                nArray = RUNNING_COUNT;
                break;
            }
            case 20: {
                nArray = RUNNING_DISTINCTCOUNT;
                break;
            }
            case 17: {
                nArray = RUNNING_SUMMARY;
                break;
            }
            case 18: {
                nArray = RUNNING_MINIMUM;
                break;
            }
            case 19: {
                nArray = RUNNING_MAXIMUM;
                break;
            }
            case 21: {
                nArray = new int[]{16, 17};
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                nArray = new int[]{1, 2, 7};
                break;
            }
            case 22: {
                nArray = ANY;
                break;
            }
            case 23: {
                nArray = EVERY;
                break;
            }
            default: {
                throw new Error("error agg type : " + n);
            }
        }
        return nArray;
    }

    static {
        AggregationConstants.FunctionNames[0] = FUNC_NAME_NONE;
        AggregationConstants.FunctionNames[1] = FUNC_NAME_COUNT;
        AggregationConstants.FunctionNames[2] = FUNC_NAME_SUMMARY;
        AggregationConstants.FunctionNames[3] = FUNC_NAME_MINIMUM;
        AggregationConstants.FunctionNames[4] = FUNC_NAME_MAXIMUM;
        AggregationConstants.FunctionNames[5] = FUNC_NAME_DISTINCTCOUNT;
        AggregationConstants.FunctionNames[6] = FUNC_NAME_AVERAGE;
        AggregationConstants.FunctionNames[7] = FUNC_NAME_SQRSUM;
        AggregationConstants.FunctionNames[8] = FUNC_NAME_POPULATIONSTDDEV;
        AggregationConstants.FunctionNames[9] = FUNC_NAME_POPULATIONVARIANCE;
        AggregationConstants.FunctionNames[10] = FUNC_NAME_STDDEV;
        AggregationConstants.FunctionNames[11] = FUNC_NAME_VARIANCE;
        AggregationConstants.FunctionNames[12] = FUNC_NAME_RECINDMIN;
        AggregationConstants.FunctionNames[13] = FUNC_NAME_RECINDMAX;
        AggregationConstants.FunctionNames[14] = FUNC_NAME_RECSATISFYCON;
        AggregationConstants.FunctionNames[15] = FUNC_NAME_RECNOTSATISFYCON;
        AggregationConstants.FunctionNames[16] = FUNC_NAME_RUNNING_COUNT;
        AggregationConstants.FunctionNames[17] = FUNC_NAME_RUNNING_SUMMARY;
        AggregationConstants.FunctionNames[18] = FUNC_NAME_RUNNING_MINIMUM;
        AggregationConstants.FunctionNames[19] = FUNC_NAME_RUNNING_MAXIMUM;
        AggregationConstants.FunctionNames[20] = FUNC_NAME_RUNNING_DISTINCTCOUNT;
        AggregationConstants.FunctionNames[21] = FUNC_NAME_RUNNING_AVERAGE;
        AggregationConstants.FunctionNames[22] = FUNC_NAME_ANY;
        AggregationConstants.FunctionNames[23] = FUNC_NAME_EVERY;
        codemap.put(FUNC_NAME_SUMMARY.toUpperCase(), SUMMARY);
        codemap.put(FUNC_NAME_COUNT.toUpperCase(), COUNT);
        codemap.put(FUNC_NAME_MAXIMUM.toUpperCase(), MAXIMUM);
        codemap.put(FUNC_NAME_MINIMUM.toUpperCase(), MINIMUM);
        codemap.put(FUNC_NAME_AVERAGE.toUpperCase(), AVERAGE);
        codemap.put(FUNC_NAME_SQRSUM.toUpperCase(), SQUARESUM);
        codemap.put(FUNC_NAME_DISTINCTCOUNT.toUpperCase(), DISTINCTCOUNT);
        codemap.put(FUNC_NAME_POPULATIONSTDDEV.toUpperCase(), POPULATIONSTDDEV);
        codemap.put(FUNC_NAME_POPULATIONVARIANCE.toUpperCase(), POPULATIONVARIANCE);
        codemap.put(FUNC_NAME_STDDEV.toUpperCase(), STDDEV);
        codemap.put(FUNC_NAME_VARIANCE.toUpperCase(), VARIANCE);
        codemap.put(FUNC_NAME_RECINDMIN.toUpperCase(), RECINDMIN);
        codemap.put(FUNC_NAME_RECINDMAX.toUpperCase(), RECINDMAX);
        codemap.put(FUNC_NAME_RECSATISFYCON.toUpperCase(), RECSATISFYCON);
        codemap.put(FUNC_NAME_RECNOTSATISFYCON.toUpperCase(), RECNOTSATISFYCON);
        codemap.put(FUNC_NAME_NONE.toUpperCase(), NONE);
        codemap.put(FUNC_NAME_RUNNING_SUMMARY.toUpperCase(), RUNNING_SUMMARY);
        codemap.put(FUNC_NAME_RUNNING_COUNT.toUpperCase(), RUNNING_COUNT);
        codemap.put(FUNC_NAME_RUNNING_MAXIMUM.toUpperCase(), RUNNING_MAXIMUM);
        codemap.put(FUNC_NAME_RUNNING_MINIMUM.toUpperCase(), RUNNING_MINIMUM);
        codemap.put(FUNC_NAME_RUNNING_AVERAGE.toUpperCase(), RUNNING_AVERAGE);
        codemap.put(FUNC_NAME_RUNNING_DISTINCTCOUNT.toUpperCase(), RUNNING_DISTINCTCOUNT);
        codemap.put(FUNC_NAME_ANY.toUpperCase(), ANY);
        codemap.put(FUNC_NAME_EVERY.toUpperCase(), EVERY);
    }
}

