/*
 * Decompiled with CFR 0.152.
 */
package jet.log;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.log.JRLoggingEvent;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.NDC;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.spi.LoggingEvent;

public class JRMemoryAppender
extends AppenderSkeleton {
    private static JRMemoryAppender FATAL;
    private static int SEDU;
    private boolean add = true;
    private Hashtable addAppender = new Hashtable();
    Vector addElement;
    AppenderAttachableImpl contains;
    private Level get = Level.FATAL;
    private boolean getAllAppenders = false;

    public static JRMemoryAppender getMemoryAppender() {
        if (FATAL == null) {
            FATAL = new JRMemoryAppender();
            FATAL.setName(JRMemoryAppender.class.getName());
        }
        return FATAL;
    }

    private JRMemoryAppender() {
        this.addElement = new Vector();
        this.contains = new AppenderAttachableImpl();
    }

    public void append(LoggingEvent loggingEvent) {
        if (!this.getAllAppenders) {
            return;
        }
        Level level = loggingEvent.getLevel();
        if (level.toInt() >= this.get.toInt()) {
            JRLoggingEvent jRLoggingEvent = null;
            if (loggingEvent instanceof JRLoggingEvent) {
                jRLoggingEvent = (JRLoggingEvent)loggingEvent;
                String string = NDC.get();
                if (string != null) {
                    Vector vector;
                    if (!this.addElement.contains(string)) {
                        this.registerEngine(string);
                    }
                    if ((vector = (Vector)this.addAppender.get(string)).size() < SEDU) {
                        vector.addElement(loggingEvent);
                    }
                }
            }
        }
    }

    public void setLevel(Level level) {
        this.get = level;
    }

    public synchronized void registerEngine(String string) {
        if (this.getAllAppenders) {
            this.addElement.add(string);
            this.addAppender.put(string, new Vector());
        }
    }

    public synchronized void releaseEngine(String string) {
        if (this.getAllAppenders) {
            this.addElement.remove(string);
            this.clear(string);
        }
    }

    public Vector getActiveEngines() {
        return this.addElement;
    }

    private void clear(String string) {
        Vector vector = (Vector)this.addAppender.get(string);
        if (vector != null) {
            vector.removeAllElements();
            this.addAppender.remove(string);
        }
    }

    public Vector getErrorsByID(String string) {
        Object v = this.addAppender.get(string);
        if (v != null) {
            return (Vector)v;
        }
        return null;
    }

    public int getErrorCount(String string) {
        Vector vector = (Vector)this.addAppender.get(string);
        if (vector != null) {
            return vector.size();
        }
        return 0;
    }

    public void close() {
    }

    public String toString() {
        return this.addAppender.toString();
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setBufferSize(int n) {
        SEDU = n;
    }

    public int getBufferSize() {
        return SEDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.contains;
        synchronized (appenderAttachableImpl) {
            this.contains.addAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.contains;
        synchronized (appenderAttachableImpl) {
            return this.contains.getAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appender getAppender(String string) {
        AppenderAttachableImpl appenderAttachableImpl = this.contains;
        synchronized (appenderAttachableImpl) {
            return this.contains.getAppender(string);
        }
    }

    public boolean isAttached(Appender appender) {
        return this.contains.isAttached(appender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.contains;
        synchronized (appenderAttachableImpl) {
            this.contains.removeAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.contains;
        synchronized (appenderAttachableImpl) {
            this.contains.removeAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String string) {
        AppenderAttachableImpl appenderAttachableImpl = this.contains;
        synchronized (appenderAttachableImpl) {
            this.contains.removeAppender(string);
        }
    }

    public void setUsedMemoryAppender(boolean bl) {
        this.getAllAppenders = bl;
    }

    static {
        SEDU = 10;
    }
}

