/*
 * Decompiled with CFR 0.152.
 */
package jet.net2.www.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jet.client.api.BaseJRClient;
import jet.net2.NetworkClient;
import jet.net2.ProgressData;
import jet.net2.ProgressEntry;
import jet.net2.misc.REException;
import jet.net2.misc.RegexpPool;
import jet.net2.www.HeaderParser;
import jet.net2.www.MessageHeader;
import jet.net2.www.MeteredStream;
import jet.net2.www.http.CookiePool;
import jet.net2.www.http.KeepAliveCache;
import jet.net2.www.http.KeepAliveStream;
import jet.net2.www.http.SSLClient;

public class HttpClient
extends NetworkClient {
    MessageHeader SEDU;
    boolean TRUE = false;
    KeepAliveStream I;
    private static RegexpPool add = new RegexpPool();
    private static String addCookie = null;
    public static String proxyHost = null;
    public static int proxyPort = 80;
    private String append = null;
    private int checkConnect = -1;
    protected boolean proxyDisabled;
    public boolean usingProxy = false;
    private boolean checkError = false;
    private String close;
    private int closeServer;
    protected static KeepAliveCache kac = new KeepAliveCache();
    boolean doConnect = false;
    int equals = -1;
    int err = 0;
    protected URL url;
    private static Hashtable findInt = new Hashtable();

    protected int getDefaultPort() {
        return 80;
    }

    private String SEDU() {
        String string = this.checkError ? HttpClient.getSysProp("https.proxyHost") : HttpClient.getSysProp("http.proxyHost");
        if (string == null) {
            string = HttpClient.getSysProp("proxyHost");
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private int TRUE() {
        int[] nArray = new int[]{0};
        Object var2_2 = null;
        nArray[0] = this.checkError ? (HttpClient.getSysProp("https.proxyHost") != null ? HttpClient.getSysProp("https.proxyPort", 80) : HttpClient.getSysProp("proxyPort", 80)) : (HttpClient.getSysProp("http.proxyHost") != null ? HttpClient.getSysProp("http.proxyPort", 80) : HttpClient.getSysProp("proxyPort", 80));
        return nArray[0];
    }

    public boolean getHttpKeepAliveSet() {
        return BaseJRClient.getKeepAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RegexpPool add() {
        RegexpPool regexpPool = add;
        synchronized (regexpPool) {
            String string = null;
            string = HttpClient.getSysProp("http.nonProxyHosts");
            if (string == null && addCookie == null || string != null && string.equals(addCookie)) {
                return add;
            }
            RegexpPool regexpPool2 = new RegexpPool();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        regexpPool2.add(stringTokenizer.nextToken().toLowerCase(), Boolean.TRUE);
                    }
                }
                catch (REException rEException) {
                    System.err.println("Error in http.nonProxyHosts system property:  " + rEException);
                }
            }
            addCookie = string;
            add = regexpPool2;
        }
        return add;
    }

    public HttpClient(URL uRL, String string, int n) throws IOException {
        this(uRL, string, n, false);
    }

    private HttpClient(URL uRL, String string, int n, boolean bl) throws IOException {
        this.checkError = uRL.getProtocol().equals("https");
        this.proxyDisabled = bl;
        if (!bl) {
            this.append = string;
            this.checkConnect = n < 0 ? this.getDefaultPort() : n;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            this.close = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.close = uRL.getHost();
        }
        this.url = uRL;
        this.closeServer = uRL.getPort();
        if (this.closeServer == -1) {
            this.closeServer = this.getDefaultPort();
        }
        this.checkError();
    }

    protected HttpClient(URL uRL, boolean bl) throws IOException {
        this(uRL, null, -1, bl);
    }

    private HttpClient(URL uRL) throws IOException {
        this(uRL, null, -1, false);
    }

    public static HttpClient New(URL uRL) throws IOException {
        HttpClient httpClient = (HttpClient)kac.get(uRL);
        if (httpClient == null) {
            httpClient = new HttpClient(uRL);
        } else {
            httpClient.url = uRL;
        }
        return httpClient;
    }

    public static void finished(HttpClient httpClient) {
        --httpClient.equals;
        if (httpClient.equals > 0 && httpClient.doConnect && !httpClient.serverOutput.checkError()) {
            kac.put(httpClient.url, httpClient);
        } else {
            httpClient.closeServer();
        }
    }

    @Override
    public void openServer(String string, int n) throws IOException {
        this.serverSocket = this.doConnect(string, n);
        if (this.checkError) {
            SSLClient sSLClient = new SSLClient(this.serverSocket, this.close, this.closeServer);
            this.serverSocket = proxyHost != null && proxyPort != -1 ? sSLClient.getProxied() : sSLClient.getSocket();
        }
        this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()));
        this.serverSocket.setTcpNoDelay(true);
    }

    private synchronized void addCookie(String string, int n) throws IOException {
        this.openServer(string, n);
    }

    private void append(String string, int n) throws IOException, UnknownHostException {
        super.openServer(string, n);
    }

    private synchronized void checkConnect(String string, int n) throws IOException {
        this.append(string, n);
    }

    private synchronized void checkError() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.close, this.closeServer);
        }
        if (this.doConnect) {
            return;
        }
        RegexpPool regexpPool = HttpClient.add();
        if (this.url.getProtocol().equals("http") || this.url.getProtocol().equals("https")) {
            if (this.append != null) {
                this.addCookie(this.append, this.checkConnect);
                this.usingProxy = true;
                return;
            }
            proxyHost = this.SEDU();
            if (proxyHost != null && !this.proxyDisabled && regexpPool.match(this.url.getHost().toLowerCase()) == null && regexpPool.match(this.close) == null) {
                try {
                    int n = this.TRUE();
                    this.addCookie(proxyHost, n);
                    this.append = proxyHost;
                    this.checkConnect = n;
                    this.usingProxy = true;
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.openServer(this.close, this.closeServer);
            this.usingProxy = false;
            return;
        }
        if (this.append != null) {
            this.checkConnect(this.append, this.checkConnect);
            this.usingProxy = true;
            return;
        }
        proxyHost = this.SEDU();
        if (proxyHost != null && !this.proxyDisabled && regexpPool.match(this.url.getHost().toLowerCase()) == null && regexpPool.match(this.close) == null) {
            try {
                int n = this.TRUE();
                this.checkConnect(proxyHost, n);
                this.append = proxyHost;
                this.checkConnect = n;
                this.usingProxy = true;
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.openServer(this.close, this.closeServer);
        this.usingProxy = false;
    }

    public String getURLFile() {
        if (this.usingProxy && !this.checkError) {
            String string = this.url.getProtocol() + "://" + this.url.getHost();
            if (this.url.getPort() != -1) {
                string = string + ":" + this.url.getPort();
            }
            return string + this.url.getFile();
        }
        return this.url.getFile();
    }

    public void writeRequests(MessageHeader messageHeader) {
        this.SEDU = messageHeader;
        this.SEDU.print(this.serverOutput);
        this.serverOutput.flush();
    }

    public boolean parseHTTP(MessageHeader messageHeader, ProgressEntry progressEntry) throws IOException {
        int n;
        this.equals = -1;
        this.err = 0;
        boolean bl = false;
        byte[] byArray = new byte[7];
        try {
            int n2;
            this.serverInput = this.serverSocket.getInputStream();
            this.serverInput = new BufferedInputStream(this.serverInput);
            this.serverInput = new PushbackInputStream(this.serverInput, 7);
            for (n = 0; n < 7 && (n2 = this.serverInput.read(byArray, n, 7 - n)) >= 0; n += n2) {
            }
            String string = null;
            bl = byArray[0] == 72 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 80 && byArray[4] == 47 && byArray[5] == 49 && byArray[6] == 46;
            ((PushbackInputStream)this.serverInput).unread(byArray);
            if (bl) {
                Object object;
                messageHeader.parseHeader(this.serverInput);
                string = this.usingProxy ? messageHeader.findValue("Proxy-Connection") : messageHeader.findValue("Connection");
                if (string != null && string.toLowerCase().equals("keep-alive")) {
                    object = new HeaderParser(messageHeader.findValue("Keep-Alive"));
                    this.equals = ((HeaderParser)object).findInt("max", 5);
                    this.err = ((HeaderParser)object).findInt("timeout", 5);
                }
                if ((object = messageHeader.findValue("Set-Cookie")) == null) {
                    object = messageHeader.findValue("Set-Cookie2");
                }
                if (object != null) {
                    String string2 = this.url.getFile();
                    int n3 = string2.indexOf(63);
                    if (n3 >= 0) {
                        string2 = string2.substring(0, n3);
                    }
                    if ((n3 = string2.indexOf(35)) >= 0) {
                        string2 = string2.substring(0, n3);
                    }
                    if (string2.length() == 0) {
                        string2 = "/";
                    }
                    CookiePool.addCookie((String)object, this.url.getHost(), this.url.getPort(), string2);
                }
            } else {
                if (n != 7) {
                    if (!this.TRUE && this.SEDU != null) {
                        this.TRUE = true;
                        this.closeServer();
                        this.checkError();
                        this.writeRequests(this.SEDU);
                        return this.parseHTTP(messageHeader, progressEntry);
                    }
                    throw new SocketException("Unexpected end of file from server");
                }
                messageHeader.set("Content-type", "unknown/unknown");
            }
        }
        catch (IOException iOException) {
            this.closeServer();
            if (!this.TRUE && this.SEDU != null) {
                this.TRUE = true;
                this.checkError();
                this.writeRequests(this.SEDU);
                return this.parseHTTP(messageHeader, progressEntry);
            }
            throw iOException;
        }
        n = -1;
        try {
            n = Integer.parseInt(messageHeader.findValue("content-length"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.equals > 1 && n >= 0) {
            this.doConnect = true;
        } else if (this.doConnect) {
            // empty if block
        }
        if (n >= 0) {
            progressEntry.setType(this.url.getFile(), messageHeader.findValue("content-type"));
            progressEntry.update(0, n);
            if (this.doConnect) {
                this.I = new KeepAliveStream(this.serverInput, progressEntry, this);
                this.serverInput = this.I;
                this.TRUE = false;
            } else {
                this.serverInput = new MeteredStream(this.serverInput, progressEntry);
            }
        } else {
            ProgressData.pdata.unregister(progressEntry);
        }
        return bl;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.url + ")";
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.doConnect;
    }

    protected void finalize() throws Throwable {
    }

    @Override
    public void closeServer() {
        try {
            this.doConnect = false;
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProxyHostUsed() {
        if (!this.usingProxy) {
            return null;
        }
        return this.append;
    }

    public int getProxyPortUsed() {
        return this.checkConnect;
    }
}

