/*
 * Decompiled with CFR 0.152.
 */
package jet.swingviewer;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.swingviewer.MouseWheelHandler;
import jet.thinviewer.JReportViewer;

public class DesignerViewerPane
extends JPanel
implements AdjustmentListener,
MouseListener {
    private final int I = 1;
    private final int SEDU = 3;
    private final int add = 4;
    private final int addAdjustmentListener = 5;
    private final int convertUnitToPixel = 5;
    protected JViewport viewPort = new JViewport();
    protected JReportViewer viewer;
    protected Communicator communicator;
    private JPanel firstViewReport = new JPanel();
    private Rectangle getCurrentPage;
    JScrollBar Z;
    JScrollBar C;
    int getPageArea = 0;
    int getResolution = 0;
    boolean B = true;

    public DesignerViewerPane(Communicator communicator, boolean bl) {
        this.setLayout(new ViewerLayout());
        this.Z = new JScrollBar(1);
        this.C = new JScrollBar(0);
        this.communicator = communicator;
        this.run(bl);
    }

    public void run(boolean bl) {
        this.viewer = new JReportViewer(this.communicator){

            @Override
            public Insets getInsets() {
                return new Insets(1, 1, 5, 5);
            }

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                Dimension dimension = this.getSize();
                graphics.setColor(Color.black);
                for (int i = 0; i < 1; ++i) {
                    graphics.drawRect(i, i, dimension.width - 4 - 2 - i * 2, dimension.height - 4 - 2 - i * 2);
                }
                graphics.setColor(Color.black);
                graphics.fillRect(3, dimension.height - 4 - 1, dimension.width - 3 - 1, 4);
                graphics.fillRect(dimension.width - 4 - 1, 3, 4, dimension.height - 3 - 1);
            }

            @Override
            public void setLocation(int n, int n2) {
                if (DesignerViewerPane.this.B) {
                    super.setLocation(n, n2);
                }
            }
        };
        this.viewer.setIsApplet(bl);
        int n = 100;
        this.setZoom(n);
        this.setBackground(Color.gray);
        this.firstViewReport.setLayout(null);
        this.firstViewReport.setBackground(Color.gray);
        this.firstViewReport.add(this.viewPort);
        this.add(this.firstViewReport);
        this.add(this.Z);
        this.add(this.C);
        this.addMouseWheelListener(new MouseWheelHandler(this.Z));
        this.addMouseWheelListener(new MouseWheelHandler(this.C));
        this.validate();
        this.viewer.firstViewReport(0, 0, this.getCurrentPage.width, this.getCurrentPage.height);
        this.Z.addAdjustmentListener(this);
        this.C.addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.C) {
            this.B = true;
            Point point = this.viewPort.getViewPosition();
            point.x = this.C.getValue();
            this.viewPort.setViewPosition(point);
            point = this.viewPort.getViewPosition();
            this.B = false;
        } else if (object == this.Z) {
            if (!this.Z.isVisible()) {
                return;
            }
            this.B = true;
            Point point = this.viewPort.getViewPosition();
            point.y = this.Z.getValue();
            this.viewPort.setViewPosition(point);
            point = this.viewPort.getViewPosition();
            this.B = false;
        }
    }

    public void setZoom(int n) {
        if (this.communicator != null) {
            int n2 = (int)((double)Unit.getResolution() * ((double)n / 100.0));
            this.communicator.setResolution(n2);
            this.viewer.setUsingThread(false);
            this.viewer.setDataStream(null);
            CommEnumeration commEnumeration = new CommEnumeration(this.communicator);
            Rectangle rectangle = null;
            if (commEnumeration.hasMoreElements()) {
                DSPage dSPage = (DSPage)commEnumeration.nextElement();
                rectangle = dSPage.getPageArea();
                this.getCurrentPage = new Rectangle(rectangle.x, rectangle.y, 0, 0);
            }
            this.getCurrentPage.width = Unit.convertUnitToPixel(rectangle.width, n2) + 2 + 4;
            this.getCurrentPage.height = Unit.convertUnitToPixel(rectangle.height, n2) + 2 + 4;
            this.viewer.setSize(this.getCurrentPage.width, this.getCurrentPage.height);
            this.viewPort.setView(this.viewer);
            this.viewPort.setBounds(5, 5, this.getCurrentPage.width, this.getCurrentPage.height);
            this.viewPort.setBackground(Color.gray);
            this.Z.setValue(0);
            this.C.setValue(0);
        }
    }

    public void _setZoom() {
        if (this.communicator != null) {
            int n = Unit.getResolution();
            this.communicator.setResolution(n);
            this.viewer.setUsingThread(false);
            this.viewer.setDataStream(null);
            this.getCurrentPage = this.viewer.getCurrentPage().getPageArea();
            Rectangle rectangle = new Rectangle(this.getCurrentPage.x, this.getCurrentPage.y, this.getCurrentPage.width, this.getCurrentPage.height);
            rectangle.width = Unit.convertUnitToPixel(rectangle.width, n) + 2 + 4;
            rectangle.height = Unit.convertUnitToPixel(rectangle.height, n) + 2 + 4;
            this.viewer.setSize(rectangle.width, rectangle.height);
            this.viewPort.setView(this.viewer);
            this.viewPort.setBounds(5, 5, rectangle.width, rectangle.height);
            this.viewPort.setBackground(Color.gray);
            this.Z.setValue(0);
            this.C.setValue(0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.B = true;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.B = false;
    }

    class ViewerLayout
    implements LayoutManager {
        ViewerLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            Dimension dimension = container.getSize();
            Dimension dimension2 = DesignerViewerPane.this.viewer.getSize();
            int n2 = DesignerViewerPane.this.Z.getPreferredSize().width;
            int n3 = DesignerViewerPane.this.C.getPreferredSize().height;
            if (dimension.width >= dimension2.width + 10 && dimension.height >= dimension2.height + 10) {
                DesignerViewerPane.this.C.setVisible(false);
                DesignerViewerPane.this.Z.setVisible(false);
                n2 = 0;
                n3 = 0;
            } else {
                if (dimension.width < dimension2.width + 10) {
                    if (!DesignerViewerPane.this.C.isVisible()) {
                        DesignerViewerPane.this.C.setVisible(true);
                    }
                    if (dimension.height >= dimension2.height + 10 + n3) {
                        n2 = 0;
                        DesignerViewerPane.this.Z.setVisible(false);
                    } else if (!DesignerViewerPane.this.Z.isVisible()) {
                        DesignerViewerPane.this.Z.setVisible(true);
                    }
                }
                if (dimension.height < dimension2.height + 10) {
                    if (!DesignerViewerPane.this.Z.isVisible()) {
                        DesignerViewerPane.this.Z.setVisible(true);
                    }
                    if (dimension.width >= dimension2.width + 10 + n2) {
                        n3 = 0;
                        DesignerViewerPane.this.C.setVisible(false);
                    } else if (!DesignerViewerPane.this.C.isVisible()) {
                        DesignerViewerPane.this.C.setVisible(true);
                    }
                }
            }
            int n4 = dimension.width - n2;
            int n5 = dimension.height - n3;
            DesignerViewerPane.this.firstViewReport.setBounds(0, 0, n4, n5);
            if (DesignerViewerPane.this.Z.isVisible()) {
                n = Math.min(DesignerViewerPane.this.Z.getValue(), dimension2.height + 10 + n3 - dimension.height);
                DesignerViewerPane.this.Z.setBounds(n4, 0, n2, n5);
                DesignerViewerPane.this.Z.setValue(n);
                DesignerViewerPane.this.Z.setMaximum(dimension2.height + 10);
                DesignerViewerPane.this.Z.setVisibleAmount(n5);
                DesignerViewerPane.this.Z.setBlockIncrement(n5);
                DesignerViewerPane.this.Z.setUnitIncrement(n5 / 10);
            }
            if (DesignerViewerPane.this.C.isVisible()) {
                n = Math.min(DesignerViewerPane.this.C.getValue(), dimension2.width + 10 + n2 - dimension.width);
                DesignerViewerPane.this.C.setBounds(0, n5, n4, n3);
                DesignerViewerPane.this.C.setValue(n);
                DesignerViewerPane.this.C.setMaximum(dimension2.width + 10);
                DesignerViewerPane.this.C.setVisibleAmount(n4);
                DesignerViewerPane.this.C.setBlockIncrement(n4);
                DesignerViewerPane.this.C.setUnitIncrement(n4 / 10);
            }
            Point point = DesignerViewerPane.this.viewPort.getViewPosition();
            if (point.x != DesignerViewerPane.this.C.getValue()) {
                point.x = DesignerViewerPane.this.C.getValue();
                DesignerViewerPane.this.viewPort.setViewPosition(point);
            }
            if (point.y != DesignerViewerPane.this.Z.getValue()) {
                point.y = DesignerViewerPane.this.Z.getValue();
                DesignerViewerPane.this.viewPort.setViewPosition(point);
            }
        }
    }
}

