/*
 * Decompiled with CFR 0.152.
 */
package jet.swingviewer;

import guitools.toolkit.TPaintBoard;
import guitools.toolkit.Unit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import jet.JRStopEngineException;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.datastream.DataStream;
import jet.thinviewer.JReportDrillDownViewer;
import jet.thinviewer.viewerSizeChangedListener;

public class DrillDownView
extends JFrame
implements viewerSizeChangedListener {
    int I = 5;
    int Z = 5;
    protected ImageIcon titleImage = null;
    Communicator C;
    private DataStream SEDU;
    private String add;
    Timer B = null;
    JPanel addAdjustmentListener;
    JScrollBar D = new JScrollBar(1);
    JScrollBar F = new JScrollBar(0);
    DSPage changeContentsSize;
    protected JReportDrillDownViewer drillDownViewer;
    TPaintBoard J = new TPaintBoard();
    boolean convertUnitToPixel;
    boolean S = false;
    Scroller getDataStream;
    Dimension A;

    public DrillDownView(Communicator communicator, DataStream dataStream, DSPage dSPage, String string, boolean bl) {
        super(string);
        this.C = communicator;
        this.SEDU = dataStream;
        this.changeContentsSize = dSPage;
        this.add = string;
        this.convertUnitToPixel = bl;
        this.setBounds(20, 20, 800, 400);
        this.getContentPane().setLayout(new BorderLayout());
    }

    public void setViewer(JReportDrillDownViewer jReportDrillDownViewer) {
        this.drillDownViewer = jReportDrillDownViewer;
        jReportDrillDownViewer.setLocation(this.I, this.Z);
    }

    public JReportDrillDownViewer getDrillDownViwer() {
        this.initViewer(this.changeContentsSize, this.add, this.SEDU);
        return this.drillDownViewer;
    }

    public void initViewer(DSPage dSPage, String string, DataStream dataStream) {
        this.drillDownViewer = new JReportDrillDownViewer(dataStream, string){

            @Override
            public Insets getInsets() {
                return new Insets(1, 1, 5, 5);
            }

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                Dimension dimension = this.getSize();
                graphics.setColor(Color.black);
                for (int i = 0; i < 1; ++i) {
                    graphics.drawRect(i, i, dimension.width - 4 - 2 - i * 2, dimension.height - 4 - 2 - i * 2);
                }
                graphics.setColor(Color.black);
                graphics.fillRect(3, dimension.height - 4 - 1, dimension.width - 3 - 1, 4);
                graphics.fillRect(dimension.width - 4 - 1, 3, 4, dimension.height - 3 - 1);
            }
        };
        this.drillDownViewer.setCurPage(dSPage);
        Rectangle rectangle = dataStream.getPageArea();
        this.drillDownViewer.setBounds(0, 0, rectangle.width, rectangle.height);
        this.A = new Dimension(rectangle.width / 10, rectangle.height / 10);
        this.J.add(this.drillDownViewer);
        this.J.setBackground(Color.gray);
        this.getDataStream = new Scroller();
        this.F.addAdjustmentListener(this.getDataStream);
        this.D.addAdjustmentListener(this.getDataStream);
        this.addAdjustmentListener = new JPanel();
        this.addAdjustmentListener.add((Component)this.J, "Center");
        this.addAdjustmentListener.add((Component)this.D, "East");
        this.addAdjustmentListener.add((Component)this.F, "South");
        this.addAdjustmentListener.setBackground(Color.gray);
        Rectangle rectangle2 = this.drillDownViewer.getViewerArea();
        this.J.add(this.drillDownViewer);
        this.J.setBackground(Color.gray);
        this.getContentPane().add(this.addAdjustmentListener);
        this.drillDownViewer.runThread();
        this.addAdjustmentListener.setBounds(5, 5, rectangle2.width, rectangle2.height);
        this.addAdjustmentListener.setLayout(new ViewerLayout());
        this.addAdjustmentListener.setBounds(15, 15, rectangle2.width, rectangle2.height);
        this.show();
        this.I();
    }

    public Communicator getCommunicator() {
        return this.C;
    }

    public void refresh() {
        int n = this.C.getResolution();
        try {
            DataStream dataStream = (DataStream)this.C.getDataStream(0);
            Rectangle rectangle = dataStream.getPageArea();
            rectangle.x = Unit.convertUnitToPixel(rectangle.x, n);
            rectangle.y = Unit.convertUnitToPixel(rectangle.y, n);
            rectangle.width = Unit.convertUnitToPixel(rectangle.width, n);
            rectangle.height = Unit.convertUnitToPixel(rectangle.height, n);
        }
        catch (JRStopEngineException jRStopEngineException) {
            jRStopEngineException.printStackTrace();
        }
    }

    public boolean setTitleImage(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.titleImage = imageIcon;
            this.setIconImage(imageIcon.getImage());
            return true;
        }
        return false;
    }

    public void setCommunicator(Communicator communicator) {
        this.C = communicator;
    }

    public void setDataStream(DataStream dataStream) {
        this.SEDU = dataStream;
    }

    public void setGroupBy(String string) {
        this.add = string;
    }

    @Override
    public void setScrollPosition(int n, int n2) {
        this.F.setValue(n);
        this.D.setValue(n2);
    }

    @Override
    public void viewerSizeChanged(Dimension dimension) {
        this.invalidate();
        this.validate();
    }

    @Override
    public void changeContentsSize() {
        this.F.setMaximumSize(new Dimension((int)this.drillDownViewer.getSize().getWidth(), 25));
        this.D.setMaximumSize(new Dimension(25, (int)this.drillDownViewer.getSize().getHeight()));
    }

    @Override
    public void scrolls(int n, int n2) {
        this.F.setValue(n);
        this.D.setValue(n2);
        this.changeContentsSize();
    }

    @Override
    public int[] getScrollPosition() {
        int[] nArray = new int[]{this.F.getValue(), this.D.getValue()};
        return nArray;
    }

    private synchronized void I() {
        this.B = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrillDownView.this.S = DrillDownView.this.C.isEngineFinished();
                if (DrillDownView.this.B != null) {
                    DrillDownView.this.A = DrillDownView.this.drillDownViewer.getSize();
                    DrillDownView.this.D.setMaximum(DrillDownView.this.A.height + 2 * DrillDownView.this.Z);
                    DrillDownView.this.F.setMaximum(DrillDownView.this.A.width + 2 * DrillDownView.this.I);
                    DrillDownView.this.drillDownViewer.reload();
                    DrillDownView.this.B.stop();
                    DrillDownView.this.B = null;
                }
            }
        });
        this.B.start();
    }

    class ViewerLayout
    implements LayoutManager {
        ViewerLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            Dimension dimension = container.getSize();
            if (DrillDownView.this.S) {
                DrillDownView.this.A = DrillDownView.this.drillDownViewer.getSize().height != 67351 ? DrillDownView.this.drillDownViewer.getSize() : DrillDownView.this.drillDownViewer.getSize();
            }
            DrillDownView.this.S = true;
            Point point = DrillDownView.this.drillDownViewer.getLocation();
            int n2 = DrillDownView.this.D.getPreferredSize().width;
            int n3 = DrillDownView.this.F.getPreferredSize().height;
            if (dimension.width >= DrillDownView.this.A.width + 2 * DrillDownView.this.I && dimension.height >= DrillDownView.this.A.height + 2 * DrillDownView.this.Z) {
                DrillDownView.this.F.setVisible(false);
                DrillDownView.this.D.setVisible(false);
                n2 = 0;
                n3 = 0;
            } else {
                if (dimension.width < DrillDownView.this.A.width + 2 * DrillDownView.this.I) {
                    if (!DrillDownView.this.F.isVisible()) {
                        point.x = DrillDownView.this.I;
                        DrillDownView.this.F.setVisible(true);
                    }
                    if (dimension.height >= DrillDownView.this.A.height + 2 * DrillDownView.this.Z + n3) {
                        n2 = 0;
                        DrillDownView.this.D.setVisible(false);
                    } else if (!DrillDownView.this.D.isVisible()) {
                        point.y = DrillDownView.this.Z;
                        DrillDownView.this.D.setVisible(true);
                    }
                }
                if (dimension.height < DrillDownView.this.A.height + 2 * DrillDownView.this.Z) {
                    if (!DrillDownView.this.D.isVisible()) {
                        point.y = DrillDownView.this.Z;
                        DrillDownView.this.D.setVisible(true);
                    }
                    if (dimension.width >= DrillDownView.this.A.width + 2 * DrillDownView.this.I + n2) {
                        n3 = 0;
                        DrillDownView.this.F.setVisible(false);
                    } else if (!DrillDownView.this.F.isVisible()) {
                        point.x = DrillDownView.this.I;
                        DrillDownView.this.F.setVisible(true);
                    }
                }
            }
            int n4 = dimension.width - n2;
            int n5 = dimension.height - n3;
            DrillDownView.this.F.setMaximumSize(new Dimension((int)DrillDownView.this.drillDownViewer.getSize().getWidth(), 25));
            DrillDownView.this.D.setMaximumSize(new Dimension(25, (int)DrillDownView.this.drillDownViewer.getSize().getHeight()));
            DrillDownView.this.J.setBounds(0, 0, n4, n5);
            if (DrillDownView.this.D.isVisible()) {
                n = Math.min(DrillDownView.this.D.getValue(), DrillDownView.this.A.height + 2 * DrillDownView.this.Z + n3 - dimension.height);
                point.y = DrillDownView.this.Z - n;
                DrillDownView.this.D.setBounds(n4, 0, n2, n5);
                DrillDownView.this.D.setValue(n);
                DrillDownView.this.D.setMaximum(DrillDownView.this.A.height + 2 * DrillDownView.this.Z);
                DrillDownView.this.D.setVisibleAmount(n5);
                DrillDownView.this.D.setBlockIncrement(n5);
                DrillDownView.this.D.setUnitIncrement(n5 / 10);
            } else {
                point.y = (dimension.height - DrillDownView.this.A.height - n3) / 2;
            }
            if (DrillDownView.this.F.isVisible()) {
                n = Math.min(DrillDownView.this.F.getValue(), DrillDownView.this.A.width + 2 * DrillDownView.this.I + n2 - dimension.width);
                point.x = DrillDownView.this.I - n;
                DrillDownView.this.F.setBounds(0, n5, n4, n3);
                DrillDownView.this.F.setValue(n);
                DrillDownView.this.F.setMaximum(DrillDownView.this.A.width + 2 * DrillDownView.this.I);
                DrillDownView.this.F.setVisibleAmount(n4);
                DrillDownView.this.F.setBlockIncrement(n4);
                DrillDownView.this.F.setUnitIncrement(n4 / 10);
            } else {
                point.x = (dimension.width - DrillDownView.this.A.width - n2) / 2;
            }
            if (!DrillDownView.this.drillDownViewer.getLocation().equals(point)) {
                DrillDownView.this.J.scrolls(point.x - DrillDownView.this.I, point.y - DrillDownView.this.Z);
            }
            DrillDownView.this.J.unlockUpdate();
        }
    }

    class Scroller
    implements AdjustmentListener {
        Scroller() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Dimension dimension = DrillDownView.this.drillDownViewer.getSize();
            Point point = DrillDownView.this.J.getClientAreaOffsets();
            int n = DrillDownView.this.F.isVisible() ? Math.min(DrillDownView.this.F.getValue(), dimension.width + 2 * DrillDownView.this.I) : -point.x;
            int n2 = DrillDownView.this.D.isVisible() ? Math.min(DrillDownView.this.D.getValue(), dimension.height + 2 * DrillDownView.this.Z) : -point.y;
            DrillDownView.this.J.scrolls(-n, -n2);
        }
    }
}

