/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import guitools.Painter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Vector;
import jet.JResource;
import jet.datastream.DSGMap;
import jet.export.util.ExportUtil;
import jet.export.util.GMapTool;
import jet.thinviewer.JReportContainer;
import jet.util.PropertySetable;

public class JReportGoogleMap
extends JReportContainer {
    Image I = null;
    DSGMap SEDU = null;
    String black = "JReport does not support this map type for this format.";

    @Override
    public void setProperty(PropertySetable propertySetable) {
        this.SEDU = (DSGMap)propertySetable;
        super.setProperty(propertySetable);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "get gmap");
        }
        if (this.getIntPropertyByName(this.SEDU, "MapType") >= 3) {
            this.I = null;
            this.black = JResource.getMessage("EXP_MAP_1");
        } else {
            this.I = GMapTool.getImage(this.SEDU);
            this.black = "JReport can not connect to the Google Map service. Check your internet connection or contact your system administrator.";
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "get gmap finish");
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "paint gmap");
        }
        Dimension dimension = this.getSize();
        if (graphics instanceof Graphics2D) {
            if (this.I != null) {
                ExportUtil.waitImage(this.I);
                graphics.drawImage(this.I, 0, 0, dimension.width, dimension.height, this);
            } else {
                this.I(dimension, graphics, this.black);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "map is null");
                }
            }
            super.paint(graphics);
        } else if (this.I != null) {
            graphics.drawImage(this.I, 0, 0, this);
        } else {
            this.I(dimension, graphics, this.black);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "map is null");
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "paint gmap finsieh");
        }
    }

    public Image getMapImage(DSGMap dSGMap) {
        this.setProperty(dSGMap);
        Image image = this.I;
        Rectangle rectangle = dSGMap.getBounds();
        this.setBounds(rectangle);
        if (this.I == null) {
            image = new BufferedImage(rectangle.width, rectangle.height, 1);
            Graphics graphics = image.getGraphics();
            this.I(this.getSize(), graphics, this.black);
            this.paint(graphics);
        }
        return image;
    }

    private void I(Dimension dimension, Graphics graphics, String string) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(new Color(200, 200, 200));
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.setColor(Color.black);
        Font font = new Font("Helvetica", 0, 12);
        graphics.setFont(font);
        boolean bl = false;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        Vector vector = Painter.lineBreaker(string, dimension.width - 20, font, bl);
        int n2 = (dimension.height - n * vector.size()) / 2;
        for (int i = 0; i < vector.size(); ++i) {
            graphics.drawString((String)vector.get(i), 20, n2 + i * n);
        }
        if (JRLog.isTrace(4)) {
            JRLog.error(4, "return a blank goolge map");
        }
    }
}

