/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import guitools.Painter;
import guitools.toolkit.FigurePeer;
import guitools.toolkit.TComponent;
import guitools.toolkit.TContainer;
import guitools.toolkit.TransparentPeer;
import guitools.toolkit.Unit;
import html.HelpFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.JResource;
import jet.JViewResource;
import jet.connect.Record;
import jet.controls.editor.UndoRedoListener;
import jet.datastream.CommNode;
import jet.datastream.Communicator;
import jet.datastream.DSBody;
import jet.datastream.DSColumn;
import jet.datastream.DSContainer;
import jet.datastream.DSPage;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSShape;
import jet.datastream.DSTable;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.ExportAuxInfo;
import jet.export.util.CCUtil;
import jet.export.util.ExportUtil;
import jet.export.util.ExportingInfo;
import jet.export.util.FillPatternAdapter;
import jet.export.util.FillPatternProperties;
import jet.export.util.URLEncoder;
import jet.export.util.ViewerExportingInfo;
import jet.ie.PJFCommunicator;
import jet.log.JRLoggingUtil;
import jet.thinviewer.ChartDrillDownImplementor;
import jet.thinviewer.ClickActionListener;
import jet.thinviewer.JReportBody;
import jet.thinviewer.JReportColumn;
import jet.thinviewer.JReportContainer;
import jet.thinviewer.JReportField;
import jet.thinviewer.JReportGTBox;
import jet.thinviewer.JReportLine;
import jet.thinviewer.JReportObjectRender;
import jet.thinviewer.JReportSection;
import jet.thinviewer.JReportTable;
import jet.thinviewer.JetRptDrillDown;
import jet.thinviewer.JetRptShowPageLabel;
import jet.thinviewer.ViewerRecycler;
import jet.thinviewer.ViewerTools;
import jet.thinviewer.viewerSizeChangedListener;
import jet.udo.JRObjectLinkRender;
import jet.udos.IEExecuter;
import jet.util.FontSets;
import jet.util.JRInterruptedException;
import jet.util.Propertiable;
import jet.util.PropertySetable;
import jet.util.SystemTools;
import jet.util.TempFile;
import jet.util.TreeIterater;

public class JReportViewer
extends TContainer
implements Runnable,
ChartDrillDownImplementor {
    private Color KEY_FRACTIONALMETRICS = Color.blue;
    public static final int STATUS_ERROR = -1;
    public static final int STATUS_PENDING = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_STOP = 2;
    public static final int STATUS_OK = 4;
    protected int status = 0;
    protected static CCUtil ccutil = new CCUtil();
    protected DataStream dataStream = null;
    protected Communicator curComm = null;
    protected Communicator mainComm = null;
    protected int curPageNumber = 1;
    protected DSPage curPage = null;
    protected TContainer viewerClient = new TContainer();
    protected Thread thread = null;
    protected JetRptDrillDown drillDownImplement = null;
    protected JetRptShowPageLabel showPageNumberImplement = null;
    protected viewerSizeChangedListener sizeChangedListener = null;
    private Vector VALUE_FRACTIONALMETRICS_ON = null;
    protected UndoRedoListener undoRedoListener;
    private boolean addChildNotify = false;
    private boolean addChildWithoutNotify = false;
    private int addDrillDownCard = -1;
    protected String logKey;
    boolean addElement = true;
    protected int res = 96;
    protected boolean isChangeCommunicator = false;
    protected String groupby = "";
    private static long afterDoAction = 0L;
    private Cursor black;
    private Component blue;
    protected boolean isForPS = false;
    String bottom = null;
    private boolean changeContentsSize = false;
    protected ExportingInfo info;
    static boolean Z = true;
    protected static ExportAuxInfo auxinfo;
    boolean clearMem = false;
    Rectangle clickOnField = null;
    Point close = null;
    Vector convertInchToPixel = null;
    TempFile copySelection = new TempFile("", "~url", "url");
    static HelpFrame createChildren;
    private Stack createTempFile = new Stack();
    private Stack currentTimeMillis = new Stack();
    protected boolean doSaveUndoRedoInfo = true;

    public JReportViewer() {
        this.enableEvents(56L);
        this.logKey = JRLoggingUtil.getNDC();
    }

    public JReportViewer(DataStream dataStream) {
        this(dataStream.getCommunicator());
    }

    public JReportViewer(Communicator communicator) {
        this();
        this.curComm = communicator;
        this.mainComm = communicator;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "current communicator :" + communicator);
        }
    }

    public void setIsApplet(boolean bl) {
        if (bl) {
            this.setExportInfo(new AppletCache());
        }
    }

    public Rectangle getViewerArea() {
        return this.viewerClient.getBounds();
    }

    public void setIsLCView(boolean bl) {
        this.changeContentsSize = bl;
    }

    public boolean isLCView() {
        return this.changeContentsSize;
    }

    public void setExportInfo(ExportingInfo exportingInfo) {
        this.info = exportingInfo;
    }

    public ExportingInfo getexportInfo() {
        return this.info;
    }

    public void setAuxInfo(ExportAuxInfo exportAuxInfo) {
        auxinfo = exportAuxInfo;
    }

    public void setResolution(int n) {
        this.res = n;
    }

    public void setBrowserPath(String string) {
        this.bottom = string;
    }

    public int getStatus() {
        return this.status;
    }

    public void setMarginLineColor(Color color) {
        this.KEY_FRACTIONALMETRICS = color;
    }

    public void showMargin(boolean bl) {
        if (this.addChildWithoutNotify != bl) {
            this.addChildWithoutNotify = bl;
            this.repaint();
        }
    }

    public boolean isShowingMargin() {
        return this.addChildWithoutNotify;
    }

    public void setUndoRedoListener(UndoRedoListener undoRedoListener) {
        this.undoRedoListener = undoRedoListener;
    }

    public void setSizeChangedListener(viewerSizeChangedListener viewerSizeChangedListener2) {
        this.sizeChangedListener = viewerSizeChangedListener2;
    }

    public void addClickActionListener(ClickActionListener clickActionListener) {
        if (this.VALUE_FRACTIONALMETRICS_ON == null) {
            this.VALUE_FRACTIONALMETRICS_ON = new Vector(3);
        }
        this.VALUE_FRACTIONALMETRICS_ON.addElement(clickActionListener);
    }

    public void firstViewReport(int n, int n2, int n3, int n4) {
        this.curPageNumber = 1;
        this.setSize(n3, n4);
        this.runThread();
    }

    public void setUsingThread(boolean bl) {
        this.addElement = bl;
    }

    public synchronized void runThread() {
        this.status = 1;
        if (this.addElement) {
            this.thread = new Thread(this);
            this.thread.start();
        } else {
            this.run();
        }
    }

    public synchronized void killThread() {
        if (this.thread != null) {
            this.addChildNotify = true;
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                ViewerTools.I(2401515, interruptedException);
            }
            this.thread = null;
            this.addChildNotify = false;
        }
        this.status = 2;
    }

    @Override
    public void run() {
        block6: {
            if (this.logKey != null && !this.logKey.equals(JRLoggingUtil.getNDC())) {
                JRLoggingUtil.setNDC(this.logKey);
            }
            try {
                this.res = this.mainComm.getResolution();
                this.curComm.setResolution(this.res);
                if (this.dataStream == null || this.isChangeCommunicator) {
                    this.dataStream = (DataStream)this.curComm.getDataStream(0);
                }
                Z = this.curComm.isHighPrecision();
                this.addChild();
                if (this.isChangeCommunicator && this.sizeChangedListener != null) {
                    this.sizeChangedListener.changeContentsSize();
                }
                if (this.curPageNumber != -1) {
                    this.repaint();
                }
            }
            catch (JRStopEngineException jRStopEngineException) {
                this.status = 2;
                if (!JRLog.isTrace(2)) break block6;
                JRLog.trace(2, jRStopEngineException);
            }
        }
    }

    public boolean reportEnd() {
        return this.mainComm.isEngineFinished();
    }

    public Communicator getMainCommunicator() {
        return this.mainComm;
    }

    public Communicator getCommunicator() {
        return this.curComm;
    }

    public DataStream getDataStream() {
        return this.dataStream;
    }

    public void setDataStream(DataStream dataStream) {
        this.dataStream = dataStream;
    }

    public int getTotalPageNumber() {
        int n = this.mainComm.getPhysicalTotalPageNum();
        return n == 0 ? 1 : n;
    }

    public int getCurrentPageNumber() {
        return this.KEY_FRACTIONALMETRICS() + this.curPageNumber;
    }

    public DSPage getCurrentPage() {
        return this.curPage;
    }

    private int KEY_FRACTIONALMETRICS() {
        int n = 0;
        TreeIterater treeIterater = new TreeIterater(new CommNode(this.mainComm), false);
        CommNode commNode = (CommNode)treeIterater.next();
        Communicator communicator = null;
        while (commNode != null && (communicator = commNode.getComm()) != this.curComm) {
            n += communicator.getPageNum();
            commNode = (CommNode)treeIterater.next();
        }
        return n;
    }

    public void setDrillDownImplement(JetRptDrillDown jetRptDrillDown) {
        this.drillDownImplement = jetRptDrillDown;
    }

    public void setShowPageNumberImplement(JetRptShowPageLabel jetRptShowPageLabel) {
        this.showPageNumberImplement = jetRptShowPageLabel;
    }

    public String firstPage() throws JRStopEngineException {
        return this.gotoPage(1);
    }

    public String prevPage() throws JRStopEngineException {
        int n = this.getCurrentPageNumber();
        return this.gotoPage(--n);
    }

    public String nextPage() throws JRStopEngineException {
        int n = this.getCurrentPageNumber();
        return this.gotoPage(++n);
    }

    public String lastPage() throws JRStopEngineException {
        return this.gotoPage(this.getTotalPageNumber());
    }

    public int toPage(int n) throws JRStopEngineException {
        if (this.getCurrentPageNumber() != n) {
            if (n > this.getTotalPageNumber()) {
                n = this.getTotalPageNumber();
            } else if (n < 1) {
                n = 1;
            }
            this.gotoPage(n);
        }
        return n;
    }

    public String gotoPage(int n) throws JRStopEngineException {
        return this.gotoPage(n, true);
    }

    public String gotoPage(int n, boolean bl) throws JRStopEngineException {
        String string = JViewResource.getMessage("TV_NOMOREPAGE");
        if (n < 1) {
            this.status = -1;
            return string;
        }
        try {
            TreeIterater treeIterater = new TreeIterater(new CommNode(this.mainComm), false);
            CommNode commNode = (CommNode)treeIterater.next();
            Communicator communicator = null;
            while (commNode != null) {
                communicator = commNode.getComm();
                if (communicator == null) {
                    this.status = -1;
                    return string;
                }
                int n2 = communicator.getPageNum();
                if (n <= n2) {
                    this.SEDU(n, communicator);
                    if (bl) {
                        this.VALUE_FRACTIONALMETRICS_ON();
                    }
                    string = JViewResource.getMessage("TV_OK");
                    break;
                }
                n -= n2;
                commNode = (CommNode)treeIterater.next();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.status = -1;
            ViewerTools.I(2401512, arrayIndexOutOfBoundsException);
            string = arrayIndexOutOfBoundsException.getMessage();
        }
        this.status = 4;
        return string;
    }

    private void SEDU(int n, Communicator communicator) throws JRStopEngineException {
        if (this.doSaveUndoRedoInfo) {
            this.blue();
        }
        if (this.curComm != communicator) {
            this.curComm = communicator;
            this.isChangeCommunicator = true;
        } else {
            this.isChangeCommunicator = false;
        }
        this.dataStream = (DataStream)this.curComm.getDataStream(0);
        this.curPageNumber = n;
    }

    private void VALUE_FRACTIONALMETRICS_ON() {
        this.killThread();
        this.clear();
        this.runThread();
        if (this.doSaveUndoRedoInfo && this.sizeChangedListener != null) {
            this.sizeChangedListener.scrolls(0, 0);
            this.sizeChangedListener.setScrollPosition(0, 0);
        }
        if (this.showPageNumberImplement != null) {
            this.showPageNumberImplement.setCurrentPageNumber(this.getCurrentPageNumber(), this.getTotalPageNumber(), this.reportEnd());
        }
    }

    public void reload() {
        this.killThread();
        this.clear();
        this.runThread();
    }

    protected void clear() {
        if (this.tpb != null) {
            this.tpb.lockUpdate();
        }
        this.auxinfo();
        this.remove(this.viewerClient);
        this.freeViewerObject();
        this.viewerClient.removeAll();
        if (this.tpb != null) {
            this.tpb.unlockUpdate();
        }
        this.repaint();
    }

    protected void addChild() throws JRStopEngineException {
        this.addChildWithoutNotify();
        this.addChildNotify();
    }

    protected void addChildNotify() {
        this.add(this.viewerClient);
        String string = null;
        if (!(this.mainComm instanceof PJFCommunicator)) {
            string = System.getProperty("awt.toolkit");
        }
        if (string == null || !string.equals("com.eteks.awt.PJAToolkit")) {
            this.validate();
        }
        if (!this.addChildNotify) {
            this.status = 4;
        }
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 5401501, new Integer(this.curPageNumber));
        }
    }

    protected void addChildWithoutNotify() throws JRStopEngineException {
        if (!FontSets.hasUserFonts()) {
            try {
                this.curComm.initFonts();
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                ViewerTools.I(2401509, exception);
            }
        }
        long l = System.currentTimeMillis();
        this.curPage = null;
        this.curPage = this.curComm.getPage(this.curPageNumber);
        if (this.curPage == null) {
            if (this.curComm.isBeStopping()) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401523);
                }
                throw new JRStopEngineException();
            }
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401510, new Integer(this.curPageNumber));
            }
            this.curPageNumber = -1;
            this.status = -1;
            return;
        }
        this.ccutil(this.curPage, this.res);
        JReportContainer jReportContainer = null;
        int n = this.curPage.size();
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 5401502, new Integer(n));
        }
        List list = ExportUtil.getContainerChildren(this.curPage);
        for (int i = 0; !this.addChildNotify && i < n; ++i) {
            Object object;
            Object object2;
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
            int n2 = jRObjectResult.getObjectType();
            while (n2 == 8192) {
                jRObjectResult = ((DSReference)jRObjectResult).getRefData();
                n2 = jRObjectResult.getObjectType();
            }
            if ((n2 & 0x200) == 512) {
                object2 = (DSSection)jRObjectResult;
                if (!this.info.isExport((JRObjectResult)object2)) continue;
                object = ((JRVisiableResult)object2).getBounds();
                try {
                    jReportContainer = (JReportSection)JReportViewer.I((JRObjectResult)object2);
                    jReportContainer.setProperty((PropertySetable)object2);
                    jReportContainer.setBounds((Rectangle)object);
                    jReportContainer.setLcView(this.changeContentsSize);
                    jReportContainer.setauxinfo(auxinfo);
                    if (this.info == null) {
                        this.info = new ViewerExportingInfo();
                    }
                    jReportContainer.setExportInfo(this.info);
                    jReportContainer.createChildren((DSContainer)object2);
                    this.viewerClient.add((Component)jReportContainer, 0);
                    continue;
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                    }
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    ViewerTools.I(2401511, exception);
                    this.status = -1;
                    continue;
                }
            }
            if (n2 == 262177) {
                object2 = (JReportBody)JReportViewer.I(jRObjectResult);
                ((JReportContainer)object2).setLcView(this.changeContentsSize);
                ((JReportContainer)object2).setauxinfo(auxinfo);
                if (this.info == null) {
                    this.info = new ViewerExportingInfo();
                }
                ((JReportContainer)object2).setExportInfo(this.info);
                ((JReportBody)object2).setProperty(jRObjectResult);
                ((Component)object2).setBounds(((DSBody)jRObjectResult).getBounds());
                ((JReportBody)object2).createChildren((DSBody)jRObjectResult);
                this.viewerClient.add((Component)object2, 0);
                continue;
            }
            if (n2 == 18 || n2 == 23 || n2 == 22 || n2 == 19 || n2 == 20) {
                object2 = (DSShape)jRObjectResult;
                object = ViewerTools.getShapeViewObject((DSShape)object2, this.res);
                if (object == null) continue;
                this.viewerClient.add((Component)object);
                continue;
            }
            if (n2 != 16385) continue;
            object2 = (DSTable)jRObjectResult;
            jReportContainer = (JReportTable)JReportViewer.I((JRObjectResult)object2);
            jReportContainer.setProperty((PropertySetable)object2);
            jReportContainer.setBounds(((JRVisiableResult)object2).getBounds());
            jReportContainer.removeAll();
            object = ((DSContainer)object2).getChildren();
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                DSColumn dSColumn = (DSColumn)((Vector)object).elementAt(j);
                JReportColumn jReportColumn = (JReportColumn)JReportViewer.I(dSColumn);
                if (jReportColumn == null) continue;
                jReportColumn.setProperty(dSColumn);
                jReportColumn.setBounds(dSColumn.getBounds());
                jReportContainer.add(jReportColumn);
            }
            this.viewerClient.add(jReportContainer);
        }
        long l2 = System.currentTimeMillis();
        afterDoAction += l2 - l;
    }

    public void freeViewerObject() {
        for (int i = 0; i < this.viewerClient.getComponentCount(); ++i) {
            this.abs(this.viewerClient.getComponent(i));
        }
    }

    private void abs(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.abs(container.getComponent(i));
            }
        }
        ViewerRecycler.recycleObject(component);
    }

    boolean I(String string) {
        return true;
    }

    public String getDSSectionName(DSSection dSSection) {
        if (dSSection.groupValue == null) {
            return "Report";
        }
        return dSSection.groupValue.toString();
    }

    public void drillDown(String string, DSSection dSSection) throws JRStopEngineException {
        if (this.drillDownImplement != null) {
            DSPage dSPage = this.curComm.getDrillDownPage(dSSection.getDataStream().getSubIndex(), this.curPageNumber, dSSection.getRecordIndex(), dSSection.getTemplateIndex(), this.getIntPropertyByName(dSSection, "BranchIdx"), dSSection);
            this.drillDownImplement.addDrillDownCard(dSPage, string, dSSection.groupValue == null ? JViewResource.getMessage("TV_NULL") : this.getDSSectionName(dSSection), this.dataStream);
        }
    }

    @Override
    public void drilldownInChart(String string, DSSection dSSection) {
        IEExecuter iEExecuter = new IEExecuter();
        iEExecuter.execute(null, null, string);
    }

    @Override
    public void drilldownInChart(String string, String string2, DSSection dSSection) throws JRStopEngineException {
        DSPage dSPage;
        if (this.drillDownImplement != null && (dSPage = this.curComm.getDrillDownPage(dSSection.getDataStream().getSubIndex(), this.curPageNumber, dSSection.getRecordIndex(), dSSection.getTemplateIndex(), (Integer)dSSection.getTemplate().getPropertyByName("BranchIdx").getObject(), dSSection.getObjectType(), string, string2, dSSection)) != null) {
            String string3 = "";
            JRObjectResult jRObjectResult = dSPage.getObject(0);
            if (jRObjectResult.getObjectType() == 515) {
                string3 = this.getStringPropertyByName(jRObjectResult, "Group");
            } else {
                jRObjectResult = dSPage.getObject(dSPage.size() - 1);
                if (jRObjectResult.getObjectType() == 518) {
                    string3 = this.getStringPropertyByName(jRObjectResult, "Group");
                }
            }
            this.drillDownImplement.addDrillDownCard(dSPage, string3, string2, this.dataStream);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (n == 501) {
            this.auxinfo();
            if ((mouseEvent.getModifiers() & 0x10) > 0) {
                this.close = mouseEvent.getPoint();
                this.clearMem = true;
            }
            this.requestFocus();
        } else if (n == 502) {
            if (this.blue != null) {
                JRObjectResult jRObjectResult = (JRObjectResult)((JRObjectLinkRender)((Object)this.blue)).getProperties();
                int n2 = jRObjectResult.getLinkComm();
                int n3 = -1;
                if (n2 != -1) {
                    Communicator communicator = this.curComm.getLinkedComm(n2);
                    try {
                        n3 = communicator.getLinkedPage(jRObjectResult.getLinkCondition());
                    }
                    catch (JRStopEngineException jRStopEngineException) {
                        this.status = 2;
                        JRLog.error(131600, mouseEvent);
                    }
                }
                this.addDrillDownCard();
                if (n2 > 0 && n3 > 0) {
                    try {
                        this.SEDU(n3, this.curComm.getLinkedComm(n2));
                        this.VALUE_FRACTIONALMETRICS_ON();
                    }
                    catch (JRStopEngineException jRStopEngineException) {
                        this.status = 2;
                        ViewerTools.I(131600, jRStopEngineException);
                    }
                }
            }
            this.repaint();
        }
        super.processMouseEvent(mouseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void I(int n, int n2) throws JRStopEngineException {
        block22: {
            if (n != -1) {
                Communicator communicator = this.curComm.getLinkedComm(n);
                int n3 = communicator.getLinkedPage(n2);
                if (n3 > 0) {
                    this.SEDU(n3, communicator);
                    this.VALUE_FRACTIONALMETRICS_ON();
                }
            } else {
                String string;
                String string2 = string = this.curComm == null ? null : this.curComm.getLinkedInfo(n2);
                if (string != null) {
                    try {
                        Runtime runtime = Runtime.getRuntime();
                        string = URLEncoder.encode(string, URLEncoder.getSystemURLEncoding());
                        if (SystemTools.isWinNT) {
                            if (string.indexOf("http:") == -1 && string.indexOf("%20") != -1) {
                                string = "\"" + string.replaceAll("%20", " ") + "\"";
                            }
                            File file = auxinfo.getDiskStore().createTempFile(null, ".url");
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            PrintWriter printWriter = new PrintWriter(fileOutputStream);
                            printWriter.println("[InternetShortcut]");
                            printWriter.println("URL=" + string);
                            printWriter.println("Modified=F0DB6E5C9293BE0179");
                            printWriter.close();
                            fileOutputStream.close();
                            String[] stringArray = new String[]{"cmd", "/c", "start", " ", file.getAbsolutePath()};
                            Process process = runtime.exec(stringArray);
                            process.waitFor();
                            JReportViewer jReportViewer = this;
                            synchronized (jReportViewer) {
                                try {
                                    this.wait(3000L);
                                }
                                catch (JRInterruptedException jRInterruptedException) {
                                    if (JRLog.isError(2)) {
                                        JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                                    }
                                    throw jRInterruptedException;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            auxinfo.getDiskStore().fileUpdated(file);
                            auxinfo.getDiskStore().delete(file);
                            break block22;
                        }
                        if (this.bottom != null) {
                            Process process = runtime.exec(this.bottom + " " + string);
                            process.waitFor();
                        } else {
                            ViewerTools.I(2401522);
                        }
                    }
                    catch (JRInterruptedException jRInterruptedException) {
                        if (JRLog.isError(2)) {
                            JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                        }
                        throw jRInterruptedException;
                    }
                    catch (Exception exception) {
                        this.status = -1;
                        ViewerTools.I(2401513, exception);
                        try {
                            if (createChildren == null) {
                                createChildren = new HelpFrame();
                            }
                            createChildren.setLocation(new URL(string));
                        }
                        catch (IOException iOException) {
                            ViewerTools.I(2401514, iOException);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void Z(JRObjectResult jRObjectResult) throws JRStopEngineException {
        block22: {
            int n = jRObjectResult.getLinkComm();
            if (n != -1) {
                Communicator communicator = this.curComm.getLinkedComm(n);
                int n2 = communicator.getLinkedPage(jRObjectResult.getLinkCondition());
                if (n2 > 0) {
                    this.SEDU(n2, communicator);
                    this.VALUE_FRACTIONALMETRICS_ON();
                }
            } else {
                String string;
                String string2 = string = this.curComm == null ? null : this.curComm.getLinkedInfo(jRObjectResult.getLinkCondition());
                if (string != null) {
                    try {
                        Runtime runtime = Runtime.getRuntime();
                        string = URLEncoder.encode(string, URLEncoder.getSystemURLEncoding());
                        if (SystemTools.isWinNT) {
                            if (string.indexOf("http:") == -1 && string.indexOf("%20") != -1) {
                                string = "\"" + string.replaceAll("%20", " ") + "\"";
                            }
                            File file = auxinfo.getDiskStore().createTempFile(null, ".url");
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            PrintWriter printWriter = new PrintWriter(fileOutputStream);
                            printWriter.println("[InternetShortcut]");
                            printWriter.println("URL=" + string);
                            printWriter.println("Modified=F0DB6E5C9293BE0179");
                            printWriter.close();
                            fileOutputStream.close();
                            String[] stringArray = new String[]{"cmd", "/c", "start", " ", file.getAbsolutePath()};
                            Process process = runtime.exec(stringArray);
                            process.waitFor();
                            JReportViewer jReportViewer = this;
                            synchronized (jReportViewer) {
                                try {
                                    this.wait(3000L);
                                }
                                catch (JRInterruptedException jRInterruptedException) {
                                    if (JRLog.isError(2)) {
                                        JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                                    }
                                    throw jRInterruptedException;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            auxinfo.getDiskStore().fileUpdated(file);
                            auxinfo.getDiskStore().delete(file);
                            break block22;
                        }
                        if (this.bottom != null) {
                            Process process = runtime.exec(this.bottom + " " + string);
                            process.waitFor();
                        } else {
                            ViewerTools.I(2401522);
                        }
                    }
                    catch (JRInterruptedException jRInterruptedException) {
                        if (JRLog.isError(2)) {
                            JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                        }
                        throw jRInterruptedException;
                    }
                    catch (Exception exception) {
                        this.status = -1;
                        ViewerTools.I(2401513, exception);
                        try {
                            if (createChildren == null) {
                                createChildren = new HelpFrame();
                            }
                            createChildren.setLocation(new URL(string));
                        }
                        catch (IOException iOException) {
                            ViewerTools.I(2401514, iOException);
                        }
                    }
                }
            }
        }
    }

    private void addDrillDownCard() {
        if (this.black != null && !this.black.equals(this.blue.getCursor())) {
            this.blue.setCursor(this.black);
            this.black = null;
            this.blue = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            if (this.clearMem) {
                Point point = mouseEvent.getPoint();
                if (this.convertInchToPixel == null) {
                    this.convertInchToPixel = new Vector();
                } else {
                    this.convertInchToPixel.removeAllElements();
                }
                Rectangle rectangle = this.afterDoAction(this.close, point);
                if (!rectangle.equals(this.clickOnField) && this.convertInchToPixel.size() > 0) {
                    Graphics graphics = this.getGraphics();
                    try {
                        this.background(graphics);
                        this.clickOnField = rectangle;
                        this.background(graphics);
                    }
                    finally {
                        graphics.dispose();
                    }
                }
            }
        } else if (mouseEvent.getID() == 503) {
            Component component = this.addElement(this, mouseEvent.getPoint());
            if (component != null) {
                this.black = component.getCursor();
                component.setCursor(new Cursor(12));
                this.blue = component;
                super.processMouseMotionEvent(mouseEvent);
                return;
            }
            this.addDrillDownCard();
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    boolean C(JRObjectResult jRObjectResult) {
        int n = jRObjectResult.getLinkComm();
        boolean bl = false;
        if (n != -1) {
            Communicator communicator;
            if (this.curComm != null && (communicator = this.curComm.getLinkedComm(n)) != null) {
                int n2 = 0;
                try {
                    n2 = communicator.getLinkedPage(jRObjectResult.getLinkCondition());
                }
                catch (JRStopEngineException jRStopEngineException) {
                    this.status = 2;
                    JRLog.error(131600, jRStopEngineException);
                }
                bl = n2 >= 0;
            }
        } else {
            String string = this.curComm == null ? null : this.curComm.getLinkedInfo(jRObjectResult.getLinkCondition());
            bl = string != null;
        }
        return bl;
    }

    private Component addElement(Container container, Point point) {
        Component component = container.getComponentAt(point);
        if (component != null) {
            JRObjectResult jRObjectResult;
            Object object;
            if (component instanceof JRObjectLinkRender && (object = ((JRObjectLinkRender)((Object)component)).getProperties()) != null && object instanceof JRObjectResult && ((jRObjectResult = (JRObjectResult)object).getLinkPage() != -1 || jRObjectResult.getLinkComm() != -1)) {
                return component;
            }
            if (component instanceof Container && component != container) {
                object = component.getLocation();
                ((Point)object).x = point.x - ((Point)object).x;
                ((Point)object).y = point.y - ((Point)object).y;
                return this.addElement((Container)component, (Point)object);
            }
        }
        return null;
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.isControlDown() && keyEvent.getKeyCode() == 67) {
            this.copySelection();
        }
        super.processKeyEvent(keyEvent);
    }

    public void copySelection() {
        int n = this.convertInchToPixel.size();
        if (n > 0) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String string = "";
            Rectangle rectangle = null;
            Vector<JReportField> vector = new Vector<JReportField>();
            for (int i = 0; i < n; ++i) {
                int n2;
                JReportField jReportField = (JReportField)this.convertInchToPixel.elementAt(i);
                Rectangle rectangle2 = jReportField.mapBoundsToBoard();
                if (rectangle == null) {
                    rectangle = rectangle2;
                    vector.addElement(jReportField);
                } else if (rectangle2.y < rectangle.y + rectangle.height) {
                    n2 = 0;
                    int n3 = 0;
                    int n4 = vector.size();
                    while (n3 != n4) {
                        n2 = (n3 + n4) / 2;
                        TransparentPeer transparentPeer = (TransparentPeer)vector.elementAt(n2);
                        Rectangle rectangle3 = transparentPeer.mapBoundsToBoard();
                        if (rectangle2.x > rectangle3.x) {
                            n3 = ++n2;
                            continue;
                        }
                        n4 = n2;
                    }
                    vector.insertElementAt(jReportField, n2);
                }
                if (rectangle2.y < rectangle.y + rectangle.height && i != n - 1) continue;
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    JReportField jReportField2 = (JReportField)vector.elementAt(n2);
                    string = string + (n2 == 0 ? "" : "\t") + jReportField2.Z;
                }
                string = string + "\n";
                if (i != 0 && i == n - 1 && rectangle2.y >= rectangle.y + rectangle.height) {
                    string = string + jReportField.Z + "\n";
                    continue;
                }
                vector.removeAllElements();
                rectangle = rectangle2;
                vector.addElement(jReportField);
            }
            clipboard.setContents(new StringSelection(string), null);
        }
    }

    private Rectangle afterDoAction(Point point, Point point2) {
        Rectangle rectangle;
        TransparentPeer transparentPeer;
        int n;
        Point point3 = this.mapToBoard(point.x, point.y);
        Point point4 = this.mapToBoard(point2.x, point2.y);
        Rectangle rectangle2 = new Rectangle(Math.min(point3.x, point4.x), Math.min(point3.y, point4.y), Math.abs(point3.x - point4.x), Math.abs(point3.y - point4.y));
        for (n = 0; n < this.viewerClient.getComponentCount(); ++n) {
            transparentPeer = (TransparentPeer)((Object)this.viewerClient.getComponent(n));
            rectangle = transparentPeer.mapBoundsToBoard();
            if (!(transparentPeer instanceof TContainer) || !rectangle.intersects(rectangle2)) continue;
            this.append(rectangle2, (TContainer)transparentPeer, this.convertInchToPixel);
        }
        for (n = 0; n < this.convertInchToPixel.size(); ++n) {
            transparentPeer = (TransparentPeer)this.convertInchToPixel.elementAt(n);
            rectangle = transparentPeer.mapBoundsToBoard();
            if (n == 0) {
                point3.x = rectangle.x;
                point3.y = rectangle.y;
                point4.x = rectangle.x + rectangle.width;
                point4.y = rectangle.y + rectangle.height;
                continue;
            }
            point3.x = Math.min(rectangle.x, point3.x);
            point3.y = Math.min(rectangle.y, point3.y);
            point4.x = Math.max(rectangle.x + rectangle.width, point4.x);
            point4.y = Math.max(rectangle.y + rectangle.height, point4.y);
        }
        rectangle2.x = point3.x;
        rectangle2.y = point3.y;
        rectangle2.width = point4.x - point3.x;
        rectangle2.height = point4.y - point3.y;
        this.mapToComp(rectangle2);
        return rectangle2;
    }

    private void append(Rectangle rectangle, TContainer tContainer, Vector vector) {
        for (int i = 0; i < tContainer.getComponentCount(); ++i) {
            TransparentPeer transparentPeer;
            Rectangle rectangle2;
            if (!(tContainer.getComponent(i) instanceof TransparentPeer) || !(rectangle2 = (transparentPeer = (TransparentPeer)((Object)tContainer.getComponent(i))).mapBoundsToBoard()).intersects(rectangle)) continue;
            if (transparentPeer instanceof TContainer) {
                this.append(rectangle, (TContainer)transparentPeer, vector);
                continue;
            }
            if (!(transparentPeer instanceof JReportField)) continue;
            int n = 0;
            int n2 = 0;
            int n3 = vector.size();
            while (n2 != n3) {
                n = (n2 + n3) / 2;
                TransparentPeer transparentPeer2 = (TransparentPeer)vector.elementAt(n);
                Rectangle rectangle3 = transparentPeer2.mapBoundsToBoard();
                if (rectangle2.y > rectangle3.y || rectangle2.y == rectangle3.y && rectangle2.x > rectangle3.x) {
                    n2 = ++n;
                    continue;
                }
                n3 = n;
            }
            vector.insertElementAt(transparentPeer, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void auxinfo() {
        if (this.clearMem) {
            Graphics graphics = this.getGraphics();
            try {
                this.background(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
        this.clickOnField = null;
        this.convertInchToPixel = null;
        this.clearMem = false;
    }

    private void background(Graphics graphics) {
        if (this.clickOnField != null && !this.clickOnField.isEmpty()) {
            graphics.setXORMode(Color.darkGray);
            graphics.setColor(Color.black);
            graphics.fillRect(this.clickOnField.x, this.clickOnField.y, this.clickOnField.width, this.clickOnField.height);
            graphics.setPaintMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        Rectangle rectangle;
        Rectangle rectangle2;
        block49: {
            int n;
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 5401503, new Integer(this.curPageNumber));
            }
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
            Insets insets = this.getInsets();
            Rectangle rectangle3 = this.getBounds();
            rectangle2 = graphics.getClipBounds();
            rectangle = this.viewerClient.getBounds();
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 5401504, rectangle3);
                JRLog.trace(4, 5401505, this.viewerClient);
            }
            if (!this.changeContentsSize) {
                try {
                    if (this.curComm.getHeaderInfo((int)0).background != null) {
                        graphics.setColor(this.curComm.getHeaderInfo((int)0).background);
                        graphics.fillRect(insets.left, insets.top, rectangle3.width - 1 - insets.left - insets.right, rectangle3.height - 1 - insets.top - insets.bottom);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (this.addChildWithoutNotify && this.KEY_FRACTIONALMETRICS != null) {
                    boolean bl = rectangle.y > insets.top || rectangle.height < rectangle3.height - insets.top - insets.bottom;
                    graphics.setColor(this.KEY_FRACTIONALMETRICS);
                    if (bl) {
                        for (n = insets.left; n < rectangle3.width - 1 - insets.left - insets.right; n += 8) {
                            if (rectangle.y > insets.top) {
                                graphics.drawLine(n, rectangle.y - 1, n + 4, rectangle.y - 1);
                            }
                            if (rectangle.height >= rectangle3.height - insets.top - insets.bottom) continue;
                            graphics.drawLine(n, rectangle.y + rectangle.height, n + 4, rectangle.y + rectangle.height);
                        }
                    }
                    boolean bl2 = bl = rectangle.x > insets.left || rectangle.width < rectangle3.width - insets.left - insets.right;
                    if (bl) {
                        for (n = insets.top; n < rectangle3.height - 1 - insets.top - insets.bottom; n += 8) {
                            if (rectangle.x > insets.left) {
                                graphics.drawLine(rectangle.x - 1, n, rectangle.x - 1, n + 4);
                            }
                            if (rectangle.width >= rectangle3.width - insets.left - insets.right) continue;
                            graphics.drawLine(rectangle.x + rectangle.width, n, rectangle.x + rectangle.width, n + 4);
                        }
                    }
                }
            }
            Rectangle rectangle4 = rectangle2.intersection(rectangle);
            graphics.setClip(rectangle4);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 5401506, graphics.getClipBounds());
            }
            try {
                int n2;
                Object object;
                Object object2;
                int n3;
                n = this.viewerClient.getComponentCount();
                Vector<Component> vector = new Vector<Component>();
                Vector<Component> vector2 = new Vector<Component>();
                Component component = null;
                for (n3 = n - 1; n3 >= 0; --n3) {
                    Object object3;
                    Component component2 = this.viewerClient.getComponent(n3);
                    rectangle3 = component2.getBounds();
                    rectangle3.x += rectangle.x;
                    rectangle3.y += rectangle.y;
                    if (!component2.isVisible() || rectangle4 == null || !rectangle4.intersects(rectangle3)) continue;
                    if (component2 instanceof JReportTable) {
                        this.addDrillDownCard = rectangle3.width;
                        component = (JReportTable)component2;
                        if (!((TransparentPeer)((Object)component2)).hasEraser()) continue;
                        object3 = rectangle4.intersection(rectangle3);
                        graphics.setColor(component2.getBackground());
                        graphics.fillRect(((Rectangle)object3).x, ((Rectangle)object3).y, ((Rectangle)object3).width, ((Rectangle)object3).height);
                        continue;
                    }
                    if (component2 instanceof JReportContainer) {
                        if (component2 instanceof JReportSection) {
                            object3 = ((JReportSection)component2).getFillProp();
                            if (object3 != null) {
                                object2 = new FillPatternAdapter((FillPatternProperties)object3);
                                object = rectangle4.intersection(rectangle3);
                                ((FillPatternAdapter)object2).fillPattern(graphics, (Shape)object);
                            }
                            if (this.addDrillDownCard != -1) {
                                ((JReportSection)component2).I(this.addDrillDownCard);
                            }
                        }
                        vector2.addElement(component2);
                        continue;
                    }
                    if (component2 instanceof JReportGTBox || component2 instanceof JReportLine) {
                        vector.addElement(component2);
                        continue;
                    }
                    ViewerTools.I(component2, graphics);
                }
                if (component != null) {
                    rectangle3 = component.getBounds();
                    rectangle3.x += rectangle.x;
                    rectangle3.y += rectangle.y;
                    Graphics graphics2 = graphics.create(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    try {
                        ((JReportTable)component).paint(graphics2);
                    }
                    finally {
                        graphics2.dispose();
                    }
                }
                n3 = vector.size();
                int n4 = vector2.size();
                for (n2 = 0; n2 < n3 + n4; ++n2) {
                    if (n2 < n3) {
                        object2 = (Component)vector.elementAt(n2);
                        if (!((TComponent)object2).hasEraser()) {
                            continue;
                        }
                    } else {
                        object2 = (Component)vector2.elementAt(n2 - n3);
                    }
                    rectangle3 = ((Component)object2).getBounds();
                    rectangle3.x += rectangle.x;
                    rectangle3.y += rectangle.y;
                    object = graphics.create(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    try {
                        if (n2 < n3) {
                            ((FigurePeer)object2).paintInterior((Graphics)object);
                            continue;
                        }
                        ((Component)object2).paint((Graphics)object);
                        continue;
                    }
                    finally {
                        ((Graphics)object).dispose();
                    }
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    object2 = (TComponent)vector.elementAt(n2);
                    rectangle3 = ((Component)object2).getBounds();
                    rectangle3.x += rectangle.x;
                    rectangle3.y += rectangle.y;
                    object = graphics.create(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    try {
                        ((FigurePeer)object2).paintShape((Graphics)object);
                        continue;
                    }
                    finally {
                        ((Graphics)object).dispose();
                    }
                }
                if (component == null || !component.isVisible()) break block49;
                Rectangle rectangle5 = component.getBounds();
                rectangle5.x += rectangle.x;
                rectangle5.y += rectangle.y;
                object2 = graphics.create(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
                try {
                    ((JReportTable)component).paintInterior((Graphics)object2);
                }
                finally {
                    ((Graphics)object2).dispose();
                }
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                this.status = -1;
                ViewerTools.I(2401516, exception);
            }
        }
        try {
            if (((DataStream)this.curComm.getDataStream(0)).ie() == 1) {
                int n = rectangle.x + Unit.convertInchToPixel(2.0);
                int n5 = rectangle.y + Unit.convertInchToPixel(1.0);
                this.changeContentsSize(graphics, n, n5);
            }
        }
        catch (JRStopEngineException jRStopEngineException) {
            this.status = 2;
            ViewerTools.I(131600, jRStopEngineException);
        }
        this.background(graphics);
        graphics.setClip(rectangle2);
    }

    static JReportObjectRender I(JRObjectResult jRObjectResult) {
        return ViewerTools.I(jRObjectResult, false);
    }

    public void clearMem() {
        this.curPage = null;
        if (this.dataStream != null) {
            this.dataStream.clearMem();
            this.dataStream = null;
        }
        this.curPageNumber = 1;
        if (this.viewerClient != null) {
            this.viewerClient.removeAll();
            this.viewerClient = null;
        }
        if (this.thread != null) {
            this.thread.stop();
        }
        this.drillDownImplement = null;
        this.showPageNumberImplement = null;
        this.curComm = null;
        this.mainComm = null;
        this.sizeChangedListener = null;
        if (this.VALUE_FRACTIONALMETRICS_ON != null) {
            this.VALUE_FRACTIONALMETRICS_ON.removeAllElements();
            this.VALUE_FRACTIONALMETRICS_ON = null;
        }
        this.undoRedoListener = null;
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void clickOnField(Record record) {
        if (this.VALUE_FRACTIONALMETRICS_ON != null) {
            for (int i = 0; i < this.VALUE_FRACTIONALMETRICS_ON.size(); ++i) {
                ((ClickActionListener)this.VALUE_FRACTIONALMETRICS_ON.elementAt(i)).clickOnField(record);
            }
        }
    }

    private int[] black() {
        int[] nArray = new int[3];
        nArray[0] = this.getCurrentPageNumber();
        if (this.sizeChangedListener != null) {
            int[] nArray2 = this.sizeChangedListener.getScrollPosition();
            nArray[1] = nArray2[0];
            nArray[2] = nArray2[1];
        }
        return nArray;
    }

    private void blue() {
        this.createTempFile.push(this.black());
        if (this.currentTimeMillis != null) {
            this.currentTimeMillis.removeAllElements();
        }
        if (this.undoRedoListener != null) {
            this.undoRedoListener.afterDoAction(this.createTempFile.size(), this.currentTimeMillis.size());
        }
    }

    public void undo() throws JRStopEngineException {
        int[] nArray;
        if (!this.createTempFile.empty() && (nArray = (int[])this.createTempFile.pop()) != null) {
            this.currentTimeMillis.push(this.black());
            this.doSaveUndoRedoInfo = false;
            this.gotoPage(nArray[0]);
            this.doSaveUndoRedoInfo = true;
            if (this.sizeChangedListener != null) {
                this.sizeChangedListener.scrolls(-nArray[1], -nArray[2]);
                this.sizeChangedListener.setScrollPosition(nArray[1], nArray[2]);
            }
            if (this.undoRedoListener != null) {
                this.undoRedoListener.afterDoAction(this.createTempFile.size(), this.currentTimeMillis.size());
            }
        }
    }

    public void redo() throws JRStopEngineException {
        int[] nArray;
        if (!this.currentTimeMillis.empty() && (nArray = (int[])this.currentTimeMillis.pop()) != null) {
            this.createTempFile.push(this.black());
            this.doSaveUndoRedoInfo = false;
            this.gotoPage(nArray[0]);
            this.doSaveUndoRedoInfo = true;
            if (this.sizeChangedListener != null) {
                this.sizeChangedListener.scrolls(-nArray[1], -nArray[2]);
                this.sizeChangedListener.setScrollPosition(nArray[1], nArray[2]);
            }
            if (this.undoRedoListener != null) {
                this.undoRedoListener.afterDoAction(this.createTempFile.size(), this.currentTimeMillis.size());
            }
        }
    }

    protected boolean getBooleanPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    protected int getIntPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    protected String getStringPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getStringPropertyByName(jRObjectResult, string);
    }

    private Rectangle bottom(DSPage dSPage, int n) {
        Rectangle rectangle;
        if (this.changeContentsSize) {
            int n2;
            Vector vector = dSPage.getChildren();
            JRObjectResult jRObjectResult = null;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (!(vector.get(n2) instanceof DSBody)) continue;
                jRObjectResult = (DSBody)vector.get(n2);
                break;
            }
            n2 = 0;
            int n3 = 0;
            if (jRObjectResult == null) {
                return new Rectangle(0, 0, 0, 0);
            }
            n2 = ((Number)jRObjectResult.getTemplate().getPropertyByName("Width").getObject()).intValue();
            n3 = ((Number)jRObjectResult.getTemplate().getPropertyByName("Height").getObject()).intValue();
            rectangle = new Rectangle(0, 0, n2, n3);
            rectangle = ViewerTools.I(rectangle, n);
        } else {
            Rectangle rectangle2 = dSPage.getPrintableArea();
            rectangle = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            rectangle = ViewerTools.I(rectangle, n);
        }
        return rectangle;
    }

    private void ccutil(DSPage dSPage, int n) {
        Insets insets = this.getInsets();
        Rectangle rectangle = this.bottom(dSPage, n);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        if (!this.isForPS) {
            this.viewerClient.setBounds(rectangle);
        }
        Rectangle rectangle2 = dSPage.getPageArea();
        Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        rectangle3 = ViewerTools.I(rectangle3, n);
        rectangle3.x += insets.left;
        rectangle3.y += insets.top;
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 5401507, rectangle2);
        }
        if (this.changeContentsSize) {
            rectangle3 = this.bottom(dSPage, n);
        }
        this.setSize(rectangle3.width, rectangle3.height);
    }

    private void changeContentsSize(Graphics graphics, int n, int n2) {
        Rectangle rectangle = graphics.getClipBounds();
        String string = "JReport Evaluation Copy";
        String string2 = "To purchase contact " + JResource.getMessage("Sale");
        String string3 = JResource.getMessage("SalePhone") + " / " + JResource.getMessage("homeURL");
        Font font = FontSets.getFont("*ArialNarrow", 0, 20);
        Font font2 = font.deriveFont(12.0f);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font2);
        int n3 = Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth(string);
        int n4 = fontMetrics.stringWidth(string2);
        int n5 = fontMetrics.stringWidth(string3);
        int n6 = Unit.convertInchToPixel(2.0);
        int n7 = Unit.convertInchToPixel(3.0);
        graphics.setColor(Color.cyan);
        graphics.setClip(rectangle);
        do {
            graphics.setFont(font);
            Painter.drawText(graphics, string, n - n3 / 2, n2);
            graphics.setFont(font2);
            Painter.drawText(graphics, string2, n - n4 / 2, n2 + 14);
            Painter.drawText(graphics, string3, n - n5 / 2, 28 + n2);
            n += n7;
        } while ((n2 += n6) < rectangle.y + rectangle.height);
    }

    public void setIsForPS(boolean bl) {
        this.isForPS = bl;
    }

    class AppletCache
    extends ViewerExportingInfo {
        AppletCache() {
        }

        @Override
        public boolean isExport(JRObjectResult jRObjectResult) {
            Propertiable propertiable;
            boolean bl = super.isExport(jRObjectResult);
            if (bl && (propertiable = jRObjectResult.getPropertyByName("ExportToApplet")) != null) {
                return (Boolean)propertiable.getObject();
            }
            return bl;
        }

        @Override
        public String getFormat() {
            return "Applet";
        }
    }
}

