/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.util.JRLog;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import jet.util.MemorySizes;

public final class MemoryCounter {
    private static final MemorySizes FALSE = new MemorySizes();
    private Map<Object, ?> SEDU = null;
    private Stack<Object> TRUE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long estimate(Object object) {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, " START Estimate size of " + object);
        }
        try {
            this.SEDU = new IdentityHashMap();
            this.TRUE = new Stack();
            long l = this.TRUE(object);
            while (!this.TRUE.isEmpty()) {
                l += this.TRUE(this.TRUE.pop());
            }
            long l2 = l;
            return l2;
        }
        catch (Throwable throwable) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2210601, new String[]{String.valueOf(object)}, throwable);
            }
            long l = 0L;
            return l;
        }
        finally {
            if (JRLog.isTrace(7)) {
                if (this.SEDU != null) {
                    JRLog.trace(7, " END estimate size of " + object + ", " + this.SEDU.size() + " object(s) caclucated");
                } else {
                    JRLog.trace(7, " END estimate size of " + object);
                }
            }
            if (this.SEDU != null) {
                this.SEDU.clear();
            }
            if (this.TRUE != null) {
                this.TRUE.clear();
            }
            this.SEDU = null;
            this.TRUE = null;
        }
    }

    private boolean FALSE(Object object) {
        if (MemoryCounter.SEDU(object)) {
            return true;
        }
        return object == null || this.SEDU.containsKey(object);
    }

    private static boolean SEDU(Object object) {
        if (object instanceof Comparable) {
            if (object instanceof Enum) {
                return true;
            }
            if (object instanceof String) {
                return object == ((String)object).intern();
            }
            if (object instanceof Boolean) {
                return object == Boolean.TRUE || object == Boolean.FALSE;
            }
            if (object instanceof Integer) {
                return object == Integer.valueOf((Integer)object);
            }
            if (object instanceof Short) {
                return object == Short.valueOf((Short)object);
            }
            if (object instanceof Byte) {
                return object == Byte.valueOf((Byte)object);
            }
            if (object instanceof Long) {
                return object == Long.valueOf((Long)object);
            }
            if (object instanceof Character) {
                return object == Character.valueOf(((Character)object).charValue());
            }
        }
        return false;
    }

    private long TRUE(Object object) {
        Class<?> clazz;
        if (this.FALSE(object)) {
            return 0L;
        }
        this.SEDU.put(object, null);
        long l = 0L;
        if (clazz.isArray()) {
            return this._estimateArray(object);
        }
        for (clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (Modifier.isStatic(fieldArray[i].getModifiers())) continue;
                if (fieldArray[i].getType().isPrimitive()) {
                    l += (long)FALSE.getPrimitiveFieldSize(fieldArray[i].getType());
                    continue;
                }
                l += (long)FALSE.getPointerSize();
                fieldArray[i].setAccessible(true);
                try {
                    Object object2 = fieldArray[i].get(object);
                    if (object2 == null) continue;
                    this.TRUE.add(object2);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return -1L;
                }
            }
        }
        return this._estimateArray(l += (long)FALSE.getClassSize());
    }

    private long _estimateArray(long l) {
        if (l % 8L != 0L) {
            l += 8L - l % 8L;
        }
        return l;
    }

    protected long _estimateArray(Object object) {
        long l = 16L;
        int n = Array.getLength(object);
        if (n != 0) {
            Class<?> clazz = object.getClass().getComponentType();
            if (clazz.isPrimitive()) {
                l += (long)(n * FALSE.getPrimitiveArrayElementSize(clazz));
            } else {
                for (int i = 0; i < n; ++i) {
                    l += (long)FALSE.getPointerSize() + this.TRUE(Array.get(object, i));
                }
            }
        }
        return l;
    }
}

