/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.util.DataMappingNLSBundle;
import jet.util.JStringToolKit;
import jet.util.NLSResourceBundle;
import jet.util.nls.NLSResource;
import jet.util.nls.NLSToolKit;

public class NLSResourceBundleManager
extends NLSToolKit {
    private static final int FILENAME_CONCAT_CHAR = NLSResourceBundle.PROPS_FILE_EXTENSION.length();

    public static boolean deleteDataMappingNLSBundleFile(String string, String string2, Locale locale) {
        return NLSResourceBundleManager.deleteDataMappingNLSBundleFile(null, string, string2, locale);
    }

    public static void saveDataMappingNLSBundle(NLSResourceBundle nLSResourceBundle, String string, String string2, Locale locale) throws IOException {
        NLSResourceBundleManager.saveDataMappingNLSBundle(null, nLSResourceBundle, string, string2, locale);
    }

    public static NLSResourceBundle loadReportNLSResourceBundle(File file, Locale locale, String string) {
        if (file == null) {
            return null;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205001, new String[]{file.getAbsolutePath(), String.valueOf(locale)});
        }
        Object[] objectArray = NLSResourceBundleManager.FILENAME_CONCAT_CHAR(file);
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.loadNLSResourceBundle((File)objectArray[0], (String)objectArray[1], locale, string);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205004, new String[]{file.getAbsolutePath(), String.valueOf(locale)});
        }
        return nLSResourceBundle;
    }

    private static Object[] FILENAME_CONCAT_CHAR(File file) {
        File file2 = file.getParentFile();
        String string = file.getName();
        String string2 = string.toLowerCase();
        int n = string.length();
        if (string2.endsWith(".cls")) {
            string = string.substring(0, n - ".cls".length());
        } else if (string2.endsWith(".rpt")) {
            string = string.substring(0, n - ".rpt".length());
        } else if (string2.endsWith(".lc")) {
            string = string.substring(0, n - ".lc".length());
            file2 = new File(file2, "LCNLS");
        } else if (string2.endsWith(".dsh")) {
            string = string.substring(0, n - 4);
            file2 = new File(file2, "DASHNLS");
        }
        return new Object[]{file2, string};
    }

    public static NLSResourceBundle loadNLSResourceBundle(File file, String string, Locale locale, String string2) {
        String string3 = string;
        Locale locale2 = null;
        Locale locale3 = null;
        if (locale == null || String.valueOf(locale).length() == 0 || locale.getLanguage().length() == 0) {
            string3 = string + NLSResourceBundle.PROPS_FILE_EXTENSION;
            locale2 = new Locale("", "");
            locale3 = null;
        } else if (locale.getVariant().length() > 0) {
            string3 = string + NLSResourceBundle.FILENAME_CONCAT_CHAR + String.valueOf(locale) + NLSResourceBundle.PROPS_FILE_EXTENSION;
            locale2 = locale;
            locale3 = new Locale(locale.getLanguage(), locale.getCountry());
        } else if (locale.getCountry().length() > 0) {
            string3 = string + NLSResourceBundle.FILENAME_CONCAT_CHAR + String.valueOf(locale) + NLSResourceBundle.PROPS_FILE_EXTENSION;
            locale2 = locale;
            locale3 = new Locale(locale.getLanguage(), "");
        } else {
            string3 = string + NLSResourceBundle.FILENAME_CONCAT_CHAR + locale.getLanguage() + NLSResourceBundle.PROPS_FILE_EXTENSION;
            locale2 = new Locale(locale.getLanguage(), "");
            locale3 = new Locale("", "");
        }
        File file2 = new File(file, string3);
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSBundleInstance(locale2);
        NLSResourceBundleManager.KEYPREFIXES(nLSResourceBundle, file2, string2);
        if (locale3 != null) {
            NLSResourceBundle nLSResourceBundle2 = NLSResourceBundleManager.loadNLSResourceBundle(file, string, locale3, string2);
            nLSResourceBundle.resetParent(nLSResourceBundle2);
        }
        return nLSResourceBundle;
    }

    public static void saveReportNLSResourceBundle(DiskStore diskStore, NLSResourceBundle nLSResourceBundle, File file, Locale locale, boolean bl, boolean bl2) throws IOException {
        if (locale == null) {
            locale = new Locale("", "", "");
        }
        Object[] objectArray = NLSResourceBundleManager.FILENAME_CONCAT_CHAR(file);
        NLSResourceBundleManager.saveNLSResourceBundle(diskStore, nLSResourceBundle, (File)objectArray[0], (String)objectArray[1], locale, bl, bl2);
    }

    public static void saveNLSResourceBundle(DiskStore diskStore, NLSResourceBundle nLSResourceBundle, File file, String string, Locale locale, boolean bl, boolean bl2) throws IOException {
        Object object;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205005, new Object[]{string, locale, bl, bl2});
        }
        NLSResourceBundle nLSResourceBundle2 = (NLSResourceBundle)nLSResourceBundle.duplicate();
        nLSResourceBundle2.resetLocale(locale);
        if (!bl) {
            object = NLSResourceBundleManager.loadNLSResourceBundle(file, string, locale, null);
            nLSResourceBundle2.mergeWith((NLSResourceBundle)object, bl2);
        }
        object = string;
        object = locale == null || String.valueOf(locale).length() == 0 || locale.getLanguage().length() == 0 ? string + NLSResourceBundle.PROPS_FILE_EXTENSION : string + NLSResourceBundle.FILENAME_CONCAT_CHAR + String.valueOf(locale) + NLSResourceBundle.PROPS_FILE_EXTENSION;
        File file2 = new File(file, (String)object);
        NLSResourceBundleManager.PROPS_FILE_EXTENSION(diskStore, nLSResourceBundle2, file2);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205007, new Object[]{string, locale, file2.getAbsolutePath()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void KEYPREFIXES(NLSResourceBundle nLSResourceBundle, File file, String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205002, new String[]{file.getAbsolutePath()});
        }
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                nLSResourceBundle.load(fileInputStream);
                return;
            }
            catch (IOException iOException) {
                if (!JRLog.isTrace(6)) return;
                JRLog.trace(6, 6205003, new String[]{iOException.getMessage(), file.getAbsolutePath()});
                return;
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (!JRLog.isTrace(6)) return;
        JRLog.trace(6, 6205003, new String[]{"FileNotFound", file.getAbsolutePath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void PROPS_FILE_EXTENSION(DiskStore diskStore, NLSResourceBundle nLSResourceBundle, File file) throws IOException {
        File file2;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205006, new String[]{file.getAbsolutePath()});
        }
        if (!(file2 = file.getParentFile()).exists()) {
            file2.mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            nLSResourceBundle.store(fileOutputStream);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            finally {
                fileOutputStream = null;
            }
        }
        if (diskStore != null) {
            try {
                diskStore.fileUpdated(file);
            }
            catch (OutOfSpaceException outOfSpaceException) {
                file.delete();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "Because no enough space, " + file + "didnot created.");
                }
                throw new IOException("No enough space");
            }
            catch (IOException iOException) {
                file.delete();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "Because no enough space, " + file + "didnot created!");
                }
                throw new IOException("No enough space");
            }
        }
    }

    public static Locale[] getAvailableLocalesOfReport(File file) {
        if (file.isDirectory()) {
            return new Locale[0];
        }
        Object[] objectArray = NLSResourceBundleManager.FILENAME_CONCAT_CHAR(file);
        File[] fileArray = NLSResourceBundleManager.SEDU((String)objectArray[1], NLSResourceBundle.PROPS_FILE_EXTENSION, (File)objectArray[0]);
        return NLSResourceBundleManager.Z(fileArray, (String)objectArray[1]);
    }

    public static Locale[] getAvailableLocalesOf(File file, String string) {
        File[] fileArray = NLSResourceBundleManager.SEDU(string, NLSResourceBundle.PROPS_FILE_EXTENSION, file);
        return NLSResourceBundleManager.Z(fileArray, string);
    }

    private static File[] SEDU(final String string, final String string2, File file) {
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string3) {
                return string3.toLowerCase().endsWith(string2) && string3.startsWith(string);
            }
        });
    }

    public static boolean deleteReportNLSResourceBundle(DiskStore diskStore, File file, Locale locale) {
        if (file == null) {
            return false;
        }
        Object[] objectArray = NLSResourceBundleManager.FILENAME_CONCAT_CHAR(file);
        return NLSResourceBundleManager.deleteNLSResourceBundle(diskStore, (File)objectArray[0], (String)objectArray[1], locale);
    }

    public static boolean deleteNLSResourceBundle(DiskStore diskStore, File file, String string, Locale locale) {
        String string2 = string;
        string2 = locale == null || String.valueOf(locale).length() == 0 || locale.getLanguage().length() == 0 ? string + NLSResourceBundle.PROPS_FILE_EXTENSION : string + NLSResourceBundle.FILENAME_CONCAT_CHAR + String.valueOf(locale) + NLSResourceBundle.PROPS_FILE_EXTENSION;
        File file2 = new File(file, string2);
        if (file2.exists()) {
            if (diskStore != null) {
                diskStore.delete(file2);
            }
            return file2.delete();
        }
        return false;
    }

    private static Locale[] Z(File[] fileArray, String string) {
        int n = fileArray == null ? 0 : fileArray.length;
        Vector<Locale> vector = new Vector<Locale>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = fileArray[i].getName();
            string2 = string2.substring(string.length(), string2.length() - FILENAME_CONCAT_CHAR);
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (!string2.startsWith(NLSResourceBundle.FILENAME_CONCAT_CHAR)) continue;
            int n2 = string2.indexOf(95, 1);
            if (n2 > 0) {
                string3 = string2.substring(1, n2);
                int n3 = string2.indexOf(95, n2 + 1);
                if (n3 > 0) {
                    string4 = string2.substring(n2 + 1, n3);
                    string5 = string2.substring(n3 + 1);
                } else {
                    string4 = string2.substring(n2 + 1, string2.length());
                }
            } else {
                string3 = string2.substring(1);
            }
            if (!NLSResourceBundleManager.add(string3, string4, string5)) continue;
            vector.add(new Locale(string3, string4, string5));
        }
        return vector.toArray(new Locale[0]);
    }

    private static boolean add(String string, String string2, String string3) {
        if (NLSResourceBundleManager.addAll(string)) {
            if (string2 == null || string2.length() == 0) {
                return true;
            }
            return NLSResourceBundleManager.append(string2);
        }
        return false;
    }

    private static boolean addAll(String string) {
        String[] stringArray = Locale.getISOLanguages();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean append(String string) {
        String[] stringArray = Locale.getISOCountries();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static File[] getAvailableNLSFilesForBaseName(File file, String string, Locale locale) {
        Locale locale2 = locale;
        Vector<File> vector = new Vector<File>(4);
        do {
            String string2 = string;
            if (locale2 == null || String.valueOf(locale2).length() == 0 || locale2.getLanguage().length() == 0) {
                string2 = string + NLSResourceBundle.PROPS_FILE_EXTENSION;
                locale2 = null;
            } else if (locale2.getVariant().length() > 0) {
                string2 = string + NLSResourceBundle.FILENAME_CONCAT_CHAR + String.valueOf(locale2) + NLSResourceBundle.PROPS_FILE_EXTENSION;
                locale2 = new Locale(locale2.getLanguage(), locale2.getCountry());
            } else if (locale2.getCountry().length() > 0) {
                string2 = string + NLSResourceBundle.FILENAME_CONCAT_CHAR + String.valueOf(locale2) + NLSResourceBundle.PROPS_FILE_EXTENSION;
                locale2 = new Locale(locale2.getLanguage(), "");
            } else {
                string2 = string + NLSResourceBundle.FILENAME_CONCAT_CHAR + locale2.getLanguage() + NLSResourceBundle.PROPS_FILE_EXTENSION;
                locale2 = new Locale("", "");
            }
            File file2 = new File(file, string2);
            if (!file2.exists()) continue;
            vector.add(file2);
        } while (locale2 != null);
        return vector.toArray(new File[0]);
    }

    public static NLSResourceBundle loadDataMappingNLSBundle(String string, String string2, Locale locale) throws IOException {
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newDataMappingNLSBundle(locale);
        NLSResourceBundleManager.resetDataMappingNLSBundle(nLSResourceBundle, string, string2, locale);
        return nLSResourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDataMappingNLSBundle(NLSResourceBundle nLSResourceBundle, String string, String string2, Locale locale) throws IOException {
        Locale locale2 = locale;
        File file = new File(string, string2 + NLSResourceBundle.FILENAME_CONCAT_CHAR + locale + NLSResourceBundle.PROPS_FILE_EXTENSION);
        if (!file.exists()) {
            locale2 = new Locale(locale.getLanguage(), "");
            file = new File(string, string2 + NLSResourceBundle.FILENAME_CONCAT_CHAR + locale.getLanguage() + NLSResourceBundle.PROPS_FILE_EXTENSION);
            if (!file.exists()) {
                locale2 = new Locale("", "");
                file = new File(string, string2 + NLSResourceBundle.PROPS_FILE_EXTENSION);
            }
        }
        nLSResourceBundle.resetLocale(locale2);
        nLSResourceBundle.clear();
        if (file != null && file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                nLSResourceBundle.load(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
        }
    }

    public static void saveDataMappingNLSBundle(DiskStore diskStore, NLSResourceBundle nLSResourceBundle, String string, String string2, Locale locale) throws IOException {
        NLSResourceBundle nLSResourceBundle2 = nLSResourceBundle;
        nLSResourceBundle2.resetLocale(locale);
        if (locale.equals(nLSResourceBundle.getLocale())) {
            nLSResourceBundle2 = (NLSResourceBundle)nLSResourceBundle.duplicate();
            nLSResourceBundle2.resetLocale(locale);
        }
        File file = new File(string, string2 + NLSResourceBundle.FILENAME_CONCAT_CHAR + locale + NLSResourceBundle.PROPS_FILE_EXTENSION);
        NLSResourceBundleManager.PROPS_FILE_EXTENSION(diskStore, nLSResourceBundle2, file);
    }

    public static boolean deleteDataMappingNLSBundleFile(DiskStore diskStore, String string, String string2, Locale locale) {
        return NLSResourceBundleManager.deleteNLSResourceBundle(diskStore, new File(string), string2, locale);
    }

    public static List<String> getAvailableNLSResourceFilePrefix(File file) {
        Map<String, List<File>> map = NLSResourceBundleManager.getNLSResourcePrefixToFileMapping(file, null);
        Vector<String> vector = new Vector<String>(map.size() + 1);
        vector.add("");
        vector.addAll(map.keySet());
        return vector;
    }

    public static Map<String, List<File>> getNLSResourcePrefixToFileMapping(File file, Locale locale) {
        if (file == null || !file.isDirectory()) {
            return new Hashtable<String, List<File>>();
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return new Hashtable<String, List<File>>();
        }
        Hashtable<String, List<File>> hashtable = new Hashtable<String, List<File>>();
        for (File file2 : fileArray) {
            String string;
            if (file2.isDirectory() || !(string = file2.getName()).toLowerCase().endsWith(NLSResourceBundle.PROPS_FILE_EXTENSION.toLowerCase())) continue;
            string = string.substring(0, string.length() - FILENAME_CONCAT_CHAR);
            String[] stringArray = JStringToolKit.splitString(string, NLSResourceBundle.FILENAME_CONCAT_CHAR);
            int n = stringArray.length;
            boolean bl = true;
            Locale locale2 = null;
            String string2 = null;
            int n2 = 0;
            int n3 = 0;
            n3 = n >= 4 ? 3 : n - 1;
            while (n3 >= 1) {
                if (n3 == 3) {
                    if (NLSResourceBundleManager.add(stringArray[n - 3], stringArray[n - 2], stringArray[n - 1])) {
                        locale2 = new Locale(stringArray[n - 3], stringArray[n - 2], stringArray[n - 1]);
                        n2 = locale2.toString().length() + 1;
                        bl = locale == null || locale2.equals(locale);
                        break;
                    }
                    n3 = 2;
                    continue;
                }
                if (n3 == 2) {
                    if (NLSResourceBundleManager.add(stringArray[n - 2], stringArray[n - 1], null)) {
                        locale2 = new Locale(stringArray[n - 2], stringArray[n - 1]);
                        n2 = locale2.toString().length() + 1;
                        bl = locale == null || locale2.equals(locale);
                        break;
                    }
                    n3 = 1;
                    continue;
                }
                if (NLSResourceBundleManager.add(stringArray[n - 1], null, null)) {
                    n2 = stringArray[n - 1].length() + 1;
                    bl = locale == null || stringArray[n - 1].equalsIgnoreCase(locale.getLanguage());
                } else {
                    n2 = 0;
                }
                n3 = 0;
            }
            if (!bl) continue;
            string2 = n2 != 0 ? string.substring(0, string.length() - n2) : string;
            List<File> list = hashtable.get(string2);
            if (list == null) {
                list = new Vector<File>();
                hashtable.put(string2, list);
            }
            list.add(file2);
        }
        return hashtable;
    }

    public static Locale[] getAvailableLocalesOfFieldNLS(File file, String string) {
        if (file == null || !file.isDirectory()) {
            return new Locale[0];
        }
        File[] fileArray = NLSResourceBundleManager.SEDU(string, NLSResourceBundle.PROPS_FILE_EXTENSION, file);
        return NLSResourceBundleManager.Z(fileArray, string);
    }

    public static Locale parseNLSBoundleFileLocale(String string) {
        string = string.substring(0, string.length() - FILENAME_CONCAT_CHAR);
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        Vector<Locale> vector = new Vector<Locale>();
        for (int i = 0; i < n; ++i) {
            if (!string.toLowerCase().endsWith(localeArray[i].toString().toLowerCase())) continue;
            vector.add(localeArray[i]);
        }
        n = vector.size();
        Locale locale = new Locale("", "", "");
        for (int i = 0; i < n; ++i) {
            Locale locale2 = (Locale)vector.get(i);
            if (locale.toString().length() > locale2.toString().length()) continue;
            locale = locale2;
        }
        return locale;
    }

    public static NLSResourceBundle newNLSBundleInstance(Locale locale) {
        NLSResourceBundle nLSResourceBundle = new NLSResourceBundle(locale);
        nLSResourceBundle.isNewVersion = true;
        return nLSResourceBundle;
    }

    public static NLSResourceBundle newDataMappingNLSBundle(Locale locale) {
        DataMappingNLSBundle dataMappingNLSBundle = new DataMappingNLSBundle(locale);
        dataMappingNLSBundle.isNewVersion = true;
        return dataMappingNLSBundle;
    }

    public static NLSResourceBundle newNLSBundleInstance(Locale locale, InputStream inputStream) throws IOException {
        NLSResourceBundle nLSResourceBundle = new NLSResourceBundle(locale);
        nLSResourceBundle.isNewVersion = true;
        nLSResourceBundle.load(inputStream);
        return nLSResourceBundle;
    }

    public static NLSResourceBundle newDataMappingNLSBundle(Locale locale, InputStream inputStream) throws IOException {
        DataMappingNLSBundle dataMappingNLSBundle = new DataMappingNLSBundle(locale);
        dataMappingNLSBundle.isNewVersion = true;
        dataMappingNLSBundle.load(inputStream);
        return dataMappingNLSBundle;
    }

    public static NLSResourceBundle newDataMappingNLSBundle(Locale locale, Map map) {
        DataMappingNLSBundle dataMappingNLSBundle = new DataMappingNLSBundle(locale);
        dataMappingNLSBundle.isNewVersion = true;
        dataMappingNLSBundle.setReplaceMapping(3, (Map<String, String>)map, true);
        return dataMappingNLSBundle;
    }

    public static NLSResourceBundle newNLSResourceBundle(Properties properties, Locale locale) {
        Map[] mapArray = new Map[NLSResource.KEYPREFIXES.length];
        for (int i = 0; i < NLSResource.KEYPREFIXES.length; ++i) {
            mapArray[i] = new Hashtable();
        }
        block1: for (Map.Entry<Object, Object> object2 : properties.entrySet()) {
            String string = (String)object2.getKey();
            for (int i = 0; i < NLSResource.KEYPREFIXES.length; ++i) {
                if (!string.startsWith(NLSResource.KEYPREFIXES[i])) continue;
                mapArray[i].put(string.substring(NLSResource.KEYPREFIXES[i].length() + 2), String.valueOf(object2.getValue()));
                continue block1;
            }
        }
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSBundleInstance(locale);
        NLSResourceBundleManager.setReplaceMapping(nLSResourceBundle, mapArray, true);
        return nLSResourceBundle;
    }
}

