/*
 * Decompiled with CFR 0.152.
 */
package jet.util.image;

import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.resstore.loader.ImageID;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import jet.util.FileUtil;
import jet.util.JRInterruptedException;
import jet.util.image.ImageResource;
import jet.util.image.ImageResourceUtil;
import jet.util.loader.AbsCacheableLoader;
import jet.util.loader.AbsCacherKey;
import jet.util.loader.AbsCacherValue;

public class ImageResourceLoader
extends AbsCacheableLoader<ImageID, ImageResource, LoadImageResKey> {
    @Override
    protected LoadImageResKey convertToCacherKey(ImageID imageID) {
        return new LoadImageResKey(imageID);
    }

    @Override
    protected AbsCacherValue<ImageID, ImageResource, LoadImageResKey> createObjectItemInst(LoadImageResKey loadImageResKey) {
        return new ImageResourceItem(loadImageResKey);
    }

    @Override
    public ImageResource load(ImageID imageID, boolean bl) throws ResourceNotFoundException, ResourceLoadException, JRInterruptedException {
        String string = imageID.getImageName();
        if (string == null || string.isEmpty()) {
            return ImageResource.BLANK_IMAGERES;
        }
        if (FileUtil.isFileFormat(string)) {
            return (ImageResource)super.load(imageID, bl);
        }
        try {
            return ImageResourceUtil.loadImageResourceFromURL(string);
        }
        catch (IOException iOException) {
            throw new ResourceLoadException(iOException);
        }
    }

    private final class ImageResourceItem
    extends AbsCacherValue<ImageID, ImageResource, LoadImageResKey> {
        private long BLANK_IMAGERES;

        private ImageResourceItem(LoadImageResKey loadImageResKey) {
            super(loadImageResKey);
            this.BLANK_IMAGERES = 0L;
        }

        @Override
        public boolean isNeedReload() {
            File file = new File(((LoadImageResKey)this.keyInst).getCatFile);
            return file.lastModified() > this.BLANK_IMAGERES;
        }

        @Override
        public ImageResource foreceLoadValue() throws Throwable {
            File file = new File(((LoadImageResKey)this.keyInst).getCatFile);
            this.BLANK_IMAGERES = file.lastModified();
            try {
                return ImageResourceUtil.loadImageResourceFromFile(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2200013, new Object[]{((LoadImageResKey)this.keyInst).SEDU.getAbsolutePath(), file.getAbsolutePath()}, null);
                }
                return ImageResource.BLANK_IMAGERES;
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2200013, new Object[]{((LoadImageResKey)this.keyInst).SEDU.getAbsolutePath(), file.getAbsolutePath()}, (Throwable)iOException);
                }
                return ImageResource.BLANK_IMAGERES;
            }
        }

        @Override
        protected long estimateLength() {
            if (this.valueObj == ImageResource.BLANK_IMAGERES) {
                return super.doEstimateLength(null);
            }
            return super.doEstimateLength(((ImageResource)this.valueObj).getImage());
        }

        @Override
        protected void updateValueNeedNotReload() {
        }

        @Override
        protected void fireValueIsCached(boolean bl) {
        }

        @Override
        protected boolean sureCanPutInfoCacher() {
            if (this.valueObj == ImageResource.BLANK_IMAGERES) {
                return true;
            }
            int n = ((ImageResource)this.valueObj).getImageType();
            return n == 1 || n == 4 || n == 0 || n == 3;
        }
    }

    protected final class LoadImageResKey
    extends AbsCacherKey<ImageID> {
        private final File SEDU;
        private final String equals;
        private final String getCatFile;

        private LoadImageResKey(ImageID imageID) {
            super(imageID);
            this.SEDU = imageID.getCatFile();
            this.equals = imageID.getImageName();
            this.getCatFile = FileUtil.getFilePath(this.SEDU.getParent(), this.equals);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof LoadImageResKey) {
                return this.getCatFile.equals(((LoadImageResKey)object).getCatFile);
            }
            if (object instanceof ImageID) {
                return this.SEDU(((ImageID)object).getCatFile(), ((ImageID)object).getImageName());
            }
            return false;
        }

        private boolean SEDU(File file, String string) {
            if (FileUtil.isFileFormat(string)) {
                String string2 = file.getParent();
                return this.getCatFile.equals(FileUtil.getFilePath(string2, string));
            }
            return this.getCatFile.equals(string);
        }

        @Override
        public int hashCode() {
            return this.getCatFile.hashCode();
        }

        public String toString() {
            return this.getCatFile.toString();
        }
    }
}

