/*
 * Decompiled with CFR 0.152.
 */
package jet.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLWriter {
    protected PrintWriter fOut;
    protected boolean fCanonical;
    private String SEDU = null;
    private static boolean charAt = false;
    protected int fIndent;
    private boolean close = true;

    public XMLWriter() {
    }

    public XMLWriter(boolean bl) {
        this.fCanonical = bl;
    }

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(OutputStream outputStream) {
        try {
            this.setOutput(outputStream, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void writeNode(Node node) {
        String string = null;
        if (string != null) {
            this.fOut.write(string);
        } else {
            this.write(node);
        }
    }

    public void writeNode(Node node, boolean bl) {
        if (bl && node instanceof Document) {
            this.SEDU = ((Document)node).getDocumentElement().getNodeName();
        }
        this.writeNode(node);
    }

    private void write(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.fIndent = 0;
                Document document = (Document)node;
                if (!this.fCanonical) {
                    this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    this.fOut.flush();
                    this.write(document.getDoctype());
                }
                this.write(document.getDocumentElement());
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                this.fOut.print("<!DOCTYPE ");
                this.fOut.print(documentType.getName());
                String string = documentType.getPublicId();
                String string2 = documentType.getSystemId();
                if (string != null) {
                    this.fOut.print(" PUBLIC '");
                    this.fOut.print(string);
                    this.fOut.print("' '");
                    this.fOut.print(string2);
                    this.fOut.print('\'');
                } else {
                    this.fOut.print(" SYSTEM '");
                    this.fOut.print(string2);
                    this.fOut.print('\'');
                }
                String string3 = documentType.getInternalSubset();
                if (string3 != null) {
                    this.fOut.println(" [");
                    this.fOut.print(string3);
                    this.fOut.print(']');
                }
                this.fOut.println('>');
                break;
            }
            case 1: {
                this.close = false;
                if (this.fIndent > 0) {
                    this.fOut.print('\n');
                }
                this.printIndent();
                ++this.fIndent;
                this.fOut.print('<');
                this.fOut.print(node.getNodeName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes(), charAt);
                for (int i = 0; i < attrArray.length; ++i) {
                    Attr attr = attrArray[i];
                    this.fOut.print(' ');
                    this.fOut.print(attr.getNodeName());
                    this.fOut.print("=\"");
                    this.normalizeAndPrint(attr.getNodeValue());
                    this.fOut.print('\"');
                }
                this.fOut.print('>');
                this.fOut.flush();
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.write(node2);
                }
                break;
            }
            case 5: {
                if (this.fCanonical) {
                    for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                        this.write(node3);
                    }
                    break;
                }
                this.fOut.print('&');
                this.fOut.print(node.getNodeName());
                this.fOut.print(';');
                this.fOut.flush();
                break;
            }
            case 4: {
                if (this.fCanonical) {
                    this.normalizeAndPrint(node.getNodeValue());
                } else {
                    this.fOut.print("<![CDATA[");
                    this.fOut.print(node.getNodeValue());
                    this.fOut.print("]]>");
                }
                this.fOut.flush();
                break;
            }
            case 3: {
                this.normalizeAndPrint(node.getNodeValue());
                this.fOut.flush();
                break;
            }
            case 7: {
                this.fOut.print("<?");
                this.fOut.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.fOut.print(' ');
                    this.fOut.print(string);
                }
                this.fOut.println("?>");
                this.fOut.flush();
                break;
            }
        }
        if (!(s != 1 || this.SEDU != null && node.getNodeName().equals(this.SEDU))) {
            --this.fIndent;
            if (this.close) {
                this.fOut.print('\n');
                this.printIndent();
                this.fOut.print("</");
            } else {
                this.fOut.print("</");
                this.close = true;
            }
            this.fOut.print(node.getNodeName());
            this.fOut.print(">");
            this.fOut.flush();
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap, boolean bl) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        if (bl) {
            for (n = 0; n < n2 - 1; ++n) {
                String string = attrArray[n].getNodeName();
                int n3 = n;
                for (int i = n + 1; i < n2; ++i) {
                    String string2 = attrArray[i].getNodeName();
                    if (string2.compareTo(string) >= 0) continue;
                    string = string2;
                    n3 = i;
                }
                if (n3 == n) continue;
                Attr attr = attrArray[n];
                attrArray[n] = attrArray[n3];
                attrArray[n3] = attr;
            }
        }
        return attrArray;
    }

    protected void normalizeAndPrint(String string) {
        int n = string != null ? string.length() : 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.normalizeAndPrint(c);
        }
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                this.fOut.print("&quot;");
                break;
            }
            case '\n': 
            case '\r': {
                if (this.fCanonical) {
                    this.fOut.print("&#");
                    this.fOut.print(Integer.toString(c));
                    this.fOut.print(';');
                    break;
                }
            }
            default: {
                this.fOut.print(c);
            }
        }
    }

    protected void printIndent() {
        for (int i = 0; i < this.fIndent * 2; ++i) {
            this.fOut.print(' ');
        }
    }

    public void close() {
        this.fOut.close();
    }
}

