/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import util.Node;
import util.RandomAccessStream;

public abstract class StreamObject
extends Node {
    public static void output(OutputStream outputStream, StreamObject streamObject) throws IOException {
        RandomAccessStream randomAccessStream = new RandomAccessStream(255);
        streamObject.output(outputStream, randomAccessStream);
        randomAccessStream.close();
    }

    public static void output(File file, StreamObject streamObject) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            StreamObject.output(fileOutputStream, streamObject);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static void output(OutputStream outputStream, StreamObject streamObject, int n, int n2) throws IOException {
        RandomAccessStream randomAccessStream = new RandomAccessStream(255);
        randomAccessStream.writeInt(n);
        randomAccessStream.writeInt(n2);
        streamObject.output(outputStream, randomAccessStream);
        randomAccessStream.close();
    }

    public static void output(File file, StreamObject streamObject, int n, int n2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            StreamObject.output(fileOutputStream, streamObject, n, n2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            fileOutputStream.close();
        }
    }

    public abstract int getType();

    public int getLength() {
        return 0;
    }

    protected void output(OutputStream outputStream, RandomAccessStream randomAccessStream) throws IOException {
        randomAccessStream.writeInt(this.getType());
        randomAccessStream.writeInt(this.length);
        randomAccessStream.writeInt(this.getLength());
        this.outputProps(randomAccessStream);
        randomAccessStream.write(randomAccessStream.getPointer(), outputStream);
        randomAccessStream.seek(0);
        for (int i = 0; i < this.length; ++i) {
            ((StreamObject)this.nodes[i]).output(outputStream, randomAccessStream);
        }
    }

    protected void outputProps(RandomAccessStream randomAccessStream) throws IOException {
    }

    protected void output(DataOutput dataOutput, RandomAccessStream randomAccessStream) throws IOException {
        randomAccessStream.writeInt(this.getType());
        randomAccessStream.writeInt(this.length);
        randomAccessStream.writeInt(this.getLength());
        this.outputProps(randomAccessStream);
        randomAccessStream.write(randomAccessStream.getPointer(), dataOutput);
        randomAccessStream.seek(0);
        for (int i = 0; i < this.length; ++i) {
            ((StreamObject)this.nodes[i]).output(dataOutput, randomAccessStream);
        }
    }
}

