/*
 * Decompiled with CFR 0.152.
 */
package jet.client.api.misc;

import guitools.toolkit.JDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jet.JCliResource;
import jet.client.api.APIUtil;
import jet.client.api.JRClient;
import jet.client.api.JRResponseException;
import jet.client.api.NodeInfo;
import jet.client.api.NodeProp;
import jet.client.api.misc.DeployNodeInfo;
import jet.client.api.misc.OpenDirTreeNode;
import jet.client.api.misc.OpenDirTreeRenderer;
import jet.cs.CSUtil;
import jet.net2.URL;

public class OpenDlgDirectoryPanel
extends JPanel
implements TreeSelectionListener {
    private JLabel SEDU = new JLabel(JCliResource.getDlgText((String)"Public", (String)"folder") + ":");
    private JScrollPane WARNING = new JScrollPane();
    private JTree add = null;
    private Frame addFolder = null;
    private String addTreeExpansionListener = null;
    private String addTreeModelListener = null;
    private String addTreeSelectionListener = null;
    private String append = null;
    private NodeInfo checkPermission = null;
    private OpenDirTreeNode checkResponseOK = null;
    private OpenDirTreeNode close = null;
    private OpenDirTreeNode elementAt = null;
    private OpenDirTreeNode equals = null;
    private static Vector equalsIgnoreCase = null;
    private Vector expandPath = new Vector();
    protected DefaultTreeModel treeModel;
    private boolean get = false;
    private boolean getArcPolicy = false;

    public OpenDlgDirectoryPanel(Frame frame, String string, String string2, boolean bl) {
        this.addFolder = frame;
        this.addTreeExpansionListener = string;
        this.addTreeModelListener = string2;
        this.get = bl;
        this.SEDU();
    }

    private void SEDU() {
        this.setLayout(new BorderLayout());
        this.getArcPolicy = jet.cs.util.APIUtil.isLCResource((String)this.addTreeModelListener);
        this.addTreeSelectionListener = JRClient.getUser();
        this.WARNING();
        try {
            this.setSelectedPath(this.addTreeModelListener);
            this.append = this.addTreeModelListener;
            if (this.addTreeModelListener != null && this.addTreeModelListener.trim().length() > 0) {
                equalsIgnoreCase = this.checkPermission(this.addTreeModelListener);
            }
        }
        catch (Exception exception) {
            JDebug.WARNING((Throwable)exception);
            JOptionPane.showMessageDialog(this.addFolder, exception.toString(), JCliResource.getDlgText((String)"Public", (String)"error"), 0);
        }
        this.add((Component)this.SEDU, "North");
        this.add((Component)this.WARNING, "Center");
    }

    private void WARNING() {
        String[] stringArray = CSUtil.parsePrincipalDisplayName((String)this.addTreeSelectionListener);
        String string = CSUtil.getVirtualResourcePathPrefix((String)stringArray[0]);
        this.checkResponseOK = new OpenDirTreeNode(null, "Root", null);
        if (this.addTreeSelectionListener == null || this.addTreeSelectionListener.trim().equals("")) {
            this.close = null;
        } else if (!this.getArcPolicy) {
            this.close = new OpenDirTreeNode(new NodeInfo(null, string + "/USERFOLDERPATH" + "/" + stringArray[1], false, true, true), JCliResource.getMessage((String)"CLI_MSG_299"), string + "/USERFOLDERPATH" + "/" + stringArray[1]);
            this.checkResponseOK.add(this.close);
        } else {
            this.close = new OpenDirTreeNode(new NodeInfo(null, string + "/COMPONENT_LIB" + "/USERFOLDERPATH" + "/" + stringArray[1], false, true, true), JCliResource.getMessage((String)"CLI_MSG_300"), string + "/COMPONENT_LIB" + "/USERFOLDERPATH" + "/" + stringArray[1]);
            this.checkResponseOK.add(this.close);
        }
        this.elementAt = this.getArcPolicy ? new OpenDirTreeNode(new NodeInfo(null, "/COMPONENT_LIB", false, true, true), JCliResource.getMessage((String)"CLI_MSG_302"), "/COMPONENT_LIB") : new OpenDirTreeNode(new NodeInfo(null, "/", false, true, true), JCliResource.getMessage((String)"CLI_MSG_301"), "/");
        this.checkResponseOK.add(this.elementAt);
        if (stringArray[0] != null) {
            this.equals = this.getArcPolicy ? new OpenDirTreeNode(new NodeInfo(null, string + "/COMPONENT_LIB", false, true, true), JCliResource.getMessage((String)"CLI_MSG_304"), string + "/COMPONENT_LIB") : new OpenDirTreeNode(new NodeInfo(null, string + "/", false, true, true), JCliResource.getMessage((String)"CLI_MSG_303"), string + "/");
            this.checkResponseOK.add(this.equals);
        }
        this.treeModel = new DefaultTreeModel(this.checkResponseOK);
        this.treeModel.addTreeModelListener(new MyTreeModelListener());
        this.add = new MyTree(this.treeModel);
        this.add.setRootVisible(false);
        this.add.setShowsRootHandles(true);
        this.add.getSelectionModel().setSelectionMode(1);
        this.add.setEditable(true);
        OpenDirTreeRenderer openDirTreeRenderer = new OpenDirTreeRenderer();
        this.add.setCellRenderer(openDirTreeRenderer);
        this.add.setCellEditor(new MyCell(this.add, openDirTreeRenderer));
        this.WARNING.setViewportView(this.add);
        this.add.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                if (OpenDlgDirectoryPanel.this.add != null) {
                    OpenDlgDirectoryPanel.this.add.setSelectionPath(treeExpansionEvent.getPath());
                }
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                if (OpenDlgDirectoryPanel.this.add != null) {
                    OpenDlgDirectoryPanel.this.add.setSelectionPath(treeExpansionEvent.getPath());
                }
            }
        });
        this.add.addTreeSelectionListener(this);
        if (this.addTreeSelectionListener == null || this.addTreeSelectionListener.trim().equals("")) {
            this.add.setSelectionPath(new TreePath(this.elementAt.getPath()));
            this.add.expandPath(new TreePath(this.elementAt.getPath()));
        } else {
            this.add.setSelectionPath(new TreePath(this.close.getPath()));
            this.add.expandPath(new TreePath(this.close.getPath()));
        }
        try {
            this.add(this.elementAt);
            this.add(this.equals);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void add(OpenDirTreeNode openDirTreeNode) throws MalformedURLException, IOException, JRResponseException {
        if (openDirTreeNode != null) {
            boolean bl = openDirTreeNode.getHasExpanded();
            openDirTreeNode.setHasExpanded(true);
            String string = openDirTreeNode.getCurrentPath();
            if (!bl) {
                Vector vector = this.checkPermission(string);
                for (int i = 0; i < vector.size(); ++i) {
                    NodeInfo nodeInfo = (NodeInfo)vector.get(i);
                    if (nodeInfo.isSelf() || !nodeInfo.isDir()) continue;
                    OpenDirTreeNode openDirTreeNode2 = new OpenDirTreeNode(nodeInfo, nodeInfo.getName(), nodeInfo.getName());
                    openDirTreeNode.add(openDirTreeNode2);
                }
            }
        }
    }

    public void setSelectedPath(String string) throws MalformedURLException, IOException, JRResponseException {
        if (this.checkResponseOK != null) {
            TreePath treePath = null;
            treePath = this.addFolder(this.close, string);
            if (treePath == null && (treePath = this.addFolder(this.elementAt, string)) == null) {
                treePath = this.addFolder(this.equals, string);
            }
            if (treePath != null) {
                this.add.setSelectionPath(treePath);
                this.add.setSelectionPath(treePath);
            }
        }
    }

    private TreePath addFolder(OpenDirTreeNode openDirTreeNode, String string) throws MalformedURLException, IOException, JRResponseException {
        if (openDirTreeNode != null && string != null) {
            if (string.equals(openDirTreeNode.getCurrentPath())) {
                return new TreePath(openDirTreeNode.getPath());
            }
            if (string.startsWith(openDirTreeNode.getCurrentPath())) {
                if (!openDirTreeNode.getHasExpanded()) {
                    this.add(openDirTreeNode);
                }
                int n = openDirTreeNode.getChildCount();
                for (int i = 0; i < n; ++i) {
                    TreePath treePath = this.addFolder((OpenDirTreeNode)openDirTreeNode.getChildAt(i), string);
                    if (treePath == null) continue;
                    return treePath;
                }
            }
        }
        return null;
    }

    public OpenDirTreeNode addFolder() {
        Object object = new Object();
        OpenDirTreeNode openDirTreeNode = null;
        TreePath treePath = this.add.getSelectionPath();
        openDirTreeNode = treePath == null ? this.checkResponseOK : (OpenDirTreeNode)treePath.getLastPathComponent();
        return this.addFolder(openDirTreeNode, object, true);
    }

    private boolean addTreeExpansionListener(String string, String string2) {
        try {
            Vector vector = JRClient.getSubNodesInfo((Frame)this.addFolder, (String)this.addTreeExpansionListener, (String)string);
            for (int i = 0; i < vector.size(); ++i) {
                NodeInfo nodeInfo = (NodeInfo)vector.get(i);
                if (!string2.equalsIgnoreCase(nodeInfo.getName())) continue;
                return true;
            }
        }
        catch (JRResponseException jRResponseException) {
            jRResponseException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public OpenDirTreeNode addFolder(OpenDirTreeNode openDirTreeNode, Object object, boolean bl) {
        try {
            if (!JRClient.checkPermission((Frame)this.addFolder, (String)this.addTreeExpansionListener, (String)this.addTreeSelectionListener, (String)openDirTreeNode.getCurrentPath(), (String)"jrs.write")) {
                JOptionPane.showMessageDialog(this.addFolder, "User " + this.addTreeSelectionListener + " does not have permission to add folder under " + openDirTreeNode.getCurrentPath() + ".", "Warning", 0);
                return null;
            }
        }
        catch (Exception exception) {
            JDebug.WARNING((Throwable)exception);
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Error", 0);
            return null;
        }
        int n = 2;
        String string = "New Folder";
        String string2 = "New Folder";
        while (this.addTreeExpansionListener(openDirTreeNode.getCurrentPath(), string)) {
            string = string2 + " (" + n + ")";
            ++n;
        }
        OpenDirTreeNode openDirTreeNode2 = new OpenDirTreeNode(new NodeInfo(openDirTreeNode.getCurrentPath(), string, false, true, true), string, string);
        if (openDirTreeNode == null) {
            openDirTreeNode = this.checkResponseOK;
        }
        this.treeModel.insertNodeInto(openDirTreeNode2, openDirTreeNode, openDirTreeNode.getChildCount());
        try {
            this.append(string, openDirTreeNode.getCurrentPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        TreePath treePath = new TreePath(openDirTreeNode2.getPath());
        this.add.setSelectionPath(treePath);
        this.add.setSelectionPath(treePath);
        return openDirTreeNode2;
    }

    private static void addTreeModelListener(URLConnection uRLConnection) {
        uRLConnection.setRequestProperty("User-Agent", "JRViewer/1.00 JRClient-API/1.11");
    }

    private void addTreeSelectionListener(String string, String string2) throws IOException {
        try {
            NodeProp nodeProp = JRClient.getNodeProperties((Frame)this.addFolder, (String)this.addTreeExpansionListener, (String)string);
            Properties properties = new Properties();
            String string3 = null;
            properties.put("jrs.node_share", String.valueOf(nodeProp.isShared()));
            properties.put("jrs.node_name", string2);
            properties.put("jrs.node_real_path", nodeProp.getRealPath());
            properties.put("jrs.node_desc", nodeProp.getDescription());
            properties.put("jrs.node_type", nodeProp.getType());
            properties.put("jrs.enable_archive_policy", String.valueOf(nodeProp.getArcPolicy()));
            properties.put("jrs.replace_old_version", String.valueOf(nodeProp.getRepOldVer()));
            properties.put("jrs.archive_new_version", String.valueOf(!nodeProp.getRepOldVer()));
            properties.put("jrs.need_maxversion", String.valueOf(!nodeProp.getRepOldVer()));
            properties.put("jrs.maxversion", String.valueOf(nodeProp.getMaxVerAmount()));
            properties.put("jrs.define_permission", nodeProp.getGroupPermission());
            string3 = nodeProp.getLinkedCatalog();
            if (string3 != null) {
                properties.put("jrs.linked.catalog", string3);
            }
            properties.put("jrs.enable.linked.catalog", String.valueOf(nodeProp.isEnableLinkedCatalog()));
            properties.put("jrs.is.use.inherited", String.valueOf(nodeProp.isEnableInheritedLinkedCatalog()));
            properties.put("jrs.enable_dynamic_resource", String.valueOf(nodeProp.isEnableDynamic()));
            properties.put("jrs.path", string);
            JRClient.saveResourceProp((Frame)this.addFolder, (String)this.addTreeExpansionListener, (Hashtable)properties);
        }
        catch (JRResponseException jRResponseException) {
            jRResponseException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    private void append(String string, String string2) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 2;
        int n2 = 3;
        DeployNodeInfo deployNodeInfo = new DeployNodeInfo(string, n2);
        deployNodeInfo.getProperties(hashtable);
        hashtable.put("jrs.path", string2);
        hashtable.put("jrs.deploy_from_file", string);
        hashtable.put("jrs.deploy_type", String.valueOf(n));
        hashtable.remove("jrs.deploy_key");
        hashtable.put("FileSeparator", File.separator);
        hashtable.put("jrs.cmd", "jrs.import_resource");
        hashtable.put("jrs.is_plain", "true");
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(new java.net.URL(this.addTreeExpansionListener)).openConnection();
        httpURLConnection.setRequestMethod("POST");
        OpenDlgDirectoryPanel.addTreeModelListener(httpURLConnection);
        httpURLConnection.setRequestProperty("jrs.cmd", "jrs.import_resource");
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpURLConnection.setDoOutput(true);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(httpURLConnection.getOutputStream()));
        String string3 = CSUtil.makeNoHeadQuery(hashtable);
        bufferedWriter.write(string3);
        bufferedWriter.close();
        try {
            APIUtil.checkResponseOK((URLConnection)httpURLConnection);
        }
        catch (JRResponseException jRResponseException) {
            jRResponseException.printStackTrace();
        }
        JRClient.close((URLConnection)httpURLConnection);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        try {
            int n;
            Object object;
            int n2;
            OpenDirTreeNode openDirTreeNode = null;
            if (this.add.getSelectionPath() != null) {
                openDirTreeNode = (OpenDirTreeNode)this.add.getSelectionPath().getLastPathComponent();
            }
            if (openDirTreeNode == null) {
                return;
            }
            boolean bl = openDirTreeNode.getHasExpanded();
            openDirTreeNode.setHasExpanded(true);
            String string = openDirTreeNode.getCurrentPath();
            if (string != null && !string.equalsIgnoreCase(this.append)) {
                this.append = string;
                equalsIgnoreCase = this.checkPermission(string);
            }
            if (!bl) {
                for (n2 = 0; n2 < equalsIgnoreCase.size(); ++n2) {
                    NodeInfo nodeInfo = (NodeInfo)equalsIgnoreCase.get(n2);
                    if (nodeInfo.isSelf() || !nodeInfo.isDir()) continue;
                    object = new OpenDirTreeNode(nodeInfo, nodeInfo.getName(), nodeInfo.getName());
                    openDirTreeNode.add((MutableTreeNode)object);
                }
            }
            n2 = openDirTreeNode.getChildCount();
            for (n = 0; n < n2; ++n) {
                object = (OpenDirTreeNode)openDirTreeNode.getChildAt(n);
                this.add((OpenDirTreeNode)object);
            }
            this.add.validate();
            for (n = 0; n < this.expandPath.size(); ++n) {
                object = (TreeSelectionListener)this.expandPath.get(n);
                object.valueChanged(treeSelectionEvent);
            }
        }
        catch (Exception exception) {
            JDebug.WARNING((Throwable)exception);
            JOptionPane.showMessageDialog(this.addFolder, exception.getMessage(), JCliResource.getDlgText((String)"Public", (String)"error"), 0);
        }
    }

    private synchronized Vector checkPermission(String string) throws MalformedURLException, IOException, JRResponseException {
        NodeInfo nodeInfo;
        int n;
        equalsIgnoreCase = JRClient.getSubNodesInfo((Frame)this.addFolder, (String)this.addTreeExpansionListener, (String)string);
        int n2 = equalsIgnoreCase.size();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < n2; ++n) {
            nodeInfo = (NodeInfo)equalsIgnoreCase.elementAt(n);
            if ((this.getArcPolicy || !nodeInfo.isLCResource()) && (!this.getArcPolicy || !nodeInfo.isCatalog() && !nodeInfo.isReport())) continue;
            equalsIgnoreCase.removeElement(nodeInfo);
            --n2;
        }
        for (n = 0; n < n2; ++n) {
            nodeInfo = (NodeInfo)equalsIgnoreCase.elementAt(n);
            vector.add(nodeInfo.getName());
        }
        equalsIgnoreCase = jet.cs.util.APIUtil.sortAsCol((Vector)equalsIgnoreCase, vector, (boolean)true);
        return equalsIgnoreCase;
    }

    public String getFolderPath() {
        return this.append;
    }

    public NodeInfo getSelectedNode() {
        OpenDirTreeNode openDirTreeNode = null;
        if (this.add.getSelectionPath() != null) {
            openDirTreeNode = (OpenDirTreeNode)this.add.getSelectionPath().getLastPathComponent();
        }
        if (openDirTreeNode != null) {
            return openDirTreeNode.getNodeInfo();
        }
        return null;
    }

    public Vector getSubNodesInfo() {
        return equalsIgnoreCase;
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.expandPath.add(treeSelectionListener);
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            OpenDirTreeNode openDirTreeNode = (OpenDirTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            int n = treeModelEvent.getChildIndices()[0];
            openDirTreeNode = (OpenDirTreeNode)openDirTreeNode.getChildAt(n);
            String string = (String)openDirTreeNode.getUserObject();
            String string2 = openDirTreeNode.getValue();
            if (string == null || string.trim().length() == 0 || !CSUtil.isValidNodeName((String)string)) {
                JOptionPane.showMessageDialog(OpenDlgDirectoryPanel.this.addFolder, JCliResource.getMessage((String)"OpenDlgDirectoryPanel.Msg1"), "Error", 0);
                return;
            }
            String string3 = openDirTreeNode.getCurrentPath();
            if (OpenDlgDirectoryPanel.this.elementAt != null && !string3.equalsIgnoreCase(OpenDlgDirectoryPanel.this.elementAt.getCurrentPath()) && OpenDlgDirectoryPanel.this.equals != null && !string3.equalsIgnoreCase(OpenDlgDirectoryPanel.this.equals.getCurrentPath())) {
                string3 = string3.substring(0, string3.lastIndexOf("/") + 1);
            }
            if (OpenDlgDirectoryPanel.this.addTreeExpansionListener(string3, string)) {
                JOptionPane.showMessageDialog(OpenDlgDirectoryPanel.this.addFolder, JCliResource.getMessage((String)"OpenDlgDirectoryPanel.Msg2", (Object)(string3 + string)), "Error", 0);
                return;
            }
            if (string != null && string2 != null && !string2.equalsIgnoreCase(string)) {
                try {
                    OpenDlgDirectoryPanel.this.addTreeSelectionListener(openDirTreeNode.getCurrentPath(), string);
                    openDirTreeNode.setName(string);
                    openDirTreeNode.setValue(string);
                    OpenDlgDirectoryPanel.this.append = openDirTreeNode.getCurrentPath();
                }
                catch (IOException iOException) {
                    String string4 = iOException.getMessage();
                    JOptionPane.showMessageDialog(OpenDlgDirectoryPanel.this.addFolder, string4, "Error", 0);
                }
                OpenDlgDirectoryPanel.this.add.scrollPathToVisible(treeModelEvent.getTreePath());
                OpenDlgDirectoryPanel.this.add.updateUI();
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class MyCell
    extends DefaultTreeCellEditor {
        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject != null && eventObject.getSource() instanceof JTree) {
                this.setTree((JTree)eventObject.getSource());
                if (eventObject instanceof MouseEvent) {
                    if (OpenDlgDirectoryPanel.this.get) {
                        return false;
                    }
                    TreePath treePath = this.tree.getPathForLocation(((MouseEvent)eventObject).getX(), ((MouseEvent)eventObject).getY());
                    if (treePath == null) {
                        return false;
                    }
                    if (treePath.getLastPathComponent() == null) {
                        return false;
                    }
                    String string = treePath.getLastPathComponent().toString();
                    if (string.equalsIgnoreCase(JCliResource.getMessage((String)"CLI_MSG_299")) || string.equalsIgnoreCase(JCliResource.getMessage((String)"CLI_MSG_301")) || string.equalsIgnoreCase(JCliResource.getMessage((String)"CLI_MSG_300")) || string.equalsIgnoreCase(JCliResource.getMessage((String)"CLI_MSG_302")) || string.equalsIgnoreCase(JCliResource.getMessage((String)"CLI_MSG_303")) || string.equalsIgnoreCase(JCliResource.getMessage((String)"CLI_MSG_304"))) {
                        return false;
                    }
                }
            }
            return super.isCellEditable(eventObject);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            return super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        }

        public MyCell(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl = super.stopCellEditing();
            return bl && this.SEDU(this.getCellEditorValue());
        }

        @Override
        public void cancelCellEditing() {
            this.SEDU(this.getCellEditorValue());
        }

        private boolean SEDU(Object object) {
            OpenDirTreeNode openDirTreeNode = (OpenDirTreeNode)this.lastPath.getLastPathComponent();
            String string = object.toString();
            String string2 = openDirTreeNode.getValue();
            if (string == null || string.trim().length() == 0 || !CSUtil.isValidNodeName((String)string)) {
                JOptionPane.showMessageDialog(OpenDlgDirectoryPanel.this.addFolder, JCliResource.getMessage((String)"OpenDlgDirectoryPanel.Msg1"), "Error", 0);
                return false;
            }
            String string3 = openDirTreeNode.getCurrentPath();
            string3 = string3.substring(0, string3.lastIndexOf("/") + 1);
            if (string != null && string2 != null && !string2.equalsIgnoreCase(string)) {
                if (OpenDlgDirectoryPanel.this.addTreeExpansionListener(string3, string)) {
                    JOptionPane.showMessageDialog(OpenDlgDirectoryPanel.this.addFolder, JCliResource.getMessage((String)"OpenDlgDirectoryPanel.Msg2", (Object)(string3 + string)), "Error", 0);
                    return false;
                }
                try {
                    OpenDlgDirectoryPanel.this.addTreeSelectionListener(openDirTreeNode.getCurrentPath(), string);
                    openDirTreeNode.setName(string);
                    openDirTreeNode.setValue(string);
                    OpenDlgDirectoryPanel.this.append = openDirTreeNode.getCurrentPath();
                }
                catch (IOException iOException) {
                    String string4 = iOException.getMessage();
                    JOptionPane.showMessageDialog(OpenDlgDirectoryPanel.this.addFolder, string4, "Error", 0);
                }
                this.tree.scrollPathToVisible(this.lastPath);
            }
            return true;
        }
    }

    class MyTree
    extends JTree {
        MyTree(TreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public boolean isPathEditable(TreePath treePath) {
            if (treePath == null || treePath.getLastPathComponent() == null || treePath.getPathCount() == 2) {
                return false;
            }
            return super.isPathEditable(treePath);
        }
    }
}

