/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.ui;

import guitools.GuiUtil;
import guitools.SpinChangedListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.cs.ui.CSGuiUtil;
import jet.cs.ui.SCalendarPanel;
import jet.cs.ui.STimeSpin;
import jet.cs.ui.SchedulePanel;

public class OneTimePanel
extends JPanel
implements ItemListener,
SpinChangedListener {
    private int BRIGHT_BACKGROUND = 20;
    private int I = 20;
    private static final String SEDU = JCliResource.getMessage((String)"CS_MSG_41");
    STimeSpin add = null;
    SCalendarPanel addItemListener = null;
    SchedulePanel addSpinChangedListener;
    JLabel append = new JLabel(JCliResource.getMessage((String)"CS_MSG_42") + ":", 4);
    JLabel arrange = new JLabel(JCliResource.getMessage((String)"CS_MSG_39") + ":", 4);
    ButtonGroup black = new ButtonGroup();
    JRadioButton changed = new JRadioButton(SEDU, false);
    JRadioButton draw3DLine = new JRadioButton(JCliResource.getMessage((String)"CS_MSG_40"), true);
    String drawLine = CSUtil.getDefaultTimeZone();

    public OneTimePanel(GregorianCalendar gregorianCalendar, String string, SchedulePanel schedulePanel) {
        if (string != null) {
            this.drawLine = string;
        }
        GregorianCalendar gregorianCalendar2 = gregorianCalendar;
        if (gregorianCalendar == null) {
            gregorianCalendar2 = this.drawLine == null ? new GregorianCalendar() : new GregorianCalendar(TimeZone.getTimeZone(this.drawLine));
            gregorianCalendar2.add(12, 1);
        } else {
            this.changed.setSelected(true);
        }
        this.addSpinChangedListener = schedulePanel;
        this.addItemListener = new SCalendarPanel(gregorianCalendar2);
        this.add = new STimeSpin(gregorianCalendar2.get(10), gregorianCalendar2.get(12), gregorianCalendar2.get(9) == 1);
        this.init();
    }

    public void init() {
        this.setLayout(null);
        this.add.setSize(90, 25);
        this.add(this.addItemListener);
        this.add(this.add);
        this.add(this.append);
        this.add(this.arrange);
        this.arrange();
        this.changed.addItemListener(this);
        this.draw3DLine.addItemListener(this);
        this.addItemListener.addSpinChangedListener(this);
        this.add.addSpinChangedListener(this);
    }

    protected void arrange() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.addItemListener.getSize();
        Dimension dimension3 = this.add.getSize();
        int n = 10 + this.I + 130;
        int n2 = 10 + this.BRIGHT_BACKGROUND + 20;
        int n3 = 25;
        int n4 = 10;
        this.addItemListener.setLocation(n, n2);
        this.append.setBounds(n - 35, n2, 30, n3);
        n2 = 10 + this.I + dimension2.height + 40;
        this.add.setLocation(n, n2);
        this.arrange.setBounds(n - 35, n2, 30, n3);
        n2 = n2 + dimension2.height - 2 * n3 - n4;
        n2 += n3 + n4;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.addItemListener.setEnabled(bl);
        this.add.setEnabled(bl);
        this.changed.setEnabled(bl);
        this.draw3DLine.setEnabled(bl);
    }

    public void updateState() {
        boolean bl = this.changed.isSelected();
        if (!this.isEnabled()) {
            this.addItemListener.setEnabled(false);
            this.add.setEnabled(false);
            this.changed.setEnabled(false);
            this.draw3DLine.setEnabled(false);
            return;
        }
        this.addItemListener.setEnabled(bl);
        this.add.setEnabled(bl);
    }

    @Override
    public void changed(Object object) {
        GregorianCalendar gregorianCalendar = this.getGC();
        this.addSpinChangedListener.I.setLabel(SEDU + CSGuiUtil.toDateTimeString(gregorianCalendar.getTime(), this.drawLine));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.addItemListener.getBounds();
        Rectangle rectangle2 = this.add.getBounds();
        int n = rectangle.x - this.BRIGHT_BACKGROUND / 2 - 2 - 105;
        int n2 = 15;
        int n3 = graphics.getFontMetrics().stringWidth(" Option ");
        int n4 = 30;
        int n5 = 345;
        int n6 = 280;
        GuiUtil.draw3DLine((int)n, (int)n2, (int)n4, (boolean)true, (boolean)true, (Graphics)graphics);
        GuiUtil.draw3DLine((int)(n + n4 + 45), (int)n2, (int)n5, (boolean)true, (boolean)true, (Graphics)graphics);
        GuiUtil.draw3DLine((int)n, (int)(n2 + 1), (int)n6, (boolean)false, (boolean)true, (Graphics)graphics);
        GuiUtil.draw3DLine((int)(n + n4 + n5 + 45), (int)n2, (int)n6, (boolean)false, (boolean)true, (Graphics)graphics);
        GuiUtil.draw3DLine((int)n, (int)(n2 + n6), (int)(n4 + n5 + 45), (boolean)true, (boolean)true, (Graphics)graphics);
        graphics.setColor(GuiUtil.BRIGHT_BACKGROUND);
        graphics.drawLine(n + rectangle.width + this.BRIGHT_BACKGROUND, n2 + rectangle.height + this.I + 1, n + rectangle.width + this.BRIGHT_BACKGROUND + 2, n2 + rectangle.height + this.I + 1);
        graphics.setColor(Color.black);
        GuiUtil.drawString((String)" Option ", (int)(n + n4 + 5), (int)(n2 - 10), (int)n3, (int)this.I, (boolean)true, (Graphics)graphics);
        n = rectangle2.x - this.BRIGHT_BACKGROUND / 2 - 2;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
    }

    public GregorianCalendar getGC() {
        GregorianCalendar gregorianCalendar = this.drawLine == null ? new GregorianCalendar() : new GregorianCalendar(TimeZone.getTimeZone(this.drawLine));
        gregorianCalendar.set(this.addItemListener.getYear(), this.addItemListener.getMonth(), this.addItemListener.getDate(), this.add.getHourOfDay(), this.add.getMin(), 0);
        return gregorianCalendar;
    }

    public void setTimeZone(String string) {
        GregorianCalendar gregorianCalendar = this.getGC();
        Date date = gregorianCalendar.getTime();
        this.drawLine = string;
        gregorianCalendar = this.getGC();
        gregorianCalendar.setTime(date);
        this.addItemListener.setGC(gregorianCalendar);
        this.add.setTime(gregorianCalendar.get(10), gregorianCalendar.get(12), gregorianCalendar.get(9) == 1);
        this.changed(this);
        this.repaint();
    }
}

