#!/bin/sh

# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at

#   http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

. `dirname "$0"`/env.sh

if [ -z "$DERBY_HOME" ]; then
  echo "Error: DERBY_HOME is not set. Please set the DERBY_HOME environment variable"
  echo "to the location of your Derby installation."
  exit 1
fi


derby_exec_command="exec \"$JAVACMD\" $DERBY_OPTS -classpath \"$LOCALCLASSPATH\" -Dderby.system.home=\"$DERBYDIR\" -Djava.security.manager -Djava.security.policy=\"jreport.policy\" org.apache.derby.drda.NetworkServerControl start $@"
eval $derby_exec_command
