

import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import com.jinfonet.web.modules.dashboard.CatalogInfo;
import com.jinfonet.web.modules.dashboard.DashboardInfo;
import com.jinfonet.web.modules.dashboard.DashboardListener;
import com.jinfonet.web.modules.dashboard.LCInfo;

/**
 * This is an example to demonstrate how to implement DashboardListener to get
 * information of dashboard.
 */
public class DashboardListenerDemo implements DashboardListener {


	public void startAction(int actionType, DashboardInfo dshInfo) {
		try {
			System.out.println(" ---------Start Action--------- ");
			System.out.println("ActionType = "
					+ (actionType == DashboardListener.ADD_LC ? "ADD_LC"
							: "DEL_LC"));
			if (dshInfo != null) {
				System.out.println("Dashboard Name = " + dshInfo.getDshName());
				System.out.println("Dashboard Path = " + dshInfo.getDshPath());
				System.out.println("Dashboard UserName = "
						+ dshInfo.getUserName());
				LCInfo currentLC = dshInfo.getCurrentLC();
				if (currentLC != null) {
					System.out.println(" -- Current LC");
					System.out.println("CurrentLC Name = "
							+ currentLC.getLCName());
					System.out.println("CurrentLC Path = "
							+ currentLC.getLCPath());
					System.out.println("CurrentLC Type = "
							+ currentLC.getLCType());
				}

				List<LCInfo> lcs = dshInfo.getLCs();
				for (LCInfo lc : lcs) {
					System.out.println(" -- LC");
					System.out.println("LC Name = " + lc.getLCName());
					System.out.println("LC Path = " + lc.getLCPath());
					System.out.println("LC Type = " + lc.getLCPath());
					List<CatalogInfo> catalogs = lc.getCatalogs();
					if (catalogs != null && catalogs.size() > 0) {
						for (CatalogInfo catalogInfo : catalogs) {
							System.out.println("---Catalog Name = "
									+ catalogInfo.getCatalogName());
							System.out.println("---Catalog Path = "
									+ catalogInfo.getCatalogPath());
							System.out.println("---Data source name = "
									+ catalogInfo.getDsName());
							System.out.println("---Query name = "
									+ catalogInfo.getQueryName());
							System.out.println("---BV name = "
									+ catalogInfo.getBvName());
						}
					}
					Properties properties = lc.getParams();
					if (properties != null && !properties.isEmpty()) {
						System.out.println("---LC parameter list");
						Enumeration<?> keys = properties.propertyNames();
						while (keys.hasMoreElements()) {
							String key = (String) keys.nextElement();
							List<String> values = (List<String>) properties.get(key);
							String temp = null;
							if (values != null && values.size() > 0) {
								temp = values.get(0);
								for (int i = 1; i < values.size(); i++) {
									temp = temp + ", " + values.get(i);
								}
								System.out.println("---- key = " + key
										+ " values = " + temp);
							}
						}
					}
				}
			} 
		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	public void endAction(int actionType, DashboardInfo dshInfo) {
		try {
			System.out.println(" ---------End Action--------- ");
			System.out.println("ActionType = "
					+ (actionType == DashboardListener.ADD_LC ? "ADD_LC"
							: "DEL_LC"));
			if (dshInfo != null) {
				System.out.println("Dashboard Name = " + dshInfo.getDshName());
				System.out.println("Dashboard Path = " + dshInfo.getDshPath());
				System.out.println("Dashboard UserName = "
						+ dshInfo.getUserName());
				LCInfo currentLC = dshInfo.getCurrentLC();
				if (currentLC != null) {
					System.out.println(" -- Current LC");
					System.out.println("CurrentLC Name = "
							+ currentLC.getLCName());
					System.out.println("CurrentLC Path = "
							+ currentLC.getLCPath());
					System.out.println("CurrentLC Type = "
							+ currentLC.getLCType());
				}
				List<LCInfo> lcs = dshInfo.getLCs();
				for (LCInfo lc : lcs) {
					System.out.println(" -- LC");
					System.out.println("LC Name = " + lc.getLCName());
					System.out.println("LC Path = " + lc.getLCPath());
					System.out.println("LC Type = " + lc.getLCPath());
					List<CatalogInfo> catalogs = lc.getCatalogs();
					if (catalogs != null && catalogs.size() > 0) {
						for (CatalogInfo catalogInfo : catalogs) {
							System.out.println("---Catalog Name = "
									+ catalogInfo.getCatalogName());
							System.out.println("---Catalog Path = "
									+ catalogInfo.getCatalogPath());
							System.out.println("---Data source name = "
									+ catalogInfo.getDsName());
							System.out.println("---Query name = "
									+ catalogInfo.getQueryName());
							System.out.println("---BV name = "
									+ catalogInfo.getBvName());
						}
					}
					Properties properties = lc.getParams();
					if (properties != null && !properties.isEmpty()) {
						System.out.println("---LC parameter list");
						Enumeration<?> keys = properties.propertyNames();
						while (keys.hasMoreElements()) {
							String key = (String) keys.nextElement();
							List<String> values = (List<String>) properties.get(key);
							String temp = null;
							if (values != null && values.size() > 0) {
								temp = values.get(0);
								for (int i = 1; i < values.size(); i++) {
									temp = temp + ", " + values.get(i);
								}
								System.out.println("---- key = " + key
										+ " values = " + temp);
							}
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
