import java.io.*;
import jet.api.*;
import jet.jetc.*;
import jet.universe.exception.*;

/**
 * This class modifies a report called TestInvoice.cls. The report is the same as TestInvoice.cls created by TestDesignInvoice.java that needs to run first.
 * Requires JinfonetGourmetJava.cat in the TutorialReports folder and an image called coffee.gif.
 * 
 * Usage: TestDesignEditInvoice <path> <catalog> [logfile]
 */
public class TestDesignEditInvoice
{
	Designer desg;
	public static int index=1;

	public TestDesignEditInvoice(String path, String cat, String log) throws IOException, ReadFailureException, UniverseFileException
	{
		DesignerUserInfo userInfo=new DesignerUserInfo("Uid", "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");		
		desg = new Designer(path, cat,userInfo);
		if ( log != null && log.length() > 0 )
		{
			desg.setLog(new FileOutputStream(log), "8859_1");
		}
	}

	/**
	 * Modify report according to parameter name.
	 */
	public void modify(String name)
	{
		String handle, report;

		report = desg.open(name);
		if ( report != null )
		{
			// If a picture is found in the report TestInvoice.cls.
			if ( desg.getHandles(report, Designer.IMAGE,-1).length > 0 )
			{
				handle = desg.getHandles(report, Designer.IMAGE,-1)[0];
			}
			else
			// Add new image if we can't find the current one
			{
				String GroupHeaderpanel[] = desg.getHandles(desg.getHandles(report, Designer.GROUP, -1 )[0], Designer.GROUPHEADER, -1);
				handle = desg.insert(GroupHeaderpanel[1], Designer.IMAGE ,"Image"+index);
			}
			// Replace the current image with CoffeeLogo.gif or add a new image
			desg.set(handle, "PictureName", "CoffeeLogo.gif");
			desg.set(handle, "X", 4.67f);
			desg.set(handle, "Width", 1.70f);
			desg.set(handle, "Height", 0.81f);
		}

		desg.exit();
		try
		{
			desg.closeLog();
		}
		catch ( IOException e )
		{
			e.printStackTrace();
		}
	}
	
	// parameter tokens
    private final static String pathArg = "-path=";
    private final static String catArg = "-catalog=";
    private final static String rptArg = "-report=";
    private final static String logArg = "-log=";

    private final static void showUsage() {
        System.out.println( "TestDesignEditInvoice - programattically edit the invoice report created by TestDesignInvoice.");
        System.out.println( "Usage:  java TestDesignEditInvoice <-options>");
        System.out.println("\nwhere options include:");
        System.out.println("    " + pathArg +   "<path to catalog>  indicates the full path name to the report catalog directory");
        System.out.println("    " + catArg +    "<catalog name>  indicates the name of the report catalog");
        System.out.println("    " + rptArg +    "<report name>  indicates the name of the report to create");
        System.out.println("    " + logArg +    "<log file path and name>   indicates to log to this file, defined by full path name");
        System.out.println("\nExample to create and define a report from the command line:");
        System.out.println("java TestDesignEditInvoice -path=C:\\JReport\\Designer\\Demo\\Reports\\TutorialReports  -catalog=JinfonetGourmetJava.cat  -report=TestInvoice.cls -log=C:\\JReport\\Designer\\logs\\chart.log");
    }

    public static void main(String argv[])
    {
        // values of command line arguments.
        String path = "";
        String catalog = "";
        String report = "";
        String log = "";

        // get values of command line arguments
        for (int i = 0; i < argv.length; i++) {
            if (argv[i].toLowerCase().startsWith(catArg)) {
                catalog = argv[i].substring(catArg.length(), argv[i].length());
            } else if (argv[i].toLowerCase().startsWith(rptArg)) {
                report = argv[i].substring(rptArg.length(), argv[i].length());
            } else if (argv[i].toLowerCase().startsWith(pathArg)) {
                path = argv[i].substring(pathArg.length(), argv[i].length());
            } else if (argv[i].toLowerCase().startsWith(logArg)) {
                log = argv[i].substring(logArg.length(), argv[i].length());
            } else {
                // is not a valid command line argument
                showUsage();
                System.exit(1);
            }
         }    

        // log file is an optional parameter.
        // path, catalog, and report are required parameters.
        if ( (path.length() == 0) || (catalog.length() == 0) || report.length() == 0 ) {
                showUsage();
                System.exit(1);
        }

        System.out.println("Catalog = " + catalog);
        System.out.println("   Path = " + path);
        System.out.println(" Report = " + report);
        System.out.println("    Log = " + ((log==null) ? "" : log));
        

			if ( path.length() > 0 && catalog.length() > 0 )
			{
				try
				{
					TestDesignEditInvoice test = new TestDesignEditInvoice(path, catalog, log);
					test.modify(report);
					System.out.println("Successfully modified " + report + " in "+ path);
				}
				catch ( Exception e )
				{
					e.printStackTrace();
					showUsage();
				}
			}
			else
			{
				showUsage();
			}
		
		System.exit(0);
	}
}
