import java.util.ResourceBundle;

import jet.util.NLSBundleInfo;

public class MyNLSBundleInfo implements NLSBundleInfo {

	ResourceBundle dataMapping = null;

	ResourceBundle textedNLS = null;

	public MyNLSBundleInfo(String dataMappingFile, String textedNLSFile) {
		try {
			if (dataMappingFile != null)
				dataMapping = ResourceBundle.getBundle(dataMappingFile);
		} catch (Exception e) {
			e.printStackTrace();
		}
		try {
			if (textedNLSFile != null)
				textedNLS = ResourceBundle.getBundle(textedNLSFile);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public int getBundleUsage() {
		// return INFOTYPE_DATAMAPPING|(INFOTYPE_TEXTREPALCE);
		return (dataMapping == null ? 0 : INFOTYPE_DATAMAPPING)
				| (textedNLS == null ? 0 : INFOTYPE_TEXTREPLACE);
	}

	public String getDataMapped(String key) {
		try {
			return dataMapping.getString(key);
		} catch (Exception e) {
			// TODO: handle exception
			return null;
		}
	}

	public String[] getFontStyleReplace(String fontFace, double fontSize) {
		if( fontFace.equals("Arial") && fontSize == 0.125){
			return new String[]{ "Arial", "0.5"};
		}else
			return null;
	}

	public boolean getIsEmptyBundle() {

		return dataMapping == null && textedNLS == null;
	}

	public String getTextReplace(int replaceID, String key) {
		String prefix = "";
		switch (replaceID) {

		case TEXTREPLACE_FORLABEL:
			prefix = "LABEL";
			break;
		case TEXTREPLACE_FORTOCANCHOR:
			prefix = "TOC";

			break;
		case TEXTREPLACE_FORPROMPT:
			prefix = "PROMPT";

			break;
		case TEXTREPLACE_FORFORMAT:
			prefix = "FORMAT";
			break;
		case TEXTREPLACE_FORCOLUMN:
			prefix = "COLUMN";
			break;
		default:
			break;
		}
		try {
			return textedNLS.getString( prefix+"_"+key);
		} catch (Exception e) {
			return null;
		}

	}

}
