import java.util.Vector;

import jet.server.api.admin.AdminService;
import jet.server.api.admin.SecurityAdminService;
import jet.server.api.admin.security.JRole;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.RoleExistsException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;

/**
 * 
 * @author xiaoxi.lu
 * This demo is created to demonstrate the usage of the JReport Server API methods to create roles on server.
 * You can add roles,which you wish to be added on server,in "addRoleTest".
 * 
 * Announcements:1.Please confirm your server is shutdown.
 *               2.If the role to be added is exist,it will occur "RoleExistsException".
 *               
 *
 */

public class AddRole {
	String submiter = "admin";
	static String reporthome = "";
	
	public static void main(String[] args)
	{
//	    for(int i = 0; i < args.length; i++){
//	    	String arg = args[i]; //4
//	    	System.out.println("SecurityRoleCover:"  + arg);
//	    	if(arg.indexOf("-reporthome") == 0){
//	    		reporthome = args[i].substring(args[i].indexOf(":") + 1);
//	    	}
//	    }
		reporthome= "D:\\JReport\\V11Update1\\B201206291505";
		AddRole ss = new  AddRole();
	    ss.doSecurity();
	}
	
	public void doSecurity() {	
		HttpRptServer httpRptServer = null;
		try {
			// Set report home
			System.getProperties().put("reporthome", reporthome);
			System.out.println("start server:");
			// Creates instance of RptServer (JReport Server can not be running already)
			HttpUtil.initEnv(System.getProperties());
			System.out.println("end start server:");
			
			httpRptServer = HttpUtil.getHttpRptServer();
			AdminService adminServ = httpRptServer.getAdminService();
			SecurityAdminService secServ = adminServ.getSecurityAdminService();
			String curRealm = secServ.getCurRealm();
			//add roles to server.
			addRolerTest(secServ,curRealm );
			//get your current roles.
			getRoles(secServ,curRealm ); 
			
		} catch (Throwable t){
			t.printStackTrace();
		}
		finally{
			// Make sure server is shutdown or there will be a 2 minute wait to start again
			System.out.print("\n");
			httpRptServer.shutdown();
			System.out.println("Server "+ httpRptServer +" shutdown.");
		}
		System.exit(0);
    }
	
	private void addRolerTest(SecurityAdminService secServ, String curRealm){
			try {
				secServ.addRole(curRealm,"addRole", "add role test", submiter);
				secServ.addRole(curRealm,"addSubRole", "add role test", submiter);
			} catch (NoSuchRealmException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (BadRealmException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (RoleExistsException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	}

	private void getRoles(SecurityAdminService secServ, String curRealm){


		Vector vv = null;
		
		try {
			vv= new Vector();
			JRole roleName[]=secServ.getAllJRoles(curRealm, submiter);
			if(roleName.length!=0){
				for(int i=0;i<roleName.length;i++){
			        vv.add(roleName[i].getName().toString());
				}
				
			}
        }catch (NoSuchRealmException e) {
		    // TODO Auto-generated catch block
		    e.printStackTrace();
	    } catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}catch(NullPointerException e){
			e.printStackTrace();
		}
		int j=0;
		System.out.println("Find roles as below:");
		while(!vv.isEmpty()){
			System.out.println(vv.elementAt(j).toString());
			j++;
			if(j>=vv.size()){
				break;
			}
		}
	}
}
