
import java.io.IOException;
import java.util.*;

import jet.cs.util.*;
import jet.server.api.http.*;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.SecurityAdminService;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationLDAPServer;
import jet.server.api.admin.security.JGroup;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.relation.RoleGroupRelationProvider;
import jet.server.api.exception.*;




public  class SecurityGroupCover {
	Vector gourpnames;
	Enumeration egroupname;
	String submiter = "admin";
	static String reporthome = "";
	/**
	 * Add group and other security cover,get group information.
	 * Please set your server install path as "reporthome".
	 */
	CatchInfo uu = new CatchInfo();
	public static void main(String[] args)
	{
//	    for(int i = 0; i < args.length; i++){
//	    	String arg = args[i]; //4
//	    	System.out.println(arg);
//	    	if(arg.indexOf("-reporthome") == 0){
//	    		reporthome = args[i].substring(args[i].indexOf(":") + 1);
//	    	}
//	    }
		reporthome= "D:\\JReport\\V11Update1\\B201206291505";
	    SecurityGroupCover ss = new  SecurityGroupCover();
	    ss.doSecurity();
	}
	/**
	 * Start server,call addGroupTest and getGroupInfo.
	 */
	public void doSecurity() {	
		HttpRptServer httpRptServer = null;
		try {
			// Set report home
			System.getProperties().put("reporthome", reporthome);

			// Creates instance of RptServer (JReport Server can not be running already)
			HttpUtil.initEnv(System.getProperties());
			httpRptServer = HttpUtil.getHttpRptServer();
			AdminService adminServ = httpRptServer.getAdminService();
			SecurityAdminService secServ = adminServ.getSecurityAdminService();
			String curRealm = secServ.getCurRealm();
			//add groups to server
			addGroupTest(secServ,curRealm );
			//get current groups
			getGroupInfo(secServ,curRealm );
			
		} catch (Throwable t){
			t.printStackTrace();
		}
		finally{
			// Make sure server is shutdown or there will be a 2 minute wait to start again
			httpRptServer.shutdown();
			System.out.println("Server "+ httpRptServer +" shutdown.");
		}
		System.exit(0);
    }

	/**
	 * 
	 * Add group,and add other information for security configuration.
	 * Please configure the "addGroup\addUser\addRole\addGroupIntoRole\addPrivilegedGroups\
	 * addSubGroupIntoGroup\addUserIntoGroup\" as you need.
	 * @param secServ
	 * @param curRealm
	 * 
	 */
	private void addGroupTest(SecurityAdminService secServ, String curRealm){
		//add groups.
		try {
			secServ.addGroup(curRealm, "addGroup", "test addGroup method", submiter);			
			secServ.addGroup(curRealm, "addGroup1", "test addGroup method", submiter);			
			secServ.addGroup(curRealm, "addGroup2", "test addGroup method", submiter);			
			secServ.addGroup(curRealm, "addGroup3", "test addGroup method", submiter);
			secServ.addGroup(curRealm, "addGroupIntoRole", "test addGroup method", submiter);
			secServ.addGroup(curRealm, "subGroupName", "test addGroup method", submiter);
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchGroupException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InUseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		//add user for security configuration.
		try{
			secServ.addUser(curRealm,submiter,"addUserIntoGroup","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (UserExistsException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		try{
			secServ.addUser(curRealm,submiter,"addUserIntoGroup1","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (UserExistsException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		//add role and add group to role.
		try {
			try {
				secServ.addRole(curRealm, "addRoleForGroup", "test addGroupIntoRole method", submiter);
				secServ.addRole(curRealm, "addGroup", "test addGroupIntoRole method", submiter);
			} catch (RoleExistsException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			secServ.addGroupIntoRole(curRealm, submiter, "addGroupIntoRole", "addGroup");
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchGroupException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRoleException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}


		try {
			egroupname = secServ.getAllGroupNames(curRealm);
			gourpnames = uu.getVectorFromEnumeration(egroupname);
			try {
				secServ.addPrivilegedGroups(curRealm, submiter, APIConst.PRIVILEGE_PUBLISH_REPORT, gourpnames);
			} catch (NoSuchGroupException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			try {
				secServ.addSubGroupIntoGroup(curRealm, submiter, "subGroupName", gourpnames.elementAt(0).toString());
			} catch (NoSuchGroupException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			//add user into group
			try {
				secServ.addUserIntoGroup(curRealm, submiter, "addUserIntoGroup1", gourpnames.elementAt(0).toString());
				
			} catch (NoSuchGroupException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NoSuchUserException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		 
		
	}
/**
 * 
 * @param secServ
 * @param curRealm
 * Get group information.
 */
	private void getGroupInfo(SecurityAdminService secServ, String curRealm) {
		
		try{
			secServ.getGroupMemberCount(curRealm, gourpnames.elementAt(0).toString());
			secServ.getGroupPrivileges(curRealm, submiter, gourpnames.elementAt(0).toString());
		} catch (NoSuchGroupException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		try {
			Enumeration groupNames = secServ.getAllGroupNames(curRealm);
			uu.printEnumeration("getGroupInfo" , groupNames);
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        
		JGroup[] groupNames;
		try {
			groupNames = secServ.getAllJGroups(curRealm, submiter);
			for (int i = 0; i < groupNames.length ; i++) {
				uu.JgroupPrint(groupNames[i]);
			}
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}