<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<%@page contentType="text/html;charset=UTF-8" language="java" %>
<%@ page import="jet.cs.util.*, 
                 jet.server.util.nls.*,
                 jet.server.api.http.*,
                 jet.server.api.*,
                 java.io.*,
                 javax.xml.bind.DatatypeConverter,
                 java.util.*" %>

<html>
<head>
<title>Access a page proteced by HttpUtil.checkLogin()</title>
</head>
<body>

<%
    HttpRptServer httpRptServer = null;
    HttpUserSessionManager httpUserSessionManager = null;

    String jrUser = null;  
    String appUser = null;  
    String singleSignOnStatus = "";  
    boolean ssoIsOn = false;
    boolean jrUserIsLoggedIn = false;
    boolean appUserIsLoggedIn = false;
    String scenarioExpectation = "";
    long time = new Date().getTime();


    // action:
    //   1 - do no authentication
    //   2 - emulate application login
    //   3 - use JReport Server technique to pass in credential by URL
    String action = request.getParameter("action");  
    if ((! "1".equals(action)) && (! "2".equals(action)) && ( ! "3".equals(action)) ) {
        action = "1";
    }
    // target
    //   "util" - call page protected by HttpUtil.checkLogin()
    //   "session" - call page protected by HttpUserSessionManger.checkLogin()
    String target = request.getParameter("target");  
    if ((! "util".equals(target)) && (! "session".equals(target)) ) {
        target = "session";
    }

    // establish boilerplate for each target case
    boolean utilIsTarget = false;
    boolean sessionIsTarget = false;
    String targetName = "HttpUtil.checkLogin()";
    String targetAction = "";
    String targetScenario = "";
    String targetLegend = "";
    if ("util".equals(target)) {
        utilIsTarget = true;
        targetName = "HttpUtil.checkLogin()";
        targetAction = "loginUtilCheckLogin.jsp";
    }
    if ("session".equals(target)) {
        sessionIsTarget = true;
        targetName = "HttpUserSessionManager.checkLogin()";
        targetAction = "loginSessionCheckLogin.jsp";
    }

    boolean actionIs1 = false;
    boolean actionIs2 = false;
    boolean actionIs3 = false;
    if ("1".equals(action)) {
        actionIs1 = true;
        targetScenario = "Do nothing to authenticate user when accessing page.";
        targetLegend = "Do nothing to authenticat user";
    }
    if ("2".equals(action)) {
        actionIs2 = true;
        targetScenario = "Authenticate user by logging in <b>admin</b> as application user just now, before accessing page.";
        targetLegend = "Emulate application login by admin";
    }
    if ("3".equals(action)) {
        actionIs3 = true;
        targetScenario = "Authenticate user by passing in credentials using JReport query parameters when accessing page.";
        targetLegend = "Use JReport query parameters to authenticate";
    }

    session = request.getSession(true);

    // emulate application login before accessing page
    if ("2".equals(action)) {
        // emulate the code that an application login would do.
        // register that the application user is logged in,
        // and set the corresponding JReport User ID to use.
        session.setAttribute("authorized_user", "admin");
    }

    // get application user who is logged in.
    if (session.getAttribute("authorized_user") != null) {
        appUser = session.getAttribute("authorized_user").toString();
        appUserIsLoggedIn = true;
    } else {
        appUser = "No Current User";
        appUserIsLoggedIn = false;
    }

    // Request Header might contain credentials, in the header field named "Authorization".
    // The credentials would come from the browser, 
    //     when it has been asked to participate in HTTP Basic authentication.
    // If so, the Header field value looks like this "Basic encoded-Data".
    // encoded-Data is the base64 encoding of a string that looks like this "user:password"
    String authorization = request.getHeader("Authorization");
    String hdrUser = "";
    String hdrPwd = "";
    String headerAuthorization = "NULL";
    if (authorization != null) {
        String encodedUserPwd = authorization.substring(6).trim();
        String UserPwd = new String(DatatypeConverter.parseBase64Binary(encodedUserPwd));
        int pColon = UserPwd.indexOf(":");
        hdrUser = UserPwd.substring(0, pColon);
        hdrPwd = UserPwd.substring(pColon+1);
        headerAuthorization = hdrUser + ":" + hdrPwd;  // same as UserPwd
    }

    // establish context and handle for JReport API calls.
    httpRptServer = HttpUtil.getHttpRptServer(request);
    if (httpRptServer == null) {
        System.getProperties().put("jreport.context", application);
        HttpUtil.initEnv(System.getProperties());
        httpRptServer = HttpUtil.getHttpRptServer(request);
    }
    if (httpRptServer == null) {
        jrUser = "Unknown";
        jrUserIsLoggedIn = false;
    } else {

        httpUserSessionManager = httpRptServer.getHttpUserSessionManager(); 

            // When there is no current user.  this getUser() returns an empty string.
        jrUser = (String)httpUserSessionManager.getUser(request);
        if (jrUser.equals("")) {
            jrUser = "No Current User";  // establish display value
            jrUserIsLoggedIn = false;
        } else {
            jrUserIsLoggedIn = true;
        }

        HttpExternalAuthorized httpExternalAuthorized = 
                  (HttpExternalAuthorized)httpUserSessionManager.getHttpExternalAuthorized();
        if (httpExternalAuthorized == null) {
            singleSignOnStatus = "Single Sign On is OFF";
            ssoIsOn = false;
        } else {
            //  singleSignOnStatus will be displayed within enclosing bold tags.  Bold tags in extra text for this case work within that context.
            singleSignOnStatus = "Single Sign On is ON.</b><br>ExternalAuthorized is by class <b>" + httpExternalAuthorized.getClass().getName();
            ssoIsOn = true;
        }
    }

    if (ssoIsOn) {
        if (appUserIsLoggedIn) {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Page will open because JReport Server User is logged in already.  SSO External Authorized will not be called.";
                if (actionIs3) {
                    scenarioExpectation = scenarioExpectation + " Credentials in URL will be ignored.";
                }
            } else {
                scenarioExpectation = "Page will open because Application User is logged in already, "
                     + "which leads to JReport Server User getting logged in."
                     + "<br>JReport Server User will be logged in after a call to SSO External Authorized that returns the Application User ID.";
                if (actionIs3) {
                    scenarioExpectation = scenarioExpectation + " Credentials in URL will be ignored.";
                }
            }
        } else {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Page will open because JReport Server User is logged in already.  SSO External Authorized will not be called.";
                if (actionIs3) {
                    scenarioExpectation = scenarioExpectation + " Credentials in URL will be ignored.";
                }
            } else {

                if (actionIs1) {
                    scenarioExpectation = "Page will not open because no User is logged in.  SSO External Authorized will handle the failed authentication.";
                }
                // if actionIs2 - appUserIsLoggedIn, so won't be here.
                if (actionIs3) {
                    scenarioExpectation = "Page will open because credentials in URL are seen by checkLogin and user is logged into Server.";
                }

            }
        }
    } else {
        if (appUserIsLoggedIn) {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Page will open because JReport Server User is logged in already.  SSO External Authorized will not be called.";
                if (actionIs3) {
                    scenarioExpectation = scenarioExpectation + " Credentials in URL will be ignored.";
                }
            } else {
                scenarioExpectation = "Page will not open because JReport Server User is not logged in already."
                    + "<br>Browser will display HTTP Authentication login dialog to enable running of report."
                    + "<br>(Single Sign On framework is not turned on)";
                if (actionIs3) {
                    scenarioExpectation = "Page will open because credentials in URL are seen by checkLogin and user is logged into Server.";
                }
            }
        } else {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Page will open because JReport Server User is logged in already.  SSO External Authorized will not be called.";
                if (actionIs3) {
                    scenarioExpectation = scenarioExpectation + " Credentials in URL will be ignored.";
                }
            } else {
                scenarioExpectation = "Page will not open because JReport Server User is not logged in already."
                    + "<br>Browser will display HTTP Authentication login dialog to enable running of report."
                    + "<br>(Single Sign On framework is not turned on)";
                if (actionIs3) {
                    scenarioExpectation = "Page will open because credentials in URL are seen by checkLogin and user is logged into Server.";
                }
            }
        }
    }

%>


 &nbsp;&nbsp;&nbsp;   <a href="loginIndex.jsp?action=<%=String.valueOf(time) %>">Home</a>
<h4>Access a page protected by <%=targetName %></h4>
<p>
Current application user in this session: <b><%=appUser %></b>
<br>
Current JReport Server user in this session: <b><%=jrUser %></b>
<br>
SSO Status: <b><%=singleSignOnStatus %></b>
</p>
<p>
<hr>
<b>Expected result of accessing page:</b>
<br>
<%=scenarioExpectation %>
<hr>
<p>
<b>Scenario:</b>
<br>
<%=targetScenario %>
<br>
<form name="access-page" action="<%=targetAction %>">
    <fieldset>
        <legend><%=targetLegend %></legend>
            <%
            if (actionIs3) {
            %>
      <label for"jrs.util_auth_uid">User (jrs.auth_uid): </label>
      <input type="text" name="jrs.auth_uid" id="jrs.util_auth_uid" value="admin" />
      <br />
      <label for"jrs.util_auth_pwd">Password (jrs.auth_pwd): </label>
      <input type="text" name="jrs.auth_pwd" id="jrs.util_auth_pwd" value="admin" />
      <br />
            <%
            }
            %>

      <input type="submit" value="Access Page" />
    </fieldset>
  </form>

</body>
</html>
