<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<%@page contentType="text/html;charset=UTF-8" language="java" %>
<%@ page import="jet.cs.util.*, 
                 jet.server.util.nls.*,
                 jet.server.api.http.*,
                 jet.server.api.*,
                 java.io.*,
                 javax.xml.bind.DatatypeConverter,
                 java.util.*" %>
<!-- 

This jsp page is one of three that show how Single Sign On works.

This one performs the scenario where nothing is done to establish 
that there is a session for a logged in user and nothing 
is done to send a User ID by URL to the action page, customViewReport.jsp.

To run this scenario, move this JSP page and customViewReport.jsp 
to the folder "public_html/jinfonet".  
Access it from a browser by way of a bookmark after restarting the browser,
without logging into JReport Server.

   localhost:8888/jinfonet/customNoAuth.jsp

When you see the page in this way, it is when you are not yet logged
into JReport Server and you are not logged into any application.
This is shown by the current user on the page.

Press the "Run Report" button.  

This leads you to the customViewReport.jsp page, which will not run
the report until you are an authorized JReport Server user.

You should see a pop-up dialog from your browser asking for your
name and password.  This is the HTTP Authentication dialog
to log you in to JReport Server.  This login activity is
being done by JReport Server.

This is without Single Sign On in place.

Cancel the login dialog.  This leads to a 404 Error page saying the page
your requested does not exist for you (you don't have authority to view it).

To turn on Single Sign On, follow the instructions in the source of
CustomHttpExternalAuthorized.java for compiling it, putting it into 
a jar file, deploy it, and adding a CLASSPATH entry to it in JReport 
start-up script and adding a value to the System properties 
using the -D option. 

Restart JReport Server.  Now, the CustomHttpExternalAuthorized class
will be running within JReport Server, enabling Single Sign On.

Again bring up this JSP page using a bookmark, without logging into JReport Server.

   localhost:8888/jinfonet/customNoAuth.jsp

When you see the page in this way, it is when you are not yet logged
into JReport Server and you are not logged into any application.
This is shown by the current user on the page.

Press the "Run Report" button. 

This leads you to the customViewReport.jsp page, which will not run
the report until you are an authorized JReport Server user.
This time you will see a page generated by CustomHttpExternalAuthorized
that emulates what it could do when faced with a request that is
not from user who is logged into the applicaiton session.
It could  redirect you to the standard login page for an application.

This demonstrates what happens when no user is identified when the 
Single Sign On system is working.

This demonstrates the Single Sign On framework in action.
-->
<%
    HttpRptServer httpRptServer = null;
    HttpUserSessionManager httpUserSessionManager = null;

    String jrUser = null;  
    String appUser = null;  
    String singleSignOnStatus = "";  
    boolean ssoIsOn = false;
    boolean jrUserIsLoggedIn = false;
    boolean appUserIsLoggedIn = false;
    String scenarioExpectation = "";
    long time = new Date().getTime();

    session = request.getSession(true);
    if (session.getAttribute("authorized_user") != null) {
        appUser = session.getAttribute("authorized_user").toString();
        appUserIsLoggedIn = true;
    } else {
        appUser = "No Current User";
        appUserIsLoggedIn = false;
    }

    // establish context and handle for JReport API calls.
    httpRptServer = HttpUtil.getHttpRptServer(request);
    if (httpRptServer == null) {
        System.getProperties().put("jreport.context", application);
        HttpUtil.initEnv(System.getProperties());
        httpRptServer = HttpUtil.getHttpRptServer(request);
    }
    if (httpRptServer == null) {
        jrUser = "Unknown";
        jrUserIsLoggedIn = false;
    } else {

        httpUserSessionManager = httpRptServer.getHttpUserSessionManager(); 

            // When there is no current user.  this getUser() returns an empty string.
        jrUser = (String)httpUserSessionManager.getUser(request);
        if (jrUser.equals("")) {
            jrUser = "No Current User";  // establish display value
            jrUserIsLoggedIn = false;
        } else {
            jrUserIsLoggedIn = true;
        }

        HttpExternalAuthorized httpExternalAuthorized = 
                  (HttpExternalAuthorized)httpUserSessionManager.getHttpExternalAuthorized();
        if (httpExternalAuthorized == null) {
            singleSignOnStatus = "Single Sign On is OFF";
            ssoIsOn = false;
        } else {
            //  singleSignOnStatus will be displayed within enclosing bold tags.  Bold tags in extra text for this case work within that context.
            singleSignOnStatus = "Single Sign On is ON.</b>  &nbsp;&nbsp;&nbsp;&nbsp; ExternalAuthorized is by class <b>" + httpExternalAuthorized.getClass().getName();
            ssoIsOn = true;
        }
    }

    if (ssoIsOn) {
        if (appUserIsLoggedIn) {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Report will run because JReport Server User is logged in already.  SSO External Authorized will not be called.";
            } else {
                scenarioExpectation = "Report will run because Application User is logged in already, "
                     + "which leads to JReport Server User getting logged in."
                     + "<br>JReport Server User will be logged in after a call to SSO External Authorized that returns the Application User ID.";
            }
        } else {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Report will run because JReport Server User is logged in already.  SSO External Authorized will not be called";
            } else {
                scenarioExpectation = "Report will not run because no User is logged in.  SSO External Authorized will handle the failed authentication.";
            }
        }
    } else {
        if (appUserIsLoggedIn) {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Report will run because JReport Server User is logged in already.  SSO External Authorized will not be called.";
            } else {
                scenarioExpectation = "Report will not run because JReport Server User is not logged in already."
                    + "<br>Browser will display HTTP Authentication login dialog to enable running of report."
                    + "<br>(Single Sign On framework is not turned on)";
            }
        } else {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Report will run because JReport Server User is logged in already.  SSO External Authorized will not be called.";
            } else {
                scenarioExpectation = "Report will not run because JReport Server User is not logged in already."
                    + "<br>Browser will display HTTP Authentication login dialog to enable running of report."
                    + "<br>(Single Sign On framework is not turned on)";
            }
        }
    }
%>
<html>
<head>
<title>Do No Authentication - Single Sign On Demonstration</title>
</head>
<body>
 &nbsp;&nbsp;&nbsp;   <a href="customIndex.jsp?action=<%=String.valueOf(time) %>">Home</a>
<h4>Demonstrate Single Sign On by running a report</h4> 
This scenario does nothing special to identify a user as the report is requested.
<ul>
<li>
There is no emulation of logging in a user to the local application.
</li>
<li>
There is nothing done to pass in application login credentials to the report.
</li>
</ul>

<p>
Current application user in this session: <b><%=appUser %></b>
<br>
Current JReport Server user in this session: <b><%=jrUser %></b>
<br>
SSO Status: <b><%=singleSignOnStatus %></b>
</p>
<p>
<hr>
<b>Expected result of running report:</b>
<br>
<%=scenarioExpectation %>
<hr>
<p>
<form name="form1" action="customViewReport.jsp">
  <table>    
    <tr> <td>
     <b>Scenario:</b>
     <br>
     Nothing special is done about authentication for this request to run the report.
    </td> </tr>
    <tr> <td>
      <input type="submit" value="Run Report">
    </td> </tr>
  </table>
</form>
</body>
</html>
