import jet.cs.util.APIConst;

import java.io.IOException;
import java.util.Properties;

import jet.server.api.RptServer;
import jet.server.api.rmi.RemoteReportServerToolkit;
import jet.server.api.trigger.TriggerManageException;
import jet.server.api.trigger.TriggerManager;
/**
 * Class <code>DemoTrigger</code> is a demo which fires a trigger to run a scheduled report that is waiting for the trigger
 * 
 * Usage: 
 * Requires SampleReports.cat and Banded_Link.cls be deployed to /SampleReports
 * Requires that RMI be enabled on JRerpot Server on port 1129 on localhost
 * Requires that JReport be installed on Windows in the default location
 * 
 * @version 1.00, 04/24/03
 */
public class DemoTrigger {
	public static void main(String[] args) throws TriggerManageException {
		//set the location of the rmi auth file (rmi.auth)
		System.getProperties().put("jrs.rmi.auth_file", "C:/JReport/Server/bin/rmi.auth");
		
		// get instance of RptServer
		RptServer svr = RemoteReportServerToolkit.getRemoteWrappedRptServer("localhost", "1129");
		TriggerManager trigMan = svr.getTriggerManager();
		
		// create an external trigger to schedule a task when the trigger fires
		String exTriggerName = "exTriggerDemo";
        if (!trigMan.contains(exTriggerName)) {
            trigMan.createTrigger(exTriggerName, "an external trigger demo");
        }
		
		// create schedule task properties
		Properties props = new Properties();
		props.put(APIConst.TAG_TASK_CLASS, APIConst.TASK_TO_RPT);
		props.put(APIConst.TAG_LAUNCH_TYPE, String.valueOf(APIConst.IMMEDIATELY));
		props.put(APIConst.TAG_TRIGGERS_LOGIC, "ONLY");
		props.put(APIConst.TAG_TRIGGERS_ARRAY, "exTriggerDemo");
		props.put(APIConst.TAG_CATALOG, "/SampleReports/SampleReports.cat");
		props.put(APIConst.TAG_REPORT, "/SampleReports/Banded_Link.cls");
		props.put(APIConst.TAG_TO_VERSION, "true");
		props.put(APIConst.TAG_TO_VERSION_PDF, "true");

		
	
		// submit task into scheduling system
		String taskID;
		System.out.println("The task will be submitted into scheduling system...");
		try {
			taskID = svr.submitScheduledTask("admin", props);
			System.out.println("The task is ["+taskID+"]");
		} catch (Exception e) {
			
		}
		
		System.out.println("Press any key to fire trigger...");
		try {
            while (System.in.read() == -1) {}
        } catch (IOException e) {
            // TODO Auto-generated catch block
            
        };
		
        System.out.println("fired trigger!");
		// fire scheduling system to run task with trigger
		Properties userData = new Properties();
		try {
			trigMan.fire(exTriggerName, userData);
		} catch (Exception e2) {
			
		}
		System.out.println("The submited task has been fired by external trigger exTriggerDemo, you can check the result of running task...");
		System.exit(0);
	}
}
