import jet.datasource.*;
import jet.universe.engine.*;

public class HierarchicalDataSource implements JRHierarchicalDataSource 
{
	 
	//The ResultSet need to be returned.	 
	HierarchicalDataset rs;
	UFakeHDSTable hdsTable = null;

	/**
   * Gets the data in JRHierarchicalDataset according to parameters.
	 *
	 * @param param, the parameter as input to specify the data.
	 * @return the JRHierarchicalDataset object
	 * @exception JRUserDataSourceException if a data access error occurs
	 */ 
	public JRHierarchicalDataset getHierarchicalDataset(String param) throws JRUserDataSourceException
	{
		if(param == null|| param.length() < 1)
		{
			param = "9";
		}
		
		rs = new HierarchicalDataset(param);		
		if(hdsTable != null)
			rs.setUsedFields(hdsTable);
		return rs;
	}

	/**
	 * Release the data and related resources.
	 *
	 * @exception JRUserDataSourceException if a data access error occurs
	 */
	public void releaseHierarchicalDataset() throws JRUserDataSourceException
	{
		if (rs != null)
		{
			rs.close();
		}
	}
	
	/**
	 * JReport Engine send the used database fields back after parsing the entire report template.  User should organize 
	 * the data according to this tree structure.  Note here, there is a map relationship in this tree structure between 
	 * column name and column index.
	 */
	public void setUsedFields(UFakeHDSTable table)
	{					
		hdsTable = table;		
	}	
}	