package jreport.uds.javabean;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

/*
 * Created on Jul 17, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author jennyw
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public  class DataCenter {
	private static Hashtable dataTable=new Hashtable();
	public static boolean putData( 	String objeID, 
									Object data, 
									Object owner, 
									int maxShareTimes, 
									int timeout,
									boolean overwrite){
		synchronized( dataTable){
			boolean ret = false;
			if( overwrite ||!containsData(objeID)){
				UDSForJavaBeanLogger.debug("DataCenter.putData()"+"Key:"+objeID+"Data:"+data+"Owner:"+owner+"MaxShareTimes:"+maxShareTimes+"Overwrite?"+overwrite);
			    dataTable.put( objeID, new DataElementForDataCenter(objeID, owner, data,maxShareTimes, timeout));
				ret =true;
			}
			dataTable.notify();
			return ret;
	    }
			
	}
	
	public static Object removeData( String objeID){
		synchronized( dataTable){
			UDSForJavaBeanLogger.debug("DataCenter.removeDate()>>>KEY:"+objeID);
			Object oRet = dataTable.remove(objeID);
			System.out.println("DataCenter Size:"+dataTable.size());
			
			dataTable.notify();
			return oRet;
		}
		
	}
	
	public static Object getData( String objeID) throws DataCenterException{
		DataElementForDataCenter element = null;
		synchronized( dataTable){
			element =(DataElementForDataCenter)dataTable.get(objeID);
			dataTable.notify();
		}
		
		if(element!=null){
			return element.getData();
		}
		else
			return null;
	}
	
	public static Object lockData( String objID, Object locker) throws DataCenterException{
		UDSForJavaBeanLogger.debug("DataCenter.lockData()>>>KEY:"+objID+"Locker:"+locker);
		if( locker == null){
			throw new DataCenterException("The locker is null.");
		}
		
		DataElementForDataCenter element =null;
		synchronized( dataTable){
			element =(DataElementForDataCenter)dataTable.get(objID);
			dataTable.notify();
		}
		
		if(element!=null){
			if(!element.lock(locker)){
					throw new DataCenterException("Exceed max share times "+
							element.getMaxShareTimes()+" on objectID"+objID);
			
			}
			System.out.println(" element.getData() = " +element.getData());
			return element.getData();
		}
		else
			return null;
	}
	
	public static boolean containsData(String objID){
		return dataTable.containsKey(objID);
	}
	
	public static synchronized void unlockData(String objeID, Object locker){
		UDSForJavaBeanLogger.debug("DataCenter.lockData()>>>KEY:"+objeID+"Locker:"+locker);
//		System.out.println("DataCenter.unlockData()>>>KEY:"+objeID+"Locker:"+locker);
		if( locker == null)
			return;
		
		DataElementForDataCenter element =null;
		synchronized( dataTable){
			element =(DataElementForDataCenter)dataTable.get(objeID);
			dataTable.notify();
		}
		if(element!=null){
			boolean removed = false;
			synchronized(element){
			    if(element.unlock(locker)){
//			    if(element.canBeRemoved()){
				    removeData(objeID);
				    removed = true;
			    }
			    element.notify();
			}
			if( removed ){
			    element.removed();
			}
		}else{
			UDSForJavaBeanLogger.debug("DataCenter.lockData()>>>Cannot find Object ID:"+objeID);
		}
	}
	
		
//	public static void removeDataFromOwner(Object owner){
//		Enumeration keys = dataTable.keys();
//	    ArrayList toBeRemoved = new ArrayList();
//	    
//	    String key;
//	    DataElementForDataCenter obj;
//	    	    while(keys.hasMoreElements()){
//	    	key = (String)keys.nextElement();
//	    	obj = (DataElementForDataCenter)dataTable.get(key);
//	    	if( obj.getOwner().equals(owner)){
//	    		toBeRemoved.add(key);
//	    	}
//	    }
//	    
//	    Iterator iterater = toBeRemoved.iterator();
//	    while( iterater.hasNext()){
//	    	dataTable.remove(iterater.next());
//	    }
//	}
	
	public static void dump(PrintStream out){
		synchronized( dataTable){
		
			Enumeration keys = dataTable.keys();
			String key;
		    DataElementForDataCenter obj;
		
			while (keys.hasMoreElements()){
				key =(String)keys.nextElement();
				out.print("Key:"+key);
				obj =(DataElementForDataCenter)dataTable.get(key);
				obj.dump(out);
				out.println();
			}
			dataTable.notify();
		}
	}
	
	public static int size(){
		return dataTable.size();
	}
}
