package help;

import java.sql.*;
import java.util.*;
import java.math.BigDecimal;
import java.io.*;
import java.net.*;

import jet.datasource.*;

public class AddressListResultSet implements ResultSet
{
    /**
     * Array that stores values in the current row.
     * In the array, the index is the column index in address file, and the contents is
     * a String object that keeps the value.
     */
    String values[];

    /**
     * The flag that indicates whether the last accessed column was null.
     */
    boolean bWasNull = false;

    /**
     * The reader that reads the address list file.
     */
    BufferedReader reader;
	int booleanv=0;

    
    /**
     * Construct the class.
     */
    public AddressListResultSet()
    {
    }

    /** 
     * Initialize this JRResultSetSample.
     * @param colDescs the descriptions of columns in the result set.
     * @param args the arguments of this class.
     */
    public AddressListResultSet(String strFileName) throws JRUserDataSourceException
    {
        // Create the values array.
        values = new String[12]; // 11 columns in the file.

        try
        {
            // Open the file specified in argument.
            File flAddressList = new File(strFileName);
            reader = new BufferedReader(new FileReader(flAddressList));  
        }
        catch(FileNotFoundException e)
        {
            throw new JRUserDataSourceException("File not found. " + strFileName);
        }
    }

    /**
     * Fetchs the next record and returns it if fetched.
     */
    public boolean next() throws JRUserDataSourceException
    {
        try
        {
            // read the next line in address file.
            String record = reader.readLine();
			int iIndex = 0;
			
			
            
            // If the end of file not reach.
			if(record==null)
			{
				return (record != null);
			}
            else if ( record != null )
            {
				
				while(record.length()==0)
				{
					record = reader.readLine();
					if(record==null)
					{
						return (record != null);
					}
				}
				
                // Get columns from record.
                // Create string tokenizer.
                StringTokenizer tokenizer = new StringTokenizer(record, "	",true);

				

                // In the loop, get each item as token.
				String a2="";
	            while(tokenizer.hasMoreTokens())
                {
					
					String a1=null;
					a1=tokenizer.nextToken();
					if(a1.compareTo("	")!=0)
					{
						values[iIndex]=a1;
						iIndex++;
					}
					else if(a1.compareTo("	")==0 && a2.compareTo("	")==0 )
					{
						values[iIndex]=null;
						iIndex++;
					}
					else
					{
						
					}
					a2=a1;
                    
                }
            }
            // return if next line read.
            return (record != null);
        }
        catch(IOException e)
        {
            throw new JRUserDataSourceException("Cannot read file.");
        }
    }

    /**
     * Closes the result set and frees the resource.
     */
    public void close() throws JRUserDataSourceException
    {
        try
        {
            // Close the address file.
            reader.close();
        }
        catch(IOException ioe)
        {
            throw new JRUserDataSourceException("Cannot close the file.");
        }
        return;
    }

	public ResultSetMetaData getMetaData() 
	{
        return new AddressListResultSetMetaData();
    }


    /**
     * Return null if the last accessed column is null.
     */
    public boolean wasNull() 
    {
        return bWasNull;
    }
    
    /**
     * Get the string value of the specified column.
     */
    public String getString(int columnIndex) throws JRUserDataSourceException
    {
        // Calculate if the column is null.
		bWasNull = (values[columnIndex - 1] == null || values[columnIndex - 1 ].length() == 0);
        if (!bWasNull)
        {
			
            // return the value.
			
            return values[columnIndex - 1];
		}

        return null;
    }

    /**
     * Because the address file does not have the data in this type, leave the method empty.
     */
    public boolean getBoolean(int columnIndex) 
    {
        return false;
    }

    /**
     * Because the address file does not have the data in this type, leave the method empty.
     */
    public byte getByte(int columnIndex) 
    {
        return 0;
    }

    /**
     * Because the address file does not have the data in this type, leave the method empty.
	 */
    public short getShort(int columnIndex) 
    {
        return 0;
    }

    /**
     * Because the address file does not have the data in this type, leave the method empty.
     */
    public int getInt(int columnIndex) 
    {
        return 0;
    }

    /**
     * Because the address file does not have the data in this type, leave the method empty.
     */
    public long getLong(int columnIndex) 
    {
        return 0;
    }

    /**
     * Because the address file does not have the data in this type, leave the method empty.
     */
    public float getFloat(int columnIndex) 
    {
        return 0;
    }

    /**
     * Because the address file does not have data in this type, leave the method empty.
     */
    public double getDouble(int columnIndex) 
    {
        return 0;
    }

    /**
     * Because the address file does not have data in this type, leave the method empty.
     */
    public BigDecimal getBigDecimal(int columnIndex, int scale) 
    {
        return null;
    }


    /**
     * Because the address file does not have data in this type, leave the method empty.
     */
    public java.sql.Date getDate(int columnIndex) 
    {
        return null;
    }

    /**
     * Because the address file does not have the data in this type, leave the method empty.
     */
    public java.sql.Time getTime(int columnIndex) 
    {
        return null;
    }

    /**
     * Because the address file does not have the data in this type, leave the method empty.
     */
    public java.sql.Timestamp getTimestamp(int columnIndex) 
    {
        return null;
    }

    /**
     * Because the address file does not have the data in this type, leave the method empty.
     */
    public java.io.InputStream getBinaryStream(int columnIndex) 
    {
        return null;
    }
    
	

    //======================================================================
    // User do not have to implement the following methods for they
	// are not used in the JReport system.
    //======================================================================

	public byte[] getBytes(int columnIndex) 
	{
        return null;
    }
    
	public java.io.InputStream getAsciiStream(int columnIndex) {
    	return null;
    }
    
	public java.io.InputStream getUnicodeStream(int columnIndex) {
        return null;
    }

    public String getString(String columnName) {
        return null;
    }
    
	public boolean getBoolean(String columnName) {
        return false;
    }
    
	public byte getByte(String columnName) {
        return 0;
    }
    
	public short getShort(String columnName) {
        return 0;
    }
    
	public int getInt(String columnName) {
        return 0;
    }
    
	public long getLong(String columnName) {
        return 0;
    }
    
	public float getFloat(String columnName) {
        return 0;
    }
    
	public double getDouble(String columnName) {
        return 0;
    }
    
	public BigDecimal getBigDecimal(String columnName, int scale) {
        return null;
    }
    
	public byte[] getBytes(String columnName) {
        return null;
    }
    
	public java.sql.Date getDate(String columnName) {
        return null;
    }
    
	public java.sql.Time getTime(String columnName) {
        return null;
    }
    
	public java.sql.Timestamp getTimestamp(String columnName) {
        return null;
    }
    
	public java.io.InputStream getAsciiStream(String columnName) {
        return null;
    }
    
	public java.io.InputStream getUnicodeStream(String columnName) {
        return null;
    }
    
	public java.io.InputStream getBinaryStream(String columnName)
                {
        return null;
    }
    
    public SQLWarning getWarnings() {
        return null;
    }
    
    public void clearWarnings() {

    }
    
    public String getCursorName() {
        return null;
    }
    
	public Object getObject(int columnIndex) {
        return null;
    }
    
    public Object getObject(String columnName) {
        return null;
    }
    
    public int findColumn(String columnName) {
        return 0;
    }

    //--------------------------JDBC 2.0-----------------------------------

    //---------------------------------------------------------------------
    // Getter's and Setter's
    //---------------------------------------------------------------------

    /**
     * JDBC 2.0
     *
     * <p>Get the value of a column in the current row as a java.io.Reader.
     */
    public java.io.Reader getCharacterStream(int columnIndex) 
	{
		return null;
	}

    /**
     * JDBC 2.0
     *
     * <p>Get the value of a column in the current row as a java.io.Reader.
     */
    public java.io.Reader getCharacterStream(String columnName) 
	{
		return null;
	}

    /**
     * JDBC 2.0
     *
     * Get the value of a column in the current row as a java.math.BigDecimal 
     * object.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value (full precision); if the value is SQL NULL, 
     * the result is null
     * @exception JRUserDataSourceException if a database-access error occurs.
     */
    public BigDecimal getBigDecimal(int columnIndex) 
	{
		return null;
	}

    /**
     * JDBC 2.0
     *
     * Get the value of a column in the current row as a java.math.BigDecimal 
     * object.
     *
     */
    public BigDecimal getBigDecimal(String columnName) 
	{
		return null;
	}

    //---------------------------------------------------------------------
    // Traversal/Positioning
    //---------------------------------------------------------------------

    /**
     * JDBC 2.0
     *
     * <p>Determine if the cursor is before the first row in the result 
     * set.   
     *
     * @return true if before the first row, false otherwise. Returns
     * false when the result set contains no rows.
     * @exception JRUserDataSourceException if a database-access error occurs.
     */
    public boolean isBeforeFirst() 
	{
		return false;
	}
      
    /**
     * JDBC 2.0
     *
     * <p>Determine if the cursor is after the last row in the result 
     * set.   
     *
     * @return true if after the last row, false otherwise.  Returns
     * false when the result set contains no rows.
     * @exception JRUserDataSourceException if a database-access error occurs.
     */
    public boolean isAfterLast() 
	{
		return false;
	}
 
    /**
     * JDBC 2.0
     *
     * <p>Determine if the cursor is on the first row of the result set.   
     *
     * @return true if on the first row, false otherwise.   
     * @exception JRUserDataSourceException if a database-access error occurs.
     */
    public boolean isFirst() 
	{
		return false;
	}
 
    /**
     * JDBC 2.0
     *
     * <p>Determine if the cursor is on the last row of the result set.   
     * Note: Calling isLast() may be expensive since the JDBC driver
     * might need to fetch ahead one row in order to determine 
     * whether the current row is the last row in the result set.
     *
     * @return true if on the last row, false otherwise. 
     * @exception JRUserDataSourceException if a database-access error occurs.
     */
    public boolean isLast() 
	{
		return false;
	}

    /**
     * JDBC 2.0
     *
     * <p>Moves to the front of the result set, just before the
     * first row. Has no effect if the result set contains no rows.
     *
     * @exception JRUserDataSourceException if a database-access error occurs, or
     * result set type is TYPE_FORWARD_ONLY
     */
    public void beforeFirst() 
	{
	}

    /**
     * JDBC 2.0
     *
     * <p>Moves to the end of the result set, just after the last
     * row.  Has no effect if the result set contains no rows.
     *
     * @exception JRUserDataSourceException if a database-access error occurs, or
     * result set type is TYPE_FORWARD_ONLY.
     */
    public void afterLast() 
	{
	}

    /**
     * JDBC 2.0
     *
     * <p>Moves to the first row in the result set.  
     *
     * @return true if on a valid row, false if no rows in the result set.
     * @exception JRUserDataSourceException if a database-access error occurs, or
     * result set type is TYPE_FORWARD_ONLY.
     */
    public boolean first() 
	{
		return false;
	}

    /**
     * JDBC 2.0
     *
     * <p>Moves to the last row in the result set.  
     *
     * @return true if on a valid row, false if no rows in the result set.
     * @exception JRUserDataSourceException if a database-access error occurs, or
     * result set type is TYPE_FORWARD_ONLY.
     */
    public boolean last() 
	{
		return false;
	}

    /**
     * JDBC 2.0
     *
     * <p>Determine the current row number.  The first row is number 1, the
     * second number 2, etc.  
     *
     * @return the current row number, else return 0 if there is no 
     * current row
     * @exception JRUserDataSourceException if a database-access error occurs.
     */
    public int getRow() 
	{
		return 0;
	}

    /**
     * JDBC 2.0
     *
     * <p>Move to an absolute row number in the result set.
     *
     * <p>If row is positive, moves to an absolute row with respect to the
     * beginning of the result set.  The first row is row 1, the second
     * is row 2, etc. 
     *
     * <p>If row is negative, moves to an absolute row position with respect to
     * the end of result set.  For example, calling absolute(-1) positions the 
     * cursor on the last row, absolute(-2) indicates the next-to-last
     * row, etc.
     *
     * <p>An attempt to position the cursor beyond the first/last row in
     * the result set, leaves the cursor before/after the first/last
     * row, respectively.
     *
     * <p>Note: Calling absolute(1) is the same as calling first().
     * Calling absolute(-1) is the same as calling last().
     *
     * @return true if on the result set, false if off.
     * @exception JRUserDataSourceException if a database-access error occurs, or 
     * row is 0, or result set type is TYPE_FORWARD_ONLY.
     */
    public boolean absolute( int row ) 
	{
		return false;
	}

    /**
     * JDBC 2.0
     *
     * <p>Moves a relative number of rows, either positive or negative.
     * Attempting to move beyond the first/last row in the
     * result set positions the cursor before/after the
     * the first/last row. Calling relative(0) is valid, but does
     * not change the cursor position.
     *
     * <p>Note: Calling relative(1) is different than calling next()
     * since is makes sense to call next() when there is no current row,
     * for example, when the cursor is positioned before the first row
     * or after the last row of the result set.
     *
     * @return true if on a row, false otherwise.
     * @exception JRUserDataSourceException if a database-access error occurs, or there
     * is no current row, or result set type is TYPE_FORWARD_ONLY.
     */
    public boolean relative( int rows ) 
	{
		return false;
	}

    /**
     * JDBC 2.0
     *
     * <p>Moves to the previous row in the result set.  
     *
     * <p>Note: previous() is not the same as relative(-1) since it
     * makes sense to call previous() when there is no current row.
     *
     * @return true if on a valid row, false if off the result set.
     * @exception JRUserDataSourceException if a database-access error occurs, or
     * result set type is TYPE_FORWAR_DONLY.
     */
    public boolean previous() 
	{
		return false;
	}

    /**
     * JDBC 2.0
     *
     * Give a hint as to the direction in which the rows in this result set
     * will be processed.  The initial value is determined by the statement
     * that produced the result set.  The fetch direction may be changed
     * at any time.
     *
     * @exception JRUserDataSourceException if a database-access error occurs, or
     * the result set type is TYPE_FORWARD_ONLY and direction is not 
     * FETCH_FORWARD.
     */
    public void setFetchDirection(int direction) 
	{
	}

    /**
     * JDBC 2.0
     *
     * Return the fetch direction for this result set.
     *
     * @exception JRUserDataSourceException if a database-access error occurs 
     */
    public int getFetchDirection() 
	{
		return 0;
	}

    /**
     * JDBC 2.0
     *
     * Give the JDBC driver a hint as to the number of rows that should 
     * be fetched from the database when more rows are needed for this result
     * set.  If the fetch size specified is zero, then the JDBC driver 
     * ignores the value, and is free to make its own best guess as to what
     * the fetch size should be.  The default value is set by the statement 
     * that creates the result set.  The fetch size may be changed at any 
     * time.
     *
     * @param rows the number of rows to fetch
     * @exception JRUserDataSourceException if a database-access error occurs, or the
     * condition 0 <= rows <= this.getMaxRows() is not satisfied.
     */
    public void setFetchSize(int rows) 
	{
	}

    /**
     * JDBC 2.0
     *
     * Return the fetch size for this result set.
     *
     * @exception JRUserDataSourceException if a database-access error occurs 
     */
    public int getFetchSize() 
	{
		return 0;
	}

    /**
     * JDBC 2.0
     *
     * Return the type of this result set.  The type is determined based
     * on the statement that created the result set.
     *
     * @return TYPE_FORWARD_ONLY, TYPE_SCROLL_INSENSITIVE, or
	 * TYPE_SCROLL_SENSITIVE
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public int getType() 
	{
		return 0;
	}

    /**
     * JDBC 2.0
     *
     * Return the concurrency of this result set.  The concurrency
     * used is determined by the statement that created the result set.
     *
     * @return the concurrency type, CONCUR_READ_ONLY, etc.
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public int getConcurrency() 
	{
		return 0;
	}

    //---------------------------------------------------------------------
    // Updates
    //---------------------------------------------------------------------

    /**
     * JDBC 2.0
     *
     * Determine if the current row has been updated.  The value returned 
     * depends on whether or not the result set can detect updates.
     *
     * @return true if the row has been visibly updated by the owner or
     * another, and updates are detected
     * @exception JRUserDataSourceException if a database-access error occurs
     * 
     * @see DatabaseMetaData#updatesAreDetected
     */
    public boolean rowUpdated() 
	{
		return false;
	}

    /**
     * JDBC 2.0
     *
     * Determine if the current row has been inserted.  The value returned 
     * depends on whether or not the result set can detect visible inserts.
     *
     * @return true if inserted and inserts are detected
     * @exception JRUserDataSourceException if a database-access error occurs
     * 
     * @see DatabaseMetaData#insertsAreDetected
     */
    public boolean rowInserted() 
	{
		return false;
	}
   
    /**
     * JDBC 2.0
     *
     * Determine if this row has been deleted.  A deleted row may leave
     * a visible "hole" in a result set.  This method can be used to
     * detect holes in a result set.  The value returned depends on whether 
     * or not the result set can detect deletions.
     *
     * @return true if deleted and deletes are detected
     * @exception JRUserDataSourceException if a database-access error occurs
     * 
     * @see DatabaseMetaData#deletesAreDetected
     */
    public boolean rowDeleted() 
	{
		return false;
	}

    /**
     * JDBC 2.0
     * 
     * Give a nullable column a null value.
     * 
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateNull(int columnIndex) 
	{
	}

    /**
     * JDBC 2.0
     * 
     * Update a column with a boolean value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateBoolean(int columnIndex, boolean x) 
	{
	}

    /**
     * JDBC 2.0
     *   
     * Update a column with a byte value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateByte(int columnIndex, byte x) 
	{
	}

    /**
     * JDBC 2.0
     *   
     * Update a column with a short value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateShort(int columnIndex, short x) 
	{
	}

    /**
     * JDBC 2.0
     *   
     * Update a column with an integer value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateInt(int columnIndex, int x) 
	{
	}

    /**
     * JDBC 2.0
     *   
     * Update a column with a long value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateLong(int columnIndex, long x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a float value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateFloat(int columnIndex, float x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a Double value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateDouble(int columnIndex, double x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a BigDecimal value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateBigDecimal(int columnIndex, BigDecimal x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a String value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateString(int columnIndex, String x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a byte array value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateBytes(int columnIndex, byte x[]) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a Date value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateDate(int columnIndex, java.sql.Date x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a Time value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateTime(int columnIndex, java.sql.Time x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a Timestamp value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateTimestamp(int columnIndex, java.sql.Timestamp x)
      
	{
	}

    /** 
     * JDBC 2.0
     *  
     * Update a column with an ascii stream value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @param length the length of the stream
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateAsciiStream(int columnIndex, 
			   java.io.InputStream x, 
			   int length) 
	{
	}

    /** 
     * JDBC 2.0
     *  
     * Update a column with a binary stream value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value     
     * @param length the length of the stream
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateBinaryStream(int columnIndex, 
			    java.io.InputStream x,
			    int length) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a character stream value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @param length the length of the stream
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateCharacterStream(int columnIndex,
			     java.io.Reader x,
			     int length) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with an Object value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @param scale For java.sql.Types.DECIMAL or java.sql.Types.NUMERIC types
     *  this is the number of digits after the decimal.  For all other
     *  types this value will be ignored.
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateObject(int columnIndex, Object x, int scale)
      
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with an Object value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateObject(int columnIndex, Object x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a null value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateNull(String columnName) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a boolean value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateBoolean(String columnName, boolean x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a byte value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateByte(String columnName, byte x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a short value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateShort(String columnName, short x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with an integer value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateInt(String columnName, int x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a long value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateLong(String columnName, long x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a float value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateFloat(String columnName, float x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a double value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateDouble(String columnName, double x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a BigDecimal value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateBigDecimal(String columnName, BigDecimal x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a String value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateString(String columnName, String x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a byte array value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateBytes(String columnName, byte x[]) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a Date value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateDate(String columnName, java.sql.Date x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a Time value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateTime(String columnName, java.sql.Time x) 
	{
	}

    /**
     * JDBC 2.0
     *  
     * Update a column with a Timestamp value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateTimestamp(String columnName, java.sql.Timestamp x)
      {}

    /** 
     * JDBC 2.0
     *  
     * Update a column with an ascii stream value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @param length of the stream
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateAsciiStream(String columnName, 
			   java.io.InputStream x, 
			   int length) {}

    /** 
     * JDBC 2.0
     *  
     * Update a column with a binary stream value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @param length of the stream
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateBinaryStream(String columnName, 
			    java.io.InputStream x,
			    int length) {}

    /**
     * JDBC 2.0
     *  
     * Update a column with a character stream value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @param length of the stream
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateCharacterStream(String columnName,
			     java.io.Reader reader,
			     int length) {}

    /**
     * JDBC 2.0
     *  
     * Update a column with an Object value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @param scale For java.sql.Types.DECIMAL or java.sql.Types.NUMERIC types
     *  this is the number of digits after the decimal.  For all other
     *  types this value will be ignored.
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateObject(String columnName, Object x, int scale)
      {}

    /**
     * JDBC 2.0
     *  
     * Update a column with an Object value.
     *
     * The updateXXX() methods are used to update column values in the
     * current row, or the insert row.  The updateXXX() methods do not 
     * update the underlying database, instead the updateRow() or insertRow()
     * methods are called to update the database.
     *
     * @param columnName the name of the column
     * @param x the new column value
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public void updateObject(String columnName, Object x) {}

    /**
     * JDBC 2.0
     *
     * Insert the contents of the insert row into the result set and
     * the database.  Must be on the insert row when this method is called.
     *
     * @exception JRUserDataSourceException if a database-access error occurs,
     * if called when not on the insert row, or if all non-nullable columns in
     * the insert row have not been given a value
     */
    public void insertRow() {}

    /**
     * JDBC 2.0
     *
     * Update the underlying database with the new contents of the
     * current row.  Cannot be called when on the insert row.
     *
     * @exception JRUserDataSourceException if a database-access error occurs, or
     * if called when on the insert row
     */
    public void updateRow() {}

    /**
     * JDBC 2.0
     *
     * Delete the current row from the result set and the underlying
     * database.  Cannot be called when on the insert row.
     *
     * @exception JRUserDataSourceException if a database-access error occurs, or if
     * called when on the insert row.
     */
    public void deleteRow() {}

    /**
     * JDBC 2.0
     *
     * Refresh the value of the current row with its current value in 
     * the database.  Cannot be called when on the insert row.
     *
     * The refreshRow() method provides a way for an application to 
     * explicitly tell the JDBC driver to refetch a row(s) from the
     * database.  An application may want to call refreshRow() when 
     * caching or prefetching is being done by the JDBC driver to
     * fetch the latest value of a row from the database.  The JDBC driver 
     * may actually refresh multiple rows at once if the fetch size is 
     * greater than one.
     * 
     * All values are refetched subject to the transaction isolation 
     * level and cursor sensitivity.  If refreshRow() is called after
     * calling updateXXX(), but before calling updateRow() then the
     * updates made to the row are lost.  Calling refreshRow() frequently
     * will likely slow performance.
     *
     * @exception JRUserDataSourceException if a database-access error occurs, or if
     * called when on the insert row.
     */
    public void refreshRow() {}

    /**
     * JDBC 2.0
     *
     * The cancelRowUpdates() method may be called after calling an
     * updateXXX() method(s) and before calling updateRow() to rollback 
     * the updates made to a row.  If no updates have been made or 
     * updateRow() has already been called, then this method has no 
     * effect.
     *
     * @exception JRUserDataSourceException if a database-access error occurs, or if
     * called when on the insert row.
     *
     */
    public void cancelRowUpdates () {}

    /**
     * JDBC 2.0
     *
     * Move to the insert row.  The current cursor position is 
     * remembered while the cursor is positioned on the insert row.
     *
     * The insert row is a special row associated with an updatable
     * result set.  It is essentially a buffer where a new row may
     * be constructed by calling the updateXXX() methods prior to 
     * inserting the row into the result set.  
     *
     * Only the updateXXX(), getXXX(), and insertRow() methods may be 
     * called when the cursor is on the insert row.  All of the columns in 
     * a result set must be given a value each time this method is
     * called before calling insertRow().  UpdateXXX()must be called before
     * getXXX() on a column.
     *
     * @exception JRUserDataSourceException if a database-access error occurs,
     * or the result set is not updatable
     */
    public void moveToInsertRow() {}

    /**
     * JDBC 2.0
     *
     * Move the cursor to the remembered cursor position, usually the
     * current row.  Has no effect unless the cursor is on the insert 
     * row. 
     *
     * @exception JRUserDataSourceException if a database-access error occurs,
     * or the result set is not updatable
     */
    public void moveToCurrentRow() {}

    /**
     * JDBC 2.0
     *
     * Return the Statement that produced the ResultSet.
     *
     * @return the Statment that produced the result set, or
     * null if the result was produced some other way.
     * @exception JRUserDataSourceException if a database-access error occurs
     */
    public Statement getStatement() {return null;}

    /**
     * JDBC 2.0
     *
     * Returns the value of column @i as a Java object.  Use the 
     * @map to determine the class from which to construct data of 
     * SQL structured and distinct types.
     *
     * @param i the first column is 1, the second is 2, ...
     * @param map the mapping from SQL type names to Java classes
     * @return an object representing the SQL value
     */
//    public Object getObject(int i, java.util.Map map) {return null;}

    /**
     * JDBC 2.0
     *
     * Get a REF(&lt;structured-type&gt;) column.
     *
     * @param i the first column is 1, the second is 2, ...
     * @return an object representing data of an SQL REF type
     */
    public Ref getRef(int i) {return null;}

    /**
     * JDBC 2.0
     *
     * Get a BLOB column.
     *
     * @param i the first column is 1, the second is 2, ...
     * @return an object representing a BLOB
     */
    public Blob getBlob(int i) {return null;}

    /**
     * JDBC 2.0
     *
     * Get a CLOB column.
     *
     * @param i the first column is 1, the second is 2, ...
     * @return an object representing a CLOB
     */
    public Clob getClob(int i) {return null;}

    /**
     * JDBC 2.0
     *
     * Get an array column.
     *
     * @param i the first column is 1, the second is 2, ...
     * @return an object representing an SQL array
     */
    public Array getArray(int i) {return null;}

    /**
     * JDBC 2.0
     *
     * Returns the value of column @i as a Java object.  Use the 
     * @map to determine the class from which to construct data of 
     * SQL structured and distinct types.
     *
     * @param colName the column name
     * @param map the mapping from SQL type names to Java classes
     * @return an object representing the SQL value
     */
//    public Object getObject(String colName, java.util.Map map) {return null;}

    /**
     * JDBC 2.0
     *
     * Get a REF(&lt;structured-type&gt;) column.
     *
     * @param colName the column name
     * @return an object representing data of an SQL REF type
     */
    public Ref getRef(String colName) {return null;}

    /**
     * JDBC 2.0
     *
     * Get a BLOB column.
     *
     * @param colName the column name
     * @return an object representing a BLOB
     */
    public Blob getBlob(String colName) {return null;}

    /**
     * JDBC 2.0
     *
     * Get a CLOB column.
     *
     * @param colName the column name
     * @return an object representing a CLOB
     */
    public Clob getClob(String colName) {return null;}

    /**
     * JDBC 2.0
     *
     * Get an array column.
     *
     * @param colName the column name
     * @return an object representing an SQL array
     */
    public Array getArray(String colName) {return null;}

    /**
     * JDBC 2.0
     *
     * Get the value of a column in the current row as a java.sql.Date 
     * object.  Use the calendar to construct an appropriate millisecond
     * value for the Date, if the underlying database doesn't store
     * timezone information.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param cal the calendar to use in constructing the date
     * @return the column value; if the value is SQL NULL, the result is null
     * @exception JRUserDataSourceException if a database-access error occurs.
     */
    public java.sql.Date getDate(int columnIndex, java.util.Calendar cal) {return null;}

	public java.sql.Time getTime(int col, java.util.Calendar c) {return null;}
	public java.sql.Time getTime(String col, java.util.Calendar c) {return null;}
	public java.sql.Date getDate(String col, java.util.Calendar c) {return null;}
	public java.sql.Timestamp getTimestamp(int col, java.util.Calendar c) {return null;}
	public java.sql.Timestamp getTimestamp(String col, java.util.Calendar c) {return null;}
		public URL getURL(String columnName) throws SQLException
	{
		return null;

	}
	/* Below jkd1.4  methods
    */
	public URL getURL(int columnIndex) throws SQLException
	{
		return null;
	}
	public void updateRef(int columnIndex, Ref x)
	{
	}
	 public void updateRef(String columnName,Ref x)
	{
	}
	public void updateBlob(int columnIndex,Blob x) throws SQLException
	{
	}
	public void updateBlob(String columnName,Blob x)
	{
	}
	public void updateClob(int columnIndex,Clob x)
	{
	}
	public void updateClob(String columnName,Clob x)
	{
	}
	public void updateArray(int columnIndex,java.sql.Array x)
	{
	}
	public void updateArray(String columnName,java.sql.Array x)
	{
	}

	@Override
	public int getHoldability() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public Reader getNCharacterStream(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Reader getNCharacterStream(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public NClob getNClob(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public NClob getNClob(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getNString(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getNString(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object getObject(int arg0, Map<String, Class<?>> arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object getObject(String arg0, Map<String, Class<?>> arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public RowId getRowId(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public RowId getRowId(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public SQLXML getSQLXML(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public SQLXML getSQLXML(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean isClosed() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void updateAsciiStream(int arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateAsciiStream(String arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateAsciiStream(int arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateAsciiStream(String arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateBinaryStream(int arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateBinaryStream(String arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateBinaryStream(int arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateBinaryStream(String arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateBlob(int arg0, InputStream arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateBlob(String arg0, InputStream arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateBlob(int arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateBlob(String arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateCharacterStream(int arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateCharacterStream(String arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateCharacterStream(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateCharacterStream(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateClob(int arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateClob(String arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateClob(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateClob(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNCharacterStream(int arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNCharacterStream(String arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNCharacterStream(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNCharacterStream(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNClob(int arg0, NClob arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNClob(String arg0, NClob arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNClob(int arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNClob(String arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNClob(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNClob(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNString(int arg0, String arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateNString(String arg0, String arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateRowId(int arg0, RowId arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateRowId(String arg0, RowId arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public boolean isWrapperFor(Class<?> arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public <T> T unwrap(Class<T> arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

}
