<%@ page import="jet.web.dhtml.*"%>
<!-- specify the error page for this is jsp, a user can customize it and it's optional. -->
<%@ page errorPage="../dhtmljsp/errorpage.jsp" %>
<!-- include the jsp for check user login -->
<%@ include file="../dhtmljsp/AuthCheck.jsp" %>
<html>
<head>
<title> Schedule according to date and time provided by scheduleRequest.html </title>
</head>
<body>
<%	
	//get RptServer
	HttpRptServer server =  jet.server.api.http.HttpUtil.getHttpRptServer(request); 
	Properties props = new Properties();
	props.put("jrs.cmd", "jrs.submit_schedule"); 
	props.put("jrs.task_class", "jet.server.schedule.jrtasks.PublishToDiskTask");
	props.put("jrs.to_disk", "true"); 
	props.put("jrs.to_disk_pdf_path_type", "1"); 
	props.put("jrs.result_type", "2"); 
	props.put("jrs.to_pdf", "true"); // run in PDF format
	props.put("jrs.launch_type", "1"); 
	props.put("jrs.catalog", "/JinfonetGourmetJava/JinfonetGourmetJava.cat"); 
	props.put("jrs.report", "/JinfonetGourmetJava/EmployeeInformation.cls");
	props.put("jrs.auth_uid", "admin"); // set log user ID to avoid login dialog popup
	props.put("jrs.auth_pwd", "admin"); // set log user password to avoid login dialog popup
	props.put("jrs.pdf_dir", request.getParameter("filepath"));
	props.put("jrs.pdf", request.getParameter("filename"));
	props.put("jrs.exe_year", request.getParameter("year"));
	props.put("jrs.exe_month", request.getParameter("month"));
	props.put("jrs.exe_day", request.getParameter("day"));
	props.put("jrs.exe_hour", request.getParameter("hour"));
	props.put("jrs.exe_min", request.getParameter("min"));
	
	//get user information
	HttpUserSessionManager umg = server.getHttpUserSessionManager();
	UserSession us = umg.getUserSession(request);
	String userId = us.getUserID();
	
	//Submit a scheduled task and return the task ID. 
	try{
		String taskID = server.submitScheduledTask(userId, props);
		out.print("The task has been scheduled. The task ID is:" + taskID);
	}catch(Exception e){
		out.print(e.getMessage());
	}
%>
</body>
</html>
