package com.jinfonet.jdbc.obj;

import com.jinfonet.jdbc.obj.JCollection;
import com.jinfonet.jdbc.obj.JIterator;
import com.jinfonet.interfaces.query.*;
import toolkit.db.DbTools;
import java.sql.*;

public abstract class TableFilterImpl implements TableFilter
{
	/*
	 * If not set realNames, then the realNames is same as all the odf column names.
	 */
	
	/** 
	 * the real column name in database.
	 **/
	protected String[] realNames;
 	
 	/**
 	 * object table column name in JReport odf.
 	 **/
 	protected String[] columnNames = null;
 	protected String whereSQL = null;
	protected String orderColumn = null;
	protected String selectedColumns = "*";
	protected static final String STATEMENTH	= "SELECT * FROM ";
	
	/**
	 * Base tableName update select part SQL.
	 * @param tableName the Table's real Name.
	 **/ 
	protected String refreshSelectSQL(String tableName)
	{
		return "select " + selectedColumns + " from " + DbTools.quotedWhenNeed(tableName);
	}
	
	/**
	 * Base selected column, where portion update init sql .
	 * @param initSql : "select * from tableName".
	 **/ 
	protected String refreshSQL(String initSql)
	{
        String initSQL = initSql;
        if (selectedColumns!= null)
        {
            initSQL = initSql.toUpperCase();
            int idx = initSQL.indexOf(STATEMENTH);
            if (idx > -1)
            {
                String tabName = initSql.substring (idx + STATEMENTH.length ());
                initSQL = "SELECT " + selectedColumns + " FROM " + DbTools.quotedWhenNeed(tabName);
            }
        }
        
        if (whereSQL != null)
        {
            initSQL += " WHERE " + whereSQL;
        }
        if (orderColumn!= null)
        {
            initSQL += " ORDER BY " + orderColumn;
        }

        return initSQL;
    }
	
	/**
	 * return where part sql;
	 */
	protected String getWhereSQL()
	{
		String sql = "";
		if (whereSQL != null)
		{
			sql += " WHERE " + whereSQL;
		}
		if (orderColumn!= null)
        {
            sql += " ORDER BY " + orderColumn;
        }
        return sql;
	}
	
	/**
	 * base tableName update the whole sql, include selection part and where part.
	 * @param tableName the Table's real Name.
	 **/
	protected String getSQL(String tableName)
	{
		String sql = "select " + selectedColumns + " from " + tableName;
		
		if (whereSQL != null)
		{
			sql += " WHERE " + whereSQL;
		}
		if (orderColumn!= null)
        {
            sql += " ORDER BY " + orderColumn;
        }

		return sql;
	}			
	
	/**
	 * return the selected column index in the whole real name. 
	 * This return is used for build the table's JCollection
	 **/	
	protected int[] getSelColIndex(ResultSetMetaData rsmd) throws SQLException
	{
		int[] selectedIdxes = null;
		if (rsmd != null)
		{
			int colSize = rsmd.getColumnCount();
			selectedIdxes  = new int[colSize];
			if (realNames!= null)
	        {
	            for (int j = 0; j < colSize; j++)
	            {
	                String realName = rsmd.getColumnName (j+1);
	                int k = getMatchColumnIdx(realName, realNames);
					{
	                	selectedIdxes[j]= k;
	                }
	            }
	        }
	     }
	     return selectedIdxes;
	 }
	
	/**
	 * push down the where condition based the table.
	 * each simpleTableWhere is "AND" relation.
	 **/
	public boolean setSimpleTableWhere(SimpleTableWhere[] sqlWhere)
	{
		String sqlString = "";
		if (sqlWhere != null)
		{
			for (int i = 0; i < sqlWhere.length; i ++)
			{
				SimpleTableWhere part = sqlWhere[i];
				String partSql = getMatchColumn(part.getColumn()) + " " 
					+ part.getOperator() + " " + part.getValue(); 
				if ( sqlString.length() == 0 ) 
				{
					sqlString = partSql;
				}
				else
				{
					sqlString += "AND " + partSql;
				}
			}
		}
		if ( sqlString.length() > 0 )
		{
			whereSQL = sqlString;
		}
	
		return true;
	}
	
	/**
	 * push down the selected column base the table.
	 **/
	public boolean setSelectedColumn(String[] selectedColumn)
	{
		String selected= "";
		for (int i = 0 ; i < selectedColumn.length; i ++)
		{
			int idx = getMatchColumnIdx(selectedColumn[i], columnNames);
		
			String realName = getMatchColumn(idx);
			if (selected.length() == 0 )
			{
				selected = realName;
			}
			else
			{
				selected += ", " + realName;
			}
		}
		if (selected.length() > 0 )
		{
			selectedColumns = selected;
		}
		return true;
	} 
	
	/**
	 * Have join base the sortByColumn, push down the sort column.
	 */
	public boolean setSortByColumn(String sortByColumn)
	{
		if (sortByColumn != null)
		{
			int idx = getMatchColumnIdx(sortByColumn, columnNames);
            orderColumn = getMatchColumn(idx);
        }
		return true;
	}
	
	public boolean setAllColumns(String[] columns)
    {
        columnNames = columns;
        if (realNames == null)
        {
        	realNames = columns;
        }
        return true;
    }

	private String getMatchColumn(int idx)
    {
        return DbTools.quotedWhenNeed(realNames[idx]);
    }
    
	/**
	 * get the real table column of the specified table column
	 **/
	private String getMatchColumn(String odfColumn)
	{
		int idx = getMatchColumnIdx(odfColumn, columnNames);
		return getMatchColumn(idx);
	}
	
	private int getMatchColumnIdx(String column, String[] allColums)
	{
        int idx = -1;
        for (int i = 0; i < allColums.length && idx == -1; i ++)
        {
            if (allColums[i].equalsIgnoreCase(column))
            {
                idx = i;
            }
        }
		return idx;
	}
}


