/*
 * Decompiled with CFR 0.152.
 */
package chart.data;

import chart.util.ChartMath;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class ChartDataFilter
implements Cloneable {
    public static final int SCALE = 0;
    public static final int NUMBER = 1;
    public static final int DATATIME = 2;
    public static final int TEXT = 3;
    public static final int MAPPING = 4;
    private static final String[] QOIV = new String[]{"Scale", "Number", "Date/Time", "Text", "Mapping"};
    private static final String[][] abs = new String[][]{{"Logarithm", "Hundreds", "Thousands", "Millions", "Billions", "Trillions"}, {"0", "#,##0", "#,##0;-#,##0", "0.00", "#,##0.00", "#,##0.00;-#,##0.00", "0.00E00", "##0.0E0", "$0", "$#,##0", "$#,##0;-$#,##0", "$0.00", "$#,##0.00", "$#,##0.00;-$#,##0.00", "$0.00E00", "$##0.0E0", "0%", "0.00%"}, {"G", "yyyy", "yy", "yyyy G", "MM", "MMM", "MMMMMMMM", "dd/MM/yy", "dd-MMM-yy", "dd-MMM", "MMM-yy", "MMM yyyy", "dd", "DDD", "ww", "W", "EEE", "EEEEEE", "HH", "kk", "KK a", "hh a", "mm", "hh:mm a", "ss", "hh:mm:ss", "hh:mm:ss a", "mm:ss", "MMMMM dd yyyy G (EEEEEE) hh:mm:ss aa z"}, {"Default Length"}, {"One-to-One Mapping", "Range Mapping", "Text Mapping", "Prefix", "Suffix"}};
    private static final String[][] add = new String[][]{{"Logarithm", "Hundreds", "Thousands", "Millions", "Billions", "Trillions"}, {"0", "#,##0", "#,##0;-#,##0", "0.00", "#,##0.00", "#,##0.00;-#,##0.00", "0.00E00", "##0.0E0", "$0", "$#,##0", "$#,##0;-$#,##0", "$0.00", "$#,##0.00", "$#,##0.00;-$#,##0.00", "$0.00E00", "$##0.0E0", "0%", "0.00%"}, {"Default Length"}, {"One-to-One Mapping", "Range Mapping", "Text Mapping", "Prefix", "Suffix"}};
    private Vector append;
    private List clone;
    private boolean doubleValue;

    public ChartDataFilter() {
        this.append = new Vector();
    }

    public ChartDataFilter(Vector vector) {
        this.append = vector;
    }

    public void setFilters(Vector vector) {
        this.append = vector;
    }

    public List getFilters() {
        return this.append;
    }

    public boolean isLogScale() {
        return this.doubleValue;
    }

    public void setLogScale(boolean bl) {
        this.doubleValue = bl;
    }

    public Number log10Scale(Number number) {
        if (this.doubleValue) {
            number = ChartMath.log10(number);
        }
        return number;
    }

    public Number scale(Number number, List list) {
        Number number2 = number;
        int n = list.size();
        if (number2 == null || n < 0) {
            return number2;
        }
        double d = number2.doubleValue();
        if (this.doubleValue) {
            d = ChartMath.power10(d);
        } else {
            int n2 = 0;
            while (n2 < n) {
                switch ((Integer)list.get(n2)) {
                    case 1: {
                        d /= 100.0;
                        break;
                    }
                    case 2: {
                        d /= 1000.0;
                        break;
                    }
                    case 3: {
                        d /= 1000000.0;
                        break;
                    }
                    case 4: {
                        d /= 1.0E9;
                        break;
                    }
                    case 5: {
                        d /= 1.0E12;
                    }
                }
                ++n2;
            }
        }
        return new Double(d);
    }

    private Object QOIV(Number number, List list) {
        if (number == null) {
            return null;
        }
        Object object = number;
        int n = list.size();
        if (n > 0) {
            DecimalFormat decimalFormat = (DecimalFormat)list.get(0);
            if (decimalFormat != null) {
                object = decimalFormat.format(number);
            }
        } else if (this.abs(number.doubleValue())) {
            object = new DecimalFormat("0.00").format(number);
        }
        return object;
    }

    private boolean abs(double d) {
        boolean bl = false;
        if (!(Math.abs(d - (double)Math.round(d)) < 1.0E-5)) {
            bl = true;
        }
        return bl;
    }

    private String add(Date date, List list) {
        SimpleDateFormat simpleDateFormat;
        if (date == null) {
            return null;
        }
        String string = date.toLocaleString();
        int n = list.size();
        if (n > 0 && (simpleDateFormat = (SimpleDateFormat)list.get(0)) != null) {
            string = simpleDateFormat.format(date);
        }
        return string;
    }

    private Object append(Object object, int n, List list) {
        int n2 = list.size();
        Object object2 = object;
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                Object[] objectArray = (Object[])list.get(n3);
                if (objectArray != null) {
                    if (objectArray.length == 3) {
                        int n4 = (Integer)objectArray[0];
                        int n5 = (Integer)objectArray[1];
                        String string = (String)objectArray[2];
                        if (n5 == -1) {
                            n5 = Integer.MAX_VALUE;
                        }
                        if (n != Integer.MIN_VALUE) {
                            int n6 = n4;
                            n4 = Math.min(n6, n5);
                            n5 = Math.max(n6, n5);
                            if (n >= n4 && n <= n5) {
                                object = string;
                            }
                        }
                    } else if (objectArray.length == 2) {
                        String string = (String)objectArray[0];
                        String string2 = (String)objectArray[1];
                        object = string.equals("Pre") ? this.clone(object, string2) : this.doubleValue(object, string2);
                    } else if (objectArray.length == 4) {
                        String string = (String)objectArray[0];
                        String string3 = (String)objectArray[1];
                        if (string != null && string3 != null && object != null && object.toString().equals(string)) {
                            object = string3;
                        }
                    } else {
                        int n7 = (Integer)objectArray[0];
                        String string = (String)objectArray[1];
                        if (n == n7) {
                            object = string;
                        }
                    }
                }
                ++n3;
            }
            object2 = object;
        }
        return object2;
    }

    private String clone(Object object, String string) {
        try {
            if (object instanceof Double) {
                DecimalFormat decimalFormat = new DecimalFormat();
                String string2 = decimalFormat.format(object);
                return string + string2;
            }
            if (object instanceof Date) {
                return string + ((Date)object).toLocaleString();
            }
            return string + object.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    private String doubleValue(Object object, String string) {
        try {
            if (object instanceof Double) {
                DecimalFormat decimalFormat = new DecimalFormat();
                String string2 = decimalFormat.format(object);
                return string2 + string;
            }
            if (object instanceof Date) {
                return string + ((Date)object).toLocaleString();
            }
            return object.toString() + string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private Object equals(Object object, List list) {
        if (object == null) {
            return null;
        }
        Object object2 = object;
        int n = list.size();
        if (n > 0) {
            int n2 = (Integer)list.get(0);
            String string = object2.toString();
            n2 = Math.min(n2, string.length());
            string = string.substring(0, n2);
            object2 = string;
        }
        return object2;
    }

    public String filter(Object object) {
        return this.filter(object, 0);
    }

    public String filter(Object object, int n) {
        Serializable serializable;
        if (object == null) {
            return null;
        }
        if (this.clone == null) {
            this.init();
        }
        List list = (List)this.clone.get(0);
        List list2 = (List)this.clone.get(1);
        List list3 = (List)this.clone.get(2);
        List list4 = (List)this.clone.get(3);
        List list5 = (List)this.clone.get(4);
        if (object instanceof Number) {
            serializable = this.scale((Number)object, list);
            object = this.QOIV((Number)serializable, list2);
        }
        if (object instanceof Date) {
            object = this.add((Date)object, list3);
        }
        if (object instanceof Double) {
            serializable = new DecimalFormat();
            try {
                object = Long.valueOf(((Format)serializable).format((Double)object));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        object = this.append(object, n, list4);
        object = this.equals(object, list5);
        return object.toString();
    }

    public void init() {
        this.clone = new ArrayList();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<DecimalFormat> arrayList2 = new ArrayList<DecimalFormat>(1);
        ArrayList<SimpleDateFormat> arrayList3 = new ArrayList<SimpleDateFormat>(1);
        ArrayList<Object[]> arrayList4 = new ArrayList<Object[]>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>(1);
        this.clone.add(arrayList);
        this.clone.add(arrayList2);
        this.clone.add(arrayList3);
        this.clone.add(arrayList4);
        this.clone.add(arrayList5);
        int n = this.append.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])this.append.get(n2);
            int n3 = (Integer)objectArray[0];
            String string = (String)objectArray[1];
            switch (n3) {
                case 0: {
                    arrayList.add(this.filter(string));
                    break;
                }
                case 1: {
                    arrayList2.add(this.get(string));
                    break;
                }
                case 2: {
                    arrayList3.add(this.getDefault(string));
                    break;
                }
                case 3: {
                    arrayList5.add(this.format(string));
                    break;
                }
                case 4: {
                    arrayList4.add(this.indexOf(string));
                }
            }
            ++n2;
        }
        this.doubleValue = arrayList.size() > 0 && (Integer)arrayList.get(0) == 0;
    }

    private Integer filter(String string) {
        int n = abs[0].length;
        int n2 = 0;
        while (n2 < n) {
            if (abs[0][n2].equals(string)) {
                return new Integer(n2);
            }
            ++n2;
        }
        return new Integer(-1);
    }

    private Integer format(String string) {
        if (string == null || string.length() == 0) {
            return new Integer(Integer.MAX_VALUE);
        }
        return new Integer(string.length());
    }

    private DecimalFormat get(String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string, new DecimalFormatSymbols(Locale.getDefault()));
        return decimalFormat;
    }

    private SimpleDateFormat getDefault(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.getDefault());
        return simpleDateFormat;
    }

    private Object[] indexOf(String string) {
        Object[] objectArray;
        int n = string.indexOf(125);
        if (n != -1 && !string.startsWith("Text")) {
            int n2 = string.indexOf("}:{");
            if (n2 != -1) {
                objectArray = new Object[3];
                String string2 = string.substring(1, n);
                try {
                    objectArray[0] = Integer.valueOf(string2);
                }
                catch (Exception exception) {
                    return null;
                }
                n = n2 + 3;
                int n3 = string.indexOf("}->");
                try {
                    string2 = string.substring(n, n3);
                    objectArray[1] = Integer.valueOf(string2);
                }
                catch (Exception exception) {
                    return null;
                }
                n = string.indexOf("}->") + 3;
                n3 = string.length();
                string2 = string.substring(n, n3);
                objectArray[2] = string2;
            } else {
                objectArray = new Object[5];
                String string3 = string.substring(1, n);
                try {
                    objectArray[0] = Integer.valueOf(string3);
                }
                catch (Exception exception) {
                    return null;
                }
                n = string.indexOf("}->") + 3;
                string3 = string.substring(n);
                objectArray[1] = string3;
            }
        } else if (!string.startsWith("Text")) {
            objectArray = new Object[2];
            if (string.substring(0, 8).equals("Prefix: ")) {
                objectArray[0] = "Pre";
            } else if (string.substring(0, 8).equals("Suffix: ")) {
                objectArray[0] = "Suf";
            }
            objectArray[1] = string.substring(8);
        } else {
            objectArray = new Object[4];
            int n4 = string.indexOf("~");
            String string4 = string.substring(6, n4);
            objectArray[0] = string4;
            String string5 = string.substring(n4 + 1);
            objectArray[1] = string5;
        }
        return objectArray;
    }

    public Object clone() {
        ChartDataFilter chartDataFilter = new ChartDataFilter((Vector)this.append.clone());
        return chartDataFilter;
    }

    public String[] getBuiltinFilters() {
        return QOIV;
    }

    public String[] getBuiltinPatterns(int n) {
        return abs[n];
    }
}

