/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.util;

import com.jinfonet.dataservice.util.IntList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class OneDimensionIntArrayList
implements Cloneable,
Serializable,
IntList {
    private static final long serialVersionUID = 1L;
    private transient int[] QOIV;
    private int modCount = 0;
    private int size;

    public OneDimensionIntArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.QOIV = new int[n];
    }

    public OneDimensionIntArrayList() {
        this(30);
    }

    public void trimToSize() {
        ++this.modCount;
        int n = this.QOIV.length;
        if (this.size < n) {
            int[] nArray = this.QOIV;
            this.QOIV = new int[this.size];
            System.arraycopy(nArray, 0, this.QOIV, 0, this.size);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.QOIV.length;
        if (n > n2) {
            int[] nArray = this.QOIV;
            int n3 = n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.QOIV = new int[n3];
            System.arraycopy(nArray, 0, this.QOIV, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    public int indexOf(int n) {
        int n2 = 0;
        while (n2 < this.size) {
            if (this.QOIV[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        if (n >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE) {
            int n2 = this.size - 1;
            while (n2 >= 0) {
                if (this.QOIV[n2] == n) {
                    return n2;
                }
                --n2;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            OneDimensionIntArrayList oneDimensionIntArrayList = (OneDimensionIntArrayList)super.clone();
            oneDimensionIntArrayList.QOIV = new int[this.size];
            System.arraycopy(this.QOIV, 0, oneDimensionIntArrayList.QOIV, 0, this.size);
            oneDimensionIntArrayList.modCount = 0;
            return oneDimensionIntArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.QOIV, 0, nArray, 0, this.size);
        return nArray;
    }

    public int[] toArray(int[] nArray) {
        if (nArray.length < this.size) {
            nArray = (int[])Array.newInstance(nArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.QOIV, 0, nArray, 0, this.size);
        if (nArray.length > this.size) {
            nArray[this.size] = 0;
        }
        return nArray;
    }

    public int get(int n) {
        this.append(n);
        return this.QOIV[n];
    }

    public int set(int n, int n2) {
        this.append(n);
        int n3 = this.QOIV[n];
        this.QOIV[n] = n2;
        return n3;
    }

    public boolean add(int n) {
        this.ensureCapacity(this.size + 1);
        this.QOIV[this.size++] = n;
        return true;
    }

    public boolean addAll(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray2.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(nArray2, 0, this.QOIV, this.size, n);
        this.size += n;
        return n != 0;
    }

    public boolean addAll(IntList intList) {
        return this.QOIV(intList.getIntArray(), intList.size());
    }

    private boolean QOIV(int[] nArray, int n) {
        int[] nArray2 = nArray;
        int n2 = n;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(nArray2, 0, this.QOIV, this.size, n2);
        this.size += n2;
        return n2 != 0;
    }

    public void add(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.QOIV, n, this.QOIV, n + 1, this.size - n);
        this.QOIV[n] = n2;
        ++this.size;
    }

    public void clear() {
        ++this.modCount;
        int n = 0;
        while (n < this.size) {
            this.QOIV[n] = 0;
            ++n;
        }
        this.size = 0;
    }

    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.size - n2;
        System.arraycopy(this.QOIV, n2, this.QOIV, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.QOIV[--this.size] = 0;
        }
    }

    private void append(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Object)) {
            return false;
        }
        IntList intList = (IntList)object;
        if (intList.size() != this.size()) {
            return false;
        }
        try {
            for (int i = 0; i < intList.size(); ++i) {
                if (this.get(i) == intList.get(i)) {
                    continue;
                }
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public int remove(int n) {
        this.append(n);
        ++this.modCount;
        int n2 = this.QOIV[n];
        int n3 = this.size - n - 1;
        if (n3 > 0) {
            System.arraycopy(this.QOIV, n + 1, this.QOIV, n, n3);
        }
        this.QOIV[--this.size] = 0;
        return n2;
    }

    public int removeElement(int n) {
        int n2 = this.indexOf(n);
        if (n2 >= 0) {
            return this.remove(n2);
        }
        return n - 1;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.QOIV.length);
        int n = 0;
        while (n < this.size) {
            objectOutputStream.writeInt(this.QOIV[n]);
            ++n;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.QOIV = new int[n];
        int n2 = 0;
        while (n2 < this.size) {
            this.QOIV[n2] = objectInputStream.readInt();
            ++n2;
        }
    }

    public IntList merge(IntList intList) {
        int n = 0;
        int n2 = intList.size();
        while (n < n2) {
            if (!this.contains(intList.get(n))) {
                this.add(intList.get(n));
            }
            ++n;
        }
        return this;
    }

    public IntList sort() {
        OneDimensionIntArrayList oneDimensionIntArrayList = (OneDimensionIntArrayList)this.clone();
        Arrays.sort(oneDimensionIntArrayList.getIntArray());
        return oneDimensionIntArrayList;
    }

    public IntList interSection(IntList intList) {
        int n;
        OneDimensionIntArrayList oneDimensionIntArrayList = new OneDimensionIntArrayList();
        IntList intList2 = this.size <= intList.size() ? this : intList;
        IntList intList3 = this.size > intList.size() ? this : intList;
        intList2 = intList2.sort();
        intList3 = intList3.sort();
        int n2 = 0;
        int n3 = 0;
        n2 = intList2.get(0);
        n3 = intList3.get(0);
        int n4 = 0;
        int n5 = 0;
        int n6 = intList2.size();
        do {
            n = intList3.size();
            n2 = intList2.get(n4);
            if (n2 == (n3 = intList3.get(n5))) {
                oneDimensionIntArrayList.add(n2);
                ++n4;
                ++n5;
                continue;
            }
            if (n2 > n3) {
                ++n5;
                continue;
            }
            ++n4;
        } while (n4 < n6 && n5 < n);
        return oneDimensionIntArrayList;
    }

    public int[] getIntArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.QOIV, 0, nArray, 0, this.size);
        return nArray;
    }

    public void close() {
    }
}

