/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;

public class DbByteColumnBuffer
extends DbColumnBuffer {
    byte[] QOIV;

    public byte[] getBuffer() {
        return this.QOIV;
    }

    public DbByteColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.QOIV = new byte[n];
    }

    public void updateCell(int n, DbValue dbValue) {
        this.QOIV[n] = (byte)((DbTinyInt)dbValue).get();
    }

    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbTinyInt)dbValue).set(this.QOIV[n]);
    }

    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            dataOutput.writeByte(this.QOIV[n]);
            ++n;
        }
    }

    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            this.QOIV[n] = dataInput.readByte();
            ++n;
        }
    }

    public void clearMem() {
        super.clearMem();
        this.QOIV = null;
    }
}

