/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import com.jinfonet.util.loader.DynamicClassManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import jet.ReportEnv;
import jet.exception.FormulaSyntaxErrorException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.FormulaCompilerListener;
import jet.formula.FormulaContainer;
import jet.formula.FormulatoJava;
import jet.formula.JetRptFormula;
import jet.formula.StreamGobbler;
import jet.formula.VarsTable;
import jet.log.JRLogger;
import jet.universe.exception.LoadJavaFormulaException;
import jet.util.FullClassPath;

public class FormulaCompiler {
    private static JRLogger C;
    protected FormulaCompilerListener compilerListener;
    protected String tmpDir = null;
    static Class class$jet$formula$FormulaCompiler;
    static final boolean $assertionsDisabled;

    public FormulaCompiler(FormulaCompilerListener formulaCompilerListener) {
        this.compilerListener = formulaCompilerListener;
        this.tmpDir = ReportEnv.temporaryPath;
        this.tmpDir = this.tmpDir == null ? "" : this.tmpDir;
    }

    protected String translate(Vector vector, String string, VarsTable varsTable) {
        File file;
        PrintStream printStream;
        if (!$assertionsDisabled && this.tmpDir == null) {
            throw new AssertionError((Object)"tmpDir should not be null");
        }
        String string2 = this.tmpDir + string + ".java";
        Vector<FormulaSyntaxErrorException> vector2 = new Vector<FormulaSyntaxErrorException>();
        try {
            printStream = new PrintStream(new FileOutputStream(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            C.error("Can not open printStream: " + string2, fileNotFoundException);
            return null;
        }
        FormulatoJava formulatoJava = new FormulatoJava(string, printStream);
        formulatoJava.FormulaClass();
        boolean bl = true;
        JetRptFormula jetRptFormula = null;
        int n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 < vector.size()) {
                jetRptFormula = (JetRptFormula)vector.elementAt(n2);
                try {
                    jetRptFormula.parseFormula(formulatoJava);
                }
                catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
                    if (n == 0) {
                        bl = false;
                    }
                    vector2.addElement(formulaSyntaxErrorException);
                }
                ++n2;
            }
            if (bl) break;
            ++n;
        }
        formulatoJava.declareVar(varsTable);
        formulatoJava.declareField();
        formulatoJava.declareAggDesc();
        formulatoJava.declareTempVar(varsTable);
        formulatoJava.schedule(vector);
        formulatoJava.CodeEnd();
        printStream.close();
        if (this.compilerListener != null) {
            this.compilerListener.translateComplete(vector2);
        }
        if (!(file = new File(string2)).exists()) {
            return null;
        }
        return string2;
    }

    protected Vector parseRefUDFName(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            JetRptFormula jetRptFormula = (JetRptFormula)vector.elementAt(n);
            if (jetRptFormula.isparsedOK()) {
                Vector vector3 = jetRptFormula.formulainfo.refUDFClass;
                int n2 = 0;
                while (n2 < vector3.size()) {
                    String string = (String)vector3.elementAt(n2);
                    if (!vector2.contains(string) && string.length() > 0) {
                        vector2.add(string);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return vector2;
    }

    protected String reflectClasspath(ClassLoader classLoader, Class clazz) {
        String string = clazz.getName().replace('.', '/') + ".class";
        URL uRL = classLoader.getResource(string);
        String string2 = URLDecoder.decode(uRL.getPath());
        String string3 = uRL.getProtocol();
        if (string3.equals("jar") || string3.equals("wsjar") || string3.equals("zip")) {
            if (string2.startsWith("file:")) {
                string2 = string2.charAt(7) == ':' ? string2.substring(6) : string2.substring(5);
            }
            return string2.substring(0, string2.indexOf(33)).replace('/', File.separatorChar);
        }
        if (string2.length() >= 3 && string2.charAt(0) == '/' && string2.charAt(2) == ':') {
            string2 = string2.substring(1);
        }
        return string2.substring(0, string2.length() - string.length()).replace('/', File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean $assertionsDisabled(File var1_1, String var2_2) {
        if (var1_1.exists() == false) return false;
        if (var1_1.isFile() == false) return false;
        var3_3 = null;
        try {
            var3_3 = new ZipFile(var1_1);
            if (var3_3.getEntry(var2_2) == null) ** GOTO lbl62
            var4_4 = true;
            var9_6 = null;
            ** GOTO lbl55
        }
        catch (ZipException var4_5) {
            var5_18 = false;
            var9_8 = null;
            try {
                var3_3.close();
                return var5_18;
            }
            catch (Throwable var10_14) {
                if (FormulaCompiler.C.isDebugEnabled() == false) return var5_18;
                FormulaCompiler.C.debug(var10_14);
            }
            return var5_18;
        }
        catch (IOException var5_19) {
            var6_20 = false;
            var9_9 = null;
            ** try [egrp 2[TRYBLOCK] [9 : 91->98)] { 
lbl28:
            // 1 sources

            var3_3.close();
            return var6_20;
lbl30:
            // 1 sources

            catch (Throwable var10_15) {
                if (FormulaCompiler.C.isDebugEnabled() == false) return var6_20;
                FormulaCompiler.C.debug(var10_15);
            }
            return var6_20;
        }
        catch (Throwable var6_21) {
            var7_22 = false;
            var9_10 = null;
            ** try [egrp 2[TRYBLOCK] [9 : 91->98)] { 
lbl39:
            // 1 sources

            var3_3.close();
            return var7_22;
lbl41:
            // 1 sources

            catch (Throwable var10_16) {
                if (FormulaCompiler.C.isDebugEnabled() == false) return var7_22;
                FormulaCompiler.C.debug(var10_16);
            }
            return var7_22;
        }
        {
            catch (Throwable var8_23) {
                var9_11 = null;
                ** try [egrp 2[TRYBLOCK] [9 : 91->98)] { 
lbl49:
                // 1 sources

                var3_3.close();
                throw var8_23;
lbl51:
                // 1 sources

                catch (Throwable var10_17) {
                    if (FormulaCompiler.C.isDebugEnabled() == false) throw var8_23;
                    FormulaCompiler.C.debug(var10_17);
                }
                throw var8_23;
            }
lbl55:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [9 : 91->98)] { 
lbl56:
            // 1 sources

            var3_3.close();
            return var4_4;
lbl58:
            // 1 sources

            catch (Throwable var10_12) {
                if (FormulaCompiler.C.isDebugEnabled() == false) return var4_4;
                FormulaCompiler.C.debug(var10_12);
            }
            return var4_4;
lbl62:
            // 1 sources

            var9_7 = null;
            try {}
            catch (Throwable var10_13) {}
            if (FormulaCompiler.C.isDebugEnabled() == false) return false;
            FormulaCompiler.C.debug(var10_13);
            return false;
            var3_3.close();
            return false;
        }
    }

    protected String filterClassPath() {
        String string = "";
        String string2 = System.getProperty("java.home");
        String string3 = FullClassPath.getFullClassPath();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.indexOf(string2.substring(0, string2.length() - 4)) >= 0) continue;
            if (string4.endsWith(".zip") || string4.endsWith(".jar")) {
                File file = new File(string4);
                if (!file.exists() || !file.isFile() || !this.$assertionsDisabled(file, "jet")) continue;
                string = string + string4 + File.pathSeparator;
                continue;
            }
            string = string + string4 + File.pathSeparator;
        }
        return string;
    }

    protected String constructClassPath(Vector vector) {
        String[] stringArray;
        Object object;
        String string = "";
        String[] stringArray2 = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            object = (String)vector.elementAt(n);
            stringArray2[n] = ((String)object).indexOf(46) < 0 ? "jet.formula.javaformula." + (String)object : object;
            ++n;
        }
        object = DynamicClassManager.getInstance();
        String[] stringArray3 = ((DynamicClassManager)object).getResourceName(stringArray2);
        int n2 = 0;
        while (n2 < stringArray3.length) {
            string = string.endsWith(File.pathSeparator) ? string + stringArray3[n2] : string + File.pathSeparator + stringArray3[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            block6: {
                try {
                    stringArray = Class.forName(stringArray2[n3]);
                    String string2 = this.reflectClasspath(stringArray.getClassLoader(), (Class)stringArray);
                    string = string.endsWith(File.pathSeparator) ? string + string2 : string + File.pathSeparator + string2;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!C.isErrorEnabled()) break block6;
                    C.error(classNotFoundException);
                }
            }
            ++n3;
        }
        stringArray = new String[]{"jet.formula.FormulaClassLoader", "jet.util.FullClassPath", "jet.connect.DbQuery"};
        stringArray3 = ((DynamicClassManager)object).getResourceName(stringArray);
        int n4 = 0;
        while (n4 < stringArray3.length) {
            string = string.endsWith(File.pathSeparator) ? string + stringArray3[n4] : string + File.pathSeparator + stringArray3[n4];
            ++n4;
        }
        string = string.endsWith(File.pathSeparator) ? string + this.filterClassPath() : string + File.pathSeparator + this.filterClassPath();
        return string;
    }

    protected String scanDir4Javac(String string) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        String[] stringArray = new File(string).list();
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            String string3 = stringArray[n];
            File file = new File(string + string3);
            if (file.isDirectory()) {
                string2 = this.scanDir4Javac(file.getAbsolutePath());
                if (string2 != null) {
                    return string2;
                }
            } else if (string3.indexOf(46) > 0 && (string2 = string3.substring(0, string3.indexOf(46))).equalsIgnoreCase("javac")) {
                return string + string3;
            }
            ++n;
        }
        return null;
    }

    protected String scan4Javac() {
        String string = System.getProperty("java.home");
        String string2 = "";
        if (C.isDebugEnabled()) {
            C.info("scan4Javac #1: java.home = " + string);
        }
        if (!string.endsWith("java")) {
            try {
                if (string.endsWith("jre")) {
                    string = string.substring(0, string.length() - 3);
                    string2 = string + "bin" + File.separator;
                }
                if (string.indexOf("java") == -1) {
                    if (C.isDebugEnabled()) {
                        C.info("scan4Javac #2: Java Home get error.");
                    }
                    throw new Exception("Java Home get error");
                }
                int n = string.indexOf("java");
                string = string.substring(0, n + 4);
                string2 = string + File.separator + "bin" + File.separator;
            }
            catch (Exception exception) {
                C.error(exception);
                return null;
            }
        } else {
            string2 = string + File.separator + "bin" + File.separator;
        }
        string2 = string2 + "javac";
        if (C.isDebugEnabled()) {
            C.info("scan4Javac #3: javacPath = " + string2);
        }
        return string2;
    }

    protected String compileJava(String string, Vector vector) {
        String string2;
        String string3 = System.getProperty("javac_path");
        if (string3 == null) {
            string3 = this.scan4Javac();
        }
        if (string3 == null) {
            C.error("Unable to find command line compiler 'javac'.");
            return null;
        }
        Vector vector2 = this.parseRefUDFName(vector);
        String string4 = this.constructClassPath(vector2);
        String[] stringArray = new String[]{string3, "-source", "1.4", "-target", "1.4", "-nowarn", "-classpath", string4, string};
        if (C.isDebugEnabled()) {
            string2 = "The compile cmd:";
            int n = 0;
            while (n < stringArray.length) {
                string2 = string2 + " " + stringArray[n];
                ++n;
            }
            C.debug(string2);
        }
        string2 = null;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), true);
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), false);
            streamGobbler.start();
            streamGobbler2.start();
            int n = process.waitFor();
            C.info("Compiling process returns: " + n);
            string2 = string.substring(0, string.indexOf(".java")) + ".class";
            File file = new File(string2);
            if (!file.exists()) {
                string2 = null;
            }
        }
        catch (Exception exception) {
            C.error("Get exception when compiling java: ", exception);
            string2 = null;
        }
        return string2;
    }

    public String compileFormulas(Vector vector, String string, FormulaContainer formulaContainer) {
        return this.compileFormulas(vector, string, formulaContainer.getGVarTable());
    }

    public String compileFormulas(Vector vector, String string, VarsTable varsTable) {
        String string2 = null;
        string2 = this.translate(vector, string, varsTable);
        if (string2 == null) {
            C.error("==##==> the java file is null");
            return null;
        }
        String string3 = this.compileJava(string2, vector);
        return string3;
    }

    public void checkFormulas(Vector vector) throws ParseFormulaFailedException {
        String string = "tempClass";
        FormulatoJava formulatoJava = new FormulatoJava(string, null);
        Vector<FormulaSyntaxErrorException> vector2 = new Vector<FormulaSyntaxErrorException>();
        boolean bl = true;
        JetRptFormula jetRptFormula = null;
        int n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 < vector.size()) {
                jetRptFormula = (JetRptFormula)vector.elementAt(n2);
                try {
                    jetRptFormula.parseFormula(formulatoJava);
                }
                catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
                    if (n == 0) {
                        bl = false;
                    }
                    vector2.addElement(formulaSyntaxErrorException);
                }
                ++n2;
            }
            if (bl) break;
            ++n;
        }
        if (vector2.size() > 0) {
            throw new ParseFormulaFailedException(vector2);
        }
    }

    public Object loadJavaFormula(String string, byte[] byArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, LoadJavaFormulaException {
        DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
        Class clazz = dynamicClassManager.bytesToClass(string, byArray);
        Object var5_5 = null;
        try {
            var5_5 = clazz.newInstance();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            C.error(noClassDefFoundError);
            LoadJavaFormulaException loadJavaFormulaException = new LoadJavaFormulaException(1);
            loadJavaFormulaException.initCause(noClassDefFoundError);
            throw loadJavaFormulaException;
        }
        return var5_5;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$formula$FormulaCompiler == null ? (class$jet$formula$FormulaCompiler = FormulaCompiler.class$("jet.formula.FormulaCompiler")) : class$jet$formula$FormulaCompiler).desiredAssertionStatus();
        C = JRLogger.getLogger((class$jet$formula$FormulaCompiler == null ? (class$jet$formula$FormulaCompiler = FormulaCompiler.class$("jet.formula.FormulaCompiler")) : class$jet$formula$FormulaCompiler).getName());
    }
}

