/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.group.pls.JGroupTreePLS;
import jet.dataengine.api.group.pls.PLSProcessor;
import jet.ie.AbstractRSDExporter;
import jet.ie.IndexInfos;
import jet.ie.RSDResourceTools;
import jet.ie.RSDTools;
import jet.ie.VersionException;
import jet.ie.io.FileBlockOutputStream;
import jet.ie.io.PJFDataOutput;
import jet.reportset.JetRptReportSet;
import jet.util.RAFile;

public class PRSDSaveControler
extends AbstractRSDExporter {
    public static final String FLAG = "DHTML Result With PLS";
    public static final String DATASETSTATE = "dataSetState";
    public static final String DATAPERMTAB = "dataPermTab";
    public static final String RECORDINDEXS = "recordIndex";
    public static final String RESOURCE = "resource";
    public static final String NLSRESOURCE = "NLSResource";
    private Hashtable GetResFromRptPath;
    private Hashtable GetResFromUniPath;
    private Hashtable I;
    public Hashtable _datasetMapping;
    protected IndexInfos _indexInfos;
    protected String _uniPath;
    protected String _realPath;

    public PRSDSaveControler(String string) {
        File file = new File(string);
        this._rsdTools = new RSDTools(file.getParent());
        this._fileName = string;
        this.GetResFromRptPath = new Hashtable();
        this.GetResFromUniPath = new Hashtable();
        this.I = new Hashtable();
        this._datasetMapping = new Hashtable();
    }

    public void write() throws VersionException, JRStopEngineException {
        long l = System.currentTimeMillis();
        if (this._reportNames == null || this._universe == null || this._rptInfos == null || this._dataSetInfos == null || this._rptReportSet == null || this._resultSets == null) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407201);
            }
            throw new VersionException(407201);
        }
        this._realPath = this._fileName.substring(0, this._fileName.lastIndexOf(File.separator));
        this._uniPath = this._realPath + File.separator + new Random().nextInt();
        new File(this._uniPath).mkdir();
        File file = new File(this._fileName);
        if (file.exists()) {
            file.delete();
        }
        if (this._rsdTools == null) {
            this._rsdTools = new RSDTools(file.getParent());
        }
        this._rsdTools.setCompression(this._isZip, this.bufferSize);
        try {
            this.rafFile = new RAFile(file, "rw");
            this.raf = new PJFDataOutput(new FileBlockOutputStream(this.rafFile));
            long l2 = this.raf.getPosition();
            this.raf.writeUTF(FLAG);
            this.raf.writeInt(131600);
            this.raf.writeLong(System.currentTimeMillis());
            this.raf.writeUTF("Copyright (c) 1998, Jinfonet Software, Inc.  All rights reserved.");
            this.raf.writeBoolean(this._isZip);
            this.raf.writeUTF(this._id);
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            long l3 = this.raf.getPosition();
            this.raf.writeLong(0L);
            this._rsdTools.saveMapInfoForString(this.raf, this._datasetMapping);
            hashtable.put("ReportNames", new Long(this.saveReportNames()));
            hashtable.put("Universe", new Long(this.saveUniverse()));
            hashtable.put("ReportInfos", new Long(this.saveRptInfos()));
            hashtable.put("DatasetInfos", new Long(this.saveDataSetInfos()));
            hashtable.put("BindInfo", new Long(this.saveBindInfo()));
            hashtable.put("ReportSets", new Long(this.saveReportSets()));
            hashtable.put("ResultSets", new Long(this.saveResultSets()));
            hashtable.put("Parameters", new Long(this.saveParameter()));
            hashtable.put("IndexInfo", new Long(this.saveIndexInfo()));
            hashtable.put(NLSRESOURCE, new Long(this.QOIV()));
            hashtable.put("Precision", new Long(this.savePrecision()));
            hashtable.put("Permission", new Long(this.savePermisions()));
            hashtable.put("CLSInfo", new Long(this.saveCLSInfos()));
            hashtable.put(DATASETSTATE, new Long(this.saveDataSetStatus()));
            hashtable.put(DATAPERMTAB, new Long(this.GetResFromRptPath()));
            hashtable.put(RECORDINDEXS, new Long(this.GetResFromUniPath()));
            hashtable.put(RESOURCE, new Long(this.I()));
            long l4 = this.writeAddressTableH(hashtable);
            String string = String.valueOf(this.raf.getPosition() - l2);
            JRLog.trace(5, 2407227, string);
            this.raf.seek(l3);
            this.raf.writeLong(l4);
            long l5 = System.currentTimeMillis();
            String string2 = String.valueOf(l5 - l);
            JRLog.trace(5, 2407228, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB22, (Throwable)exception);
            }
            throw new VersionException(407202, (Throwable)exception);
        }
    }

    public long saveUniverse() throws VersionException {
        try {
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            String string = this._uniPath + File.separator + new Random().nextInt() + ".cat";
            File file = new File(string);
            this._universe.SaveTo(file);
            this.raf.writeUTF(this._uniPath.substring(this._uniPath.lastIndexOf(File.separator)) + File.separator + file.getName());
            String string2 = String.valueOf(this.raf.getPosition() - l2);
            JRLog.trace(5, 2407229, string2);
            long l3 = System.currentTimeMillis();
            String string3 = String.valueOf(l3 - l);
            JRLog.trace(5, 2407230, string3);
            return l2;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB24, (Throwable)exception);
            }
            throw new VersionException(407204, (Throwable)exception);
        }
    }

    public long saveResultSets() throws VersionException {
        try {
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            this.raf.writeLong(0L);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Enumeration enumeration = this._resultSets.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                File file = this._rsdTools.getTempFile("resultSet" + string);
                RAFile rAFile = new RAFile(file, "rw");
                PJFDataOutput pJFDataOutput = new PJFDataOutput(new FileBlockOutputStream(rAFile));
                ResultSet resultSet = (ResultSet)this._resultSets.get(string);
                this._rsdTools.writeResultSet(pJFDataOutput, resultSet);
                hashtable.put(string, file.getName());
            }
            long l3 = this.raf.getPosition();
            this._rsdTools.saveMapInfoForString(this.raf, hashtable);
            long l4 = this.raf.getPosition();
            this.raf.seek(l2);
            this.raf.writeLong(l3);
            this.raf.seek(l4);
            String string = String.valueOf(this.raf.getPosition() - l2);
            JRLog.trace(5, 2407231, string);
            long l5 = System.currentTimeMillis();
            String string2 = String.valueOf(l5 - l);
            JRLog.trace(5, 2407232, string2);
            return l2;
        }
        catch (SQLException sQLException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 0x24BB2B, (Throwable)sQLException);
            }
            throw new VersionException(407211, (Throwable)sQLException);
        }
        catch (DSException dSException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407210, (Throwable)dSException);
            }
            throw new VersionException(407210, (Throwable)dSException);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407209, (Throwable)iOException);
            }
            throw new VersionException(407209, (Throwable)iOException);
        }
    }

    protected long saveDataSetStatus() throws VersionException {
        try {
            long l = this.raf.getPosition();
            this._rsdTools.saveMapInfoForInteger(this.raf, this.GetResFromRptPath);
            return l;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407208, (Throwable)iOException);
            }
            throw new VersionException(407208, (Throwable)iOException);
        }
    }

    private long GetResFromRptPath() throws VersionException {
        try {
            long l = System.currentTimeMillis();
            long l2 = this.raf.getPosition();
            this.raf.writeLong(0L);
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            Enumeration enumeration = this.GetResFromUniPath.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JGroupTreePLS jGroupTreePLS = (JGroupTreePLS)this.GetResFromUniPath.get(string);
                hashtable.put(string, new Long(this.raf.getPosition()));
                PLSProcessor.applyAndSave(this.raf, jGroupTreePLS);
            }
            long l3 = this.writeAddressTableH(hashtable);
            long l4 = this.raf.getPosition();
            this.raf.seek(l2);
            this.raf.writeLong(l3);
            this.raf.seek(l4);
            String string = String.valueOf(this.raf.getPosition() - l2);
            JRLog.trace(5, 2407233, string);
            long l5 = System.currentTimeMillis();
            String string2 = String.valueOf(l5 - l);
            JRLog.trace(5, 0x24BB42, string2);
            return l2;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407208, (Throwable)exception);
            }
            throw new VersionException(407208, (Throwable)exception);
        }
    }

    private long GetResFromUniPath() throws VersionException {
        try {
            long l = this.raf.getPosition();
            long l2 = System.currentTimeMillis();
            this.raf.writeLong(0L);
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            Enumeration enumeration = this.I.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JGroupTreePLS jGroupTreePLS = (JGroupTreePLS)this.I.get(string);
                hashtable.put(string, new Long(this.raf.getPosition()));
                PLSProcessor.applyAndSave(this.raf, jGroupTreePLS, this._id);
            }
            long l3 = this.writeAddressTableH(hashtable);
            long l4 = this.raf.getPosition();
            this.raf.seek(l);
            this.raf.writeLong(l3);
            this.raf.seek(l4);
            String string = String.valueOf(this.raf.getPosition() - l);
            JRLog.trace(5, 2407235, string);
            long l5 = System.currentTimeMillis();
            String string2 = String.valueOf(l5 - l2);
            JRLog.trace(5, 0x24BB44, string2);
            return l;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407208, (Throwable)exception);
            }
            throw new VersionException(407208, (Throwable)exception);
        }
    }

    private long I() throws IOException {
        long l = this.raf.getPosition();
        Collection collection = this._rptReportSet.values();
        JetRptReportSet[] jetRptReportSetArray = new JetRptReportSet[collection.size()];
        collection.toArray(jetRptReportSetArray);
        String[] stringArray = RSDResourceTools.GetResFromUniPath(this._universe.getFilePath(), jetRptReportSetArray);
        if (stringArray != null) {
            this.raf.writeUTF(this._uniPath);
            int n = 0;
            while (n < stringArray.length) {
                String string = this._uniPath + File.separator + stringArray[n].substring(stringArray[n].lastIndexOf(File.separator) + 1);
                this._rsdTools.copyFile(stringArray[n], string);
                ++n;
            }
        }
        return l;
    }

    private long QOIV() throws VersionException {
        try {
            long l = this.raf.getPosition();
            this.raf.writeLong(0L);
            Enumeration enumeration = this._rptReportSet.elements();
            String string = "";
            String string2 = "";
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            while (enumeration.hasMoreElements()) {
                String string3;
                JetRptReportSet jetRptReportSet = (JetRptReportSet)enumeration.nextElement();
                String[] stringArray = RSDResourceTools.GetResFromRptPath(jetRptReportSet);
                if (stringArray == null || stringArray.length <= 0) continue;
                String string4 = stringArray[0].substring(0, stringArray[0].lastIndexOf(File.separator));
                if (!hashtable.containsValue(string4)) {
                    hashtable.put(jetRptReportSet.getInstName(), string4);
                    string2 = String.valueOf(new Random().nextInt());
                    string = this._realPath + File.separator + string2;
                    File file = new File(string);
                    file.mkdir();
                    int n = 0;
                    while (n < stringArray.length) {
                        string3 = string + File.separator + stringArray[n].substring(stringArray[n].lastIndexOf(File.separator) + 1);
                        this._rsdTools.copyFile(stringArray[n], string3);
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < stringArray.length) {
                        string3 = string + File.separator + stringArray[n].substring(stringArray[n].lastIndexOf(File.separator) + 1);
                        if (!new File(string3).exists()) {
                            this._rsdTools.copyFile(stringArray[n], string3);
                        }
                        ++n;
                    }
                }
                hashtable2.put(jetRptReportSet.getInstName(), string2);
            }
            long l2 = this.raf.getPosition();
            this._rsdTools.saveMapInfoForString(this.raf, hashtable2);
            long l3 = this.raf.getPosition();
            this.raf.seek(l);
            this.raf.writeLong(l2);
            this.raf.seek(l3);
            return l;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new VersionException(exception);
        }
    }

    public void setDataSetStatus(int n, String string, int n2) {
        String string2 = this._rsdTools.getKey(n, string);
        this.GetResFromRptPath.put(string2, new Integer(n2));
    }

    public void setDataPermTab(int n, String string, int n2, String string2, JGroupTreePLS jGroupTreePLS) {
        String string3 = this._rsdTools.getKey(n2, string2);
        String string4 = this._rsdTools.getKey(n, string);
        this._datasetMapping.put(string4, string3);
        this.GetResFromUniPath.put(string4, jGroupTreePLS);
    }

    public void setRecordIndexs(int n, String string, int n2, String string2, JGroupTreePLS jGroupTreePLS) {
        String string3 = this._rsdTools.getKey(n2, string2);
        String string4 = this._rsdTools.getKey(n, string);
        this._datasetMapping.put(string4, string3);
        this.I.put(string4, jGroupTreePLS);
    }

    public void setIndexInfo(IndexInfos indexInfos) {
        this._indexInfos = indexInfos;
    }

    public long saveIndexInfo() throws VersionException {
        try {
            long l = this.raf.getPosition();
            this._rsdTools.saveIdxInfoForVrctor(this.raf, this._indexInfos.getInfos());
            return l;
        }
        catch (Exception exception) {
            throw new VersionException(exception);
        }
    }

    public void clear() throws IOException {
        if (this._rptReportSet != null) {
            this._rptReportSet = null;
        }
        if (this._resultSets != null) {
            this._resultSets.clear();
            this._resultSets = null;
        }
        if (this._reportNames != null) {
            this._reportNames = null;
        }
        if (this._parameter != null) {
            this._parameter.clear();
            this._parameter = null;
        }
        if (this._rptInfos != null) {
            this._rptInfos = null;
        }
        if (this._rptReportSet != null) {
            this._rptReportSet = null;
        }
        if (this._bindInfo != null) {
            this._bindInfo = null;
        }
        if (this._rsdTools != null) {
            this._rsdTools = null;
        }
        if (this._dataSetInfos != null) {
            this._dataSetInfos = null;
        }
        if (this._permissions != null) {
            this._permissions = null;
        }
        if (this._precisions != null) {
            this._precisions = null;
        }
        if (this._CLSInfos != null) {
            this._CLSInfos = null;
        }
        this.rafFile.close();
        this.raf.close();
    }
}

