/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic;

import chart.ChartDefinition;
import com.jinfonet.util.JRLog;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.report.JetRptObject;
import jet.report.chart.JetRptChartPlatform;
import jet.reportLogic.objectInfo.CTHdFldInfo;
import jet.reportLogic.objectInfo.CTSpecialFldInfo;
import jet.reportLogic.objectInfo.CTSumFldInfo;
import jet.reportLogic.objectInfo.DisplayFieldInfo;
import jet.reportLogic.objectInfo.GroupInfo;
import jet.reportLogic.objectLogic.ResourceLogic;
import jet.reportLogic.objectLogic.resourceLogic.validation.DataSetChangeValidation;
import jet.reportset.DataSet;
import jet.reportset.JetRptDataSet;
import jet.universe.JetUDBField;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.InvalidEntityException;
import jet.util.IntKeyHashtable;

class ResourceLogicImpl
implements ResourceLogic {
    ResourceLogicImpl() {
    }

    public boolean isDataMatch(JetRptObject jetRptObject, JetRptDataSet jetRptDataSet) {
        DataSetChangeValidation dataSetChangeValidation = new DataSetChangeValidation();
        return dataSetChangeValidation.isDataMatch(jetRptObject, jetRptDataSet);
    }

    public boolean isDataMatch(DisplayFieldInfo displayFieldInfo, JetRptDataSet jetRptDataSet) {
        DataSetChangeValidation dataSetChangeValidation = new DataSetChangeValidation();
        return dataSetChangeValidation.isDataMatch(displayFieldInfo, jetRptDataSet);
    }

    public boolean isDataMatch(GroupInfo groupInfo, JetRptDataSet jetRptDataSet) {
        DataSetChangeValidation dataSetChangeValidation = new DataSetChangeValidation();
        return dataSetChangeValidation.isDataMatch(groupInfo.getGroupFieldInfo(), jetRptDataSet);
    }

    public boolean isDataMatch(CTHdFldInfo cTHdFldInfo, JetRptDataSet jetRptDataSet) {
        return this.QOIV(jetRptDataSet, cTHdFldInfo.get_fldname());
    }

    private boolean QOIV(JetRptDataSet jetRptDataSet, String string) {
        Vector<String> vector = new Vector<String>(0);
        vector.add(string);
        try {
            jetRptDataSet.getCurrentUniverse().checkIfMappingFldsValidToQuery(jetRptDataSet.getDataSourceName(), jetRptDataSet.getQueryName(), vector);
        }
        catch (InvalidEntityException invalidEntityException) {
            JRLog.trace(6, invalidEntityException);
            return false;
        }
        catch (CannotFindQuery cannotFindQuery) {
            JRLog.trace(6, cannotFindQuery);
            return false;
        }
        Object object = jetRptDataSet.getResourceByName(string);
        if (object != null && object instanceof JetUResourceEntity) {
            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)object;
            if (jetUResourceEntity instanceof JetUFormula) {
                return ((JetUFormula)jetUResourceEntity).canSummary();
            }
            return jetUResourceEntity instanceof JetUDBField;
        }
        return false;
    }

    public boolean isDataMatch(CTSumFldInfo cTSumFldInfo, JetRptDataSet jetRptDataSet) {
        return this.QOIV(jetRptDataSet, cTSumFldInfo.get_relativeField());
    }

    public boolean isDataMatch(CTSpecialFldInfo cTSpecialFldInfo, JetRptDataSet jetRptDataSet) {
        return this.QOIV(jetRptDataSet, cTSpecialFldInfo.get_relativeField());
    }

    public IntKeyHashtable checkDataMatch(JetRptChartPlatform jetRptChartPlatform, DataSet dataSet) {
        DataSetChangeValidation dataSetChangeValidation = new DataSetChangeValidation();
        Hashtable hashtable = dataSetChangeValidation.isDataMatch(jetRptChartPlatform, (JetRptDataSet)dataSet);
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            intKeyHashtable.put(n, hashtable.get(n));
        }
        return intKeyHashtable;
    }

    public IntKeyHashtable isDataMatch(JetRptChartPlatform jetRptChartPlatform, ChartDefinition chartDefinition, JetRptDataSet jetRptDataSet) {
        return this.isDataMatch(jetRptChartPlatform, chartDefinition, jetRptDataSet, jetRptChartPlatform.dataInherit.get());
    }

    public IntKeyHashtable isDataMatch(JetRptChartPlatform jetRptChartPlatform, ChartDefinition chartDefinition, JetRptDataSet jetRptDataSet, boolean bl) {
        DataSetChangeValidation dataSetChangeValidation = new DataSetChangeValidation();
        Hashtable hashtable = dataSetChangeValidation.isDataMatch(jetRptChartPlatform, chartDefinition, jetRptDataSet, bl);
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            intKeyHashtable.put(n, hashtable.get(n));
        }
        return intKeyHashtable;
    }
}

