/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUHDSField;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;
import jet.xml.model.ElementNode;

public class JetUHDSTable
extends JetUResourceContainer
implements JetUQueriable {
    public JetNumber maxRows = new JetNumber(this, "maxRows");
    public JetNumber maxDuration = new JetNumber(this, "maxDuration");
    public JetString fullName = new JetString(this, "FullName");
    public JetBoolean att = new JetBoolean(this, "Attributes", false);
    private static JRLogger C;
    private static final HashMap InitAfterCreate;
    static Class class$jet$universe$JetUHDSTable;
    static final boolean $assertionsDisabled;

    public JetUHDSTable() {
        this.$assertionsDisabled();
    }

    public JetUHDSTable(String string, String string2) {
        this(string, string2, "");
    }

    public JetUHDSTable(String string, String string2, String string3) {
        super(string, string2);
        this.fullName.set(string3);
        this.$assertionsDisabled();
    }

    public JetUHDSTable(ElementNode elementNode) {
        this(elementNode.getName(), "");
        this.fullName.set(ElementNode.getFullPath(elementNode));
        this.$assertionsDisabled();
    }

    private void $assertionsDisabled() {
        this.fullName.setEditFlag(0);
    }

    public int getTransactionIsolation() {
        return 0;
    }

    public int getReadOnly() {
        return 1;
    }

    public Vector getAutoGroupFields() {
        return null;
    }

    public void setMaxRows(int n) {
        this.maxRows.set(n);
    }

    public int getMaxRows() {
        return this.maxRows.get();
    }

    public void setMaxDuration(int n) {
        this.maxDuration.set(n);
    }

    public int getMaxDuration() {
        return this.maxDuration.get();
    }

    public void setFullName(String string) {
        this.fullName.set(string);
    }

    public String getFullName() {
        return this.fullName.get();
    }

    public String getRealName() {
        String string = this.getFullName();
        return string.substring(string.lastIndexOf(ElementNode.pathDelimer) + 1);
    }

    public JetUHDSTable getHDSRoot() {
        if (this instanceof JetUHierDataSource) {
            return this;
        }
        JetUHDSTable jetUHDSTable = (JetUHDSTable)this.getParent();
        while (jetUHDSTable != null) {
            if (jetUHDSTable instanceof JetUHierDataSource) {
                return jetUHDSTable;
            }
            jetUHDSTable = (JetUHDSTable)jetUHDSTable.getParent();
        }
        return jetUHDSTable;
    }

    public void addColumn(JetUHDSField jetUHDSField) {
        this.add(jetUHDSField);
        jetUHDSField.InitAfterCreate();
    }

    public void addTable(JetUHDSTable jetUHDSTable) {
        this.add(jetUHDSTable);
        jetUHDSTable.InitAfterCreate();
    }

    public Vector getColumns() {
        Vector<JetObject> vector = new Vector<JetObject>();
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            JetObject jetObject = (JetObject)enumeration.nextElement();
            if (!(jetObject instanceof JetUHDSField)) continue;
            vector.add(jetObject);
        }
        return vector;
    }

    public Vector getTables() {
        Vector<JetObject> vector = new Vector<JetObject>();
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            JetObject jetObject = (JetObject)enumeration.nextElement();
            if (!(jetObject instanceof JetUHDSTable)) continue;
            vector.add(jetObject);
        }
        return vector;
    }

    public Vector getNoAttribTables() {
        Vector<JetObject> vector = new Vector<JetObject>();
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            JetObject jetObject = (JetObject)enumeration.nextElement();
            if (!(jetObject instanceof JetUHDSTable) || ((JetUHDSTable)jetObject).isAttrib()) continue;
            vector.add(jetObject);
        }
        return vector;
    }

    public Vector getFields() {
        return this.getColumns();
    }

    public boolean isAttrib() {
        return this.att.get();
    }

    public JetUResourceEntity getFieldByResourceName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUHDSField && ((JetUHDSField)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return (JetUHDSField)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public JetUHDSTable getTableByResourceName(String string) {
        Vector vector = this.getTables();
        int n = 0;
        while (n < vector.size()) {
            JetUHDSTable jetUHDSTable = (JetUHDSTable)vector.elementAt(n);
            if (jetUHDSTable.getResourceName().equalsIgnoreCase(string)) {
                return jetUHDSTable;
            }
            ++n;
        }
        return null;
    }

    public String getSQLString() {
        return null;
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(jetUUniverse, string, "");
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, String string, String string2) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity jetUResourceEntity;
        JetUResourceEntity jetUResourceEntity2 = jetUUniverse.getResourceByName(string2, this.getResourceName(), string);
        if (jetUResourceEntity2 == null && (jetUResourceEntity = jetUUniverse.getAnyResourceByName(string)) != null && jetUResourceEntity instanceof JetUParameter) {
            jetUResourceEntity2 = jetUResourceEntity;
        }
        if (jetUResourceEntity2 == null) {
            throw new CannotFindEntity(string);
        }
        return this.isFieldValidToQuery(jetUUniverse, jetUResourceEntity2, string2);
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, JetUResourceEntity jetUResourceEntity) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(jetUUniverse, jetUResourceEntity, "");
    }

    public boolean isFieldValidToQuery(JetUUniverse jetUUniverse, JetUResourceEntity jetUResourceEntity, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bl = false;
        if (!$assertionsDisabled && jetUResourceEntity == null) {
            throw new AssertionError((Object)"entity can not be null");
        }
        if (jetUResourceEntity instanceof JetUParameter) {
            bl = true;
        } else if (jetUResourceEntity instanceof JetUFormula) {
            bl = this.isFormulaValidToQuery((JetUFormula)jetUResourceEntity, jetUUniverse, string);
        } else if (jetUResourceEntity instanceof JetUHDSField) {
            bl = ((JetUHDSField)jetUResourceEntity).getHDS() == this;
        }
        return bl;
    }

    public boolean isFormulaValidToQuery(JetUFormula jetUFormula, JetUUniverse jetUUniverse, String string) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector vector = jetUFormula.getRefDbFld();
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)vector.elementAt(n2);
                try {
                    if (!this.isFieldValidToQuery(jetUUniverse, string2, string)) {
                        return false;
                    }
                }
                catch (CannotFindEntity cannotFindEntity) {
                    throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string2);
                }
                ++n2;
            }
        }
        Vector vector2 = jetUFormula.getRefFormuFld();
        int n = vector2.size();
        int n3 = 0;
        while (n3 < n) {
            String string3 = (String)vector2.elementAt(n3);
            try {
                if (!this.isFieldValidToQuery(jetUUniverse, string3, string)) {
                    return false;
                }
            }
            catch (CannotFindEntity cannotFindEntity) {
                throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string3);
            }
            ++n3;
        }
        Vector vector3 = jetUFormula.getGroupByVector();
        n = vector3.size();
        int n4 = 0;
        while (n4 < n) {
            String string4 = (String)vector3.elementAt(n4);
            if (!(jetUFormula instanceof JetUSummary) || !JetUDatabase.I(string4)) {
                try {
                    if (!string4.equalsIgnoreCase("Report") && !this.isFieldValidToQuery(jetUUniverse, string4, string)) {
                        return false;
                    }
                }
                catch (CannotFindEntity cannotFindEntity) {
                    throw new CannotFindFrmlRefFld(jetUFormula.getResourceName(), string4);
                }
            }
            ++n4;
        }
        return true;
    }

    public JetUHDSField getFieldByPathString(String string) {
        Vector vector = this.getColumns();
        int n = vector.size();
        JetUHDSField jetUHDSField = null;
        int n2 = 0;
        while (n2 < n) {
            jetUHDSField = (JetUHDSField)vector.elementAt(n2);
            String string2 = jetUHDSField.getFullName();
            if (string2.equals(string)) {
                return jetUHDSField;
            }
            ++n2;
        }
        return null;
    }

    public Hashtable getAllFields(Hashtable hashtable) {
        JetUDBTreeNode jetUDBTreeNode;
        Enumeration enumeration = this.getTables().elements();
        Enumeration enumeration2 = this.getColumns().elements();
        while (enumeration2.hasMoreElements()) {
            jetUDBTreeNode = (JetUHDSField)enumeration2.nextElement();
            if (((JetUHDSField)jetUDBTreeNode).isAttribute()) {
                hashtable.put(((JetUHDSField)jetUDBTreeNode).getFullName() + "_Att", jetUDBTreeNode);
                continue;
            }
            hashtable.put(((JetUHDSField)jetUDBTreeNode).getFullName(), jetUDBTreeNode);
        }
        while (enumeration.hasMoreElements()) {
            jetUDBTreeNode = (JetUHDSTable)enumeration.nextElement();
            ((JetUHDSTable)jetUDBTreeNode).getAllFields(hashtable);
        }
        return hashtable;
    }

    public JetUHDSTable findTablebyName(String string) {
        Vector vector = this.getTables();
        JetUHDSTable jetUHDSTable = null;
        int n = string.indexOf(".");
        int n2 = 0;
        while (n2 < vector.size()) {
            jetUHDSTable = (JetUHDSTable)vector.elementAt(n2);
            if (n > -1) {
                if (jetUHDSTable.getRealName().equalsIgnoreCase(string.substring(0, n))) {
                    jetUHDSTable = jetUHDSTable.findTablebyName(string.substring(n + 1));
                    return jetUHDSTable;
                }
            } else if (jetUHDSTable.getRealName().equalsIgnoreCase(string)) {
                return jetUHDSTable;
            }
            ++n2;
        }
        return null;
    }

    public String getMappingName(String string, JetUHDSTable jetUHDSTable) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        JetUDatabase jetUDatabase = this.getDatabase();
        String string3 = null;
        String string4 = string2 = string == null ? "fw" : string;
        boolean bl = jetUDatabase.IsMappingNameOK(string4, stringBuffer);
        int n = 1;
        if (!bl) {
            string4 = jetUHDSTable != null ? jetUHDSTable.getResourceName() + "_" + string2 : this.getResourceName() + "_" + string2;
            bl = jetUDatabase.IsMappingNameOK(string4, stringBuffer);
        }
        string3 = string4;
        while (!bl) {
            string4 = string3 + n++;
            bl = jetUDatabase.IsMappingNameOK(string4, stringBuffer);
        }
        return string4;
    }

    public Vector getMappingNames(String string, JetUHDSTable jetUHDSTable, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        JetUDatabase jetUDatabase = this.getDatabase();
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            String string2 = string + "_" + n3;
            while (!jetUDatabase.IsMappingNameOK(string2, stringBuffer) || vector.contains(string2)) {
                string2 = string + "_" + ++n3;
            }
            vector.addElement(string2);
            ++n2;
        }
        return vector;
    }

    public void cloneChildren(JetUHDSTable jetUHDSTable) {
        Object object;
        Enumeration enumeration = this.getColumns().elements();
        while (enumeration.hasMoreElements()) {
            object = ((JetUHDSField)enumeration.nextElement()).cloneEntity();
            jetUHDSTable.add((JetObject)object);
        }
        object = this.getTables().elements();
        while (object.hasMoreElements()) {
            JetUHDSTable jetUHDSTable2 = ((JetUHDSTable)object.nextElement()).cloneEntity();
            jetUHDSTable.add(jetUHDSTable2);
        }
    }

    public JetUHDSTable cloneEntity() {
        JetUHDSTable jetUHDSTable = new JetUHDSTable(this.getResourceName(), this.getDesc());
        jetUHDSTable.setMaxRows(this.getMaxRows());
        jetUHDSTable.setMaxDuration(this.getMaxDuration());
        jetUHDSTable.setFullName(this.getFullName());
        this.cloneChildren(jetUHDSTable);
        JetObject.copyProperties(jetUHDSTable, this);
        return jetUHDSTable;
    }

    public boolean isEqualChildren(JetUResourceContainer jetUResourceContainer) {
        boolean bl = jetUResourceContainer instanceof JetUHDSTable;
        if (bl) {
            Object object;
            Vector vector = ((JetUHDSTable)jetUResourceContainer).getFields();
            Vector vector2 = this.getFields();
            if (vector.size() >= vector2.size()) {
                int n = 0;
                while (n < vector2.size()) {
                    object = (JetUHDSField)vector2.elementAt(n);
                    if (JetUDBTreeNode.findNodeByName(vector, ((JetUDBTreeNode)object).getResourceName()) == null) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            } else {
                bl = false;
            }
            if (bl) {
                Vector vector3 = ((JetUHDSTable)jetUResourceContainer).getTables();
                object = this.getTables();
                if (vector3.size() >= ((Vector)object).size()) {
                    int n = 0;
                    while (n < ((Vector)object).size()) {
                        JetUHDSTable jetUHDSTable = (JetUHDSTable)((Vector)object).elementAt(n);
                        if (JetUDBTreeNode.findNodeByName(vector3, jetUHDSTable.getResourceName()) == null) {
                            bl = false;
                            break;
                        }
                        ++n;
                    }
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public boolean hasSibling() {
        JetUHDSTable jetUHDSTable = (JetUHDSTable)this.getParent();
        if (jetUHDSTable == null) {
            return false;
        }
        return jetUHDSTable.getTables().size() > 1;
    }

    public String toString() {
        return this.getResourceName();
    }

    public String getInstancePrefix() {
        return "HDSTable";
    }

    public boolean isSimilar(JetUResourceContainer jetUResourceContainer) {
        return super.isSimilar(jetUResourceContainer) && this.att.equal(((JetUHDSTable)jetUResourceContainer).att);
    }

    public HashMap getIndecialMap() {
        return InitAfterCreate;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUHDSTable == null ? (class$jet$universe$JetUHDSTable = JetUHDSTable.class$("jet.universe.JetUHDSTable")) : class$jet$universe$JetUHDSTable).desiredAssertionStatus();
        C = JRLogger.getLogger((class$jet$universe$JetUHDSTable == null ? (class$jet$universe$JetUHDSTable = JetUHDSTable.class$("jet.universe.JetUHDSTable")) : class$jet$universe$JetUHDSTable).getName());
        InitAfterCreate = new HashMap(6);
        InitAfterCreate.put("Description", new Integer(0));
        InitAfterCreate.put("maxRows", new Integer(1));
        InitAfterCreate.put("Name", new Integer(2));
        InitAfterCreate.put("maxDuration", new Integer(3));
        InitAfterCreate.put("Attributes", new Integer(4));
        InitAfterCreate.put("FullName", new Integer(5));
    }
}

