/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade;

import com.jinfonet.awt.JFont;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.log.JRLogger;
import jet.naming.EnumerationConstant;
import jet.report.JetRptField;
import jet.report.JetRptObject;
import jet.report.JetRptPicture;
import jet.report.JetRptTextBox;
import jet.report.JetRptTextField;
import jet.report.JetRptTextObject;
import jet.report.paragraph.build.JetRptParagraph;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.ParagraphLogic;
import jet.reportLogic.objectLogic.paragraphLogic.ParagraphConstant;
import jet.reportLogic.objectLogic.paragraphLogic.StyleTypeDef;
import jet.textobj.ChrObj;
import jet.textobj.DblLinkable;
import jet.textobj.DestVect;
import jet.textobj.DocObj;
import jet.textobj.FieldDest;
import jet.textobj.KwdObj;
import jet.textobj.Obj;
import jet.textobj.ObjVect;
import jet.textobj.ParObj;
import jet.textobj.PictDest;
import jet.textobj.RtfDest;
import jet.textobj.SecObj;
import jet.upgrade.UpgradeRpt;
import jet.upgrade.UpgradeRptFieldToV8Impl;
import jet.upgrade.UpgradeToV8Util;
import jet.util.FontSets;
import jet.util.ValueToUnit;

class UpgradeTextObjToV8Impl
implements UpgradeRpt {
    private static JRLogger QOIV = JRLogger.getLogger((class$jet$upgrade$UpgradeTextObjToV8Impl == null ? (class$jet$upgrade$UpgradeTextObjToV8Impl = UpgradeTextObjToV8Impl.class$("jet.upgrade.UpgradeTextObjToV8Impl")) : class$jet$upgrade$UpgradeTextObjToV8Impl).getName());
    private ParagraphLogic STRIKETHROUGH_NAME = ObjectLogicFactory.getParagraphLogic();
    private BasicComponentLogic SUPERSUBSCRIPT_NAME = ObjectLogicFactory.getBasicComponentLogic();
    private UpgradeRpt TRUE = null;
    private Hashtable TYPE_NAME = null;
    private Vector UNDERLINE_STYLE_NAME = null;
    static Class class$jet$upgrade$UpgradeTextObjToV8Impl;

    UpgradeTextObjToV8Impl() {
    }

    public JetRptObject upgrade(JetRptObject jetRptObject) {
        JetRptTextObject jetRptTextObject = null;
        if (!(jetRptObject instanceof JetRptTextObject)) {
            return null;
        }
        jetRptTextObject = (JetRptTextObject)jetRptObject;
        return this.SUPERSUBSCRIPT_NAME(jetRptTextObject);
    }

    private Hashtable QOIV(RtfDest rtfDest) {
        DestVect destVect = (DestVect)rtfDest.getObjValue("fonttbl");
        int n = destVect.size();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n2 = 0;
        while (n2 < n) {
            Obj obj = destVect.getSubProp(n2);
            Integer n3 = new Integer(obj.getIntValue("f"));
            String string = obj.getCharsValue("fontname").toString();
            if (string.endsWith(";") && string.length() > 1) {
                string = string.substring(0, string.length() - 1);
            }
            hashtable.put(n3, string);
            ++n2;
        }
        return hashtable;
    }

    private Vector STRIKETHROUGH_NAME(RtfDest rtfDest) {
        DestVect destVect = (DestVect)rtfDest.getObjValue("colortbl");
        int n = destVect.size();
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < n) {
            Obj obj = destVect.getSubProp(n2);
            String string = Integer.toHexString(obj.getIntValue("red"));
            String string2 = Integer.toHexString(obj.getIntValue("green"));
            String string3 = Integer.toHexString(obj.getIntValue("blue"));
            if (string.length() < 2) {
                string = '0' + string;
            }
            if (string2.length() < 2) {
                string2 = '0' + string2;
            }
            if (string3.length() < 2) {
                string3 = '0' + string3;
            }
            vector.add("0x" + string + string2 + string3);
            ++n2;
        }
        return vector;
    }

    private JetRptTextBox SUPERSUBSCRIPT_NAME(JetRptTextObject jetRptTextObject) {
        RtfDest rtfDest = jetRptTextObject.rtfProp.get();
        this.TYPE_NAME = this.QOIV(rtfDest);
        this.UNDERLINE_STYLE_NAME = this.STRIKETHROUGH_NAME(rtfDest);
        JetRptTextBox jetRptTextBox = new JetRptTextBox();
        jetRptTextBox.setEditable();
        boolean bl = false;
        DocObj docObj = (DocObj)rtfDest.getHead();
        this.TRUE(jetRptTextBox, docObj);
        while (docObj != null) {
            SecObj secObj = (SecObj)docObj.getHead();
            while (secObj != null) {
                ParObj parObj = (ParObj)secObj.getHead();
                while (parObj != null) {
                    JetRptParagraph jetRptParagraph = this.STRIKETHROUGH_NAME.createParagraphObject();
                    this.TYPE_NAME(jetRptParagraph, rtfDest);
                    this.UNDERLINE_STYLE_NAME(jetRptParagraph, docObj);
                    this.abs(jetRptParagraph, secObj);
                    this.add(jetRptParagraph, parObj);
                    DblLinkable dblLinkable = parObj.getHead();
                    this.afterSpacing(jetRptParagraph, dblLinkable);
                    this.SUPERSUBSCRIPT_NAME.add(jetRptTextBox, jetRptParagraph);
                    bl = true;
                    parObj = (ParObj)parObj.getNext();
                }
                secObj = (SecObj)secObj.getNext();
            }
            docObj = (DocObj)docObj.getNext();
        }
        if (bl) {
            this.autoFit(jetRptTextBox, jetRptTextObject);
        } else {
            jetRptTextBox = null;
        }
        return jetRptTextBox;
    }

    private void TRUE(JetRptTextBox jetRptTextBox, DocObj docObj) {
        if (docObj.hasValue("docfmt.txtvalign")) {
            switch (docObj.getIntValue("docfmt.txtvalign")) {
                case 0: {
                    jetRptTextBox.vAlignment.set(new Integer(1));
                    break;
                }
                case 1: {
                    jetRptTextBox.vAlignment.set(new Integer(2));
                    break;
                }
                case 2: {
                    jetRptTextBox.vAlignment.set(new Integer(0));
                    break;
                }
            }
        }
    }

    private void TYPE_NAME(JetRptParagraph jetRptParagraph, RtfDest rtfDest) {
        int n;
        if (rtfDest.hasProp("deff") && (n = ((Integer)rtfDest.getPropValue("deff")).intValue()) >= 0 && n < this.TYPE_NAME.size()) {
            jetRptParagraph.fontFace.set((String)this.TYPE_NAME.get(new Integer(n)));
        }
    }

    private void UNDERLINE_STYLE_NAME(JetRptParagraph jetRptParagraph, DocObj docObj) {
        int n = -1;
        if (docObj.hasValue("docfmt.deftab") && (n = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.deftab"))) != 0) {
            jetRptParagraph.tabDefaultStop.setUnitValue(n);
        }
        if (docObj.hasValue("docfmt.margb")) {
            n = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margb"));
            jetRptParagraph.bottomMargin.setUnitValue(n);
        }
        if (docObj.hasValue("docfmt.margl")) {
            n = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margl"));
            jetRptParagraph.leftMargin.setUnitValue(n);
        }
        if (docObj.hasValue("docfmt.margr")) {
            n = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margr"));
            jetRptParagraph.rightMargin.setUnitValue(n);
        }
        if (docObj.hasValue("docfmt.margt")) {
            n = (int)ValueToUnit.convertTwipToUnit(docObj.getIntValue("docfmt.margt"));
            jetRptParagraph.topMargin.setUnitValue(n);
        }
        jetRptParagraph.backColor.set("Transparent");
    }

    private void abs(JetRptParagraph jetRptParagraph, SecObj secObj) {
    }

    private void add(JetRptParagraph jetRptParagraph, ParObj parObj) {
        int n;
        int n2;
        if (parObj.hasValue("parfmt.paraalign")) {
            switch (parObj.getIntValue("parfmt.paraalign")) {
                case 0: {
                    jetRptParagraph.horiAlignment.set(new Integer(0));
                    break;
                }
                case 1: {
                    jetRptParagraph.horiAlignment.set(new Integer(1));
                    break;
                }
                case 3: {
                    jetRptParagraph.horiAlignment.set(new Integer(2));
                    break;
                }
                default: {
                    jetRptParagraph.horiAlignment.set(new Integer(3));
                }
            }
        }
        if (parObj.hasValue("parfmt.fi")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.fi"));
            if (n2 >= 0) {
                jetRptParagraph.lineIndentation.setUnitValue(n2);
            } else {
                jetRptParagraph.hangIndentation.setUnitValue(Math.abs(n2));
            }
        }
        if (parObj.hasValue("parfmt.li")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.li"));
            jetRptParagraph.leftIndentation.setUnitValue(n2);
        }
        if (parObj.hasValue("parfmt.ri")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.ri"));
            jetRptParagraph.rightIndentation.setUnitValue(n2);
        }
        if (parObj.hasValue("parfmt.sl")) {
            n2 = parObj.getIntValue("parfmt.sl");
            n = (int)ValueToUnit.convertTwipToUnit(n2);
            jetRptParagraph.lineSpacing.setUnitValue(n);
        }
        if (parObj.hasValue("parfmt.slmult")) {
            switch (parObj.getIntValue("parfmt.slmult")) {
                case 0: {
                    jetRptParagraph.lineSpacingType.set(false);
                    break;
                }
                case 1: {
                    jetRptParagraph.lineSpacingType.set(true);
                    break;
                }
            }
        }
        if (parObj.hasValue("parfmt.sa")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.sa"));
            jetRptParagraph.afterSpacing.setUnitValue(n2);
        }
        if (parObj.hasValue("parfmt.sb")) {
            n2 = (int)ValueToUnit.convertTwipToUnit(parObj.getIntValue("parfmt.sb"));
            jetRptParagraph.beforeSpacing.setUnitValue(n2);
        }
        if (parObj.hasValue("parfmt.tabdefs")) {
            ObjVect objVect = (ObjVect)parObj.getObjValue("parfmt.tabdefs");
            n = objVect.size();
            int n3 = 0;
            while (n3 < n) {
                Obj obj = objVect.getSubProp(n3);
                int n4 = obj.getIntValue("tabstyle");
                double d = obj.getFlagValue("tabstyle");
                int n5 = obj.getIntValue("tablead");
                if (n4 == 1) {
                    n4 = 0;
                } else if (n4 == 2) {
                    n4 = 0;
                }
                d = ValueToUnit.convertTwipToUnit(d);
                switch (n5) {
                    case 1: {
                        n5 = 1;
                        break;
                    }
                    case 2: {
                        n5 = 0;
                        break;
                    }
                    case 3: {
                        n5 = 3;
                        break;
                    }
                    case 4: {
                        n5 = 2;
                        break;
                    }
                    case 5: {
                        n5 = 4;
                    }
                }
                jetRptParagraph.tabAlignmentSet.add("" + n4);
                jetRptParagraph.tabStopPosition.add("" + (int)d);
                jetRptParagraph.tabLeaderSet.add("" + n5);
                ++n3;
            }
        }
    }

    private void afterSpacing(JetRptParagraph jetRptParagraph, DblLinkable dblLinkable) {
        int n = 0;
        while (dblLinkable != null) {
            if (dblLinkable instanceof ChrObj) {
                Object object;
                ChrObj chrObj = (ChrObj)dblLinkable;
                if (chrObj.getFldOwner() != null) {
                    object = chrObj.getFldOwner();
                    JetRptObject jetRptObject = (JetRptObject)((Object)((FieldDest)object).getField());
                    JetRptField jetRptField = this.applyTextStyle((JetRptField)jetRptObject);
                    jetRptField.position.set("static");
                    this.STRIKETHROUGH_NAME.insertReplaceElement(jetRptParagraph, n, jetRptField);
                    ++n;
                } else if (chrObj.getHead() instanceof PictDest) {
                    try {
                        Object object2;
                        object = new JetRptPicture();
                        ((JetObject)object).setEditable();
                        Image image = ((PictDest)chrObj.getHead()).getImg();
                        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType("image/jpeg");
                        ImageWriter imageWriter = iterator.hasNext() ? iterator.next() : null;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
                        imageWriter.setOutput(imageOutputStream);
                        BufferedImage bufferedImage = null;
                        int n2 = image.getWidth(null);
                        int n3 = image.getHeight(null);
                        if (image instanceof BufferedImage) {
                            bufferedImage = (BufferedImage)image;
                        } else {
                            bufferedImage = new BufferedImage(n2, n3, 1);
                            object2 = bufferedImage.createGraphics();
                            ((Graphics)object2).drawImage(image, 0, 0, null);
                        }
                        imageWriter.write(new IIOImage(bufferedImage, null, null));
                        imageWriter.dispose();
                        object2 = byteArrayOutputStream.toByteArray();
                        ((JetRptPicture)object).setEmbedImage((byte[])object2);
                        if (n2 == 0 || n3 == 0) {
                            ((JetRptPicture)object).autosize.set(true);
                        } else {
                            float f = (float)((PictDest)chrObj.getHead()).getIntValue("picscalex") / 100.0f;
                            float f2 = (float)((PictDest)chrObj.getHead()).getIntValue("picscaley") / 100.0f;
                            int n4 = ((PictDest)chrObj.getHead()).getIntValue("picwgoal");
                            int n5 = ((PictDest)chrObj.getHead()).getIntValue("pichgoal");
                            ((JetRptPicture)object).width.setUnitValue((int)ValueToUnit.convertTwipToUnit((float)n4 * f));
                            ((JetRptPicture)object).height.setUnitValue((int)ValueToUnit.convertTwipToUnit((float)n5 * f2));
                        }
                        ((JetRptPicture)object).position.set("static");
                        this.STRIKETHROUGH_NAME.insertReplaceElement(jetRptParagraph, n, (JetRptObject)object);
                        ++n;
                    }
                    catch (IOException iOException) {
                        QOIV.warn("Error on Convert image, the image will be skip:", iOException);
                    }
                } else {
                    object = chrObj.getText().toString();
                    int n6 = ((String)object).length();
                    int n7 = this.STRIKETHROUGH_NAME.getParagraphSize(jetRptParagraph);
                    this.STRIKETHROUGH_NAME.insertText(jetRptParagraph, n7, (String)object);
                    this.append(jetRptParagraph, n, n + n6, chrObj);
                    n += n6;
                }
            } else {
                if (((KwdObj)dblLinkable).isKwd(630)) break;
                if (((KwdObj)dblLinkable).isKwd(895)) {
                    this.STRIKETHROUGH_NAME.insertText(jetRptParagraph, n, "\t");
                    ++n;
                }
            }
            dblLinkable = ((Obj)dblLinkable).getNextLeaf();
        }
    }

    private void append(JetRptParagraph jetRptParagraph, int n, int n2, ChrObj chrObj) {
        int n3;
        String string = "";
        String string2 = "";
        if (chrObj.hasValue("chrfmt.b")) {
            string2 = StyleTypeDef.TYPE_NAME[1];
            string = "" + chrObj.getBooleanValue("chrfmt.b");
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.i")) {
            string2 = StyleTypeDef.TYPE_NAME[2];
            string = "" + chrObj.getBooleanValue("chrfmt.i");
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.f") && (string = (String)this.TYPE_NAME.get(new Integer(n3 = chrObj.getIntValue("chrfmt.f")))) != null) {
            string2 = StyleTypeDef.TYPE_NAME[0];
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.fs")) {
            double d = chrObj.getIntValue("chrfmt.fs") / 2;
            string = "" + ValueToUnit.convertPointToUnit(d);
            string2 = StyleTypeDef.TYPE_NAME[3];
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.cb") && (n3 = chrObj.getIntValue("chrfmt.cb")) >= 0 && n3 < this.UNDERLINE_STYLE_NAME.size()) {
            string = (String)this.UNDERLINE_STYLE_NAME.get(n3);
            if (string == null) {
                string = "Transparent";
            }
            string2 = StyleTypeDef.TYPE_NAME[4];
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.cf") && (n3 = chrObj.getIntValue("chrfmt.cf")) < this.UNDERLINE_STYLE_NAME.size() && n3 >= 0 && (string = (String)this.UNDERLINE_STYLE_NAME.get(n3)) != null) {
            string2 = StyleTypeDef.TYPE_NAME[5];
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.chcbpat") && (n3 = chrObj.getIntValue("chrfmt.chcbpat")) >= 0 && n3 < this.UNDERLINE_STYLE_NAME.size()) {
            string = (String)this.UNDERLINE_STYLE_NAME.get(n3);
            if (string == null) {
                string = "Transparent";
            }
            string2 = StyleTypeDef.TYPE_NAME[4];
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.highlight") && (n3 = chrObj.getIntValue("chrfmt.highlight")) >= 0 && n3 < this.UNDERLINE_STYLE_NAME.size()) {
            string = (String)this.UNDERLINE_STYLE_NAME.get(n3);
            if (string == null) {
                string = "Transparent";
            }
            string2 = StyleTypeDef.TYPE_NAME[4];
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (!chrObj.hasValue("chrfmt.nosupersub")) {
            if (chrObj.hasValue("chrfmt.super") || chrObj.hasValue("chrfmt.up")) {
                string2 = StyleTypeDef.TYPE_NAME[13];
                string = ParagraphConstant.SUPERSUBSCRIPT_NAME[1];
                this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            } else if (chrObj.hasValue("chrfmt.sub") || chrObj.hasValue("chrfmt.dn")) {
                string2 = StyleTypeDef.TYPE_NAME[13];
                string = ParagraphConstant.SUPERSUBSCRIPT_NAME[2];
                this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            }
        }
        if (chrObj.hasValue("chrfmt.ul") && chrObj.getBooleanValue("chrfmt.ul") || chrObj.hasValue("chrfmt.ulstyle") && chrObj.getIntValue("chrfmt.ulstyle") != 0) {
            n3 = 1;
            int n4 = 1;
            if (chrObj.hasValue("chrfmt.ulstyle")) {
                switch (chrObj.getIntValue("chrfmt.ulstyle")) {
                    case 0: {
                        n4 = 1;
                        break;
                    }
                    case 1: {
                        n4 = 4;
                        break;
                    }
                    case 2: {
                        n4 = 2;
                        break;
                    }
                    case 3: {
                        n4 = 0;
                        break;
                    }
                    case 4: {
                        n4 = 6;
                        break;
                    }
                    case 5: {
                        n4 = 10;
                        break;
                    }
                    case 6: {
                        n4 = 12;
                        break;
                    }
                    case 7: {
                        n4 = 15;
                        break;
                    }
                    case 8: {
                        n4 = 8;
                        break;
                    }
                    case 9: {
                        n3 = 0;
                        break;
                    }
                    case 10: {
                        n4 = 3;
                        break;
                    }
                    case 11: {
                        n4 = 5;
                        break;
                    }
                    case 12: {
                        n4 = 7;
                        break;
                    }
                    case 13: {
                        n4 = 11;
                        break;
                    }
                    case 14: {
                        n4 = 13;
                        break;
                    }
                    case 15: {
                        n4 = 9;
                        break;
                    }
                    case 16: {
                        n4 = 16;
                        break;
                    }
                    case 17: {
                        n4 = 14;
                        break;
                    }
                    default: {
                        n3 = 0;
                    }
                }
            }
            if (n3 != 0) {
                string2 = StyleTypeDef.TYPE_NAME[8];
                string = Boolean.TRUE.toString();
                this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
                string2 = StyleTypeDef.TYPE_NAME[9];
                string = ParagraphConstant.UNDERLINE_STYLE_NAME[n4];
                this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            }
        }
        if (chrObj.hasValue("chrfmt.ulc") && (n3 = chrObj.getIntValue("chrfmt.ulc")) >= 0 && n3 < this.UNDERLINE_STYLE_NAME.size()) {
            string = (String)this.UNDERLINE_STYLE_NAME.get(n3);
            if (string == null) {
                string = "0x000000";
            }
            string2 = StyleTypeDef.TYPE_NAME[6];
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.strike")) {
            string2 = StyleTypeDef.TYPE_NAME[10];
            string = String.valueOf(chrObj.getBooleanValue("chrfmt.strike"));
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            string2 = StyleTypeDef.TYPE_NAME[11];
            string = EnumerationConstant.STRIKETHROUGH_NAME[0];
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
        if (chrObj.hasValue("chrfmt.strikedl")) {
            string2 = StyleTypeDef.TYPE_NAME[10];
            string = "true";
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
            string2 = StyleTypeDef.TYPE_NAME[11];
            string = EnumerationConstant.STRIKETHROUGH_NAME[0];
            this.STRIKETHROUGH_NAME.applyTextStyle(jetRptParagraph, n, n2, string2, string);
        }
    }

    private JetRptField applyTextStyle(JetRptField jetRptField) {
        if (this.TRUE == null) {
            this.TRUE = new UpgradeRptFieldToV8Impl();
        }
        JetRptField jetRptField2 = (JetRptField)this.TRUE.upgrade(jetRptField);
        this.autosize(jetRptField2);
        return jetRptField2;
    }

    private void autoFit(JetRptTextBox jetRptTextBox, JetRptTextObject jetRptTextObject) {
        jetRptTextBox.setInstName(jetRptTextObject.getInstName());
        String[] stringArray = new String[]{"border-top-style", "border-bottom-style", "border-left-style", "border-right-style", "border-top-width", "border-bottom-width", "border-left-width", "border-right-width", "border-top-color", "border-bottom-color", "border-left-color", "border-right-color", "Alignment"};
        Hashtable hashtable = jetRptTextBox.getProperties();
        Hashtable hashtable2 = jetRptTextObject.getProperties();
        int n = stringArray.length;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                if (string.compareTo(stringArray[n2]) == 0) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) continue;
            JetProperty jetProperty = (JetProperty)hashtable.get(string);
            JetProperty jetProperty2 = (JetProperty)hashtable2.get(string);
            if (jetProperty2 == null) continue;
            jetProperty.setEditorType(jetProperty2.getEditorType());
            UpgradeToV8Util.setProperty(jetRptTextBox, jetProperty2);
        }
        if (jetRptTextObject.autoFit.isChangeByOther()) {
            jetRptTextBox.vAutoSize.setChangeByObject(jetRptTextObject.autoFit.getChangeByObject());
        } else {
            jetRptTextBox.vAutoSize.setObject(jetRptTextObject.autoFit.getObject());
        }
        if (jetRptTextObject.borderWidth.isChangeByOther()) {
            jetRptTextBox.topBorderWidth.setChangeByObject(jetRptTextObject.borderWidth.getChangeByObject());
            jetRptTextBox.rightBorderWidth.setChangeByObject(jetRptTextObject.borderWidth.getChangeByObject());
            jetRptTextBox.bottomBorderWidth.setChangeByObject(jetRptTextObject.borderWidth.getChangeByObject());
            jetRptTextBox.leftBorderWidth.setChangeByObject(jetRptTextObject.borderWidth.getChangeByObject());
        } else if (jetRptTextObject.borderWidth.getObject() != null) {
            jetRptTextBox.topBorderWidth.setObject(jetRptTextObject.borderWidth.getObject());
            jetRptTextBox.rightBorderWidth.setObject(jetRptTextObject.borderWidth.getObject());
            jetRptTextBox.bottomBorderWidth.setObject(jetRptTextObject.borderWidth.getObject());
            jetRptTextBox.leftBorderWidth.setObject(jetRptTextObject.borderWidth.getObject());
        }
        if (jetRptTextObject.borderColor.isChangeByOther()) {
            jetRptTextBox.topBorderColor.setChangeByObject(jetRptTextObject.borderColor.getChangeByObject());
            jetRptTextBox.rightBorderColor.setChangeByObject(jetRptTextObject.borderColor.getChangeByObject());
            jetRptTextBox.bottomBorderColor.setChangeByObject(jetRptTextObject.borderColor.getChangeByObject());
            jetRptTextBox.leftBorderColor.setChangeByObject(jetRptTextObject.borderColor.getChangeByObject());
        } else if (jetRptTextObject.borderColor.getObject() != null) {
            jetRptTextBox.topBorderColor.setObject(jetRptTextObject.borderColor.getObject());
            jetRptTextBox.rightBorderColor.setObject(jetRptTextObject.borderColor.getObject());
            jetRptTextBox.bottomBorderColor.setObject(jetRptTextObject.borderColor.getObject());
            jetRptTextBox.leftBorderColor.setObject(jetRptTextObject.borderColor.getObject());
        }
    }

    private void autosize(JetRptField jetRptField) {
        int n = 0;
        if (jetRptField.bold.get()) {
            n |= 1;
        }
        if (jetRptField.italic.get()) {
            n |= 2;
        }
        float f = jetRptField.fontSize.get();
        String string = jetRptField.fontName.get();
        Font font = FontSets.getFont(string, n, f);
        FontMetrics fontMetrics = font instanceof JFont ? ((JFont)((Object)font)).getFontMetrics() : Toolkit.getDefaultToolkit().getFontMetrics(font);
        String string2 = jetRptField instanceof JetRptTextField ? ((JetRptTextField)jetRptField).text.get() : jetRptField.format.get();
        jetRptField.width.set(fontMetrics.stringWidth(string2));
        jetRptField.height.set(fontMetrics.getHeight());
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

