/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.api;

import toolkit.db.api.ColumnInfo;

public class JoinInfo {
    public static final int INNER_JOIN = 0;
    public static final int RIGHT_OUTER_JOIN = 1;
    public static final int FULL_OUTER_JOIN = 2;
    public static final int LEFT_OUTER_JOIN = 4;
    public static final int OUTER_JOIN = 7;
    public static final int UNION_JOIN = 8;
    public static final String STR_INNER_JOIN = "Inner Join";
    public static final String STR_RIGHT_OUTER_JOIN = "Right Outer Join";
    public static final String STR_FULL_OUTER_JOIN = "Full Outer Join";
    public static final String STR_LEFT_OUTER_JOIN = "Left Outer Join";
    public static final String STR_OUTER_JOIN = "Outer Join";
    public static final String STR_UNION_JOIN = "Union Join";
    private ColumnInfo QOIV;
    private String append;
    private ColumnInfo equals;
    int equalsIgnoreCase;
    boolean getMappingName;
    boolean toString;

    public JoinInfo(ColumnInfo columnInfo, String string, ColumnInfo columnInfo2, int n, boolean bl, boolean bl2) {
        this.QOIV = columnInfo;
        this.append = string;
        this.equals = columnInfo2;
        this.equalsIgnoreCase = n;
        this.getMappingName = bl;
        this.toString = bl2;
    }

    public ColumnInfo getColumnFrom() {
        return this.QOIV;
    }

    public String getOperator() {
        return this.append;
    }

    public ColumnInfo getColumnTo() {
        return this.equals;
    }

    public int getJoinType() {
        return this.equalsIgnoreCase;
    }

    public boolean isOuterJoin() {
        return (this.equalsIgnoreCase & 7) != 0;
    }

    public boolean isLeftOuterJoin() {
        return (this.equalsIgnoreCase & 4) != 0;
    }

    public boolean isRightOuterJoin() {
        return (this.equalsIgnoreCase & 1) != 0;
    }

    public boolean isFullOuterJoin() {
        return (this.equalsIgnoreCase & 2) != 0;
    }

    public boolean isSQL92() {
        return this.getMappingName;
    }

    public boolean isSelfJoin() {
        return this.toString;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JoinInfo) {
            JoinInfo joinInfo = (JoinInfo)object;
            return this.QOIV.equals(joinInfo.QOIV) && this.append.equalsIgnoreCase(joinInfo.append) && this.equals.equals(joinInfo.equals) && this.equalsIgnoreCase == joinInfo.equalsIgnoreCase && this.getMappingName ^ joinInfo.getMappingName && this.toString ^ joinInfo.toString;
        }
        return false;
    }

    public String toString() {
        return super.toString() + "[ " + this.QOIV == null ? "Null" : (this.QOIV.getMappingName() + " | " + this.append + " | " + this.equals == null ? "Null" : this.equals.getMappingName() + " | " + JoinInfo.QOIV(this.equalsIgnoreCase) + " | " + this.getMappingName + " | " + this.toString + " ]");
    }

    private static String QOIV(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = STR_INNER_JOIN;
                break;
            }
            case 1: {
                string = STR_RIGHT_OUTER_JOIN;
                break;
            }
            case 2: {
                string = STR_FULL_OUTER_JOIN;
                break;
            }
            case 4: {
                string = STR_LEFT_OUTER_JOIN;
                break;
            }
            case 8: {
                string = STR_UNION_JOIN;
            }
        }
        return string;
    }
}

