/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.swap;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelation;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.Record;
import com.jinfonet.dataservice.relational.swap.ARelationPool;
import com.jinfonet.dataservice.relational.swap.RowDataPool;
import com.jinfonet.dataservice.util.Bits;
import com.jinfonet.datatypes.JinfonetBlobBaseBytes;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.dataengine.api.DSException;
import jet.dataengine8.util.JBoolean;
import jet.dataengine8.util.dataswap.ArrayTool;
import jet.dataengine8.util.dataswap.IDataCache;

public class PooledRecord
extends Record {
    private final int QOIV;
    private byte[] array2Bytes = null;
    private boolean arraycopy = false;
    private final IDataCache booleanValue;
    private JRelationMetaData byteValue = null;
    private int[] bytes2Array;
    private char[] class$;
    private int[] createRelation;
    private int[] desiredAssertionStatus;
    private int doubleToRawLongBits = 1;
    private int doubleValue;
    private int findColumn;
    private int floatToIntBits;
    private int floatValue;
    private int[] forName;
    private JAttribute[] getAttribute;
    static final boolean $assertionsDisabled = !(class$com$jinfonet$dataservice$relational$swap$PooledRecord == null ? (class$com$jinfonet$dataservice$relational$swap$PooledRecord = PooledRecord.class$("com.jinfonet.dataservice.relational.swap.PooledRecord")) : class$com$jinfonet$dataservice$relational$swap$PooledRecord).desiredAssertionStatus();
    static Class class$com$jinfonet$dataservice$relational$swap$PooledRecord;

    public PooledRecord(RowDataPool rowDataPool) throws DSException {
        this.booleanValue = rowDataPool.I;
        this.byteValue = rowDataPool.getMetaData();
        this.QOIV = this.byteValue.getColumnCount();
        this.$assertionsDisabled();
    }

    public PooledRecord(ARelationPool aRelationPool, JRelationMetaData jRelationMetaData) throws DSException {
        this.booleanValue = aRelationPool.getDataCache();
        this.byteValue = jRelationMetaData;
        this.QOIV = jRelationMetaData.getColumnCount();
        this.$assertionsDisabled();
    }

    private final void $assertionsDisabled() throws DSException {
        int n = this.doubleValue = (this.QOIV >> 3) + 1;
        int n2 = this.doubleValue;
        int n3 = 0;
        this.bytes2Array = new int[this.QOIV + 1];
        this.createRelation = new int[this.QOIV + 1];
        this.desiredAssertionStatus = new int[this.QOIV + 1];
        this.forName = new int[this.QOIV + 1];
        this.getAttribute = new JAttribute[this.QOIV + 1];
        int n4 = 1;
        while (n4 <= this.QOIV) {
            this.getAttribute[n4] = this.byteValue.getAttribute(n4);
            this.bytes2Array[n4] = this.byteValue.getColumnType(n4);
            this.desiredAssertionStatus[n4] = Types.swapDataLength(this.bytes2Array[n4]);
            int n5 = 0;
            if (this.desiredAssertionStatus[n4] == 0) {
                switch (this.bytes2Array[n4]) {
                    case 12: {
                        n5 = this.byteValue.getPrecision(n4) * 2 + 1;
                        if (n5 <= 0 || n5 > 255) {
                            n5 = 255;
                        }
                        if (n3 >= this.byteValue.getPrecision(n4)) break;
                        n3 = this.byteValue.getPrecision(n4);
                        break;
                    }
                    case -2: 
                    case 3: 
                    case 2003: {
                        n5 = 255;
                    }
                }
                this.desiredAssertionStatus[n4] = 4;
            }
            if (this.getAttribute[n4].isConstant()) {
                this.desiredAssertionStatus[n4] = 0;
            }
            this.createRelation[n4] = n;
            this.forName[n4] = n5;
            n += this.desiredAssertionStatus[n4];
            n2 = n2 + this.desiredAssertionStatus[n4] + Math.max(8, n5);
            ++n4;
        }
        if (!$assertionsDisabled && n2 >= 0x7FFFFF) {
            throw new AssertionError();
        }
        this.floatToIntBits = n;
        this.array2Bytes = new byte[n2];
        if (n3 > 1024) {
            n3 = 1024;
        }
        this.class$ = new char[n3];
        this.reset();
    }

    public void putByte(byte by) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.array2Bytes[this.floatValue++] = by;
        ++this.doubleToRawLongBits;
    }

    public byte getByte(String string) throws DSException {
        return this.getByte(this.byteValue.findColumn(string));
    }

    public byte getByte(int n) {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return 0;
            }
            this.arraycopy = false;
            return (Byte)object;
        }
        this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        return this.array2Bytes[this.createRelation[n]];
    }

    public void putBoolean(boolean bl) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.array2Bytes[this.floatValue++] = bl ? (byte)1 : 0;
        ++this.doubleToRawLongBits;
    }

    public boolean getBoolean(String string) throws DSException {
        return this.getBoolean(this.byteValue.findColumn(string));
    }

    public boolean getBoolean(int n) {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return false;
            }
            this.arraycopy = false;
            return (Boolean)object;
        }
        this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        return this.array2Bytes[this.createRelation[n]] == 1;
    }

    public void putShort(short s) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.array2Bytes[this.floatValue++] = (byte)s;
        this.array2Bytes[this.floatValue++] = (byte)(s >> 8);
        ++this.doubleToRawLongBits;
    }

    public short getShort(String string) throws DSException {
        return this.getShort(this.byteValue.findColumn(string));
    }

    public short getShort(int n) {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return 0;
            }
            this.arraycopy = false;
            return (Short)object;
        }
        this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        return (short)(this.array2Bytes[this.createRelation[n] + 1] << 8 | this.array2Bytes[this.createRelation[n]] & 0xFF);
    }

    public void putInt(int n) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.array2Bytes[this.floatValue++] = (byte)n;
        this.array2Bytes[this.floatValue++] = (byte)(n >> 8);
        this.array2Bytes[this.floatValue++] = (byte)(n >> 16);
        this.array2Bytes[this.floatValue++] = (byte)(n >> 24);
        ++this.doubleToRawLongBits;
    }

    public void putInt(int n, int n2) {
        if (this.getAttribute[n].isConstant()) {
            return;
        }
        this.array2Bytes[n >> 3] = (byte)(this.array2Bytes[n >> 3] | 1 << (n - 1 & 7));
        this.array2Bytes[this.createRelation[n]] = (byte)n2;
        this.array2Bytes[this.createRelation[n] + 1] = (byte)(n2 >> 8);
        this.array2Bytes[this.createRelation[n] + 2] = (byte)(n2 >> 16);
        this.array2Bytes[this.createRelation[n] + 3] = (byte)(n2 >> 24);
    }

    public int getInt(String string) throws DSException {
        return this.getInt(this.byteValue.findColumn(string));
    }

    public int getInt(int n) {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return 0;
            }
            this.arraycopy = false;
            return (Integer)object;
        }
        this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        return this.array2Bytes[this.createRelation[n] + 3] << 24 | (this.array2Bytes[this.createRelation[n] + 2] & 0xFF) << 16 | (this.array2Bytes[this.createRelation[n] + 1] & 0xFF) << 8 | this.array2Bytes[this.createRelation[n]] & 0xFF;
    }

    public void putFloat(float f) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.putInt(Float.floatToIntBits(f));
    }

    public float getFloat(String string) throws DSException {
        return this.getFloat(this.byteValue.findColumn(string));
    }

    public float getFloat(int n) {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return 0.0f;
            }
            this.arraycopy = false;
            return ((Float)object).floatValue();
        }
        this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        return Float.intBitsToFloat(this.getInt(n));
    }

    public final void putLong(long l) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.array2Bytes[this.floatValue++] = (byte)l;
        this.array2Bytes[this.floatValue++] = (byte)(l >> 8);
        this.array2Bytes[this.floatValue++] = (byte)(l >> 16);
        this.array2Bytes[this.floatValue++] = (byte)(l >> 24);
        this.array2Bytes[this.floatValue++] = (byte)(l >> 32);
        this.array2Bytes[this.floatValue++] = (byte)(l >> 40);
        this.array2Bytes[this.floatValue++] = (byte)(l >> 48);
        this.array2Bytes[this.floatValue++] = (byte)(l >> 56);
        ++this.doubleToRawLongBits;
    }

    public long getLong(String string) throws DSException {
        return this.getLong(this.byteValue.findColumn(string));
    }

    public long getLong(int n) {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return 0L;
            }
            this.arraycopy = false;
            return (Long)object;
        }
        this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        int n2 = this.createRelation[n];
        return (long)this.array2Bytes[n2 + 7] << 56 | ((long)this.array2Bytes[n2 + 6] & 0xFFL) << 48 | ((long)this.array2Bytes[n2 + 5] & 0xFFL) << 40 | ((long)this.array2Bytes[n2 + 4] & 0xFFL) << 32 | ((long)this.array2Bytes[n2 + 3] & 0xFFL) << 24 | ((long)this.array2Bytes[n2 + 2] & 0xFFL) << 16 | ((long)this.array2Bytes[n2 + 1] & 0xFFL) << 8 | (long)this.array2Bytes[n2] & 0xFFL;
    }

    public void putDouble(double d) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.putLong(Double.doubleToRawLongBits(d));
    }

    public double getDouble(String string) throws DSException {
        return this.getDouble(this.byteValue.findColumn(string));
    }

    public double getDouble(int n) {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return 0.0;
            }
            this.arraycopy = false;
            return (Double)object;
        }
        return Double.longBitsToDouble(this.getLong(n));
    }

    public void putBigDecimal(BigDecimal bigDecimal) throws DSException {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        byte[] byArray = this.QOIV(bigDecimal);
        this.putBytes(byArray);
    }

    private byte[] QOIV(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 4];
        int n2 = bigDecimal.scale();
        Bits.putInt(byArray2, 0, n2);
        System.arraycopy(byArray, 0, byArray2, 4, n);
        return byArray2;
    }

    public BigDecimal getBigDecimal(String string) throws DSException {
        return this.getBigDecimal(this.byteValue.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws DSException {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return null;
            }
            this.arraycopy = false;
            return (BigDecimal)object;
        }
        boolean bl = this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.arraycopy) {
            return null;
        }
        return this.array2Bytes(this.getBytes(n));
    }

    private BigDecimal array2Bytes(byte[] byArray) {
        int n = Bits.getInt(byArray, 0);
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
        return new BigDecimal(new BigInteger(byArray2), n);
    }

    public void putDate(Date date) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.putLong(date.getTime());
    }

    public void putDate(long l) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.putLong(l);
    }

    public Date getDate(String string) throws DSException {
        return this.getDate(this.byteValue.findColumn(string));
    }

    public Date getDate(int n) {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return null;
            }
            this.arraycopy = false;
            return (Date)object;
        }
        return new JinfonetDate(this.getLong(n));
    }

    public void putTimeStamp(Timestamp timestamp) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.putLong(timestamp.getTime() - (long)(timestamp.getNanos() / 1000000));
        int n = timestamp.getNanos();
        this.array2Bytes[this.floatValue++] = (byte)n;
        this.array2Bytes[this.floatValue++] = (byte)(n >> 8);
        this.array2Bytes[this.floatValue++] = (byte)(n >> 16);
        this.array2Bytes[this.floatValue++] = (byte)(n >> 24);
    }

    public void putTimeStamp(long l, int n) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.putLong(l);
        this.array2Bytes[this.floatValue++] = (byte)n;
        this.array2Bytes[this.floatValue++] = (byte)(n >> 8);
        this.array2Bytes[this.floatValue++] = (byte)(n >> 16);
        this.array2Bytes[this.floatValue++] = (byte)(n >> 24);
    }

    public Timestamp getTimeStamp(String string) throws DSException {
        return this.getTimeStamp(this.byteValue.findColumn(string));
    }

    public Timestamp getTimeStamp(int n) {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return null;
            }
            this.arraycopy = false;
            return (Timestamp)object;
        }
        JinfonetTimeStamp jinfonetTimeStamp = new JinfonetTimeStamp(this.getLong(n));
        int n2 = this.array2Bytes[this.createRelation[n] + 11] << 24 | (this.array2Bytes[this.createRelation[n] + 10] & 0xFF) << 16 | (this.array2Bytes[this.createRelation[n] + 9] & 0xFF) << 8 | this.array2Bytes[this.createRelation[n] + 8] & 0xFF;
        jinfonetTimeStamp.setNanos(n2);
        return jinfonetTimeStamp;
    }

    public void putTime(Time time2) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.putLong(time2.getTime());
    }

    public void putTime(long l) {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        this.putLong(l);
    }

    public Time getTime(String string) throws DSException {
        return this.getTime(this.byteValue.findColumn(string));
    }

    public Time getTime(int n) {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return null;
            }
            this.arraycopy = false;
            return (Time)object;
        }
        return new JinfonetTime(this.getLong(n));
    }

    public void putString(String string) throws DSException {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        if (string == null) {
            this.putNull(12);
            return;
        }
        int n = string.length();
        if (this.class$.length < n) {
            this.class$ = new char[(int)((float)n * 1.5f)];
        }
        string.getChars(0, n, this.class$, 0);
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (this.class$[n2] > '\u00ff') {
                bl = false;
                break;
            }
            ++n2;
        }
        int n3 = bl ? n + 1 : n * 2 + 1;
        if (n3 <= this.forName[this.doubleToRawLongBits]) {
            this.array2Bytes[this.floatValue++] = (byte)(this.findColumn >> 16);
            this.array2Bytes[this.floatValue++] = (byte)(this.findColumn >> 8);
            this.array2Bytes[this.floatValue++] = (byte)this.findColumn;
            this.array2Bytes[this.floatValue++] = (byte)n3;
            if (bl) {
                this.array2Bytes[this.findColumn++] = 0;
                int n4 = 0;
                while (n4 < n) {
                    this.array2Bytes[this.findColumn++] = (byte)this.class$[n4];
                    ++n4;
                }
            } else {
                this.array2Bytes[this.findColumn++] = 1;
                int n5 = 0;
                while (n5 < n) {
                    this.array2Bytes[this.findColumn++] = (byte)this.class$[n5];
                    this.array2Bytes[this.findColumn++] = (byte)(this.class$[n5] >> 8);
                    ++n5;
                }
            }
        } else {
            int n6;
            byte[] byArray = null;
            int n7 = 0;
            if (bl) {
                byArray = new byte[n + 1];
                byArray[n7++] = 0;
                n6 = 0;
                while (n6 < n) {
                    byArray[n7++] = (byte)this.class$[n6];
                    ++n6;
                }
            } else {
                byArray = new byte[n * 2 + 1];
                byArray[n7++] = 1;
                n6 = 0;
                while (n6 < n) {
                    byArray[n7++] = (byte)this.class$[n6];
                    byArray[n7++] = (byte)(this.class$[n6] >> 8);
                    ++n6;
                }
            }
            long l = this.booleanValue.putBlob(new JinfonetBlobBaseBytes(byArray));
            this.array2Bytes[this.floatValue++] = -1;
            this.array2Bytes[this.floatValue++] = (byte)(this.findColumn >> 16);
            this.array2Bytes[this.floatValue++] = (byte)(this.findColumn >> 8);
            this.array2Bytes[this.floatValue++] = (byte)this.findColumn;
            Bits.putLong(this.array2Bytes, this.findColumn, l);
            this.findColumn += 8;
        }
        ++this.doubleToRawLongBits;
    }

    public String getString(String string) throws DSException {
        return this.getString(this.byteValue.findColumn(string));
    }

    public String getString(int n) throws DSException {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return null;
            }
            this.arraycopy = false;
            return (String)object;
        }
        boolean bl = this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.arraycopy) {
            return null;
        }
        if ((this.array2Bytes[this.createRelation[n]] & 0x80) == 0) {
            int n2 = (this.array2Bytes[this.createRelation[n] + 0] & 0xFF) << 16 | (this.array2Bytes[this.createRelation[n] + 1] & 0xFF) << 8 | this.array2Bytes[this.createRelation[n] + 2] & 0xFF;
            int n3 = this.array2Bytes[this.createRelation[n] + 3] & 0xFF;
            return this.arraycopy(this.array2Bytes, n2, n3);
        }
        int n4 = (this.array2Bytes[this.createRelation[n] + 1] & 0xFF) << 16 | (this.array2Bytes[this.createRelation[n] + 2] & 0xFF) << 8 | this.array2Bytes[this.createRelation[n] + 3] & 0xFF;
        Blob blob = this.booleanValue.getBlob(Bits.getLong(this.array2Bytes, n4));
        return this.arraycopy(blob.getBytes(1L, (int)blob.length()), 0, (int)blob.length());
    }

    private String arraycopy(byte[] byArray, int n, int n2) {
        int n3 = n2 - 1;
        if (this.class$.length < n3) {
            this.class$ = new char[(int)((float)n3 * 1.5f)];
        }
        if (byArray[n] == 0) {
            int n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                this.class$[n4] = (char)(byArray[n + n4 + 1] & 0xFF);
                ++n4;
            }
            return new String(this.class$, 0, n3);
        }
        int n6 = 0;
        int n7 = n3 >> 1;
        while (n6 < n7) {
            this.class$[n6] = (char)(byArray[n + 2 * n6 + 1] & 0xFF | byArray[n + 2 * n6 + 2] << 8);
            ++n6;
        }
        return new String(this.class$, 0, n3 >> 1);
    }

    public void putBlob(Blob blob) throws DSException {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        if (blob == null) {
            this.putNull(2004);
            return;
        }
        this.putLong(this.booleanValue.putBlob(blob));
    }

    public Blob getBlob(String string) throws DSException {
        return this.getBlob(this.byteValue.findColumn(string));
    }

    public Blob getBlob(int n) throws DSException {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return null;
            }
            this.arraycopy = false;
            return (Blob)object;
        }
        boolean bl = this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.arraycopy) {
            return null;
        }
        return this.booleanValue.getBlob(this.getLong(n));
    }

    public void putClob(Clob clob) throws DSException {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        if (clob == null) {
            this.putNull(2005);
            return;
        }
        this.putLong(this.booleanValue.putClob(clob));
    }

    public Clob getClob(String string) throws DSException {
        return this.getClob(this.byteValue.findColumn(string));
    }

    public Clob getClob(int n) throws DSException {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return null;
            }
            this.arraycopy = false;
            return (Clob)object;
        }
        boolean bl = this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.arraycopy) {
            return null;
        }
        return this.booleanValue.getClob(this.getLong(n));
    }

    public void putBytes(byte[] byArray) throws DSException {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if (byArray.length > 255) {
            long l = this.booleanValue.putBlob(new JinfonetBlobBaseBytes(byArray));
            this.array2Bytes[this.floatValue++] = -1;
            this.array2Bytes[this.floatValue++] = (byte)(this.findColumn >> 16);
            this.array2Bytes[this.floatValue++] = (byte)(this.findColumn >> 8);
            this.array2Bytes[this.floatValue++] = (byte)this.findColumn;
            Bits.putLong(this.array2Bytes, this.findColumn, l);
            this.findColumn += 8;
        } else {
            System.arraycopy(byArray, 0, this.array2Bytes, this.findColumn, byArray.length);
            this.array2Bytes[this.floatValue++] = (byte)(this.findColumn >> 16);
            this.array2Bytes[this.floatValue++] = (byte)(this.findColumn >> 8);
            this.array2Bytes[this.floatValue++] = (byte)this.findColumn;
            this.array2Bytes[this.floatValue++] = (byte)byArray.length;
            this.findColumn += byArray.length;
        }
        ++this.doubleToRawLongBits;
    }

    public byte[] getBytes(String string) throws DSException {
        return this.getBytes(this.byteValue.findColumn(string));
    }

    public byte[] getBytes(int n) throws DSException {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return null;
            }
            this.arraycopy = false;
            return (byte[])object;
        }
        boolean bl = this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.arraycopy) {
            return null;
        }
        if ((this.array2Bytes[this.createRelation[n]] & 0x80) == 0) {
            int n2 = (this.array2Bytes[this.createRelation[n] + 0] & 0xFF) << 16 | (this.array2Bytes[this.createRelation[n] + 1] & 0xFF) << 8 | this.array2Bytes[this.createRelation[n] + 2] & 0xFF;
            int n3 = this.array2Bytes[this.createRelation[n] + 3] & 0xFF;
            byte[] byArray = new byte[n3];
            System.arraycopy(this.array2Bytes, n2, byArray, 0, n3);
            return byArray;
        }
        int n4 = (this.array2Bytes[this.createRelation[n] + 1] & 0xFF) << 16 | (this.array2Bytes[this.createRelation[n] + 2] & 0xFF) << 8 | this.array2Bytes[this.createRelation[n] + 3] & 0xFF;
        Blob blob = this.booleanValue.getBlob(Bits.getLong(this.array2Bytes, n4));
        return blob.getBytes(1L, (int)blob.length());
    }

    public JRelationMetaData getMetaData() {
        return this.byteValue;
    }

    public int putRecord() {
        int n = this.booleanValue.putBytes(this.array2Bytes, 0, this.findColumn);
        this.reset();
        return n;
    }

    public void reset() {
        this.doubleToRawLongBits = 1;
        this.floatValue = this.doubleValue;
        this.findColumn = this.floatToIntBits;
        int n = 0;
        while (n < this.doubleValue) {
            this.array2Bytes[n] = -1;
            ++n;
        }
    }

    public void init(int n) {
        int n2 = this.booleanValue.getBytes(n, 0, this.array2Bytes);
        while (n2 == this.array2Bytes.length) {
            byte[] byArray = new byte[this.booleanValue(this.array2Bytes.length)];
            System.arraycopy(this.array2Bytes, 0, byArray, 0, n2);
            n2 = this.array2Bytes.length + this.booleanValue.getBytes(n, n2, byArray, n2, byArray.length - n2);
            this.array2Bytes = byArray;
        }
        this.findColumn = n2;
    }

    public void putNull(int n) {
        this.array2Bytes[this.doubleToRawLongBits >> 3] = (byte)(this.array2Bytes[this.doubleToRawLongBits >> 3] & ~(1 << (this.doubleToRawLongBits - 1 & 7)));
        this.floatValue += this.desiredAssertionStatus[this.doubleToRawLongBits];
        ++this.doubleToRawLongBits;
    }

    public void putNull(int n, int n2) {
        this.array2Bytes[n >> 3] = (byte)(this.array2Bytes[n >> 3] & ~(1 << (n - 1 & 7)));
    }

    public boolean wasNull() {
        return this.arraycopy;
    }

    private int booleanValue(int n) {
        if (n <= 500) {
            return (int)(2.0f * (float)n);
        }
        if (n <= 1000) {
            return (int)(1.5f * (float)n);
        }
        return (int)(1.2f * (float)n);
    }

    public int dataType(String string) throws DSException {
        return this.byteValue.getColumnType(this.byteValue.findColumn(string));
    }

    public int dataType(int n) throws DSException {
        return this.byteValue.getColumnType(n);
    }

    public Object getObject(int n) throws DSException {
        int n2 = this.byteValue.getColumnType(n);
        switch (n2) {
            case -6: {
                return new Byte(this.getByte(n));
            }
            case -7: {
                return new JBoolean(this.getBoolean(n));
            }
            case 5: {
                return new Short(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 3: {
                return this.getBigDecimal(n);
            }
            case 12: {
                return this.getString(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 93: {
                return this.getTimeStamp(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 0x7FFFFFFF: {
                return this.getRelationData(n);
            }
        }
        throw new DSException(6036, new Object[]{Integer.toString(n), Integer.toString(n2)});
    }

    public Object getObject(String string) throws DSException {
        return this.getObject(this.byteValue.findColumn(string));
    }

    void I(JRelation jRelation) throws DSException {
        throw new UnsupportedOperationException();
    }

    public boolean isNull(int n) {
        return (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
    }

    public void pubRelationData(IRelationData iRelationData) throws DSException {
        this.I(iRelationData.createRelation());
    }

    public IRelationData getRelationData(int n) throws DSException {
        return null;
    }

    public void close() throws DSException {
        this.array2Bytes = null;
        this.bytes2Array = null;
    }

    public boolean update(int n) {
        boolean bl = this.booleanValue.updateBytes(n, this.array2Bytes, 0, this.findColumn);
        return bl;
    }

    public void putArray(Array array) throws DSException {
        if (this.getAttribute[this.doubleToRawLongBits].isConstant()) {
            ++this.doubleToRawLongBits;
            return;
        }
        byte[] byArray = ArrayTool.array2Bytes(array);
        this.putBytes(byArray);
    }

    public Array getArray(int n) throws DSException {
        if (this.getAttribute[n].isConstant()) {
            Object object = this.getAttribute[n].getConstant();
            if (object == null) {
                this.arraycopy = true;
                return null;
            }
            this.arraycopy = false;
            return (Array)object;
        }
        boolean bl = this.arraycopy = (this.array2Bytes[n >> 3] & 1 << (n - 1 & 7)) == 0;
        if (this.arraycopy) {
            return null;
        }
        byte[] byArray = this.getBytes(n);
        return byArray == null ? null : ArrayTool.bytes2Array(byArray);
    }

    public static void main(String[] stringArray) {
    }

    public byte[] getRec() {
        return this.array2Bytes;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

