/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.join;

import com.jinfonet.jdbc.join.JoinNode;
import com.jinfonet.jdbc.join.VectorEnumerator;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class JoinVector
implements Cloneable,
Serializable {
    protected JoinNode[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = 1475822639284773727L;

    public JoinVector(int n, int n2) {
        this.elementData = new JoinNode[n];
        this.capacityIncrement = n2;
    }

    public JoinVector(int n) {
        this(n, 0);
    }

    public JoinVector() {
        this(10);
    }

    public final synchronized void copyInto(JoinNode[] joinNodeArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            joinNodeArray[n] = this.elementData[n];
        }
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            JoinNode[] joinNodeArray = this.elementData;
            this.elementData = new JoinNode[this.elementCount];
            System.arraycopy(joinNodeArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        if (n > this.elementData.length) {
            this.QOIV(n);
        }
    }

    private void QOIV(int n) {
        int n2;
        int n3 = this.elementData.length;
        JoinNode[] joinNodeArray = this.elementData;
        int n4 = n2 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
        if (n2 < n) {
            n2 = n;
        }
        this.elementData = new JoinNode[n2];
        System.arraycopy(joinNodeArray, 0, this.elementData, 0, this.elementCount);
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount && n > this.elementData.length) {
            this.QOIV(n);
        } else {
            int n2 = n;
            while (n2 < this.elementCount) {
                this.elementData[n2] = null;
                ++n2;
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final synchronized Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public final boolean contains(JoinNode joinNode) {
        return this.indexOf(joinNode, 0) >= 0;
    }

    public final int indexOf(JoinNode joinNode) {
        return this.indexOf(joinNode, 0);
    }

    public final synchronized int indexOf(JoinNode joinNode, int n) {
        int n2 = n;
        while (n2 < this.elementCount) {
            if (joinNode.equals(this.elementData[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final int lastIndexOf(JoinNode joinNode) {
        return this.lastIndexOf(joinNode, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(JoinNode joinNode, int n) {
        int n2 = n;
        while (n2 >= 0) {
            if (joinNode.equals(this.elementData[n2])) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public final synchronized JoinNode elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final synchronized JoinNode firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized JoinNode lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(JoinNode joinNode, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = joinNode;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final synchronized void insertElementAt(JoinNode joinNode, int n) {
        int n2 = this.elementCount + 1;
        if (n >= n2) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        if (n2 > this.elementData.length) {
            this.QOIV(n2);
        }
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = joinNode;
        ++this.elementCount;
    }

    public final synchronized void addElement(JoinNode joinNode) {
        int n = this.elementCount + 1;
        if (n > this.elementData.length) {
            this.QOIV(n);
        }
        this.elementData[this.elementCount++] = joinNode;
    }

    public final synchronized boolean removeElement(JoinNode joinNode) {
        int n = this.indexOf(joinNode);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        int n = 0;
        while (n < this.elementCount) {
            this.elementData[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            JoinVector joinVector = (JoinVector)super.clone();
            joinVector.elementData = new JoinNode[this.elementCount];
            System.arraycopy(this.elementData, 0, joinVector.elementData, 0, this.elementCount);
            return joinVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        stringBuffer.append("[");
        int n2 = 0;
        while (n2 <= n) {
            String string = enumeration.nextElement().toString();
            stringBuffer.append(string);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

