/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbBinary;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbValue;

public class DbBinaryColumnBuffer
extends DbColumnBuffer {
    byte[][] I;

    public byte[][] getBuffer() {
        return this.I;
    }

    public DbBinaryColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.I = new byte[n][];
    }

    public void updateCell(int n, DbValue dbValue) {
        this.I[n] = ((DbBinary)dbValue).get();
    }

    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbBinary)dbValue).set(this.I[n]);
    }

    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this.I.length) {
            dataOutput.write(this.I[n]);
            ++n;
        }
    }

    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = 0;
        while (n < this.I.length) {
            if (this.I[n].length == 0) {
                this.I[n] = new byte[this.C.precision];
            }
            dataInput.readFully(this.I[n]);
            ++n;
        }
    }

    public void clearMem() {
        super.clearMem();
        this.I = null;
    }
}

