/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbLongColumnBuffer;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;

public class DbTimestampColumnBuffer
extends DbLongColumnBuffer {
    int[] QOIV;

    public int[] getNanos() {
        return this.QOIV;
    }

    public DbTimestampColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.QOIV = new int[n];
    }

    public void updateCell(int n, DbValue dbValue) {
        this.B[n] = ((DbTimestamp)dbValue).get();
        this.QOIV[n] = ((DbTimestamp)dbValue).getNanos();
    }

    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbTimestamp)dbValue).set(this.B[n]);
        ((DbTimestamp)dbValue).setNanos(this.QOIV[n]);
    }

    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        super.writeValueToFile(dataOutput);
        int n = 0;
        while (n < this.QOIV.length) {
            dataOutput.writeInt(this.QOIV[n]);
            ++n;
        }
    }

    protected void readValueFromFile(DataInput dataInput) throws IOException {
        super.readValueFromFile(dataInput);
        int n = 0;
        while (n < this.QOIV.length) {
            this.QOIV[n] = dataInput.readInt();
            ++n;
        }
    }

    public void clearMem() {
        super.clearMem();
        this.QOIV = null;
    }
}

