/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbColDesc;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.datasource.JRHierarchicalDataset;

public class DbTinyInt
extends DbNumber {
    public int value;

    public DbTinyInt() {
    }

    public DbTinyInt(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public int get() {
        return this.value;
    }

    public void set(byte by) {
        this.value = by;
        this.bNull = false;
    }

    public void set(ResultSet resultSet, int n) throws SQLException {
        this.value = resultSet.getByte(n) & 0xFF;
        this.bNull = resultSet.wasNull();
    }

    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        this.value = jRHierarchicalDataset.getByte(n) & 0xFF;
        this.bNull = jRHierarchicalDataset.wasNull();
    }

    public String toString() {
        if (this.bNull) {
            return "NULL";
        }
        return String.valueOf(this.value);
    }

    public Object clone() {
        DbTinyInt dbTinyInt = new DbTinyInt(this.desc);
        dbTinyInt.bNull = this.bNull;
        dbTinyInt.value = this.value;
        return dbTinyInt;
    }

    public boolean equals(DbValue dbValue) {
        DbTinyInt dbTinyInt = (DbTinyInt)dbValue;
        if (dbTinyInt.bNull != this.bNull) {
            return false;
        }
        if (this.bNull) {
            return true;
        }
        return this.value == dbTinyInt.value;
    }

    public int compareTo(DbValue dbValue) {
        DbTinyInt dbTinyInt = (DbTinyInt)dbValue;
        if (dbTinyInt.bNull) {
            if (this.bNull) {
                return 0;
            }
            return 1;
        }
        if (this.bNull) {
            if (dbTinyInt.bNull) {
                return 0;
            }
            return -1;
        }
        if (this.value == dbTinyInt.value) {
            return 0;
        }
        if (this.value < dbTinyInt.value) {
            return -1;
        }
        return 1;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public void set(DbValue dbValue) {
        this.value = ((DbTinyInt)dbValue).value;
        this.bNull = dbValue.bNull;
    }

    public void setValue(DbNumber dbNumber) {
        if (dbNumber instanceof DbTinyInt) {
            this.set(dbNumber);
        } else {
            this.bNull = dbNumber.bNull;
            if (!this.bNull) {
                this.value = dbNumber.byteValue();
            }
        }
    }

    public void setValue(String string) {
        this.value = Byte.parseByte(string);
        this.bNull = false;
    }
}

