/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core.node;

import jet.dataengine.api.DSException;
import jet.dataengine.api.schema.olap.AggregateException;
import jet.dataengine.api.schema.olap.AggregationType;
import jet.dataengine8.olap.core.node.ANode;
import jet.dataengine8.olap.core.node.ICountCalculator;
import jet.dataengine8.olap.util.DataValue;

public abstract class ACalculator {
    protected final ICountCalculator countCalculator;
    protected final int nodeValueIndex;
    protected final int baseType;

    protected ACalculator(ICountCalculator iCountCalculator, int n, int n2) {
        this.countCalculator = iCountCalculator;
        this.nodeValueIndex = n;
        this.baseType = n2;
    }

    public final DataValue calculate(ANode aNode, AggregationType aggregationType, DataValue dataValue) throws DSException {
        if (!aNode.isAggregated()) {
            throw new RuntimeException();
        }
        DataValue dataValue2 = dataValue = dataValue != null ? dataValue : new DataValue(0, null);
        if (aggregationType == AggregationType.SUM) {
            return this.sum(aNode, dataValue);
        }
        if (aggregationType == AggregationType.SQUARESUM) {
            return this.squareSum(aNode, dataValue);
        }
        if (aggregationType == AggregationType.COUNT) {
            return this.count(aNode, dataValue);
        }
        if (aggregationType == AggregationType.MAX) {
            return this.max(aNode, dataValue);
        }
        if (aggregationType == AggregationType.MIN) {
            return this.min(aNode, dataValue);
        }
        if (aggregationType == AggregationType.AVERAGE) {
            return this.average(aNode, dataValue);
        }
        if (aggregationType == AggregationType.DISTINCTCOUNT) {
            return this.distinctCount(aNode, dataValue);
        }
        if (aggregationType == AggregationType.STDDEV) {
            return this.stdDev(aNode, dataValue);
        }
        if (aggregationType == AggregationType.POPULATIONSTDDEV) {
            return this.populationStdDev(aNode, dataValue);
        }
        if (aggregationType == AggregationType.VARIANCE) {
            return this.variance(aNode, dataValue);
        }
        if (aggregationType == AggregationType.POPULATIONVARIANCE) {
            return this.populationVariance(aNode, dataValue);
        }
        throw new AggregateException(3069, new String[]{aggregationType.toString()});
    }

    public final int getBaseType() {
        return this.baseType;
    }

    protected long getCount(ANode aNode) throws DSException {
        return this.countCalculator.count(aNode, this.nodeValueIndex);
    }

    protected DataValue count(ANode aNode, DataValue dataValue) throws DSException {
        dataValue.set(-5, this.getCount(aNode));
        return dataValue;
    }

    protected DataValue distinctCount(ANode aNode, DataValue dataValue) throws DSException {
        long l = this.countCalculator.distinctCount(aNode, this.nodeValueIndex);
        dataValue.set(-5, l);
        return dataValue;
    }

    protected abstract DataValue sum(ANode var1, DataValue var2) throws DSException;

    protected abstract DataValue squareSum(ANode var1, DataValue var2) throws DSException;

    protected abstract DataValue max(ANode var1, DataValue var2) throws DSException, AggregateException;

    protected abstract DataValue min(ANode var1, DataValue var2) throws DSException;

    protected abstract DataValue variance(ANode var1, DataValue var2) throws DSException;

    protected abstract DataValue populationVariance(ANode var1, DataValue var2) throws DSException;

    protected abstract DataValue stdDev(ANode var1, DataValue var2) throws DSException;

    protected abstract DataValue populationStdDev(ANode var1, DataValue var2) throws DSException;

    protected abstract DataValue average(ANode var1, DataValue var2) throws DSException;

    public static int resultType(int n, AggregationType aggregationType) throws DSException {
        if (AggregationType.SUM == aggregationType || AggregationType.SQUARESUM == aggregationType || AggregationType.AVERAGE == aggregationType || AggregationType.STDDEV == aggregationType || AggregationType.POPULATIONSTDDEV == aggregationType || AggregationType.VARIANCE == aggregationType || AggregationType.POPULATIONVARIANCE == aggregationType) {
            switch (n) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    return -5;
                }
                case 6: 
                case 8: {
                    return 8;
                }
                case 3: {
                    return 3;
                }
            }
            throw new DSException(3028, new String[]{String.valueOf(n)});
        }
        if (AggregationType.COUNT == aggregationType) {
            return -5;
        }
        if (AggregationType.MAX == aggregationType) {
            return n;
        }
        if (AggregationType.MIN == aggregationType) {
            return n;
        }
        if (AggregationType.DISTINCTCOUNT == aggregationType) {
            return -5;
        }
        if (AggregationType.PERCENTAGE == aggregationType) {
            return 8;
        }
        throw new RuntimeException();
    }
}

