/*
 * Decompiled with CFR 0.152.
 */
package jet.export.text;

import com.jinfonet.awt.JFont;
import com.jinfonet.util.JRLog;
import com.jinfonet.util.loader.DynamicClassManager;
import guitools.Painter;
import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.bean.TextParameter;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSBody;
import jet.datastream.DSContainer;
import jet.datastream.DSField;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.DSTable;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.util.CCUtil;
import jet.export.util.ExportUtil;
import jet.udo.JRObjectRender;
import jet.udo.TextGeneratable;
import jet.udos.JHyperLinkRslt;
import jet.udos.JHyperlinkLineInfo;
import jet.util.FontSets;
import jet.util.Propertiable;
import jet.util.TextBreaker;

public class ExportToText
extends AbstractExporter {
    public static final String EXP = ".txt";
    private static boolean IsForMail;
    private static boolean QOIV;
    private static String add;
    private boolean addElement;
    private boolean adjustJustifyString;
    private boolean adjustString;
    private boolean append = true;
    private boolean booleanValue;
    private int charAt;
    private int charsHeight;
    private int charsWidth = -1;
    private int checkError;
    private int checkFilePathExist;
    private int checkOutputStream;
    private String checkStop;
    private ArrayList clear;
    private Stack clipString;
    private Stack close;
    private PrintWriter containsKey;
    private Map convertUnitToPixel = new HashMap();
    private Map currentThread = new HashMap();
    private boolean currentTimeMillis = false;
    private boolean deIndent = false;
    private int dx = -1;
    private int dy = Integer.MAX_VALUE;
    private long elementAt = 0L;
    private long empty = 0L;
    private Hashtable endsWith = new Hashtable();

    private void IsForMail() {
        this.currentThread.clear();
        this.currentThread = null;
        this.convertUnitToPixel.clear();
        this.convertUnitToPixel = null;
        this.clear.clear();
        this.clear = null;
        this.endsWith.clear();
        this.endsWith = null;
    }

    public ExportToText(Communicator communicator, TextParameter textParameter) {
        this._commu = communicator;
        this.booleanValue = JRLog.isError(2);
        this.empty(textParameter);
    }

    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        this.checkFilePathExist(string);
        String string2 = string.endsWith(EXP) ? string : string + EXP;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.treatIOException(fileNotFoundException, string2, true);
        }
        this.exportToStream(fileOutputStream);
        try {
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, string2, true);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        return arrayList;
    }

    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
        this.checkOutputStream(outputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            this.QOIV(bufferedOutputStream);
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, null, false);
        }
        this.IsForMail();
    }

    private void QOIV(BufferedOutputStream bufferedOutputStream) throws IOException, ExpException, JRStopEngineException {
        this.waitCommunicator();
        this.currentTimeMillis = this._commu.isHighPrecision();
        long l = System.currentTimeMillis();
        boolean bl = JRLog.isTrace(4);
        if (bl) {
            JRLog.indent("Export to normal text");
            JRLog.trace(4, 4402001, new Timestamp(l));
        }
        if (this.booleanValue) {
            JRLog.indent("Export to normal text error element");
        }
        this._commu();
        CommEnumeration commEnumeration = new CommEnumeration(this._commu);
        this.clear = new ArrayList();
        long l2 = 0L;
        int n = 0;
        while (commEnumeration.hasMoreElements()) {
            if (++n < this.dx) {
                commEnumeration.nextElement();
                continue;
            }
            ExportUtil.checkStop(this._commu);
            this.close.insertElementAt(new Stack(), 0);
            long l3 = System.currentTimeMillis();
            DSPage dSPage = (DSPage)commEnumeration.nextElement();
            long l4 = System.currentTimeMillis();
            l2 += l4 - l3;
            this.addElement(dSPage);
            if (n == this.dy) break;
        }
        try {
            if (this.deIndent) {
                this.checkStop = "UTF-8";
            }
            this.containsKey = new PrintWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, this.checkStop));
            this.add();
            this.containsKey.flush();
            if (this.booleanValue) {
                JRLog.deIndent("Export to normal text error element");
            }
            if (bl) {
                long l5 = System.currentTimeMillis();
                JRLog.trace(4, 4402002, new Timestamp(l5));
                JRLog.trace(4, 4402003, new Long(l5 - l - l2));
                JRLog.trace(4, "To String times(" + this.elementAt + ")");
                JRLog.trace(4, "Get font and get string width and height times(" + this.empty + ")");
                JRLog.deIndent("Export to normal text");
            }
        }
        catch (IOException iOException) {
            this.containsKey.checkError();
            throw iOException;
        }
        if (JRLog.isAd()) {
            JRLog.print("Successed produce the normal text file");
        }
    }

    private void _commu() {
        if (this.charsWidth <= 0) {
            this.charsWidth = this._commu.getResolution();
        }
        this.checkStop = this._commu.getEncoding();
        if (this.checkStop == null) {
            this.checkStop = "UTF-8";
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, 5402006);
            }
        }
        this.charsHeight = Integer.MAX_VALUE;
        this.charAt = Integer.MAX_VALUE;
        this.clipString = new Stack();
        this.close = new Stack();
    }

    private void add() {
        int n = 0;
        int n2 = 0;
        while (!this.close.empty()) {
            int n3;
            int n4;
            Vector<StringBuffer> vector = new Vector<StringBuffer>();
            Stack stack = (Stack)this.close.pop();
            n = Integer.parseInt((String)this.clear.get(n2++));
            n = this.dy(n);
            while (!stack.empty()) {
                TextBlock textBlock = (TextBlock)stack.pop();
                int n5 = this.charsHeight * textBlock.B.length();
                n4 = textBlock.C;
                n4 = n4 < 10 ? (n4 - 1) % 3 : 3;
                switch (n4) {
                    case 1: {
                        textBlock.x += (textBlock.I - n5) / 2;
                        break;
                    }
                    case 2: {
                        textBlock.x += textBlock.I - n5;
                    }
                }
                switch (textBlock.C) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 11: {
                        textBlock.y += (textBlock.Z - this.charAt) / 2;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: {
                        textBlock.y += textBlock.Z - this.charAt;
                    }
                }
                textBlock.x = textBlock.x < 0 ? 0 : textBlock.x;
                textBlock.y = textBlock.y < 0 ? 0 : textBlock.y;
                int n6 = this.elementAt(textBlock.x);
                int n7 = this.dy(textBlock.y);
                int n8 = n7 - vector.size();
                while (n8 >= 0) {
                    vector.addElement(new StringBuffer());
                    --n8;
                }
                StringBuffer stringBuffer = (StringBuffer)vector.elementAt(n7);
                n3 = n6 - stringBuffer.length();
                while (n3 > 0) {
                    stringBuffer.append(' ');
                    --n3;
                }
                int n9 = n6;
                while (n9 < stringBuffer.length() && n9 < n6 + textBlock.B.length()) {
                    stringBuffer.setCharAt(n9, textBlock.B.charAt(n9 - n6));
                    ++n9;
                }
                int n10 = stringBuffer.length();
                while (n10 < n6 + textBlock.B.length()) {
                    stringBuffer.append(textBlock.B.charAt(n10 - n6));
                    ++n10;
                }
            }
            n4 = 0;
            while (n4 < vector.size()) {
                StringBuffer stringBuffer = (StringBuffer)vector.elementAt(n4);
                if (this.adjustString && stringBuffer.length() > 0 || !this.adjustString) {
                    this.deIndent(stringBuffer);
                }
                this.containsKey.print(stringBuffer.toString());
                ++n4;
            }
            if (this.adjustString) continue;
            StringBuffer stringBuffer = new StringBuffer();
            n3 = n - vector.size();
            while (n3 >= 0) {
                this.deIndent(stringBuffer);
                --n3;
            }
            this.containsKey.print(stringBuffer.toString());
        }
    }

    private void addElement(DSPage dSPage) {
        this.clipString.push(new Offset(0, 0));
        this.clear.add(String.valueOf(this.getFont(dSPage.getPageArea().height)));
        int n = 0;
        while (n < dSPage.size()) {
            JRObjectResult jRObjectResult = this.currentTimeMillis(dSPage.getObject(n));
            int n2 = jRObjectResult.getObjectType();
            if (this.dx(jRObjectResult)) {
                if ((n2 & 0x200) == 512) {
                    this.adjustJustifyString((DSSection)jRObjectResult, 0);
                } else if (n2 == 262177) {
                    this.adjustJustifyString((DSBody)jRObjectResult, 0);
                }
            }
            ++n;
        }
        this.clipString.pop();
    }

    private void adjustJustifyString(DSContainer dSContainer, int n) {
        int n2 = dSContainer.getStartYPos();
        JRObjectResult jRObjectResult = null;
        Vector vector = dSContainer.getChildren();
        int n3 = vector.size();
        this.clipString.push(new Offset((Offset)this.clipString.peek(), this.getFont(dSContainer.getX()), this.getFont(this.getY(dSContainer, n))));
        int n4 = 0;
        while (n4 < n3) {
            jRObjectResult = this.currentTimeMillis((JRObjectResult)vector.get(n4));
            this.adjustString(jRObjectResult, n2);
            ++n4;
        }
        this.clipString.pop();
    }

    private void adjustString(JRObjectResult jRObjectResult, int n) {
        if (this.dx(jRObjectResult)) {
            int n2 = jRObjectResult.getObjectType();
            if ((n2 & 0x20) == 32) {
                if (n2 == 262179) {
                    this.charAt((DSTableObject)jRObjectResult, n);
                } else if (n2 == 262178) {
                    this.append((DSParagraph)jRObjectResult, n);
                } else {
                    this.adjustJustifyString((DSContainer)jRObjectResult, n);
                }
            } else if (n2 == 524291) {
                this.charsWidth((DSParagraphText)jRObjectResult, n);
            } else if ((n2 & 0x100) == 256 && ((DSField)jRObjectResult).getStartLine() != -1) {
                this.checkFilePathExist((DSField)jRObjectResult, n);
            } else if (n2 == 4096) {
                this.containsKey((JRVisiableResult)jRObjectResult, n);
            } else if ((n2 & 0x200) == 512) {
                this.adjustJustifyString((DSSection)jRObjectResult, n);
            } else if (jRObjectResult instanceof DSContainer) {
                this.adjustJustifyString((DSContainer)jRObjectResult, n);
            } else if (JRLog.isAd()) {
                JRLog.print("now, can not treat this type! Type : " + n2 + " object is : " + jRObjectResult + " the parent : " + jRObjectResult.getParent());
            }
        }
    }

    private void append(DSParagraph dSParagraph, int n) {
        Cloneable cloneable;
        int n2;
        int n3;
        int n4;
        Object object;
        JRObjectResult jRObjectResult = null;
        Vector vector = dSParagraph.getChildren();
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        int n5 = vector.size();
        this.clipString.push(new Offset((Offset)this.clipString.peek(), this.getFont(dSParagraph.getX()), this.getFont(this.getY(dSParagraph, n))));
        int n6 = 0;
        int n7 = dSParagraph.getStartYPos();
        Vector vector2 = new Vector();
        int n8 = 0;
        while (n8 < n5) {
            jRObjectResult = (JRObjectResult)vector.get(n8);
            n6 = jRObjectResult.getObjectType();
            if (n6 == 524291) {
                object = (DSParagraphText)jRObjectResult;
                n4 = this.getFont(this.getY((JRVisiableResult)object, n7));
                n3 = this.getFont(((JRVisiableResult)object).getHeight());
                n2 = ((JRVisiableResult)object).getX();
                this.booleanValue(n2, n4, n3, ((DSParagraphText)object).getText(), vector2);
            } else if ((n6 & 0x100) == 256 && ((DSField)jRObjectResult).getStartLine() == 0 && this.checkError((DSField)jRObjectResult)) {
                object = (DSField)jRObjectResult;
                if (CCUtil.getIntPropertyByName((JRObjectResult)object, "position") == 3) {
                    arrayList.add(object);
                } else {
                    n4 = this.getFont(this.getY((JRVisiableResult)object, n7));
                    n3 = this.getFont(((JRVisiableResult)object).getHeight());
                    n2 = ((JRVisiableResult)object).getX();
                    this.booleanValue(n2, n4, n3, ((DSField)object).toString(), vector2);
                }
            }
            ++n8;
        }
        object = (Offset)this.clipString.peek();
        n4 = this.getFont(dSParagraph.getWidth());
        n3 = 0;
        n2 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < vector2.size()) {
            int n11;
            Object object2;
            cloneable = (Vector)vector2.get(n10);
            Vector<Object> vector3 = new Vector<Object>(((Vector)cloneable).size());
            int n12 = 0;
            while (n12 < ((Vector)cloneable).size()) {
                object2 = (TextBlock)((Vector)cloneable).get(n12);
                if (vector3.isEmpty()) {
                    vector3.add(object2);
                } else {
                    n11 = 0;
                    while (n11 < vector3.size()) {
                        if (((TextBlock)object2).x < ((TextBlock)vector3.get((int)n11)).x) break;
                        ++n11;
                    }
                    if (n11 < vector3.size()) {
                        vector3.insertElementAt(object2, n11);
                    } else {
                        vector3.add(object2);
                    }
                }
                ++n12;
            }
            object2 = "";
            n11 = 0;
            while (n11 < vector3.size()) {
                if (n11 == 0) {
                    TextBlock textBlock = (TextBlock)vector3.get(n11);
                    n3 = this.getFont(textBlock.x);
                    n2 = textBlock.y;
                    n9 = textBlock.Z;
                }
                object2 = (String)object2 + ((TextBlock)vector3.get((int)n11)).B;
                ++n11;
            }
            n3 += ((Offset)object).dx;
            n2 += ((Offset)object).dy;
            if (((String)object2).length() != 0) {
                this.close(n3, n2, n4, n9, (String)object2, n4, n9, -1);
            }
            ++n10;
        }
        int n13 = 0;
        while (n13 < arrayList.size()) {
            cloneable = (DSField)arrayList.get(n13);
            if (((DSField)cloneable).getStartLine() != -1) {
                this.checkFilePathExist((DSField)cloneable, n7);
            }
            ++n13;
        }
        this.clipString.pop();
    }

    private void booleanValue(int n, int n2, int n3, String string, Vector vector) {
        Vector vector2 = new Vector();
        Vector<TextBlock> vector3 = new Vector<TextBlock>();
        Vector vector4 = new Vector();
        if (vector.isEmpty()) {
            vector2 = new Vector();
            vector2.addElement(new TextBlock(this, n, n2, n3, string));
            vector.addElement(vector2);
        } else {
            TextBlock textBlock;
            boolean bl = true;
            int n4 = 0;
            while (n4 < vector.size()) {
                vector2 = (Vector)vector.get(n4);
                TextBlock textBlock2 = (TextBlock)vector2.get(0);
                if (n2 == textBlock2.y) {
                    vector2.addElement(new TextBlock(this, n, n2, n3, string));
                    bl = false;
                    break;
                }
                if (n2 >= textBlock2.y - n3 / 2 && n2 < textBlock2.y + n3 / 2 && textBlock2.y + textBlock2.Z > n2) {
                    vector2.addElement(new TextBlock(this, n, n2, n3, string));
                    bl = false;
                    break;
                }
                vector3 = new Vector();
                vector3.addElement(new TextBlock(this, n, n2, n3, string));
                if (n4 == 0 && n2 <= textBlock2.y - n3 / 2) {
                    vector.insertElementAt(vector3, 0);
                    bl = false;
                    break;
                }
                if (n4 == vector.size() - 1 && (n2 > textBlock2.y + n3 / 2 || n2 >= textBlock2.y + textBlock2.Z)) {
                    vector.addElement(vector3);
                    bl = false;
                    break;
                }
                if (n4 > 0) {
                    vector4 = (Vector)vector.elementAt(n4 - 1);
                    textBlock = (TextBlock)vector4.elementAt(0);
                    if (n2 > textBlock.y + n3 / 2 && n2 <= textBlock2.y - n3 / 2) {
                        vector.insertElementAt(vector3, n4);
                        bl = false;
                        break;
                    }
                }
                ++n4;
            }
            if (bl) {
                int n5 = 0;
                while (n5 < vector.size()) {
                    vector2 = (Vector)vector.elementAt(n5);
                    textBlock = (TextBlock)vector2.elementAt(0);
                    if (textBlock.y > n2) {
                        vector3 = new Vector();
                        vector3.addElement(new TextBlock(this, n, n2, n3, string));
                        vector.insertElementAt(vector3, n5);
                        break;
                    }
                    ++n5;
                }
            }
        }
    }

    private void charAt(DSTableObject dSTableObject, int n) {
        this.clipString.push(new Offset((Offset)this.clipString.peek(), this.getFont(dSTableObject.getX()), this.getFont(this.getY(dSTableObject, n))));
        Vector vector = dSTableObject.getChildren();
        int n2 = vector.size();
        int n3 = dSTableObject.getStartYPos();
        int n4 = 0;
        while (n4 < n2) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(n4);
            if (jRObjectResult instanceof DSTableRow) {
                DSTableRow dSTableRow = (DSTableRow)jRObjectResult;
                this.charsHeight(dSTableRow, n3);
            }
            ++n4;
        }
        this.clipString.pop();
    }

    private void charsHeight(DSTableRow dSTableRow, int n) {
        this.clipString.push(new Offset((Offset)this.clipString.peek(), this.getFont(dSTableRow.getX()), this.getFont(this.getY(dSTableRow, n))));
        Vector vector = dSTableRow.getChildren();
        int n2 = vector.size();
        int n3 = dSTableRow.getStartYPos();
        int n4 = 0;
        while (n4 < n2) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(n4);
            this.adjustString(jRObjectResult, n3);
            ++n4;
        }
        this.clipString.pop();
    }

    private void charsWidth(DSParagraphText dSParagraphText, int n) {
        Offset offset = (Offset)this.clipString.peek();
        int n2 = this.getFont(dSParagraphText.getX() + dSParagraphText.getTextX()) + offset.dx;
        int n3 = this.getFont(dSParagraphText.getTextY() + dSParagraphText.getY()) + offset.dy;
        int n4 = this.getFont(dSParagraphText.getWidth());
        int n5 = this.getFont(dSParagraphText.getHeight());
        String string = dSParagraphText.getText();
        Font font = null;
        String string2 = this.get(dSParagraphText, "FontFace");
        int n6 = 0;
        if (this.getEndLine(dSParagraphText, "Bold")) {
            n6 |= 1;
        }
        if (this.getEndLine(dSParagraphText, "Italic")) {
            n6 |= 2;
        }
        int n7 = this.getFont(this.getClass(dSParagraphText, "FontSize"));
        font = FontSets.getFont(string2, n6, n7);
        int n8 = TextBreaker.charsWidth(string, font, this.currentTimeMillis);
        int n9 = (int)((double)TextBreaker.charsHeight(string, font, this.currentTimeMillis) + 0.5);
        this.close(n2, n3, n4, n5, string, n8, n9, -1);
    }

    protected int getRenderType(DSField dSField) {
        Propertiable propertiable = dSField.getPropertyByName("renderType");
        if (propertiable != null) {
            return (Integer)propertiable.getObject();
        }
        return 0;
    }

    private boolean checkError(DSField dSField) {
        int n = this.getRenderType(dSField);
        return n == 0 || n == 4;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkFilePathExist(DSField var1_1, int var2_2) {
        block30: {
            block29: {
                var3_3 = System.currentTimeMillis();
                var5_4 = var1_1.toString();
                var6_5 = System.currentTimeMillis();
                this.elementAt += var6_5 - var3_3;
                if (var5_4.length() == 0) {
                    return;
                }
                var15_6 = (Offset)this.clipString.peek();
                var3_3 = System.currentTimeMillis();
                var16_7 = this.clipString(var1_1);
                var8_8 = this.getFont(var1_1.getX()) + var15_6.dx;
                var9_9 = this.getFont(this.getY(var1_1, var2_2)) + var15_6.dy;
                var10_10 = this.getFont(var1_1.getWidth());
                var11_11 = this.getFont(var1_1.getHeight());
                var14_12 = this.convertUnitToPixel(var1_1);
                var17_13 = (Integer)this.endsWith.get(var16_7);
                if (var17_13 != null) {
                    var13_14 = var17_13;
                } else {
                    var13_14 = (int)((double)TextBreaker.charsHeight(var5_4, var16_7, this.currentTimeMillis) + 0.5);
                    var17_13 = new Integer(var13_14);
                    this.endsWith.put(var16_7, var17_13);
                }
                var6_5 = System.currentTimeMillis();
                this.empty += var6_5 - var3_3;
                if (var13_14 <= 0) {
                    return;
                }
                var18_15 = this.checkStop(var14_12);
                if (var11_11 < var13_14) {
                    var11_11 = var13_14;
                }
                var19_16 = this.checkOutputStream(var1_1);
                if (var1_1.isTextobjFieldable()) {
                    var5_4 = TextBreaker.clipString(var5_4, var16_7, var18_15, var10_10, this.currentTimeMillis);
                    var12_17 = var19_16 == 0 ? var10_10 : TextBreaker.charsWidth(var5_4, var16_7, this.currentTimeMillis);
                    this.close(var8_8, var9_9, var10_10, var11_11, var5_4, var12_17, var13_14, var14_12);
                    return;
                }
                var21_21 = var1_1.getLineBreakPos();
                if (var21_21 == null) break block29;
                var5_4 = Painter.adjustString(var5_4);
                var22_22 = var1_1.getStartLine();
                var23_24 = var1_1.getEndLine();
                v0 = var24_26 = Math.min(var21_21.length - 1, var23_24) < 0 ? 0 : Math.min(var21_21.length - 1, var23_24);
                if (var22_22 < 0 && var23_24 < 0) {
                    var24_26 = 1;
                }
                var22_22 = var22_22 < 0 ? 0 : var22_22;
                var25_27 = var24_26 - var22_22 + 1;
                var26_28 = var22_22;
                if (true) ** GOTO lbl114
            }
            if (var1_1.getObjectType() != 260 || this.getChildren(var1_1, "FieldType") != 14) break block30;
            var22_23 = true;
            if (true) ** GOTO lbl126
        }
        if (var1_1.getObjectType() == 257) {
            var5_4 = TextBreaker.clipString(var5_4, var16_7, var18_15, var10_10, this.currentTimeMillis);
        }
        if (var19_16 == 0) {
            var12_20 = var10_10;
        } else {
            var12_20 = TextBreaker.charsWidth(var5_4, var16_7, this.currentTimeMillis);
            if (var12_20 > var10_10) {
                var10_10 = var12_20;
            }
        }
        this.close(var8_8, var9_9, var10_10, var11_11, var5_4, var12_20, var13_14, var14_12);
        return;
        do {
            block28: {
                block31: {
                    var20_29 = "";
                    try {
                        if (var5_4 != null && var5_4.length() != 0) {
                            var20_29 = var21_21[var26_28][1] + var21_21[var26_28][0] < var5_4.length() ? var5_4.substring(var21_21[var26_28][0], var21_21[var26_28][0] + var21_21[var26_28][1]) : var5_4.substring(var21_21[var26_28][0], var5_4.length());
                        }
                    }
                    catch (Exception var27_31) {
                        if (JRLog.isTrace(5)) {
                            JRLog.trace(5, var27_31);
                        }
                        if (this.listeners == null) break block28;
                        var28_33 = 0;
                        if (true) ** GOTO lbl86
                    }
                    var12_18 = TextBreaker.charsWidth(var20_29, var16_7, this.currentTimeMillis);
                    v1 = var27_32 = var22_22 == var23_24;
                    if (var27_32 || var14_12 <= 9) break block31;
                    var28_33 = var20_29.length();
                    var29_34 = true;
                    var30_35 = var20_29.toCharArray();
                    var31_36 = 0;
                    if (true) ** GOTO lbl91
                    do {
                        this.listeners[var28_33].noteError(Thread.currentThread(), var27_31, 0, "");
                        ++var28_33;
lbl86:
                        // 2 sources

                    } while (var28_33 < this.listeners.length);
                    break block28;
                    do {
                        var29_34 &= var30_35[var31_36] == ' ' || var30_35[var31_36] == '\n';
                        ++var31_36;
lbl91:
                        // 2 sources

                    } while (var29_34 && var31_36 < var30_35.length);
                    if (var26_28 == var24_26) {
                        var29_34 = true;
                    }
                    if (!var29_34) {
                        while ((var28_33 = var20_29.length()) > 0 && var20_29.charAt(var28_33 - 1) == ' ') {
                            var20_29 = var20_29.substring(0, var20_29.length() - 1);
                        }
                        while (var28_33 > 0 && var20_29.charAt(0) == ' ') {
                            var20_29 = var20_29.substring(1);
                            var28_33 = var20_29.length();
                        }
                        var32_37 = var20_29.indexOf(32);
                        if (var32_37 > 0 && var32_37 < var20_29.length() - 1) {
                            var33_38 = TextBreaker.charsWidth(" ", var16_7, this.currentTimeMillis);
                            while ((var12_18 = TextBreaker.charsWidth(var20_29, var16_7, this.currentTimeMillis)) < var10_10 - var33_38) {
                                var34_39 = (var10_10 - var12_18) / var33_38;
                                var20_29 = Painter.adjustJustifyString(var20_29, var34_39);
                            }
                        }
                        var12_18 = TextBreaker.charsWidth(var20_29, var16_7, this.currentTimeMillis);
                    }
                }
                this.clear(var8_8, var9_9, var10_10, var11_11, var20_29, var12_18, var13_14, var14_12, var25_27, var26_28 - var22_22);
            }
            ++var26_28;
lbl114:
            // 2 sources

        } while (var26_28 <= var24_26);
        return;
        do {
            if (!var22_23) {
                var9_9 += var13_14;
            } else {
                var22_23 = false;
            }
            var20_30 = TextBreaker.clipString(var5_4.substring(0, ++var23_25), var16_7, var18_15, var10_10, this.currentTimeMillis);
            var12_19 = TextBreaker.charsWidth(var20_30, var16_7, this.currentTimeMillis);
            this.close(var8_8, var9_9, var10_10, var13_14, var20_30, var12_19, var13_14, var14_12);
            var5_4 = var5_4.substring(var23_25);
            var9_9 += var13_14;
lbl126:
            // 2 sources

        } while ((var23_25 = var5_4.indexOf(44)) != -1);
        if (var5_4.length() <= 0) return;
        if (!var22_23) {
            var9_9 += var13_14;
        }
        var5_4 = TextBreaker.clipString(var5_4, var16_7, var18_15, var10_10, this.currentTimeMillis);
        var12_19 = var19_16 == 0 ? var10_10 : TextBreaker.charsWidth(var5_4, var16_7, this.currentTimeMillis);
        this.close(var8_8, var9_9, var10_10, var22_23 != false ? var11_11 : var13_14, var5_4, var12_19, var13_14, var14_12);
    }

    private int checkOutputStream(DSField dSField) {
        return CCUtil.getIntPropertyByName(dSField, "HorizontalAlignment");
    }

    private int checkStop(int n) {
        int n2 = n < 10 ? (n - 1) % 3 : 3;
        return n2;
    }

    private void clear(int n, int n2, int n3, int n4, String string, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        if (string.length() <= 0) {
            return;
        }
        int n11 = n6 - n4;
        if (n11 > 0 && n11 < n4 / 2) {
            n6 = n4;
        } else {
            n10 = 0;
            switch (n7) {
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    n10 = (n4 - n6 * n8) / 2;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    n10 = n4 - n6 * n8;
                }
            }
            n2 = n2 + n10 + n6 * n9;
        }
        int n12 = n7 < 10 ? (n7 - 1) % 3 : 3;
        switch (n12) {
            case 1: {
                n += (n3 - n5) / 2;
                break;
            }
            case 2: {
                n += n3 - n5;
            }
        }
        n3 = n5;
        n4 = n6;
        n10 = n3 / string.length();
        this.charsHeight = n10 < this.charsHeight ? n10 : this.charsHeight;
        this.charAt = n6 < this.charAt ? n6 : this.charAt;
        ((Stack)this.close.elementAt(0)).insertElementAt(new TextBlock(this, n, n2, n3, n4, n7, string, this.checkOutputStream), 0);
    }

    private Font clipString(DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Font font = (Font)this.convertUnitToPixel.get(dSTemplatible);
        if (font == null) {
            boolean bl = true;
            String string = this.flush(dSField, "FontFace");
            int n = 0;
            if (this.getEncoding(dSField, "Bold")) {
                n |= 1;
            }
            if (this.getEncoding(dSField, "Italic")) {
                n |= 2;
            }
            int n2 = this.getFont(this.getChildren(dSField, "FontSize"));
            font = FontSets.getFont(string, n, n2);
            if (this.currentThread.containsKey(dSTemplatible)) {
                bl = (Boolean)this.currentThread.get(dSTemplatible);
            } else {
                if (CCUtil.isChangeByFormularProperty(dSField, "FontFace") || CCUtil.isChangeByFormularProperty(dSField, "Bold") || CCUtil.isChangeByFormularProperty(dSField, "Italic")) {
                    bl = false;
                }
                this.currentThread.put(dSTemplatible, bl);
            }
            if (bl) {
                this.convertUnitToPixel.put(dSTemplatible, font);
            }
        }
        return font;
    }

    private void close(int n, int n2, int n3, int n4, String string, int n5, int n6, int n7) {
        int n8 = n6 - n4;
        if (n8 > 0 && n8 < n4 / 2) {
            n6 = n4;
        }
        if (string.length() > 0 && n4 - n6 / 2 > 0) {
            int n9 = n7 < 10 ? (n7 - 1) % 3 : 3;
            switch (n9) {
                case 1: {
                    n += (n3 - n5) / 2;
                    break;
                }
                case 2: {
                    n += n3 - n5;
                }
            }
            n3 = n5;
            switch (n7) {
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    n2 += (n4 - n6) / 2;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    n2 += n4 - n6;
                }
            }
            n4 = n6;
            int n10 = n3 / string.length();
            this.charsHeight = n10 < this.charsHeight ? n10 : this.charsHeight;
            this.charAt = n6 < this.charAt ? n6 : this.charAt;
            ((Stack)this.close.elementAt(0)).insertElementAt(new TextBlock(this, n, n2, n3, n4, n7, string, this.checkOutputStream), 0);
        }
    }

    private void containsKey(JRVisiableResult jRVisiableResult, int n) {
        JRObjectRender jRObjectRender;
        String string = null;
        boolean bl = jRVisiableResult instanceof TextGeneratable;
        try {
            jRObjectRender = (JRObjectRender)DynamicClassManager.getInstance().getClass((String)jRVisiableResult.getPropertyByName("UDORenderName").getObject()).newInstance();
        }
        catch (Exception exception) {
            jRObjectRender = null;
        }
        if (jRObjectRender != null) {
            jRObjectRender.setProperty(jRVisiableResult);
            if (bl) {
                string = ((TextGeneratable)((Object)jRVisiableResult)).toText();
                if (string == null || string.length() == 0) {
                    return;
                }
                Offset offset = (Offset)this.clipString.peek();
                int n2 = this.getFont(jRVisiableResult.getX()) + offset.dx;
                int n3 = this.getFont(this.getY(jRVisiableResult, n)) + offset.dy;
                int n4 = this.getFont(jRVisiableResult.getWidth());
                int n5 = this.getFont(jRVisiableResult.getHeight());
                Font font = FontSets.getFont((String)jRVisiableResult.getPropertyByName("FontFace").getObject(), 0 | ((Boolean)jRVisiableResult.getPropertyByName("Bold").getObject() != false ? 1 : 0) | ((Boolean)jRVisiableResult.getPropertyByName("Italic").getObject() != false ? 2 : 0), this.getFont((Integer)jRVisiableResult.getPropertyByName("FontSize").getObject()));
                int n6 = (Integer)jRVisiableResult.getPropertyByName("Alignment").getObject();
                boolean bl2 = font instanceof JFont;
                int n7 = TextBreaker.charsWidth(string, font, this.currentTimeMillis);
                int n8 = (int)((double)TextBreaker.charsHeight(string, font, this.currentTimeMillis) + 0.5);
                int n9 = this.checkStop(n6);
                string = TextBreaker.clipString(string, font, n9, n4, this.currentTimeMillis);
                n7 = TextBreaker.charsWidth(string, font, this.currentTimeMillis);
                this.close(n2, n3, n4, n5, string, n7, n8, n6);
            } else if (jRVisiableResult instanceof JHyperLinkRslt) {
                JHyperLinkRslt jHyperLinkRslt = (JHyperLinkRslt)jRVisiableResult;
                List list = jHyperLinkRslt.getLines();
                Offset offset = (Offset)this.clipString.peek();
                int n10 = this.getFont(jRVisiableResult.getX()) + offset.dx;
                int n11 = this.getFont(this.getY(jRVisiableResult, n)) + offset.dy;
                int n12 = this.getFont(jRVisiableResult.getWidth());
                int n13 = this.getFont(jRVisiableResult.getHeight());
                if (list != null && list.size() != 0) {
                    Font font = FontSets.getFont((String)jRVisiableResult.getPropertyByName("fontFace").getObject(), 0 | ((Boolean)jRVisiableResult.getPropertyByName("fontBold").getObject() != false ? 1 : 0) | ((Boolean)jRVisiableResult.getPropertyByName("fontItalic").getObject() != false ? 2 : 0), this.getFont((Integer)jRVisiableResult.getPropertyByName("fontSize").getObject()));
                    int n14 = this.convertUnitToPixel(jRVisiableResult);
                    int n15 = list.size();
                    int n16 = this.checkStop(n14);
                    if (n15 > 1) {
                        int n17 = 0;
                        while (n17 < n15) {
                            JHyperlinkLineInfo jHyperlinkLineInfo = (JHyperlinkLineInfo)list.get(n17);
                            String string2 = jHyperlinkLineInfo.getLine();
                            int n18 = TextBreaker.charsWidth(string2, font, this.currentTimeMillis);
                            int n19 = (int)((double)TextBreaker.charsHeight(string2, font, this.currentTimeMillis) + 0.5);
                            this.clear(n10, n11, n12, n13, string2, n18, n19, n14, n15, n17);
                            ++n17;
                        }
                    } else {
                        JHyperlinkLineInfo jHyperlinkLineInfo = (JHyperlinkLineInfo)list.get(0);
                        string = jHyperlinkLineInfo.getLine();
                        string = TextBreaker.clipString(string, font, n16, n12, this.currentTimeMillis);
                        int n20 = TextBreaker.charsWidth(string, font, this.currentTimeMillis);
                        int n21 = (int)((double)TextBreaker.charsHeight(string, font, this.currentTimeMillis) + 0.5);
                        this.close(n10, n11, n12, n13, string, n20, n21, n14);
                    }
                }
            }
        }
    }

    private int convertUnitToPixel(JRVisiableResult jRVisiableResult) {
        int n = CCUtil.getIntPropertyByName(jRVisiableResult, "HorizontalAlignment");
        int n2 = CCUtil.getIntPropertyByName(jRVisiableResult, "VerticalAlignment");
        int n3 = 5;
        switch (n) {
            case 2: {
                if (n2 == 1) {
                    n3 = 2;
                    break;
                }
                if (n2 == 0) {
                    n3 = 5;
                    break;
                }
                n3 = 8;
                break;
            }
            case 0: {
                if (n2 == 1) {
                    n3 = 1;
                    break;
                }
                if (n2 == 0) {
                    n3 = 4;
                    break;
                }
                n3 = 7;
                break;
            }
            case 1: {
                if (n2 == 1) {
                    n3 = 3;
                    break;
                }
                if (n2 == 0) {
                    n3 = 6;
                    break;
                }
                n3 = 9;
                break;
            }
            default: {
                n3 = n2 == 1 ? 10 : (n2 == 0 ? 11 : 12);
            }
        }
        return n3;
    }

    private int getY(JRVisiableResult jRVisiableResult, int n) {
        if (jRVisiableResult.getParent() instanceof DSPage) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult instanceof DSTable) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult.getStartYPos() == 0) {
            return jRVisiableResult.getY() - n;
        }
        if (!(jRVisiableResult instanceof DSSection)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        if (jRVisiableResult.getStartYPos() != 0) {
            JRObjectResult jRObjectResult;
            int n4 = 0;
            if (jRVisiableResult instanceof DSSection && ((jRObjectResult = (JRObjectResult)((Object)((DSSection)jRVisiableResult).getParent())).getObjectType() == 45 || jRObjectResult.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded"))) {
                n4 = Math.max(0, ((DSSection)jRVisiableResult).getY() - ((DSSubReport)jRObjectResult).getStartYPos());
            }
            n3 = (n2 = n4) > 0 ? n2 : 0;
        }
        return n3;
    }

    private boolean currentThread(JRObjectResult jRObjectResult) {
        boolean bl;
        boolean bl2 = bl = !this.getEncoding(jRObjectResult, "Invisible");
        if (bl) {
            if (jRObjectResult.getObjectType() == 262178) {
                bl = true;
            } else if (((JRVisiableResult)jRObjectResult).getWidth() <= 0 || ((JRVisiableResult)jRObjectResult).getHeight() <= 0) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2402104, String.valueOf(((JRVisiableResult)jRObjectResult).getObjectType()));
                    JRLog.error(2, 2402105, ((JRVisiableResult)jRObjectResult).getWidth() + "*" + ((JRVisiableResult)jRObjectResult).getHeight());
                }
                bl = false;
            }
        }
        return bl;
    }

    private JRObjectResult currentTimeMillis(JRObjectResult jRObjectResult) {
        JRObjectResult jRObjectResult2 = jRObjectResult;
        int n = jRObjectResult.getObjectType();
        while (n == 8192) {
            jRObjectResult2 = ((DSReference)jRObjectResult2).getRefData();
            n = jRObjectResult2.getObjectType();
        }
        return jRObjectResult2;
    }

    private void deIndent(StringBuffer stringBuffer) {
        if (this.adjustJustifyString) {
            if (this.addElement) {
                stringBuffer.append("\r\n");
            } else {
                stringBuffer.append("\n");
            }
        } else {
            stringBuffer.append(add);
        }
    }

    private boolean dx(JRObjectResult jRObjectResult) {
        boolean bl = jRObjectResult instanceof JRVisiableResult;
        if (bl) {
            int n = jRObjectResult.getObjectType();
            if (n == 40) {
                return false;
            }
            bl = this.currentThread(jRObjectResult);
            if (bl) {
                switch (n) {
                    case 513: 
                    case 514: 
                    case 515: 
                    case 2561: 
                    case 2563: {
                        if (!this.append) {
                            DSContainer dSContainer = (DSContainer)jRObjectResult;
                            this.checkOutputStream -= this.getFont(dSContainer.getHeight());
                        }
                    }
                    case 516: 
                    case 517: 
                    case 518: 
                    case 2562: 
                    case 2564: {
                        bl = this.append;
                        break;
                    }
                    case 34: {
                        break;
                    }
                    case 33: 
                    case 37: 
                    case 45: {
                        bl = !((DSSubReport)jRObjectResult).isError();
                        break;
                    }
                    case 264: {
                        bl = false;
                        break;
                    }
                    case 262183: {
                        bl = false;
                        break;
                    }
                }
            }
        }
        return bl;
    }

    private int dy(int n) {
        if (QOIV && this.checkError > this.charAt) {
            this.charAt = this.checkError;
        }
        return Math.round((float)n / (float)this.charAt);
    }

    private int elementAt(int n) {
        if (IsForMail && this.checkFilePathExist > this.charsHeight) {
            this.charsHeight = this.checkFilePathExist;
        }
        if (this.charsHeight < 1) {
            return n;
        }
        return Math.round((float)n / (float)this.charsHeight);
    }

    private void empty(TextParameter textParameter) {
        if (textParameter != null) {
            this.endsWith(textParameter.isForWinExport());
            this.append = textParameter.isHasHeadFoot();
            this.exportToStream(textParameter.getResolution());
            this.error(textParameter.getUDCHWidth(), textParameter.getUDCHHeight());
            this.adjustString = textParameter.isCompress();
            this.deIndent = textParameter.IsForMail();
            if (JRLog.isTrace(5)) {
                JRLog.indent("normal text parameters");
                JRLog.trace(5, 5402001, "" + textParameter.isHasHeadFoot());
                JRLog.trace(5, 5402002, "" + textParameter.isForWinExport());
                JRLog.trace(5, 5402003, "" + textParameter.getResolution());
                JRLog.trace(5, 5402004, "" + textParameter.getUDCHWidth() + "*" + textParameter.getUDCHHeight());
                JRLog.trace(5, 5402005, "" + textParameter.isCompress());
                JRLog.deIndent("normal text parameters");
            }
        } else if (JRLog.isTrace(5)) {
            JRLog.indent("normal text parameters, it use default parameter");
            JRLog.deIndent("normal text parameters, it use default parameter");
        }
    }

    private void endsWith(boolean bl) {
        this.addElement = bl;
        this.adjustJustifyString = true;
    }

    private void error(int n, int n2) {
        if (n < 0 && n2 > 0) {
            this.checkError = n2;
            QOIV = true;
        }
        if (n > 0 && n2 < 0) {
            this.checkFilePathExist = n;
            IsForMail = true;
        }
        if (n > 0 && n2 > 0 && n < 11) {
            this.checkFilePathExist = n;
            this.checkError = n2;
            IsForMail = true;
            QOIV = true;
        }
    }

    private void exportToStream(int n) {
        if (n > 0) {
            this.charsWidth = n;
        }
    }

    private String flush(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getStringPropertyByName(jRObjectResult, string);
    }

    private String get(JRObjectResult jRObjectResult, String string) {
        return ((String)jRObjectResult.getPropertyByName(string).getObject()).trim();
    }

    private int getChildren(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    private int getClass(JRObjectResult jRObjectResult, String string) {
        return ((Number)jRObjectResult.getPropertyByName(string).getObject()).intValue();
    }

    private boolean getEncoding(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    private boolean getEndLine(JRObjectResult jRObjectResult, String string) {
        return (Boolean)jRObjectResult.getPropertyByName(string).getObject();
    }

    private int getFont(int n) {
        return Unit.convertUnitToPixel(n, this.charsWidth);
    }

    static {
        add = System.getProperty("line.separator");
    }

    private class TextBlock {
        int x;
        int y;
        int I;
        int Z;
        int C;
        String B;
        private final ExportToText this$0;

        TextBlock(ExportToText exportToText, int n, int n2, int n3, int n4, int n5, String string, int n6) {
            this.this$0 = exportToText;
            this.x = n;
            this.y = n2;
            this.I = n3;
            this.Z = n4;
            this.C = n5;
            this.B = string;
        }

        TextBlock(ExportToText exportToText, int n, int n2, int n3, String string) {
            this.this$0 = exportToText;
            this.x = n;
            this.y = n2;
            this.Z = n3;
            this.B = string;
        }
    }
}

