/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.controls.JetBLColumnName;
import jet.controls.JetBLColumnVector;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetColumnName;
import jet.controls.JetColumnVector;
import jet.controls.JetEnumeration;
import jet.controls.JetFont;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.controls.JetStringList;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.datastream.DSTemplatible;
import jet.datastream.TextobjFieldable;
import jet.naming.EnumerationConstant;
import jet.naming.PropertyNameConstant;
import jet.report.JRObjectTemplate;
import jet.report.JetLink;
import jet.report.JetRptBox;
import jet.textobj.ChrObj;
import jet.textobj.ExtGraphics;
import jet.textobj.Field;
import jet.textobj.FieldDest;
import jet.textobj.Obj;
import jet.textobj.RtfDest;
import jet.util.CharBuf;
import jet.util.HashVector;
import jet.util.JStringToolKit;

public abstract class JetRptField
extends JetRptBox
implements Field,
TextobjFieldable {
    public static final String[] JOINOP = new String[]{"=", ">", ">=", "<", "<=", "<>"};
    public static final String[] LOGIC = new String[]{"AND", "OR", "END"};
    public static final int REPORTDES_REPORSET = 0;
    public static final int REPORTDES_REPORT = 1;
    public static final int REPORTDES_VIEW = 2;
    public static final int FILTEROPTIONS_ALL = 0;
    public static final int FILTEROPTIONS_TOPN = 1;
    public static final int FILTEROPTIONS_BOTTOMN = 2;
    public static final int FILTEROPTIONS_MORE = 3;
    public static final int FILTEROPTIONS_DEFAULT = 4;
    public static final int POPUP_WINDOW_VALUE_DEFAULT = 0;
    public static final int POPUP_WINDOW_VALUE_TRUE = 1;
    public static final int POPUP_WINDOW_VALUE_FALSE = 2;
    public static final String POPUP_WINDOW_KEY_DEFAULT = EnumerationConstant.POPUP_WINDOW[0];
    public static final String POPUP_WINDOW_KEY_TRUE = EnumerationConstant.POPUP_WINDOW[1];
    public static final String POPUP_WINDOW_KEY_FALSE = EnumerationConstant.POPUP_WINDOW[2];
    public JetColor patternColor;
    public JetColor fontColor;
    public JetFont fontName;
    public JetUnitNumber fontSize;
    public JetBoolean bold;
    public JetBoolean italic;
    public JetBoolean strikeout;
    public JetBoolean underline;
    public JetEnumeration align;
    public JetEnumeration patternStyle;
    public JetStringList format;
    public JetUnitNumber maxWidth;
    public JetBoolean autoFit;
    public JetBoolean wordWrap;
    public JetBoolean transWhileToHtml;
    public JetBoolean enableHyperlinkOnPDF;
    public JetBoolean enableHyperlinkOnExcel;
    public JetBoolean enableHyperlinkOnHTML;
    public JetLink link;
    public JetString detailRpt;
    public JetString detailJoin;
    public JetString joinOp;
    public JetColumnName masterJoin;
    public JetVector detailCols;
    public JetVector ops;
    public JetVector logics;
    public JetVector paraInDetail;
    public JetColumnVector masterCols;
    public JetColumnVector paraValInMaster;
    public JetBoolean sameEnc;
    public JetString linkCatalog;
    public JetBoolean gotoDetail;
    private JetStringList DETAIL_REPORT_EDITOR;
    public JetBLColumnName blDetailJoin;
    public JetBLColumnName blMasterJoin;
    public JetBLColumnVector blDetailCols;
    public JetBLColumnVector blMasterCols;
    public JetEnumeration HAlignment;
    public JetEnumeration VAlignment;
    public JetVector linkTargetCompInst;
    public JetVector detailTargetCompInst;
    public JetEnumeration linkURLTargetFrame;
    public JetString cusTargetFrame;
    private JetEnumeration POPUP_WINDOW;
    public JetBoolean transferStyle;
    private JetString append;
    private JetString black;
    private JetString booleanValue;
    private JetString copyJetPropToTxt;
    private JetString copyJetPropsToTxt;
    private JetNumber copyTxtPropToJet;
    private Color dup;
    private String duplicatePropGrpsDesc;
    private Font elementAt;
    private boolean endsWith;
    private boolean equals;
    private boolean equalsIgnoreCase;
    boolean fieldUpdated = false;
    public JetBoolean exportToPDF;
    private FieldDest get;
    private boolean getCurrentRender = false;
    private RtfDest getIndecialMap;
    private ChrObj getIntValue;
    private ChrObj getJetRptMode;
    public static final String JET_FIELD_INST_HEADER = "JetField_";
    static Hashtable getNameByID = new Hashtable();
    static Hashtable getObjectType = new Hashtable();
    private static HashMap getParent;

    public JetRptField() {
        this.JOINOP();
        this.LOGIC();
        this.setObjectType(256);
    }

    public void afterInit() {
        super.afterInit();
        if (this.gotoDetail.isChangeByOther() || this.gotoDetail.booleanValue()) {
            this.DETAIL_REPORT_EDITOR.setEditFlag(2);
        } else {
            this.DETAIL_REPORT_EDITOR.setEditFlag(0);
        }
    }

    public void setTxtOwner(FieldDest fieldDest) {
        this.get = fieldDest;
    }

    public FieldDest getTxtOwner() {
        return this.get;
    }

    public void setRtf(RtfDest rtfDest) {
        this.getIndecialMap = rtfDest;
    }

    public RtfDest getRtf() {
        return this.getIndecialMap;
    }

    public void ownerUpdated() {
    }

    public boolean isFixedField() {
        return this.getCurrentRender;
    }

    public void paint(ExtGraphics extGraphics) {
    }

    public Dimension getSize() {
        return null;
    }

    public void setSize(Dimension dimension) {
    }

    public static int getJetRtfId(String string) {
        int n = string.indexOf(" \\*");
        int n2 = string.indexOf(JET_FIELD_INST_HEADER);
        int n3 = Integer.valueOf(string.substring(n2 + 9, n));
        return n3;
    }

    public ChrObj getInst() {
        if (this.getIntValue == null) {
            this.DEFAULT_FONTSIZE();
            if (this.getIntValue.hasProp("chrfmt.fs")) {
                String string = "" + (double)this.getIntValue.getIntValue("chrfmt.fs") / 2.0;
                this.getIntValue.setPropValue("chrfmt.fs", string, this.getIndecialMap);
            }
        }
        return this.getIntValue;
    }

    void DEFAULT_FONTSIZE() {
        this.getIntValue = ChrObj.newChrObj(null, new CharBuf(JET_FIELD_INST_HEADER + this.rtfId.get() + " \\* "));
        JetRptField.copyJetPropsToTxt(this, this.getIntValue, this.getIndecialMap);
    }

    public ChrObj getRslt() {
        if (this.getJetRptMode == null) {
            this.DETAIL_REPORT_EDITOR();
            if (this.getJetRptMode.hasProp("chrfmt.fs")) {
                String string = "" + (double)this.getJetRptMode.getIntValue("chrfmt.fs") / 2.0;
                this.getJetRptMode.setPropValue("chrfmt.fs", string, this.getIndecialMap);
            }
        }
        return this.getJetRptMode;
    }

    void DETAIL_REPORT_EDITOR() {
        String string = this.format.get();
        if (string == null || string.length() == 0) {
            string = "[Null Field]";
        }
        this.getJetRptMode = ChrObj.newChrObj(null, new CharBuf(string));
        JetRptField.copyJetPropsToTxt(this, this.getJetRptMode, this.getIndecialMap);
    }

    public void propsUpdated(Vector vector) {
        if (this.get == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (getNameByID.get(string) != null) {
                bl = true;
                if (this.getIntValue == null) {
                    this.DEFAULT_FONTSIZE();
                } else {
                    JetRptField.copyJetPropToTxt(this, string, this.getIntValue, this.getIndecialMap);
                }
                if (this.getJetRptMode == null) {
                    this.DETAIL_REPORT_EDITOR();
                } else {
                    JetRptField.copyJetPropToTxt(this, string, this.getJetRptMode, this.getIndecialMap);
                }
            } else if (string.equalsIgnoreCase("Format")) {
                bl2 = true;
                this.DETAIL_REPORT_EDITOR();
                bl = true;
            } else if (string.equalsIgnoreCase("RTFID")) {
                this.DEFAULT_FONTSIZE();
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this.get.fieldUpdated(bl2);
        }
    }

    public void refreshField() {
        this.DEFAULT_FONTSIZE();
        this.DETAIL_REPORT_EDITOR();
        this.get.fieldUpdated(false);
    }

    public static final void copyJetPropToTxt(DSTemplatible dSTemplatible, String string, Obj obj, RtfDest rtfDest) {
        String string2 = (String)getNameByID.get(string);
        String string3 = string2.equals("chrfmt.fs") ? Integer.toString(((JetUnitNumber)dSTemplatible.getPropertyByName(string)).getUnit() / 80) : dSTemplatible.getPropertyByName(string).toString();
        if (string3 != null && obj.hasProp(string2)) {
            obj.setPropValue(string2, string3, rtfDest);
        }
    }

    public static final void copyTxtPropToJet(Obj obj, String string, JetObject jetObject, RtfDest rtfDest) {
        String string2 = (String)getObjectType.get(string);
        JetProperty jetProperty = jetObject.nameToProperty(string2);
        if (jetProperty != null && obj.hasProp(string)) {
            String string3 = obj.getPropValue(string, rtfDest);
            if (string3 != null && string3.length() > 0) {
                if (string.equals("chrfmt.fs")) {
                    try {
                        int n = Integer.parseInt(string3);
                        ((JetUnitNumber)jetProperty).setUnitValue(n * 80);
                    }
                    catch (NumberFormatException numberFormatException) {
                        jetProperty.set(string3);
                    }
                } else {
                    jetProperty.set(string3);
                }
            } else if (string.endsWith("cb")) {
                jetProperty.set("Transparent");
            }
        }
    }

    public static void copyJetPropsToTxt(DSTemplatible dSTemplatible, Obj obj, RtfDest rtfDest) {
        Enumeration enumeration = getNameByID.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JetRptField.copyJetPropToTxt(dSTemplatible, string, obj, rtfDest);
        }
    }

    public static void copyTxtPropsToJet(Obj obj, JetObject jetObject, RtfDest rtfDest) {
        Enumeration enumeration = getObjectType.keys();
        while (enumeration.hasMoreElements()) {
            JetRptField.copyTxtPropToJet(obj, (String)enumeration.nextElement(), jetObject, rtfDest);
        }
    }

    static void HAlignment(String string, String string2) {
        getNameByID.put(string, string2);
        getObjectType.put(string2, string);
    }

    public static String getJetPropName(String string) {
        return (String)getObjectType.get(string);
    }

    public static String getTxtPropName(String string) {
        return (String)getNameByID.get(string);
    }

    public Object clone() {
        return this.dup();
    }

    public boolean isTextobjFieldable() {
        return this.fieldUpdated;
    }

    public void setTextobjFieldable(boolean bl) {
        this.fieldUpdated = bl;
    }

    public boolean isLinkable() {
        return !this.link.isEmpty();
    }

    public JetProperty getLinkProperty() {
        return this.link;
    }

    public Color getForeColor() {
        return this.dup;
    }

    public String getFormat() {
        return this.duplicatePropGrpsDesc;
    }

    public Font getFont() {
        return this.elementAt;
    }

    public boolean getForeByOther() {
        return this.equalsIgnoreCase;
    }

    public boolean getFormatByOther() {
        return this.equals;
    }

    public boolean getFontByOther() {
        return this.endsWith;
    }

    public static final String[] parseRptName(String string) {
        String[] stringArray = new String[3];
        String[] stringArray2 = JStringToolKit.splitString(string, "~'@~");
        int n = 0;
        while (n < stringArray2.length) {
            if (n == 3) break;
            stringArray[n] = stringArray2[n];
            ++n;
        }
        return stringArray;
    }

    public static final String assembleRptName(String string, String string2, String string3) {
        String string4 = "";
        if (string == null) {
            string = "";
        }
        string4 = string4 + string;
        if (string2 == null) {
            string2 = "";
        }
        string4 = string4 + "~'@~" + string2 + "~'@~";
        if (string3 == null) {
            string3 = "";
        }
        string4 = string4 + string3;
        return string4;
    }

    public HashMap getIndecialMap() {
        if (getParent != null) {
            return getParent;
        }
        getParent = new HashMap();
        HashMap hashMap = super.getIndecialMap();
        getParent.putAll(hashMap);
        int n = hashMap.size();
        getParent.put("EnableHyperlinkOnPDF", new Integer(n++));
        getParent.put("EnableHyperlinkOnExcel", new Integer(n++));
        getParent.put("EnableHyperlinkOnHTML", new Integer(n++));
        getParent.put("Link", new Integer(n++));
        getParent.put("DetailReport", new Integer(n++));
        getParent.put("DetailJoin", new Integer(n++));
        getParent.put("JoinOP", new Integer(n++));
        getParent.put("MasterJoin", new Integer(n++));
        getParent.put("DetailCols", new Integer(n++));
        getParent.put("Operators", new Integer(n++));
        getParent.put("MasterCols", new Integer(n++));
        getParent.put("Logics", new Integer(n++));
        getParent.put("SameEncode", new Integer(n++));
        getParent.put("ParaInDetail", new Integer(n++));
        getParent.put("ParaValueInMaster", new Integer(n++));
        getParent.put("LinkCatalog", new Integer(n++));
        getParent.put("GotoDetail", new Integer(n++));
        getParent.put("BLDetailJoin", new Integer(n++));
        getParent.put("BLMasterJoin", new Integer(n++));
        getParent.put("BLDetailCols", new Integer(n++));
        getParent.put("BLMasterCols", new Integer(n++));
        getParent.put("HorizontalAlignment", new Integer(n++));
        getParent.put("VerticalAlignment", new Integer(n++));
        getParent.put("LinkTargetComponent", new Integer(n++));
        getParent.put("DetailTargetComponent", new Integer(n++));
        getParent.put("LinkURLTargetFrame", new Integer(n++));
        getParent.put("PopUpNewWindow", new Integer(n++));
        getParent.put("TransferStyle", new Integer(n++));
        getParent.put("HrefLang", new Integer(n++));
        getParent.put("ExternalAccessKey", new Integer(n++));
        getParent.put("ExternalDir", new Integer(n++));
        getParent.put("ExternalTabIndex", new Integer(n++));
        getParent.put("LongDesc", new Integer(n++));
        getParent.put("ExternalTitle", new Integer(n++));
        getParent.put("ExportToPDF", new Integer(n++));
        getParent.put("PatternColor", new Integer(n++));
        getParent.put("Foreground", new Integer(n++));
        getParent.put("FontFace", new Integer(n++));
        getParent.put("FontSize", new Integer(n++));
        getParent.put("Bold", new Integer(n++));
        getParent.put("Italic", new Integer(n++));
        getParent.put("StrikeOut", new Integer(n++));
        getParent.put("Underline", new Integer(n++));
        getParent.put("Alignment", new Integer(n++));
        getParent.put("PatternStyle", new Integer(n++));
        getParent.put("Format", new Integer(n++));
        getParent.put("MaxWidth", new Integer(n++));
        getParent.put("AutoFit", new Integer(n++));
        getParent.put("WordWrap", new Integer(n++));
        getParent.put("TransWhileToHtml", new Integer(n++));
        getParent.put("CusTargetFrame", new Integer(n++));
        getParent.put("DetailTargetFrame", new Integer(n++));
        return getParent;
    }

    private void JOINOP() {
        this.enableHyperlinkOnPDF = new JetBoolean(this, "EnableHyperlinkOnPDF", true);
        this.enableHyperlinkOnExcel = new JetBoolean(this, "EnableHyperlinkOnExcel", true);
        this.enableHyperlinkOnHTML = new JetBoolean(this, "EnableHyperlinkOnHTML", true);
        this.link = new JetLink(this, "Link");
        this.detailRpt = new JetString(this, "DetailReport");
        this.detailJoin = new JetString(this, "DetailJoin");
        this.joinOp = new JetString(this, "JoinOP");
        this.masterJoin = new JetColumnName(this, "MasterJoin");
        this.detailCols = new JetVector(this, "DetailCols");
        this.ops = new JetVector(this, "Operators");
        this.masterCols = new JetColumnVector(this, "MasterCols");
        this.logics = new JetVector(this, "Logics");
        this.sameEnc = new JetBoolean(this, "SameEncode", true);
        this.paraInDetail = new JetVector(this, "ParaInDetail");
        this.paraValInMaster = new JetColumnVector(this, "ParaValueInMaster");
        this.linkCatalog = new JetString(this, "LinkCatalog");
        this.gotoDetail = new JetBoolean(this, "GotoDetail", true);
        this.DETAIL_REPORT_EDITOR = new JetStringList(this, "DetailTargetFrame", "");
        this.blDetailJoin = new JetBLColumnName(this, "BLDetailJoin");
        this.blMasterJoin = new JetBLColumnName(this, "BLMasterJoin");
        this.blDetailCols = new JetBLColumnVector(this, "BLDetailCols");
        this.blMasterCols = new JetBLColumnVector(this, "BLMasterCols");
        this.HAlignment = new JetEnumeration(this, PropertyNameConstant.getNameByID(979), 2);
        this.VAlignment = new JetEnumeration(this, PropertyNameConstant.getNameByID(1760), 6);
        this.linkTargetCompInst = new JetVector(this, "LinkTargetComponent");
        this.detailTargetCompInst = new JetVector(this, "DetailTargetComponent");
        this.linkURLTargetFrame = new JetEnumeration(this, "LinkURLTargetFrame", 65);
        this.cusTargetFrame = new JetString(this, "CusTargetFrame");
        this.POPUP_WINDOW = new JetEnumeration(this, "PopUpNewWindow", 79);
        this.transferStyle = new JetBoolean(this, "TransferStyle");
        this.detailRpt.setEditorType(JetProperty.DETAIL_REPORT_EDITOR);
        this.link.setTransient(true);
        this.topPadding.set(2);
        this.bottomPadding.set(2);
        this.leftPadding.set(2);
        this.rightPadding.set(2);
        this.linkURLTargetFrame.set(new Integer(0));
        this.POPUP_WINDOW.set(new Integer(0));
        this.HAlignment.set(new Integer(2));
        this.VAlignment.set(new Integer(0));
        this.append = new JetString(this, "HrefLang");
        this.black = new JetString(this, "ExternalAccessKey");
        this.booleanValue = new JetString(this, "ExternalDir");
        this.copyTxtPropToJet = new JetNumber(this, "ExternalTabIndex");
        this.copyJetPropToTxt = new JetString(this, "LongDesc");
        this.copyJetPropsToTxt = new JetString(this, "ExternalTitle");
        this.exportToPDF = new JetBoolean(this, "ExportToPDF", true);
        Vector<String> vector = new Vector<String>();
        vector.add("");
        vector.add("_self");
        vector.add("_top");
        vector.add("_blank");
        vector.add("_parent");
        this.DETAIL_REPORT_EDITOR.setList(vector);
        this.DETAIL_REPORT_EDITOR.setCanChangeByOthers(false);
        this.DETAIL_REPORT_EDITOR.setCanChangeByBL(false);
        this.DETAIL_REPORT_EDITOR.setCanChangeByFmtt(false);
        this.DETAIL_REPORT_EDITOR.set("_self");
    }

    private void LOGIC() {
        this.patternColor = new JetColor(this, "PatternColor", Color.black, false);
        this.fontColor = new JetColor(this, "Foreground", Color.black);
        this.fontName = new JetFont(this, "FontFace");
        this.fontSize = new JetUnitNumber(this, "FontSize");
        this.bold = new JetBoolean(this, "Bold", false);
        this.italic = new JetBoolean(this, "Italic", false);
        this.strikeout = new JetBoolean(this, "StrikeOut", false);
        this.underline = new JetBoolean(this, "Underline", false);
        this.align = new JetEnumeration(this, "Alignment", 0);
        this.patternStyle = new JetEnumeration(this, "PatternStyle", 78);
        this.format = new JetStringList(this, "Format");
        this.maxWidth = new JetUnitNumber(this, "MaxWidth", 0);
        this.autoFit = new JetBoolean(this, "AutoFit", false);
        this.wordWrap = new JetBoolean(this, "WordWrap", false);
        this.transWhileToHtml = new JetBoolean(this, "TransWhileToHtml", true);
        this.patternStyle.set(new Integer(0));
        this.top.set(new Integer(0));
        this.bottom.set(new Integer(0));
        this.left.set(new Integer(0));
        this.right.set(new Integer(0));
        this.fontSize.setUnitValue(JRObjectTemplate.DEFAULT_FONTSIZE);
        this.align.set(new Integer(5));
        this.autoFit.setTransient(true);
        this.maxWidth.setTransient(true);
        this.x.setCanChangeByOthers(true);
        this.y.setCanChangeByOthers(true);
        this.width.setCanChangeByOthers(true);
        this.height.setCanChangeByOthers(true);
    }

    protected HashVector specialCaseOfPropGrps(HashVector hashVector) {
        if (!this.bEditable) {
            return null;
        }
        JetObject jetObject = (JetObject)((Object)this.getParent());
        if (jetObject != null && jetObject instanceof JRObjectTemplate) {
            JRObjectTemplate jRObjectTemplate = (JRObjectTemplate)jetObject;
            if (jRObjectTemplate.getObjectType() == 262180) {
                HashVector hashVector2 = JetObject.duplicatePropGrpsDesc(hashVector);
                hashVector2.remove("TOC");
                if (this.getJetRptMode() == null) {
                    return hashVector2;
                }
                int n = this.getJetRptMode().getCurrentRender().getRenderType();
                if (n == 0 || n == 2 || n == 3 || n == 1) {
                    Vector vector = (Vector)hashVector2.get("Others");
                    vector.remove("ExportToPDF");
                }
                return hashVector2;
            }
            if (jRObjectTemplate.getObjectType() == 262183) {
                HashVector hashVector3 = JetObject.duplicatePropGrpsDesc(hashVector);
                hashVector3.remove("Border");
                hashVector3.remove("Color");
                hashVector3.remove("Pattern");
                hashVector3.remove("Geometry");
                hashVector3.remove("Excel");
                hashVector3.remove("TOC");
                Vector vector = (Vector)hashVector3.get("TextFormat");
                vector.remove("AutoFit");
                vector.remove("Bold");
                vector.remove("FontFace");
                vector.remove("FontSize");
                vector.remove("Italic");
                vector.remove("MaxWidth");
                vector.remove("StrikeOut");
                vector.remove("Underline");
                vector.remove("WordWrap");
                vector.remove("TransWhileToHtml");
                vector = (Vector)hashVector3.get("Others");
                vector.remove("clear");
                vector.remove("display");
                vector.remove("float");
                vector.remove("position");
                vector.remove("id");
                vector.remove("class");
                vector.remove("SuppressedIfNull");
                vector.remove("Invisible");
                vector.remove("ExportToPDF");
                return hashVector3;
            }
            if (jRObjectTemplate.getObjectType() == 524293) {
                Vector vector;
                HashVector hashVector4 = JetObject.duplicatePropGrpsDesc(hashVector);
                if (this.position.intValue() == 0) {
                    vector = (Vector)hashVector4.get("Geometry");
                    vector.remove("X");
                    vector.remove("Y");
                    hashVector4.remove("TOC");
                    if (this.getJetRptMode() != null && this.getJetRptMode().getCurrentRender().getRenderType() == 0) {
                        vector = (Vector)hashVector4.get("Geometry");
                        vector.remove("Width");
                        vector.remove("Height");
                        vector = (Vector)hashVector4.get("TextFormat");
                        vector.remove("HorizontalAlignment");
                        vector.remove("VerticalAlignment");
                    }
                    if (this.display.intValue() == 1) {
                        hashVector4.remove("Border");
                        hashVector4.remove("Padding");
                    }
                    vector = (Vector)hashVector4.get("TextFormat");
                    vector.remove("WordWrap");
                    if (this.getJetRptMode() != null && this.getJetRptMode().getCurrentRender().getRenderType() != 3) {
                        vector.remove("AutoFit");
                    }
                } else {
                    hashVector4.remove("TOC");
                    if (this.getJetRptMode() != null && this.getJetRptMode().getCurrentRender().getRenderType() != 0) {
                        hashVector4.remove("Padding");
                    }
                    if (this.position.intValue() == 2) {
                        if (this.getJetRptMode() == null || this.getJetRptMode().getCurrentRender().getRenderType() != 0) {
                            vector = (Vector)hashVector4.get("TextFormat");
                            vector.remove("WordWrap");
                        }
                    } else {
                        vector = (Vector)hashVector4.get("TextFormat");
                        vector.remove("WordWrap");
                    }
                }
                if (this.getJetRptMode() == null) {
                    return hashVector4;
                }
                int n = this.getJetRptMode().getCurrentRender().getRenderType();
                if (n == 0 || n == 2 || n == 3 || n == 1) {
                    Vector vector2 = (Vector)hashVector4.get("Others");
                    vector2.remove("ExportToPDF");
                }
                return hashVector4;
            }
            if (this.getJetRptMode() == null) {
                return hashVector;
            }
            int n = this.getJetRptMode().getCurrentRender().getRenderType();
            HashVector hashVector5 = JetObject.duplicatePropGrpsDesc(hashVector);
            if (n != 0) {
                hashVector5.remove("Padding");
                Vector vector = (Vector)hashVector5.get("TextFormat");
                vector.remove("WordWrap");
                if (n != 3) {
                    vector.remove("AutoFit");
                }
                if (n == 2 || n == 3 || n == 1) {
                    vector = (Vector)hashVector5.get("Others");
                    vector.remove("ExportToPDF");
                }
                return hashVector5;
            }
            Vector vector = (Vector)hashVector5.get("Others");
            vector.remove("ExportToPDF");
            return hashVector5;
        }
        return hashVector;
    }

    public short getFontFaceChangeByType() {
        if (this.fontName == null) {
            return -1;
        }
        short s = 0;
        if (this.fontName.isChangeByOther()) {
            s = 1;
        }
        if (this.fontName.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.fontName.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    public short getFontSizeChangeByType() {
        if (this.fontSize == null) {
            return -1;
        }
        short s = 0;
        if (this.fontSize.isChangeByOther()) {
            s = 1;
        }
        if (this.fontSize.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.fontSize.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    public short getBoldChangeByType() {
        if (this.bold == null) {
            return -1;
        }
        short s = 0;
        if (this.bold.isChangeByOther()) {
            s = 1;
        }
        if (this.bold.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.bold.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    public short getItalicChangeByType() {
        if (this.italic == null) {
            return -1;
        }
        short s = 0;
        if (this.italic.isChangeByOther()) {
            s = 1;
        }
        if (this.italic.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.italic.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    public short getUnderlineChangeByType() {
        if (this.underline == null) {
            return -1;
        }
        short s = 0;
        if (this.underline.isChangeByOther()) {
            s = 1;
        }
        if (this.underline.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.underline.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    public short getForegroundChangeByType() {
        if (this.fontColor == null) {
            return -1;
        }
        short s = 0;
        if (this.fontColor.isChangeByOther()) {
            s = 1;
        }
        if (this.fontColor.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (this.fontColor.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    static {
        JetRptField.HAlignment("Background", "chrfmt.cb");
        JetRptField.HAlignment("Foreground", "chrfmt.cf");
        JetRptField.HAlignment("FontFace", "chrfmt.f");
        JetRptField.HAlignment("FontSize", "chrfmt.fs");
        JetRptField.HAlignment("Bold", "chrfmt.b");
        JetRptField.HAlignment("Italic", "chrfmt.i");
        JetRptField.HAlignment("StrikeOut", "chrfmt.strike");
        JetRptField.HAlignment("Underline", "chrfmt.ul");
        getParent = null;
    }
}

