/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import chart.ChartDefinition;
import chart.data.ChartDataSetModel;
import chart.graphics.ChartFillPattern;
import chart.properties.ChartPlatformProperties;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.controls.JetStringList;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.datastream.JetChartPropertyValues;
import jet.report.JRObjectTemplate;
import jet.report.JetRptObject;
import jet.report.chart.JetChartBackground;
import jet.report.chart.JetChartCreateInfos;
import jet.report.chart.JetChartDefinition;
import jet.report.chart.JetChartGroupInfo;
import jet.report.chart.JetRptChartComponent;
import jet.report.chart.JetRptChartLabel;
import jet.report.chart.JetRptChartLegend;
import jet.report.chart.JetRptChartPaper;
import jet.report.specialFunc.SpecialFunction;
import jet.reportLogic.objectInfo.GroupInfo;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.DataSet;
import jet.reportset.JetRptReport;
import jet.universe.JetUSummary;
import jet.universe.businesslogic.BLNode;
import jet.util.HashVector;
import jet.util.ReportFormat;

public class JetRptChartPlatform
extends JetRptChartComponent {
    public static final int WIDTH_DEF = 500;
    public static final int HEIGHT_DEF = 335;
    public static final int X_DEF = 0;
    public static final int Y_DEF = 0;
    public JetChartDefinition definition;
    public JetUnitNumber topMargin;
    public JetUnitNumber leftMargin;
    public JetUnitNumber rightMargin;
    public JetUnitNumber bottomMargin;
    public JetChartBackground background;
    public JetBoolean autoLayout;
    public JetBoolean showLegend;
    public JetVector patternList;
    public JetBoolean antiAliasing;
    public JetBoolean interactive;
    public JetEnumeration sortCategory;
    public JetEnumeration sortSeries;
    public JetBoolean reverseCategory;
    public JetBoolean reverseSeries;
    public JetNumber categoryStartOffset;
    public JetNumber categoryEndOffset;
    public JetNumber seriesStartOffset;
    public JetNumber seriesEndOffset;
    public JetVector categoryFilter;
    public JetVector seriesFilter;
    public JetVector primaryDataFilter;
    public JetVector secondaryDataFilter;
    public JetVector hintFilter;
    public JetString hyperlink;
    public JetString xhyperlink;
    public JetString zhyperlink;
    public JetStringList hyperlinkTarget;
    public JetStringList xhyperlinkTarget;
    public JetStringList zhyperlinkTarget;
    public JetString section;
    public JetBoolean level;
    public JetNumber columnNum;
    public JetNumber rowNum;
    public JetStringList grpValueFormat;
    public JetStringList serGrpValueFormat;
    public JetVector blCategory;
    public JetVector blSeries;
    public JetVector blValue;
    public JetBoolean gotoDetail;
    public JetBoolean cache;
    public JetBoolean needCreateModel;
    public JetVector runtimeCategory;
    public JetVector runtimeSeries;
    public JetVector runtimeValue;
    public JetBoolean isBVData;
    public JetBoolean swapGroup;
    public JetChartGroupInfo categoryGroupInfo;
    public JetChartGroupInfo seriesGroupInfo;
    public JetVector bindedValues;
    public JetVector bindedPatterns;
    public JetBoolean styleInherit;
    public JetVector styleList;
    public JetString boundDataContainer;
    public JetBoolean haveSeriesSF;
    public JetBoolean haveCategorySF;
    public JetString alt;
    public JetString longDesc;
    public JetString externalTitle;
    public JetVector hintPercentFilter;
    ChartDataSetModel CHART_FILTER_EDITOR = null;
    private static HashMap CHART_FILTER_EDITOR_NO_DATE = null;
    private static final HashVector CHART_PATTERN_LIST_EDITOR = new HashVector(8);

    private void CHART_FILTER_EDITOR() {
        this.bindedValues = new JetVector(this, "BindedValues");
        this.bindedPatterns = new JetVector(this, "BindedPatterns");
        this.topMargin = new JetUnitNumber(this, "TopMargin", JRObjectTemplate.convertSize(0));
        this.leftMargin = new JetUnitNumber(this, "LeftMargin", JRObjectTemplate.convertSize(0));
        this.rightMargin = new JetUnitNumber(this, "RightMargin", JRObjectTemplate.convertSize(0));
        this.bottomMargin = new JetUnitNumber(this, "BottomMargin", JRObjectTemplate.convertSize(0));
        this.background = new JetChartBackground(this, "Platform");
        this.autoLayout = new JetBoolean(this, "AutoLayout", true);
        this.showLegend = new JetBoolean(this, "ShowLegend", true);
        this.patternList = new JetVector(this, "PatternList");
        this.antiAliasing = new JetBoolean(this, "AntiAliasing", true);
        this.interactive = new JetBoolean(this, "Interactive", true);
        this.sortCategory = new JetEnumeration(this, "SortCategory", 88);
        this.sortSeries = new JetEnumeration(this, "SortSeries", 88);
        this.reverseCategory = new JetBoolean(this, "ReverseCategory", false);
        this.reverseSeries = new JetBoolean(this, "ReverseSeries", false);
        this.categoryStartOffset = new JetNumber(this, "CategoryStartOffset", -1);
        this.categoryEndOffset = new JetNumber(this, "CategoryEndOffset", -1);
        this.seriesStartOffset = new JetNumber(this, "SeriesStartOffset", -1);
        this.seriesEndOffset = new JetNumber(this, "SeriesEndOffset", -1);
        this.categoryFilter = new JetVector(this, "CategoryFilter");
        this.seriesFilter = new JetVector(this, "SeriesFilter");
        this.primaryDataFilter = new JetVector(this, "PrimaryDataFilter");
        this.secondaryDataFilter = new JetVector(this, "SecondaryDataFilter");
        this.hintFilter = new JetVector(this, "HintFilter");
        this.hyperlink = new JetString(this, "HyperLink");
        this.xhyperlink = new JetString(this, "XHyperLink");
        this.zhyperlink = new JetString(this, "ZHyperLink");
        this.hintPercentFilter = new JetVector(this, "HintPercentFilter");
        Vector<String> vector = new Vector<String>();
        vector.add("");
        vector.add("_blank");
        vector.add("_top");
        vector.add("_self");
        vector.add("_parent");
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("_blank");
        vector2.add("_top");
        vector2.add("_self");
        vector2.add("_parent");
        Vector<String> vector3 = new Vector<String>();
        vector3.add("");
        vector3.add("_blank");
        vector3.add("_top");
        vector3.add("_self");
        vector3.add("_parent");
        this.hyperlinkTarget = new JetStringList(this, "HyperLinkTarget");
        this.xhyperlinkTarget = new JetStringList(this, "XHyperLinkTarget");
        this.zhyperlinkTarget = new JetStringList(this, "ZHyperLinkTarget");
        this.hyperlinkTarget.setList(vector);
        this.xhyperlinkTarget.setList(vector2);
        this.zhyperlinkTarget.setList(vector3);
        this.section = new JetString(this, "Section");
        this.level = new JetBoolean(this, "SameLevel");
        this.columnNum = new JetNumber(this, "ColumnNumber", 0);
        this.rowNum = new JetNumber(this, "RowNumber", 0);
        this.grpValueFormat = new JetStringList(this, "GroupValueFormat");
        this.serGrpValueFormat = new JetStringList(this, "SeriesValueEncoding");
        this.blCategory = new JetVector(this, "BLCategory");
        this.blSeries = new JetVector(this, "BLSeries");
        this.blValue = new JetVector(this, "BLValue");
        this.gotoDetail = new JetBoolean(this, "GotoDetail", false);
        this.cache = new JetBoolean(this, "Cache", true);
        this.needCreateModel = new JetBoolean(this, "NeedCreateChartDataSetModel", false);
        this.runtimeCategory = new JetVector(this, "RuntimeCategory");
        this.runtimeSeries = new JetVector(this, "RuntimeSeries");
        this.runtimeValue = new JetVector(this, "RuntimeValue");
        this.isBVData = new JetBoolean(this, "IsBVData", false);
        this.swapGroup = new JetBoolean(this, "SwapGroup", false);
        this.categoryGroupInfo = new JetChartGroupInfo(this, "Category");
        this.seriesGroupInfo = new JetChartGroupInfo(this, "Series");
        this.styleInherit = new JetBoolean(this, "StyleInherit", true);
        this.styleList = new JetVector(this, "StyleList");
        this.haveSeriesSF = new JetBoolean(this, "HaveSeriesSpecialFuncation", false);
        this.haveCategorySF = new JetBoolean(this, "HaveCategorySpecialFuncation", false);
        this.boundDataContainer = new JetString(this, "BoundDataContainer");
        this.alt = new JetString(this, "Alt");
        this.longDesc = new JetString(this, "LongDesc");
        this.externalTitle = new JetString(this, "ExternalTitle");
    }

    public JetRptChartPlatform() {
        this(new ChartDefinition());
    }

    public JetRptChartPlatform(JetChartCreateInfos jetChartCreateInfos) {
        this(jetChartCreateInfos.getChartDefinition());
        this.dataSet.setObject(jetChartCreateInfos.getDataset());
        Hashtable hashtable = jetChartCreateInfos.getTitles();
        this.CHART_FILTER_EDITOR_NO_DATE(hashtable);
        ObjectLogicFactory.getDataContainerLogic().setIExpression(this, jetChartCreateInfos.getExpression());
    }

    private void CHART_FILTER_EDITOR_NO_DATE(Hashtable hashtable) {
        String string = (String)hashtable.get(new Integer(1));
        String string2 = (String)hashtable.get(new Integer(2));
        String string3 = (String)hashtable.get(new Integer(3));
        String string4 = (String)hashtable.get(new Integer(4));
        if (string != null) {
            this.afterInit(1, string);
        }
        if (string2 != null) {
            this.afterInit(2, string2);
        }
        if (string3 != null) {
            this.afterInit(3, string3);
        }
        if (string4 != null) {
            this.afterInit(4, string4);
        }
    }

    public JetRptChartPlatform(ChartDefinition chartDefinition) {
        this.CHART_FILTER_EDITOR();
        this.setTemplateIndex(71);
        this.definition = new JetChartDefinition(this, chartDefinition);
        this.isBVData.set(chartDefinition.isBVData());
        Vector vector = ReportFormat.getMoreFormat(12, 0);
        this.grpValueFormat.setList(vector);
        this.grpValueFormat.set((String)vector.elementAt(0));
        this.serGrpValueFormat.setList(vector);
        this.serGrpValueFormat.set((String)vector.elementAt(0));
        this.CHART_PATTERN_LIST_EDITOR();
        this.sortCategory.set("None");
        this.sortSeries.set("None");
        this.categoryFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR);
        this.seriesFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR);
        this.primaryDataFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.secondaryDataFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.hintFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.hintPercentFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.patternList.setEditorType(JetProperty.CHART_PATTERN_LIST_EDITOR);
        this.cache.setCanChangeByOthers(false);
    }

    private void CHART_PATTERN_LIST_EDITOR() {
        this.height.setUnitValue(JRObjectTemplate.convertSize(335));
        this.width.setUnitValue(JRObjectTemplate.convertSize(500));
        this.patternList.set(JetChartPropertyValues.getDefaultPatternString());
        this.background.borderStyle.set("Solid");
        Vector<String> vector = new Vector<String>();
        vector.add("10.00%");
        this.hintPercentFilter.set(vector);
    }

    public void setEditable() {
        super.setEditable();
        this.height.setUnitValue(JRObjectTemplate.convertSize(335));
        this.width.setUnitValue(JRObjectTemplate.convertSize(500));
    }

    public void createChildren() {
        JetRptChartPaper jetRptChartPaper = new JetRptChartPaper();
        JetRptChartLegend jetRptChartLegend = new JetRptChartLegend();
        jetRptChartPaper.setEditable();
        jetRptChartLegend.setEditable();
        this.add(jetRptChartPaper);
        this.add(jetRptChartLegend);
    }

    public ChartDefinition getChartDefinition() {
        ChartDefinition chartDefinition = this.definition.getChartDefinition();
        chartDefinition.setBVData(this.isBVData.get());
        return chartDefinition;
    }

    public ChartDataSetModel createFakeData() {
        this.CHART_FILTER_EDITOR = new ChartDataSetModel();
        double[] dArray = new double[6];
        JetRptChartPaper jetRptChartPaper = this.getPaper();
        if (jetRptChartPaper != null) {
            dArray[0] = jetRptChartPaper.axisX.minValue.doubleValue();
            dArray[1] = jetRptChartPaper.axisX.maxValue.doubleValue();
            dArray[2] = jetRptChartPaper.axisY.minValue.doubleValue();
            dArray[3] = jetRptChartPaper.axisY.maxValue.doubleValue();
            dArray[4] = jetRptChartPaper.axisY2.minValue.doubleValue();
            dArray[5] = jetRptChartPaper.axisY2.maxValue.doubleValue();
        }
        this.CHART_FILTER_EDITOR.createFakeData(this.getChartDefinition(), dArray);
        this.CHART_FILTER_EDITOR.setCategoryFilter(JetChartPropertyValues.mapChartDataFilter(this.categoryFilter));
        this.CHART_FILTER_EDITOR.setSeriesFilter(JetChartPropertyValues.mapChartDataFilter(this.seriesFilter));
        this.CHART_FILTER_EDITOR.setPrimFilter(JetChartPropertyValues.mapChartDataFilter(this.primaryDataFilter));
        this.CHART_FILTER_EDITOR.setSecFilter(JetChartPropertyValues.mapChartDataFilter(this.secondaryDataFilter));
        this.CHART_FILTER_EDITOR.setHintFilter(JetChartPropertyValues.mapChartDataFilter(this.hintFilter));
        this.CHART_FILTER_EDITOR.setHintPercentFilter(JetChartPropertyValues.mapChartDataFilter(this.hintPercentFilter));
        this.CHART_FILTER_EDITOR.setReverseCategory(this.reverseCategory.booleanValue());
        this.CHART_FILTER_EDITOR.setReverseSeries(this.reverseSeries.booleanValue());
        this.CHART_FILTER_EDITOR.setDataWindow(this.categoryStartOffset.intValue(), this.seriesStartOffset.intValue(), this.categoryEndOffset.intValue(), this.seriesEndOffset.intValue());
        this.CHART_FILTER_EDITOR.setSwapGroup(this.swapGroup.booleanValue());
        this.CHART_FILTER_EDITOR.init();
        return this.CHART_FILTER_EDITOR;
    }

    private Map QOIV() {
        Hashtable hashtable = new Hashtable();
        Vector vector = this.bindedValues.get();
        ChartFillPattern[] chartFillPatternArray = JetChartPropertyValues.mapPatterns(this.bindedPatterns);
        int n = 0;
        while (n != vector.size()) {
            hashtable.put(vector.get(n), chartFillPatternArray[n]);
            ++n;
        }
        return hashtable;
    }

    private void add(Map map) {
        if (!map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[map.size()];
            this.bindedValues.clear();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.bindedValues.add(string);
                chartFillPatternArray[n] = (ChartFillPattern)map.get(string);
                ++n;
            }
            this.bindedPatterns.set(JetChartPropertyValues.mapPatternList(chartFillPatternArray));
        }
    }

    public ChartPlatformProperties getChartPlatformProperties() {
        ChartPlatformProperties chartPlatformProperties = new ChartPlatformProperties();
        chartPlatformProperties.setTopMargin(this.topMargin.intValue());
        chartPlatformProperties.setLeftMargin(this.leftMargin.intValue());
        chartPlatformProperties.setRightMargin(this.rightMargin.intValue());
        chartPlatformProperties.setBottomMargin(this.bottomMargin.intValue());
        chartPlatformProperties.setBackground(this.background.getChartBackground());
        chartPlatformProperties.setAutoLayout(this.autoLayout.booleanValue());
        chartPlatformProperties.setShowLegend(this.showLegend.booleanValue());
        chartPlatformProperties.setPatterns(JetChartPropertyValues.mapPatterns(this.patternList));
        chartPlatformProperties.setAntiAliasing(this.antiAliasing.booleanValue());
        chartPlatformProperties.setBindedPatterns(this.QOIV());
        return chartPlatformProperties;
    }

    public void setChartPlatformProperties(ChartPlatformProperties chartPlatformProperties) {
        this.topMargin.set((int)chartPlatformProperties.getTopMargin());
        this.leftMargin.set((int)chartPlatformProperties.getLeftMargin());
        this.rightMargin.set((int)chartPlatformProperties.getRightMargin());
        this.bottomMargin.set((int)chartPlatformProperties.getBottomMargin());
        this.background.setChartBackground(chartPlatformProperties.getBackground());
        this.autoLayout.set(chartPlatformProperties.isAutoLayout());
        this.showLegend.set(chartPlatformProperties.isShowLegend());
        this.patternList.set(JetChartPropertyValues.mapPatternList(chartPlatformProperties.getPatterns()));
        this.add(chartPlatformProperties.getBindedPatterns());
        this.antiAliasing.set(chartPlatformProperties.isAntiAliasing());
        JetRptChartPlatform.applyViewLogic(this);
    }

    public JetRptChartPaper getPaper() {
        Vector vector = this.getChildren();
        JRObjectTemplate jRObjectTemplate = null;
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof JRObjectTemplate && (jRObjectTemplate = (JRObjectTemplate)e).getObjectType() == 72) break;
            ++n;
        }
        return (JetRptChartPaper)jRObjectTemplate;
    }

    public JetRptChartLegend getLegend() {
        Vector vector = this.getChildren();
        JRObjectTemplate jRObjectTemplate = null;
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof JRObjectTemplate && (jRObjectTemplate = (JRObjectTemplate)e).getObjectType() == 70) break;
            ++n;
        }
        return (JetRptChartLegend)jRObjectTemplate;
    }

    public List getLabels() {
        Vector vector = this.getChildren();
        ArrayList<JRObjectTemplate> arrayList = new ArrayList<JRObjectTemplate>();
        JRObjectTemplate jRObjectTemplate = null;
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof JRObjectTemplate && (jRObjectTemplate = (JRObjectTemplate)e).getObjectType() == 69) {
                arrayList.add(jRObjectTemplate);
            }
            ++n;
        }
        return arrayList;
    }

    public String getInstancePrefix() {
        return "ChartObject";
    }

    public ChartDefinition getDefinition() {
        return this.definition.getChartDefinition();
    }

    public void setDefinition(ChartDefinition chartDefinition) {
        this.definition = new JetChartDefinition(this, chartDefinition);
        this.isBVData.set(chartDefinition.isBVData());
        JetRptChartPlatform.applyViewLogic(this);
    }

    public void setCreateInfos(JetChartCreateInfos jetChartCreateInfos) {
        this.definition = new JetChartDefinition(this, jetChartCreateInfos.getChartDefinition());
        this.isBVData.set(jetChartCreateInfos.getChartDefinition().isBVData());
    }

    public Vector getUserDefinedSummary() {
        return new Vector();
    }

    public String[] getMappingNames() {
        ChartDefinition chartDefinition = this.definition.getChartDefinition();
        String string = chartDefinition.getSeries();
        String string2 = chartDefinition.getCategory();
        String[] stringArray = chartDefinition.getIndexedFieldNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 != null) {
            arrayList.add(string2);
        }
        if (string != null) {
            arrayList.add(string);
        }
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = new String[arrayList.size()];
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray2[n2] = (String)arrayList.get(n2);
            ++n2;
        }
        return stringArray2;
    }

    public int getObjectType() {
        return 71;
    }

    private void afterInit(int n, String string) {
        JetRptChartLabel jetRptChartLabel = new JetRptChartLabel();
        jetRptChartLabel.titleType.set(new Integer(n));
        jetRptChartLabel.text.set(string);
        jetRptChartLabel.setChartTitleDefaults(n);
        this.add(jetRptChartLabel);
    }

    public JetRptChartLabel searchChartTitle(int n) {
        JetRptChartLabel jetRptChartLabel = null;
        List list = this.getLabels();
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            JetRptChartLabel jetRptChartLabel2 = (JetRptChartLabel)list.get(n3);
            if (jetRptChartLabel2.titleType.intValue() == n) {
                jetRptChartLabel = jetRptChartLabel2;
                break;
            }
            ++n3;
        }
        return jetRptChartLabel;
    }

    public static final void applyViewLogic(JetRptObject jetRptObject) {
        String[] stringArray = jetRptObject.getPropNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!(stringArray[n2].equalsIgnoreCase("RuntimeSeries") || stringArray[n2].equalsIgnoreCase("RuntimeCategory") || stringArray[n2].equalsIgnoreCase("RuntimeValue"))) {
                JetProperty jetProperty = jetRptObject.nameToProperty(stringArray[n2]);
                ObjectLogicFactory.getViewLogic().setProperty(jetRptObject, jetProperty);
            }
            ++n2;
        }
    }

    public Rectangle reloadPaperBoundsByLegendPlacement(int n) {
        ChartPlatformProperties chartPlatformProperties = this.getChartPlatformProperties();
        int n2 = chartPlatformProperties.getBackground().getBorderStyle();
        int n3 = n2 == 0 ? 0 : (int)chartPlatformProperties.getBackground().getPen().getPenWidth();
        int n4 = this.width.intValue() - 2 * n3;
        int n5 = this.height.intValue() - 2 * n3;
        Rectangle rectangle = new Rectangle(n3, n3, n4, n5);
        Rectangle rectangle2 = this.alt(this.getPaper(), rectangle, n);
        return rectangle2;
    }

    public Rectangle reloadPaperBoundsByShowLegend(boolean bl) {
        ChartPlatformProperties chartPlatformProperties = this.getChartPlatformProperties();
        if (bl) {
            int n = this.getLegend().placement.intValue();
            n = n == 0 ? 2 : n;
            return this.reloadPaperBoundsByLegendPlacement(n);
        }
        int n = chartPlatformProperties.getBackground().getBorderStyle();
        int n2 = n == 0 ? 0 : (int)chartPlatformProperties.getBackground().getPen().getPenWidth();
        int n3 = this.width.intValue() - 2 * n2;
        int n4 = this.height.intValue() - 2 * n2;
        Rectangle rectangle = new Rectangle(n2, n2, n3, n4);
        Rectangle rectangle2 = new Rectangle(rectangle.x + 10, rectangle.y + 10, rectangle.width - 20, rectangle.height - 20);
        return rectangle2;
    }

    private Rectangle alt(JetRptChartPaper jetRptChartPaper, Rectangle rectangle, int n) {
        Rectangle rectangle2 = new Rectangle();
        switch (n) {
            case 2: 
            case 4: {
                rectangle2.setSize((int)((float)(rectangle.width * 12) / 16.0f), (int)((float)(rectangle.height * 15) / 16.0f));
                break;
            }
            case 1: 
            case 3: {
                rectangle2.setSize((int)((float)(rectangle.width * 15) / 16.0f), (int)((float)(rectangle.height * 12) / 16.0f));
                break;
            }
        }
        int n2 = (int)rectangle2.getSize().getWidth();
        int n3 = (int)rectangle2.getSize().getHeight();
        switch (n) {
            case 2: {
                rectangle2.setLocation((rectangle.x + rectangle.width * 12 / 16 - n2) / 2, rectangle.y + (rectangle.height - n3) / 2);
                break;
            }
            case 4: {
                rectangle2.setLocation(rectangle.x + rectangle.width * 4 / 16 + (rectangle.width * 12 / 16 - n2) / 2, rectangle.y + (rectangle.height - n3) / 2);
                break;
            }
            case 1: {
                rectangle2.setLocation(rectangle.x + (rectangle.width - n2) / 2, rectangle.y + rectangle.height * 4 / 16 + (rectangle.height * 12 / 16 - n3) / 2);
                break;
            }
            case 3: {
                rectangle2.setLocation(rectangle.x + (rectangle.width - n2) / 2, rectangle.y + (rectangle.height * 12 / 16 - n3) / 2);
                break;
            }
        }
        return rectangle2;
    }

    public void afterInit() {
        super.afterInit();
        JetRptReport jetRptReport = JetRptReport.getReport(this);
        if (jetRptReport != null) {
            String string = jetRptReport.getResourcePath();
            this.background.fillPattern.imageFile.setPath(string);
        }
    }

    public void setCagegoryGroupInfo(GroupInfo groupInfo) {
        this.categoryGroupInfo.setGroupInfo(groupInfo);
        if (groupInfo.getSpecialFunction() != null) {
            this.haveCategorySF.set(true);
        } else {
            this.haveCategorySF.set(false);
        }
        this.applyViewLogic(groupInfo.getSpecialFunction(), false);
    }

    public void setSeriesGroupInfo(GroupInfo groupInfo) {
        this.seriesGroupInfo.setGroupInfo(groupInfo);
        if (groupInfo.getSpecialFunction() != null) {
            this.haveSeriesSF.set(true);
        } else {
            this.haveSeriesSF.set(false);
        }
        this.applyViewLogic(groupInfo.getSpecialFunction(), true);
    }

    public GroupInfo getCategoryGropInfo() {
        GroupInfo groupInfo = this.categoryGroupInfo.getGroupInfo();
        groupInfo.setSpecialFunction(this.antiAliasing(false));
        return groupInfo;
    }

    public GroupInfo getSeriesGropInfo() {
        GroupInfo groupInfo = this.seriesGroupInfo.getGroupInfo();
        groupInfo.setSpecialFunction(this.antiAliasing(true));
        return groupInfo;
    }

    public HashMap getIndecialMap() {
        if (CHART_FILTER_EDITOR_NO_DATE != null) {
            return CHART_FILTER_EDITOR_NO_DATE;
        }
        CHART_FILTER_EDITOR_NO_DATE = new HashMap();
        HashMap hashMap = super.getIndecialMap();
        CHART_FILTER_EDITOR_NO_DATE.putAll(hashMap);
        int n = hashMap.size();
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundBorderPenTransparency", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategorySpecialOperators", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("AntiAliasing", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("BLValue", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("Section", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("ColumnNumber", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategorySpecialNames", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternImageFile", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("StyleList", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("BLSeries", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategoryEndOffset", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("Cache", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesValueEncoding", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesFilter", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternImageX", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategoryOthersName", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("GroupValueFormat", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesSelectN", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("HaveCategorySpecialFuncation", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("RuntimeSeries", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PrimaryDataFilter", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternGradientStyle", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategorySelectType", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternImageY", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundRight", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategorySpecialOpNum", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("GotoDetail", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesSortOrder", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("ZHyperLinkTarget", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundLeft", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("HyperLinkTarget", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundBorderPenStyle", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesSelectType", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternGradientStartY", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundBorderPenEndCaps", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("HintPercentFilter", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("BLCategory", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternGradientStartX", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("ExternalTitle", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternTextureBackColor", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategorySelectStartPosition", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategoryKeepOthers", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesStartOffset", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternGradientEndX", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesSpecialOpNum", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundBorderPenOutlined", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("RowNumber", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SortCategory", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesEndOffset", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesGroupType", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategorySortBy", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PatternList", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategorySpecialOperands", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternImageLayout", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundBorderPenThickness", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("ChartDefinition", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("LeftMargin", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternImageWidth", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("Alt", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundBorderPenLineJoint", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("BindedPatterns", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("NeedCreateChartDataSetModel", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesKeepOthers", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategorySelectN", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundTop", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("StyleInherit", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("TopMargin", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("ReverseSeries", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundBorderPenVariabledDash", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesSpecialOperators", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("AutoLayout", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesOthersName", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("XHyperLinkTarget", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternImageHeight", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategoryStartOffset", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategoryFilter", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SecondaryDataFilter", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("RuntimeCategory", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternGradientEndY", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("IsBVData", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("RightMargin", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternTextureForeColor", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternTransparency", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternTextureStyle", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("LongDesc", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SwapGroup", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternType", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesSpecialOperands", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("BindedValues", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("ZHyperLink", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundBottom", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternGradientStartColor", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesSortBy", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternColor", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("BottomMargin", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SortSeries", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesGroupOrder", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("HintFilter", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategoryGroupOrder", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("ShowLegend", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundBorderStyle", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundFillPatternGradientEndColor", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("HyperLink", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("HaveSeriesSpecialFuncation", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("PlatformBackgroundBorderPenColor", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("Interactive", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesSpecialNames", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategorySortOrder", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("BoundDataContainer", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SeriesSelectStartPosition", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("ReverseCategory", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("RuntimeValue", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("SameLevel", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("XHyperLink", new Integer(n++));
        CHART_FILTER_EDITOR_NO_DATE.put("CategoryGroupType", new Integer(n++));
        return CHART_FILTER_EDITOR_NO_DATE;
    }

    public HashVector getPropGrpsDesc() {
        return CHART_PATTERN_LIST_EDITOR;
    }

    public SpecialFunction getCategorySpecialFunction() {
        return this.antiAliasing(false);
    }

    public SpecialFunction getSeriesSpecialFunction() {
        return this.antiAliasing(true);
    }

    private SpecialFunction antiAliasing(boolean bl) {
        Vector vector = this.getChildren();
        int n = 0;
        SpecialFunction specialFunction = null;
        SpecialFunction specialFunction2 = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) instanceof SpecialFunction) {
                if (n == 0) {
                    specialFunction = (SpecialFunction)vector.elementAt(n2);
                } else if (n == 1) {
                    specialFunction2 = (SpecialFunction)vector.elementAt(n2);
                }
                ++n;
            }
            ++n2;
        }
        if (bl && this.haveSeriesSF.get()) {
            return specialFunction;
        }
        if (!bl && this.haveCategorySF.get()) {
            if (specialFunction2 == null) {
                return specialFunction;
            }
            return specialFunction2;
        }
        return null;
    }

    private void applyViewLogic(SpecialFunction specialFunction, boolean bl) {
        SpecialFunction specialFunction2 = this.antiAliasing(true);
        SpecialFunction specialFunction3 = this.antiAliasing(false);
        if (bl) {
            if (specialFunction2 != null) {
                ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)((Object)specialFunction2));
            }
            if (specialFunction3 != null) {
                ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)((Object)specialFunction3));
            }
            if (specialFunction != null) {
                ObjectLogicFactory.getBasicComponentLogic().add(this, (JetObject)((Object)specialFunction));
            }
            if (specialFunction3 != null) {
                ObjectLogicFactory.getBasicComponentLogic().add(this, (JetObject)((Object)specialFunction3));
            }
        } else {
            if (specialFunction2 != null) {
                ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)((Object)specialFunction2));
            }
            if (specialFunction3 != null) {
                ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)((Object)specialFunction3));
            }
            if (specialFunction2 != null) {
                ObjectLogicFactory.getBasicComponentLogic().add(this, (JetObject)((Object)specialFunction2));
            }
            if (specialFunction != null) {
                ObjectLogicFactory.getBasicComponentLogic().add(this, (JetObject)((Object)specialFunction));
            }
        }
    }

    public Hashtable getSumInfo() {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        int n = this.getDefinition().getY1Datasets().size();
        String[] stringArray = this.getDefinition().getIndexedFieldNames();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Hashtable<String, String> hashtable2;
            String string;
            String string2;
            String string3;
            String string4;
            Object object;
            DataSet dataSet;
            if (this.dataInherit.booleanValue()) {
                dataSet = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet(ObjectLogicFactory.getDataContainerLogic().getDataContainer(this, true));
                if (dataSet == null) {
                    dataSet = (DataSet)this.dataSet.getObject();
                }
            } else {
                dataSet = (DataSet)this.dataSet.getObject();
            }
            if (n3 < n) {
                object = dataSet.getResourceByName(stringArray[n3]);
                if (object instanceof JetUSummary) {
                    string4 = ((JetUSummary)object).fldName.get();
                    string3 = ((JetUSummary)object).getFunction();
                    string2 = ((JetUSummary)object).getGroupByFld();
                    string = ((JetUSummary)object).getSpecFuncKey();
                    hashtable2 = new Hashtable<String, String>();
                    hashtable2.put("sum_on", string4);
                    hashtable2.put("function", string3);
                    hashtable2.put("groupby", string2);
                    hashtable2.put("specialfunction_Key", string);
                    vector.add(hashtable2);
                }
            } else {
                object = dataSet.getResourceByName(stringArray[n3]);
                if (object instanceof JetUSummary) {
                    string4 = ((JetUSummary)object).fldName.get();
                    string3 = ((JetUSummary)object).getFunction();
                    string2 = ((JetUSummary)object).getGroupByFld();
                    string = ((JetUSummary)object).getSpecFuncKey();
                    hashtable2 = new Hashtable();
                    hashtable2.put("sum_on", string4);
                    hashtable2.put("function", string3);
                    hashtable2.put("groupby", string2);
                    hashtable2.put("specialfunction_Key", string);
                    vector2.add(hashtable2);
                }
            }
            ++n3;
        }
        hashtable.put(new Short(0), vector);
        hashtable.put(new Short(1), vector2);
        return hashtable;
    }

    public void setCreateInfoAndDataSet(JetChartCreateInfos jetChartCreateInfos) {
        this.setCreateInfos(jetChartCreateInfos);
        this.dataSet.setObject(jetChartCreateInfos.getDataset());
    }

    public String[] getCategoryAndSeriesDisplayName() {
        String[] stringArray = null;
        ChartDefinition chartDefinition = this.definition.getChartDefinition();
        if (this.isBVData.booleanValue()) {
            String string;
            stringArray = new String[2];
            DataSet dataSet = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet(this);
            String string2 = chartDefinition.getCategory();
            BLNode bLNode = null;
            if (string2 != null) {
                bLNode = ObjectLogicFactory.getDataSetLogic().getRefDataElement(dataSet, string2);
            }
            if (bLNode != null) {
                stringArray[0] = bLNode.getDisplayName();
            }
            if ((bLNode = (string = chartDefinition.getSeries()) != null ? ObjectLogicFactory.getDataSetLogic().getRefDataElement(dataSet, string) : null) != null) {
                stringArray[1] = bLNode.getDisplayName();
            }
        }
        return stringArray;
    }

    static {
        String string = null;
        Vector<String> vector = null;
        string = "Geometry";
        vector = new Vector<String>(4);
        vector.add("X");
        vector.add("Y");
        vector.add("Width");
        vector.add("Height");
        CHART_PATTERN_LIST_EDITOR.put(string, vector);
        string = "CSS";
        vector = new Vector(3);
        vector.add("Style");
        vector.add("class");
        CHART_PATTERN_LIST_EDITOR.put(string, vector);
        string = "Others";
        vector = new Vector(8);
        vector.add("position");
        vector.add("ExportToDHTML");
        vector.add("Invisible");
        vector.add("Suppressed");
        vector.add("SuppressedIfNoRecords");
        vector.add("ExportToCSV");
        vector.add("ExportToXLS");
        vector.add("Cache");
        vector.add("Alt");
        CHART_PATTERN_LIST_EDITOR.put(string, vector);
        string = "Excel";
        vector = new Vector(4);
        vector.add("ColumnIndex");
        vector.add("RowIndex");
        vector.add("ColumnNumber");
        vector.add("RowNumber");
        CHART_PATTERN_LIST_EDITOR.put(string, vector);
        string = "TOC";
        vector = new Vector(2);
        vector.add("TOCAnchor");
        vector.add("AnchorDispValue");
        CHART_PATTERN_LIST_EDITOR.put(string, vector);
        string = "Platform";
        vector = new Vector(3);
        vector.add("ShowLegend");
        vector.add("AntiAliasing");
        vector.add("PatternList");
        CHART_PATTERN_LIST_EDITOR.put(string, vector);
        string = "Background";
        vector = new Vector(32);
        vector.add("PlatformBackgroundBorderStyle");
        vector.add("PlatformBackgroundBorderPenStyle");
        vector.add("PlatformBackgroundBorderPenColor");
        vector.add("PlatformBackgroundBorderPenTransparency");
        vector.add("PlatformBackgroundBorderPenThickness");
        vector.add("PlatformBackgroundBorderPenEndCaps");
        vector.add("PlatformBackgroundBorderPenLineJoint");
        vector.add("PlatformBackgroundBorderPenOutlined");
        vector.add("PlatformBackgroundBorderPenVariabledDash");
        vector.add("PlatformBackgroundFillPatternType");
        vector.add("PlatformBackgroundFillPatternTransparency");
        vector.add("PlatformBackgroundFillPatternColor");
        vector.add("PlatformBackgroundFillPatternTextureStyle");
        vector.add("PlatformBackgroundFillPatternTextureForeColor");
        vector.add("PlatformBackgroundFillPatternTextureBackColor");
        vector.add("PlatformBackgroundFillPatternGradientStyle");
        vector.add("PlatformBackgroundFillPatternGradientStartColor");
        vector.add("PlatformBackgroundFillPatternGradientEndColor");
        vector.add("PlatformBackgroundFillPatternGradientStartX");
        vector.add("PlatformBackgroundFillPatternGradientStartY");
        vector.add("PlatformBackgroundFillPatternGradientEndX");
        vector.add("PlatformBackgroundFillPatternGradientEndY");
        vector.add("PlatformBackgroundFillPatternImageFile");
        vector.add("PlatformBackgroundFillPatternImageLayout");
        vector.add("PlatformBackgroundFillPatternImageX");
        vector.add("PlatformBackgroundFillPatternImageY");
        vector.add("PlatformBackgroundFillPatternImageWidth");
        vector.add("PlatformBackgroundFillPatternImageHeight");
        vector.add("PlatformBackgroundTop");
        vector.add("PlatformBackgroundLeft");
        vector.add("PlatformBackgroundRight");
        vector.add("PlatformBackgroundBottom");
        CHART_PATTERN_LIST_EDITOR.put(string, vector);
        string = "Data";
        vector = new Vector(20);
        vector.add("SortCategory");
        vector.add("SortSeries");
        vector.add("ReverseCategory");
        vector.add("ReverseSeries");
        vector.add("CategoryStartOffset");
        vector.add("CategoryEndOffset");
        vector.add("SeriesStartOffset");
        vector.add("SeriesEndOffset");
        vector.add("CategoryFilter");
        vector.add("SeriesFilter");
        vector.add("PrimaryDataFilter");
        vector.add("SecondaryDataFilter");
        vector.add("HintFilter");
        vector.add("GotoDetail");
        vector.add("HyperLink");
        vector.add("XHyperLink");
        vector.add("ZHyperLink");
        vector.add("GroupValueFormat");
        vector.add("SeriesValueEncoding");
        vector.add("SwapGroup");
        vector.add("HyperLinkTarget");
        vector.add("XHyperLinkTarget");
        vector.add("ZHyperLinkTarget");
        vector.add("HintPercentFilter");
        CHART_PATTERN_LIST_EDITOR.put(string, vector);
        string = "Accessibility";
        vector = new Vector(4);
        vector.add("ExternalCSSClassValue");
        vector.add("LongDesc");
        vector.add("ExternalTitle");
        vector.add("ExternalID");
        CHART_PATTERN_LIST_EDITOR.put(string, vector);
    }
}

