/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.resourceLogic.validation.jetrptobject;

import com.jinfonet.validation.NoError;
import com.jinfonet.validation.ValidationContext;
import com.jinfonet.validation.ValidationError;
import com.jinfonet.validation.ValidationException;
import com.jinfonet.validation.Validator;
import java.util.ListIterator;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.dataengine.api.SumrySpecKeyTool;
import jet.formula.SpecFormulaInfo;
import jet.report.JetRptCTDBField;
import jet.report.JetRptCrosstabCellField;
import jet.report.JetRptDBField;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptMediaField;
import jet.report.JetRptSection;
import jet.report.specialFunc.SpecialFunction;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableCell;
import jet.report.table.JetRptTableDetail;
import jet.report.table.JetRptTableFooter;
import jet.report.table.JetRptTableGroup;
import jet.report.table.JetRptTableGroupFooter;
import jet.report.table.JetRptTableGroupHeader;
import jet.report.table.JetRptTableHeader;
import jet.reportLogic.objectLogic.resourceLogic.validation.jetrptobject.JetRptObjectDataMatchValidationContext;
import jet.rptengine.JGroupInitializer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;

public class DBFieldInTable
extends Validator {
    protected ValidationError check(ValidationContext validationContext) {
        JetRptObjectDataMatchValidationContext jetRptObjectDataMatchValidationContext = (JetRptObjectDataMatchValidationContext)validationContext;
        if (!(jetRptObjectDataMatchValidationContext.getJetRptObject() instanceof JetRptDBField)) {
            return NoError.getInstance();
        }
        JetRptDBField jetRptDBField = (JetRptDBField)jetRptObjectDataMatchValidationContext.getJetRptObject();
        if (jetRptDBField instanceof JetRptCrosstabCellField || jetRptDBField instanceof JetRptMediaField || jetRptDBField instanceof JetRptCTDBField) {
            return NoError.getInstance();
        }
        JetContainable jetContainable = jetRptDBField.getParent();
        if (!(jetContainable instanceof JetRptTableCell)) {
            return NoError.getInstance();
        }
        jetContainable = ((JetRptTableCell)jetContainable).getParent();
        Vector vector = jetRptObjectDataMatchValidationContext.getMappingNameList();
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)jetRptObjectDataMatchValidationContext.getJetRptDataSet().getResourceByName(string);
            if (!(jetUResourceEntity instanceof JetUSummary)) continue;
            JetUSummary jetUSummary = (JetUSummary)jetUResourceEntity;
            String string2 = jetUSummary.getGroupByFld();
            boolean bl = jetUSummary.getFormulaInfo().aggdesc.isDynamicSummary();
            if (jetContainable instanceof JetRptTableGroupHeader || jetContainable instanceof JetRptTableGroupFooter) {
                int n;
                JetRptTableGroup jetRptTableGroup = (JetRptTableGroup)((JetRptSection)jetContainable).getParent();
                String string3 = jetRptTableGroup.groupBy.get();
                if (!bl) {
                    if (string2 != null && !string2.trim().equals("") && !string3.trim().toUpperCase().equals(string2.trim().toUpperCase())) {
                        return new StaticSummaryNotMatchInGroupPanelError(this, string, string3, string2);
                    }
                    SpecialFunction specialFunction = jetRptTableGroup.getSpecialFunction();
                    if (specialFunction == null) continue;
                    SpecFormulaInfo specFormulaInfo = JGroupInitializer.buildSpecFormulaInfo(specialFunction);
                    String string4 = SumrySpecKeyTool.getSpecKey(specFormulaInfo);
                    String string5 = jetUSummary.getSpecFuncKey();
                    if (string5 == "" || string4.equals(string5)) continue;
                    return new StaticSummaryNotMatchInGroupPanelError(this, string, string4, string5);
                }
                int n2 = Integer.parseInt(string2);
                if (n2 > 0) {
                    return new DynamicSummaryInSectionObjectMustLessThanZeroError(this, string);
                }
                if (n2 == 0 || n2 >= 0 - (n = this.QOIV(jetRptTableGroup))) continue;
                return new DynamicSummaryNotMatchInGroupPanelError(this, string, n2, 0 - n);
            }
            if (!(jetContainable instanceof JetRptTableHeader) && !(jetContainable instanceof JetRptTableFooter) && !(jetContainable instanceof JetRptTableDetail)) continue;
            if (bl && Integer.parseInt(string2) == 0) {
                return NoError.getInstance();
            }
            if (string2 == null || string2.trim().equals("")) continue;
            return new CanNotContainSummaryError(this, string);
        }
        return NoError.getInstance();
    }

    private int QOIV(JetRptGroupPanel jetRptGroupPanel) {
        int n = 0;
        JetContainable jetContainable = jetRptGroupPanel.getParent();
        while (jetContainable != null) {
            if (jetContainable instanceof JetRptNewTable || !(jetContainable instanceof JetRptTableGroup)) break;
            ++n;
            jetContainable = ((JetRptTableGroup)jetContainable).getParent();
        }
        return n + 1;
    }

    protected void handleValidationError(ValidationError validationError) throws ValidationException {
        if (validationError instanceof StaticSummaryNotMatchInGroupPanelError) {
            throw new StaticSummaryNotMatchInGroupPanelException(this);
        }
        if (validationError instanceof DynamicSummaryNotMatchInGroupPanelError) {
            throw new DynamicSummaryNotMatchInGroupPanelException(this);
        }
        if (validationError instanceof CanNotContainSummaryError) {
            throw new CanNotContainSummaryException(this);
        }
        if (validationError instanceof DynamicSummaryInSectionObjectMustLessThanZeroError) {
            throw new DynamicSummaryInSectionObjectMustLessThanZeroException(this);
        }
    }

    public class DynamicSummaryInSectionObjectMustLessThanZeroException
    extends ValidationException {
        private static final long serialVersionUID = -6136489307361566647L;
        private final DBFieldInTable this$0;

        public DynamicSummaryInSectionObjectMustLessThanZeroException(DBFieldInTable dBFieldInTable) {
            this.this$0 = dBFieldInTable;
        }
    }

    public class DynamicSummaryInSectionObjectMustLessThanZeroError
    extends ValidationError {
        private String QOIV;
        private final DBFieldInTable this$0;

        public DynamicSummaryInSectionObjectMustLessThanZeroError(DBFieldInTable dBFieldInTable, String string) {
            this.this$0 = dBFieldInTable;
            this.QOIV(string);
            this.errorMessage = string + " is summary and can't be placed here.";
        }

        private void QOIV(String string) {
            this.QOIV = string;
        }

        public String getMappingName() {
            return this.QOIV;
        }
    }

    public class CanNotContainSummaryException
    extends ValidationException {
        private static final long serialVersionUID = 3328040403184233786L;
        private final DBFieldInTable this$0;

        public CanNotContainSummaryException(DBFieldInTable dBFieldInTable) {
            this.this$0 = dBFieldInTable;
        }
    }

    public class CanNotContainSummaryError
    extends ValidationError {
        private String QOIV;
        private final DBFieldInTable this$0;

        public CanNotContainSummaryError(DBFieldInTable dBFieldInTable, String string) {
            this.this$0 = dBFieldInTable;
            this.QOIV(string);
            this.errorMessage = string + " is summary and can't be placed here.";
        }

        private void QOIV(String string) {
            this.QOIV = string;
        }

        public String getMappingName() {
            return this.QOIV;
        }
    }

    public class DynamicSummaryNotMatchInGroupPanelException
    extends ValidationException {
        private static final long serialVersionUID = 8082850847366315703L;
        private final DBFieldInTable this$0;

        public DynamicSummaryNotMatchInGroupPanelException(DBFieldInTable dBFieldInTable) {
            this.this$0 = dBFieldInTable;
        }
    }

    public class DynamicSummaryNotMatchInGroupPanelError
    extends ValidationError {
        private String QOIV;
        private int append;
        private int toString;
        private final DBFieldInTable this$0;

        public DynamicSummaryNotMatchInGroupPanelError(DBFieldInTable dBFieldInTable, String string, int n, int n2) {
            this.this$0 = dBFieldInTable;
            this.errorMessage(n2);
            this.append(n);
            this.QOIV(string);
            this.errorMessage = "The " + string + " is dynamic summary and it's level is  " + n + ",but the minimal allowed level is " + n2;
        }

        private void QOIV(String string) {
            this.QOIV = string;
        }

        public String getMappingName() {
            return this.QOIV;
        }

        private void append(int n) {
            this.append = n;
        }

        public int getCurrentLevel() {
            return this.append;
        }

        private void errorMessage(int n) {
            this.toString = n;
        }

        public int getAllowedMinLevel() {
            return this.toString;
        }
    }

    public class StaticSummaryNotMatchInGroupPanelException
    extends ValidationException {
        private static final long serialVersionUID = 6528253715570834425L;
        private final DBFieldInTable this$0;

        public StaticSummaryNotMatchInGroupPanelException(DBFieldInTable dBFieldInTable) {
            this.this$0 = dBFieldInTable;
        }
    }

    public class StaticSummaryNotMatchInGroupPanelError
    extends ValidationError {
        private String QOIV;
        private String append;
        private String toString;
        private final DBFieldInTable this$0;

        public StaticSummaryNotMatchInGroupPanelError(DBFieldInTable dBFieldInTable, String string, String string2, String string3) {
            this.this$0 = dBFieldInTable;
            this.QOIV(string2);
            this.append(string3);
            this.errorMessage(string);
            this.errorMessage = "The " + string + " summary's group by " + string3 + ",but the required group by is " + string2;
        }

        private void QOIV(String string) {
            this.QOIV = string;
        }

        public String getRequiredGroupByFieldName() {
            return this.QOIV;
        }

        private void append(String string) {
            this.append = string;
        }

        public String getCurrentFieldName() {
            return this.append;
        }

        private void errorMessage(String string) {
            this.toString = string;
        }

        public String getMappingName() {
            return this.toString;
        }
    }
}

