/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.joinpathtools.graph;

import java.util.ArrayList;
import java.util.Iterator;
import jet.universe.businesslogic.joinpathtools.graph.Edge;
import jet.universe.businesslogic.joinpathtools.graph.EdgeHashMap;
import jet.universe.businesslogic.joinpathtools.graph.EdgeList;
import jet.universe.businesslogic.joinpathtools.graph.Graph;
import jet.universe.businesslogic.joinpathtools.graph.GraphLogicalException;
import jet.universe.businesslogic.joinpathtools.graph.PathList;
import jet.universe.businesslogic.joinpathtools.graph.Vertex;
import jet.universe.businesslogic.joinpathtools.graph.VertexList;

public class Path {
    private VertexList QOIV = new VertexList();
    private EdgeList add = new EdgeList();

    public Path(VertexList vertexList) throws GraphLogicalException {
        if (vertexList.size() < 1) {
            throw new GraphLogicalException(10);
        }
        this.QOIV(vertexList);
        int n = 0;
        while (n < vertexList.size()) {
            this.QOIV.add(new Vertex(((Vertex)vertexList.get(n)).getKey()));
            ++n;
        }
    }

    public Path(EdgeList edgeList) throws GraphLogicalException {
        if (edgeList.size() < 1) {
            throw new GraphLogicalException(11);
        }
        EdgeList edgeList2 = (EdgeList)edgeList.clone();
        Edge edge = (Edge)edgeList2.remove(0);
        if (edge.isPoint()) {
            this.QOIV.add(new Vertex(edge.startKey()));
        } else {
            this.QOIV.add(new Vertex(edge.startKey()));
            this.QOIV.add(new Vertex(edge.endKey()));
        }
        block2: while (true) {
            int n = 0;
            while (n < edgeList2.size()) {
                edge = (Edge)edgeList2.get(n);
                if (this.getStartVertex().getKey().equals(edge.startKey())) {
                    if (!edge.isPoint()) {
                        this.QOIV.add(0, new Vertex(edge.endKey()));
                    }
                    edgeList2.remove(n);
                    continue block2;
                }
                if (this.getStartVertex().getKey().equals(edge.endKey())) {
                    if (!edge.isPoint()) {
                        this.QOIV.add(0, new Vertex(edge.startKey()));
                    }
                    edgeList2.remove(n);
                    continue block2;
                }
                if (this.getEndVertex().getKey().equals(edge.startKey())) {
                    if (!edge.isPoint()) {
                        this.QOIV.add(new Vertex(edge.endKey()));
                    }
                    edgeList2.remove(n);
                    continue block2;
                }
                if (this.getEndVertex().getKey().equals(edge.endKey())) {
                    if (!edge.isPoint()) {
                        this.QOIV.add(new Vertex(edge.startKey()));
                    }
                    edgeList2.remove(n);
                    continue block2;
                }
                ++n;
            }
            break;
        }
        try {
            this.QOIV(this.QOIV);
        }
        catch (GraphLogicalException graphLogicalException) {
            throw new GraphLogicalException(12);
        }
        if (edgeList2.size() > 0) {
            throw new GraphLogicalException(13);
        }
    }

    public Path(String[] stringArray) throws GraphLogicalException {
        VertexList vertexList = new VertexList();
        if (stringArray.length < 1) {
            throw new GraphLogicalException(14);
        }
        int n = 0;
        while (n < stringArray.length) {
            vertexList.add(new Vertex(stringArray[n]));
            ++n;
        }
        this.QOIV(vertexList);
        this.QOIV = vertexList;
    }

    private void QOIV(VertexList vertexList) throws GraphLogicalException {
        int n = vertexList.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string = ((Vertex)vertexList.get(n2)).getKey();
            int n3 = 0;
            while (n3 < n2) {
                if (stringArray[n3].equals(string)) {
                    if (n3 == 0 && n2 == n - 1) {
                        return;
                    }
                    throw new GraphLogicalException(15, new Object[]{vertexList.toString()});
                }
                ++n3;
            }
            stringArray[n2] = string;
            ++n2;
        }
    }

    public VertexList getVertexList() {
        return (VertexList)this.QOIV.clone();
    }

    public Vertex getStartVertex() {
        return (Vertex)this.QOIV.get(0);
    }

    public Vertex getEndVertex() {
        return (Vertex)this.QOIV.get(this.QOIV.size() - 1);
    }

    public Edge getStartEdge() {
        int n = this.getLength();
        if (n <= 1) {
            return null;
        }
        return new Edge(((Vertex)this.QOIV.get(0)).getKey(), ((Vertex)this.QOIV.get(1)).getKey());
    }

    public Edge getEndEdge() {
        int n = this.getLength();
        if (n <= 1) {
            return null;
        }
        return new Edge(((Vertex)this.QOIV.get(n - 2)).getKey(), ((Vertex)this.QOIV.get(n - 1)).getKey());
    }

    public Object clone() {
        try {
            return new Path(this.QOIV);
        }
        catch (GraphLogicalException graphLogicalException) {
            return null;
        }
    }

    public boolean isInGraph(Graph graph) {
        EdgeHashMap edgeHashMap = graph.getEdgeList();
        int n = 0;
        while (n < this.QOIV.size() - 1) {
            String string = Edge.key(((Vertex)this.QOIV.get(n)).getKey(), ((Vertex)this.QOIV.get(n + 1)).getKey());
            String string2 = Edge.key(((Vertex)this.QOIV.get(n + 1)).getKey(), ((Vertex)this.QOIV.get(n)).getKey());
            if (!edgeHashMap.containsKey(string) && !edgeHashMap.containsKey(string2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean compareTo(Path path) {
        EdgeList edgeList = path.getEdges();
        EdgeList edgeList2 = this.getEdges();
        if (edgeList2.size() != edgeList.size()) {
            return false;
        }
        int n = 0;
        while (n < edgeList2.size()) {
            Edge edge = (Edge)edgeList2.get(n);
            boolean bl = false;
            int n2 = 0;
            while (n2 < edgeList.size()) {
                if (edge.equals((Edge)edgeList.get(n2))) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public PathList getIntersection(Path path) {
        VertexList vertexList = path.getVertexList();
        EdgeList edgeList = this.getEdges();
        EdgeList edgeList2 = path.getEdges();
        EdgeList edgeList3 = new EdgeList();
        if (this.QOIV.size() == 1 || vertexList.size() == 1) {
            return new PathList();
        }
        int n = 0;
        int n2 = edgeList.size();
        while (n < n2) {
            Edge edge = (Edge)edgeList.get(n);
            int n3 = 0;
            int n4 = edgeList2.size();
            while (n3 < n4) {
                Edge edge2 = (Edge)edgeList2.get(n3);
                if (edge.equals(edge2)) {
                    edgeList3.add(edge);
                    break;
                }
                ++n3;
            }
            ++n;
        }
        if (edgeList3.size() == 0) {
            return new PathList();
        }
        return Path.getPathsFromEdgeList(edgeList3);
    }

    public EdgeList getEdges() {
        EdgeList edgeList = new EdgeList();
        if (this.QOIV.size() == 1) {
            return null;
        }
        int n = 0;
        while (n < this.QOIV.size() - 1) {
            edgeList.add(new Edge(((Vertex)this.QOIV.get(n)).getKey(), ((Vertex)this.QOIV.get(n + 1)).getKey()));
            ++n;
        }
        return edgeList;
    }

    public void use(Path path) {
        EdgeList edgeList = path.getEdges();
        int n = 0;
        while (n < edgeList.size()) {
            this.add.add(edgeList.get(n));
            ++n;
        }
    }

    public PathList getUnusedSubPathes() {
        EdgeList edgeList = this.getEdges();
        int n = edgeList.size();
        EdgeList edgeList2 = new EdgeList();
        if (this.QOIV.size() == 1) {
            return new PathList();
        }
        int n2 = 0;
        while (n2 < n) {
            block4: {
                int n3 = this.add.size();
                Edge edge = (Edge)edgeList.get(n2);
                int n4 = 0;
                while (n4 < n3) {
                    Edge edge2 = (Edge)this.add.get(n4);
                    if (!edge.equals(edge2)) {
                        ++n4;
                        continue;
                    }
                    break block4;
                }
                edgeList2.add(edge);
            }
            ++n2;
        }
        return Path.getPathsFromEdgeList(edgeList2);
    }

    public boolean isContainsLoop() {
        if (this.QOIV.size() == 1) {
            return false;
        }
        return ((Vertex)this.QOIV.get(0)).getKey().equals(((Vertex)this.QOIV.get(this.QOIV.size() - 1)).getKey());
    }

    public int getIndex(Vertex vertex) {
        int n = this.QOIV.size();
        int n2 = 0;
        while (n2 < n) {
            if (((Vertex)this.QOIV.get(n2)).getKey().equals(vertex.getKey())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getLength() {
        return this.QOIV.size();
    }

    public boolean equals(Path path) {
        if (this.getLength() != path.getLength() || this.isContainsLoop() != path.isContainsLoop()) {
            return false;
        }
        VertexList vertexList = path.getVertexList();
        int n = path.getLength();
        boolean bl = true;
        if (this.isContainsLoop()) {
            int n2;
            n = this.getLength();
            int[] nArray = new int[n - 1];
            int n3 = 0;
            while (n3 < nArray.length) {
                n2 = this.getIndex((Vertex)vertexList.get(n3));
                if (n2 == -1) {
                    return false;
                }
                nArray[n3] = n2;
                ++n3;
            }
            n2 = 0;
            while (n2 < nArray.length - 1) {
                if ((nArray[n2] + 1) % nArray.length != nArray[n2 + 1]) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                return true;
            }
            int n4 = 0;
            while (n4 < nArray.length - 1) {
                if ((nArray[n4] - 1 + nArray.length) % nArray.length != nArray[n4 + 1]) {
                    return false;
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                if (!((Vertex)this.QOIV.get(n5)).getKey().equals(((Vertex)vertexList.get(n5)).getKey())) {
                    bl = false;
                    break;
                }
                ++n5;
            }
            if (bl) {
                return true;
            }
            int n6 = 0;
            while (n6 < n) {
                if (!((Vertex)this.QOIV.get(n6)).getKey().equals(((Vertex)vertexList.get(n - n6 - 1)).getKey())) {
                    return false;
                }
                ++n6;
            }
        }
        return true;
    }

    public boolean isContainsEdge(Edge edge) {
        EdgeList edgeList = this.getEdges();
        int n = 0;
        while (n < edgeList.size()) {
            Edge edge2 = (Edge)edgeList.get(n);
            if (edge2.equals(edge)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isContainsVertex(Vertex vertex) {
        VertexList vertexList = this.getVertexList();
        Iterator iterator = vertexList.iterator();
        while (iterator.hasNext()) {
            Vertex vertex2 = (Vertex)iterator.next();
            if (!vertex2.getKey().equals(vertex.getKey())) continue;
            return true;
        }
        return false;
    }

    public VertexList getNeighbourVertex(Vertex vertex) {
        VertexList vertexList = this.getVertexList();
        VertexList vertexList2 = new VertexList();
        int n = 0;
        while (n < vertexList.size()) {
            Vertex vertex2 = (Vertex)vertexList.get(n);
            if (vertex2.getKey().equals(vertex.getKey()) && this.isContainsLoop()) {
                Vertex vertex3;
                Vertex vertex4;
                if (n == 0) {
                    vertex4 = (Vertex)vertexList.get(1);
                    vertexList2.add(vertex4);
                    vertex3 = (Vertex)vertexList.get(vertexList.size() - 2);
                    vertexList2.add(vertex3);
                    break;
                }
                if (n == vertexList.size() - 1) {
                    vertex4 = (Vertex)vertexList.get(n - 1);
                    vertexList2.add(vertex4);
                    vertex3 = (Vertex)vertexList.get(1);
                    vertexList2.add(vertex3);
                    break;
                }
                vertex4 = (Vertex)vertexList.get(n - 1);
                vertexList2.add(vertex4);
                vertex3 = (Vertex)vertexList.get(n + 1);
                vertexList2.add(vertex3);
            }
            ++n;
        }
        return vertexList2;
    }

    public static PathList getPathsFromEdgeList(EdgeList edgeList) {
        Object object;
        EdgeList edgeList2 = new EdgeList();
        int n = edgeList.size();
        PathList pathList = new PathList();
        Edge edge = null;
        int n2 = 0;
        while (n2 < n) {
            edge = (Edge)edgeList.get(n2);
            if (!edgeList2.contains(edge)) {
                edgeList2.add(edge);
            }
            ++n2;
        }
        n = edgeList2.size();
        if (n == 0) {
            return pathList;
        }
        block5: while (true) {
            ArrayList arrayList;
            try {
                arrayList = new Graph(edgeList2.toTwoDimensionArray()).getLoop();
            }
            catch (GraphLogicalException graphLogicalException) {
                arrayList = null;
            }
            if (arrayList.size() == 0) break;
            object = (Path)arrayList.get(0);
            pathList.add((Path)object);
            EdgeList edgeList3 = ((Path)object).getEdges();
            int n3 = edgeList3.size();
            int n4 = 0;
            while (true) {
                if (n4 >= n3) continue block5;
                edge = (Edge)edgeList3.get(n4);
                n = edgeList2.size();
                int n5 = 0;
                while (n5 < n) {
                    if (edge.equals((Edge)edgeList2.get(n5))) {
                        edgeList2.remove(n5);
                        break;
                    }
                    ++n5;
                }
                ++n4;
            }
            break;
        }
        if (edgeList2.size() == 0) {
            return pathList;
        }
        do {
            object = new VertexList();
            edge = (Edge)edgeList2.remove(0);
            if (edge.isPoint()) {
                ((VertexList)object).add(new Vertex(edge.startKey()));
            } else {
                ((VertexList)object).add(new Vertex(edge.startKey()));
                ((VertexList)object).add(new Vertex(edge.endKey()));
            }
            block9: while (true) {
                int n6 = 0;
                while (n6 < edgeList2.size()) {
                    Vertex vertex = (Vertex)((ArrayList)object).get(0);
                    Vertex vertex2 = (Vertex)((ArrayList)object).get(((ArrayList)object).size() - 1);
                    edge = (Edge)edgeList2.get(n6);
                    if (vertex.getKey().equals(edge.startKey())) {
                        if (!edge.isPoint()) {
                            ((VertexList)object).add(0, new Vertex(edge.endKey()));
                        }
                        edgeList2.remove(n6);
                        continue block9;
                    }
                    if (vertex.getKey().equals(edge.endKey())) {
                        if (!edge.isPoint()) {
                            ((VertexList)object).add(0, new Vertex(edge.startKey()));
                        }
                        edgeList2.remove(n6);
                        continue block9;
                    }
                    if (vertex2.getKey().equals(edge.startKey())) {
                        if (!edge.isPoint()) {
                            ((VertexList)object).add(new Vertex(edge.endKey()));
                        }
                        edgeList2.remove(n6);
                        continue block9;
                    }
                    if (vertex2.getKey().equals(edge.endKey())) {
                        if (!edge.isPoint()) {
                            ((VertexList)object).add(new Vertex(edge.startKey()));
                        }
                        edgeList2.remove(n6);
                        continue block9;
                    }
                    ++n6;
                }
                break;
            }
            try {
                pathList.add(new Path((VertexList)object));
            }
            catch (GraphLogicalException graphLogicalException) {
                graphLogicalException.printStackTrace();
            }
        } while (edgeList2.size() > 0);
        return pathList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.QOIV.size();
        stringBuffer.append("[");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((Vertex)this.QOIV.get(n2)).getKey() + " - ");
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

